/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.internal.featurehighlight;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.annotation.Nullable;
import android.support.v4.view.GestureDetectorCompat;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.gms.R;
import com.google.android.gms.cast.framework.internal.featurehighlight.zzb;
import com.google.android.gms.cast.framework.internal.featurehighlight.zzc;
import com.google.android.gms.cast.framework.internal.featurehighlight.zzd;
import com.google.android.gms.cast.framework.internal.featurehighlight.zze;
import com.google.android.gms.internal.zzagt;
import com.google.android.gms.internal.zzagy;

public final class zza
extends ViewGroup {
    private final int[] pY = new int[2];
    private final Rect pZ = new Rect();
    private final Rect qa = new Rect();
    private final zze qb;
    private final zzc qc;
    private zzb qd;
    private View targetView;
    @Nullable
    private View qe;
    @Nullable
    private Animator qf;
    private final zzd qg;
    private final GestureDetectorCompat qh;
    @Nullable
    private GestureDetectorCompat qi;
    private zza qj;
    private boolean qk;

    public zza(Context context) {
        super(context);
        this.setId(R.id.cast_featurehighlight_view);
        this.setWillNotDraw(false);
        this.qc = new zzc(context);
        this.qc.setCallback((Drawable.Callback)this);
        this.qb = new zze(context);
        this.qb.setCallback((Drawable.Callback)this);
        this.qg = new zzd(this);
        GestureDetector.SimpleOnGestureListener simpleOnGestureListener = new GestureDetector.SimpleOnGestureListener(){

            public boolean onSingleTapUp(MotionEvent motionEvent) {
                float f;
                float f2 = motionEvent.getX();
                if (!zza.this.zzc(f2, f = motionEvent.getY()) || !zza.this.qb.zzd(f2, f)) {
                    zza.this.qj.dismiss();
                }
                return true;
            }
        };
        this.qh = new GestureDetectorCompat(context, (GestureDetector.OnGestureListener)simpleOnGestureListener);
        this.qh.setIsLongpressEnabled(false);
        this.setVisibility(8);
    }

    public void zza(zzb zzb2) {
        this.qd = zzagy.zzy(zzb2);
        this.addView(zzb2.asView(), 0);
    }

    public void zza(final View view, @Nullable View view2, final boolean bl, final zza zza2) {
        this.targetView = zzagy.zzy(view);
        this.qe = view2;
        this.qj = zzagy.zzy(zza2);
        GestureDetector.SimpleOnGestureListener simpleOnGestureListener = new GestureDetector.SimpleOnGestureListener(){

            public boolean onSingleTapUp(MotionEvent motionEvent) {
                if (view.getParent() != null) {
                    view.performClick();
                }
                if (bl) {
                    zza2.zzamo();
                }
                return true;
            }
        };
        this.qi = new GestureDetectorCompat(this.getContext(), (GestureDetector.OnGestureListener)simpleOnGestureListener);
        this.qi.setIsLongpressEnabled(false);
        this.setVisibility(4);
    }

    protected void onMeasure(int n, int n2) {
        int n3 = View.MeasureSpec.getSize((int)n);
        int n4 = View.MeasureSpec.getSize((int)n2);
        this.setMeasuredDimension(zza.resolveSize((int)n3, (int)n), zza.resolveSize((int)n4, (int)n2));
    }

    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        if (this.targetView == null) {
            throw new IllegalStateException("Target view must be set before layout");
        }
        if (this.targetView.getParent() != null) {
            this.zza(this.pY, this.targetView);
        }
        this.pZ.set(this.pY[0], this.pY[1], this.pY[0] + this.targetView.getWidth(), this.pY[1] + this.targetView.getHeight());
        if (this.qe != null) {
            this.zza(this.pY, this.qe);
            this.qa.set(this.pY[0], this.pY[1], this.pY[0] + this.qe.getMeasuredWidth(), this.pY[1] + this.qe.getMeasuredHeight());
        } else {
            this.qa.set(n, n2, n3, n4);
        }
        this.qb.setBounds(this.qa);
        this.qc.setBounds(this.qa);
        this.qg.zza(this.pZ, this.qa);
    }

    protected void onDraw(Canvas canvas) {
        canvas.save();
        if (this.qe != null) {
            canvas.clipRect(this.qa);
        }
        this.qb.draw(canvas);
        this.qc.draw(canvas);
        if (this.targetView != null) {
            if (this.targetView.getParent() != null) {
                Bitmap bitmap = Bitmap.createBitmap((int)this.targetView.getWidth(), (int)this.targetView.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                Canvas canvas2 = new Canvas(bitmap);
                this.targetView.draw(canvas2);
                int n = this.qb.getColor();
                int n2 = Color.red((int)n);
                int n3 = Color.green((int)n);
                int n4 = Color.blue((int)n);
                for (int i = 0; i < bitmap.getHeight(); ++i) {
                    for (int j = 0; j < bitmap.getWidth(); ++j) {
                        int n5 = bitmap.getPixel(j, i);
                        if (Color.alpha((int)n5) == 0) continue;
                        n5 = Color.argb((int)Color.alpha((int)n5), (int)n2, (int)n3, (int)n4);
                        bitmap.setPixel(j, i, n5);
                    }
                }
                canvas.drawBitmap(bitmap, (float)this.pZ.left, (float)this.pZ.top, null);
            }
        } else {
            throw new IllegalStateException("Neither target view nor drawable was set");
        }
        canvas.restore();
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return new ViewGroup.MarginLayoutParams(this.getContext(), attributeSet);
    }

    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new ViewGroup.MarginLayoutParams(-2, -2);
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return new ViewGroup.MarginLayoutParams(layoutParams);
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return layoutParams instanceof ViewGroup.MarginLayoutParams;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean verifyDrawable(Drawable drawable) {
        if (super.verifyDrawable(drawable)) return true;
        if (drawable == this.qb) return true;
        if (drawable == this.qc) return true;
        if (drawable != null) return false;
        return true;
    }

    public void zzh(final @Nullable Runnable runnable) {
        this.addOnLayoutChangeListener(new View.OnLayoutChangeListener(){

            public void onLayoutChange(View view, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
                if (runnable != null) {
                    runnable.run();
                }
                zza.this.zzamr();
                zza.this.removeOnLayoutChangeListener(this);
            }
        });
    }

    public void zzamr() {
        if (this.targetView == null) {
            throw new IllegalStateException("Target view must be set before animation");
        }
        this.setVisibility(0);
        this.zza(this.zzamw());
    }

    public void zzi(@Nullable Runnable runnable) {
        this.zza(this.zzl(runnable));
    }

    public void zzj(@Nullable Runnable runnable) {
        this.zza(this.zzk(runnable));
    }

    public void zzeu(@ColorInt int n) {
        this.qb.setColor(n);
    }

    @Nullable
    Drawable zzams() {
        return null;
    }

    View zzamt() {
        return this.qd.asView();
    }

    zze zzamu() {
        return this.qb;
    }

    zzc zzamv() {
        return this.qc;
    }

    private void zza(int[] nArray, View view) {
        this.getLocationInWindow(nArray);
        int n = nArray[0];
        int n2 = nArray[1];
        view.getLocationInWindow(nArray);
        nArray[0] = nArray[0] - n;
        nArray[1] = nArray[1] - n2;
    }

    private void zza(Animator animator) {
        if (this.qf != null) {
            this.qf.cancel();
        }
        this.qf = animator;
        this.qf.start();
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        int n = motionEvent.getActionMasked();
        if (n == 0) {
            this.qk = this.pZ.contains((int)motionEvent.getX(), (int)motionEvent.getY());
        }
        if (this.qk) {
            MotionEvent motionEvent2 = motionEvent;
            if (this.qi != null) {
                this.qi.onTouchEvent(motionEvent);
                if (n == 1) {
                    motionEvent2 = MotionEvent.obtain((MotionEvent)motionEvent);
                    motionEvent2.setAction(3);
                }
            }
            if (this.targetView.getParent() != null) {
                this.targetView.onTouchEvent(motionEvent2);
            }
        } else {
            this.qh.onTouchEvent(motionEvent);
        }
        return true;
    }

    private boolean zzc(float f, float f2) {
        return this.qa.contains(Math.round(f), Math.round(f2));
    }

    private Animator zzamw() {
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)this.qd.asView(), (String)"alpha", (float[])new float[]{0.0f, 1.0f}).setDuration(350L);
        objectAnimator.setInterpolator((TimeInterpolator)zzagt.zzcnl());
        float f = this.pZ.exactCenterX() - this.qb.getCenterX();
        float f2 = this.pZ.exactCenterY() - this.qb.getCenterY();
        Animator animator = this.qb.zze(f, f2);
        Animator animator2 = this.qc.zzamw();
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playTogether(new Animator[]{objectAnimator, animator, animator2});
        animatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animator) {
                zza.this.qf = zza.this.zzamx();
                zza.this.qf.start();
            }
        });
        return animatorSet;
    }

    private Animator zzk(final @Nullable Runnable runnable) {
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)this.qd.asView(), (String)"alpha", (float[])new float[]{0.0f}).setDuration(200L);
        objectAnimator.setInterpolator((TimeInterpolator)zzagt.zzcnm());
        Animator animator = this.qb.zzamy();
        Animator animator2 = this.qc.zzamy();
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playTogether(new Animator[]{objectAnimator, animator, animator2});
        animatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animator) {
                zza.this.setVisibility(8);
                zza.this.qf = null;
                if (runnable != null) {
                    runnable.run();
                }
            }
        });
        return animatorSet;
    }

    private Animator zzl(final @Nullable Runnable runnable) {
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)this.qd.asView(), (String)"alpha", (float[])new float[]{0.0f}).setDuration(200L);
        objectAnimator.setInterpolator((TimeInterpolator)zzagt.zzcnm());
        float f = this.pZ.exactCenterX() - this.qb.getCenterX();
        float f2 = this.pZ.exactCenterY() - this.qb.getCenterY();
        Animator animator = this.qb.zzf(f, f2);
        Animator animator2 = this.qc.zzamz();
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playTogether(new Animator[]{objectAnimator, animator, animator2});
        animatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animator) {
                zza.this.setVisibility(8);
                zza.this.qf = null;
                if (runnable != null) {
                    runnable.run();
                }
            }
        });
        return animatorSet;
    }

    private Animator zzamx() {
        return this.qc.zzamx();
    }

    public static interface zza {
        public void zzamo();

        public void dismiss();
    }
}

