/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.media;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import com.google.android.gms.cast.framework.media.ImagePicker;
import com.google.android.gms.cast.framework.media.MediaIntentReceiver;
import com.google.android.gms.cast.framework.media.NotificationOptions;
import com.google.android.gms.cast.framework.media.zza;
import com.google.android.gms.cast.framework.media.zzb;
import com.google.android.gms.cast.internal.zzm;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;

public class CastMediaOptions
extends AbstractSafeParcelable {
    private static final zzm oT = new zzm("CastMediaOptions");
    public static final Parcelable.Creator<CastMediaOptions> CREATOR = new zza();
    private final int mVersionCode;
    private final String qK;
    private final String qL;
    private final zzb qM;
    private final NotificationOptions qN;

    CastMediaOptions(int n, String string2, String string3, IBinder iBinder, NotificationOptions notificationOptions) {
        this.mVersionCode = n;
        this.qK = string2;
        this.qL = string3;
        this.qM = zzb.zza.zzdc(iBinder);
        this.qN = notificationOptions;
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public String getMediaIntentReceiverClassName() {
        return this.qK;
    }

    public NotificationOptions getNotificationOptions() {
        return this.qN;
    }

    public String getExpandedControllerActivityClassName() {
        return this.qL;
    }

    public ImagePicker getImagePicker() {
        if (this.qM != null) {
            try {
                return (ImagePicker)zze.zzae((zzd)this.qM.zzanb());
            }
            catch (RemoteException remoteException) {
                oT.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"getWrappedClientObject", zzb.class.getSimpleName()});
            }
        }
        return null;
    }

    public IBinder zzana() {
        return this.qM == null ? null : this.qM.asBinder();
    }

    public void writeToParcel(Parcel parcel, int n) {
        zza.zza(this, parcel, n);
    }

    public static final class Builder {
        private String qK = MediaIntentReceiver.class.getName();
        private String qL;
        private ImagePicker qO;
        private NotificationOptions qN = new NotificationOptions.Builder().build();

        public Builder setMediaIntentReceiverClassName(String string2) {
            this.qK = string2;
            return this;
        }

        public Builder setExpandedControllerActivityClassName(String string2) {
            this.qL = string2;
            return this;
        }

        public Builder setImagePicker(ImagePicker imagePicker) {
            this.qO = imagePicker;
            return this;
        }

        public Builder setNotificationOptions(NotificationOptions notificationOptions) {
            this.qN = notificationOptions;
            return this;
        }

        public CastMediaOptions build() {
            IBinder iBinder = this.qO == null ? null : this.qO.zzanc().asBinder();
            return new CastMediaOptions(1, this.qK, this.qL, iBinder, this.qN);
        }
    }
}

