/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.media.widget;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.PorterDuff;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.os.Bundle;
import android.support.annotation.ColorRes;
import android.support.annotation.DrawableRes;
import android.support.v4.app.FragmentActivity;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.appcompat.R;
import android.support.v7.widget.Toolbar;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.SeekBar;
import android.widget.TextView;
import com.google.android.gms.R;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaMetadata;
import com.google.android.gms.cast.MediaStatus;
import com.google.android.gms.cast.framework.CastContext;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.SessionManager;
import com.google.android.gms.cast.framework.SessionManagerListener;
import com.google.android.gms.cast.framework.media.ImageHints;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.media.uicontroller.UIMediaController;
import com.google.android.gms.cast.framework.media.widget.ControlButtonsContainer;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.util.zzs;
import com.google.android.gms.internal.zzov;
import com.google.android.gms.internal.zzpa;

public abstract class ExpandedControllerActivity
extends AppCompatActivity
implements ControlButtonsContainer {
    private final SessionManagerListener<CastSession> tp = new zzb();
    private final RemoteMediaClient.Listener sv = new zza();
    @DrawableRes
    private int tq;
    @ColorRes
    private int tr;
    @DrawableRes
    private int ts;
    @DrawableRes
    private int tt;
    private TextView tu;
    private SeekBar sM;
    private ImageView tv;
    private ImageView tw;
    private zzov tx;
    private int[] ty;
    private ImageView[] tz = new ImageView[4];
    private View tA;
    private UIMediaController tB;
    private SessionManager oX;

    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        CastContext.getSharedInstance((Context)this).registerLifecycleCallbacksBeforeIceCreamSandwich((FragmentActivity)this, bundle);
        this.oX = CastContext.getSharedInstance((Context)this).getSessionManager();
        if (this.oX.getCurrentCastSession() == null) {
            this.finish();
        }
        this.tB = new UIMediaController((Activity)this);
        this.tB.setPostRemoteMediaClientListener(this.sv);
        this.setContentView(R.layout.cast_expanded_controller_activity);
        this.zzaon();
        this.zzaoo();
        this.zza(this.findViewById(R.id.expanded_controller_layout), this.tB);
        this.zza((Toolbar)this.findViewById(R.id.toolbar));
        this.zzaou();
        this.zzaot();
    }

    protected void onResume() {
        CastContext.getSharedInstance((Context)this).getSessionManager().addSessionManagerListener(this.tp, CastSession.class);
        CastSession castSession = CastContext.getSharedInstance((Context)this).getSessionManager().getCurrentCastSession();
        if (castSession == null || !castSession.isConnected() && !castSession.isConnecting()) {
            this.finish();
        }
        super.onResume();
    }

    protected void onPause() {
        CastContext.getSharedInstance((Context)this).getSessionManager().removeSessionManagerListener(this.tp, CastSession.class);
        super.onPause();
    }

    protected void onDestroy() {
        if (this.tB != null) {
            this.tB.setPostRemoteMediaClientListener(null);
            this.tB.dispose();
        }
        super.onDestroy();
    }

    public boolean onOptionsItemSelected(MenuItem menuItem) {
        if (menuItem.getItemId() == 16908332) {
            this.finish();
        }
        return true;
    }

    public void onWindowFocusChanged(boolean bl) {
        super.onWindowFocusChanged(bl);
        if (bl) {
            this.zzaos();
        }
    }

    public TextView getStatusTextView() {
        return this.tu;
    }

    public SeekBar getSeekBar() {
        return this.sM;
    }

    @Override
    public final int getButtonSlotCount() {
        return 4;
    }

    @Override
    public final int getButtonTypeAt(int n) throws IndexOutOfBoundsException {
        return this.ty[n];
    }

    @Override
    public final ImageView getButtonImageViewAt(int n) throws IndexOutOfBoundsException {
        return this.tz[n];
    }

    @Override
    public UIMediaController getUIMediaController() {
        return this.tB;
    }

    private void zzaon() {
        TypedArray typedArray = this.obtainStyledAttributes(new int[]{R.attr.selectableItemBackgroundBorderless, R.attr.colorControlActivated});
        this.tq = typedArray.getResourceId(0, 0);
        this.tr = typedArray.getResourceId(1, 0);
        typedArray.recycle();
    }

    private void zzaoo() {
        TypedArray typedArray = this.obtainStyledAttributes(null, R.styleable.CastExpandedController, R.attr.castExpandedControllerStyle, R.style.CastExpandedController);
        this.ts = typedArray.getResourceId(R.styleable.CastExpandedController_castSeekBarProgressDrawable, 0);
        this.tt = typedArray.getResourceId(R.styleable.CastExpandedController_castSeekBarThumbDrawable, 0);
        int n = typedArray.getResourceId(R.styleable.CastExpandedController_castControlButtons, 0);
        if (n != 0) {
            TypedArray typedArray2 = this.getResources().obtainTypedArray(n);
            zzaa.zzbt((typedArray2.length() == 4 ? 1 : 0) != 0);
            this.ty = new int[typedArray2.length()];
            for (int i = 0; i < typedArray2.length(); ++i) {
                this.ty[i] = typedArray2.getResourceId(i, 0);
            }
            typedArray2.recycle();
        } else {
            this.ty = new int[]{R.id.cast_button_type_empty, R.id.cast_button_type_empty, R.id.cast_button_type_empty, R.id.cast_button_type_empty};
        }
        typedArray.recycle();
    }

    private void zza(View view, UIMediaController uIMediaController) {
        this.tv = (ImageView)view.findViewById(R.id.background_image_view);
        this.tw = (ImageView)view.findViewById(R.id.blurred_background_image_view);
        View view2 = view.findViewById(R.id.background_place_holder_image_view);
        DisplayMetrics displayMetrics = new DisplayMetrics();
        this.getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
        uIMediaController.bindImageViewToImageOfCurrentItem(this.tv, new ImageHints(4, displayMetrics.widthPixels, displayMetrics.heightPixels), view2);
        this.tu = (TextView)view.findViewById(R.id.status_text);
        ProgressBar progressBar = (ProgressBar)view.findViewById(R.id.loading_indicator);
        uIMediaController.bindViewToLoadingIndicator((View)progressBar);
        TextView textView = (TextView)view.findViewById(R.id.start_text);
        TextView textView2 = (TextView)view.findViewById(R.id.end_text);
        ImageView imageView = (ImageView)view.findViewById(R.id.live_stream_indicator);
        this.sM = (SeekBar)view.findViewById(R.id.seek_bar);
        this.zzaop();
        this.zzaor();
        SeekBar seekBar = (SeekBar)view.findViewById(R.id.live_stream_seek_bar);
        uIMediaController.bindTextViewToStreamPosition(textView, true);
        uIMediaController.bindTextViewToStreamDuration(textView2, (View)imageView);
        uIMediaController.bindSeekBar(this.sM);
        uIMediaController.bindViewToUIController((View)seekBar, new zzpa(seekBar, this.sM));
        this.tz[0] = (ImageView)view.findViewById(R.id.button_0);
        this.tz[1] = (ImageView)view.findViewById(R.id.button_1);
        this.tz[2] = (ImageView)view.findViewById(R.id.button_2);
        this.tz[3] = (ImageView)view.findViewById(R.id.button_3);
        this.zza(view, R.id.button_0, this.ty[0], uIMediaController);
        this.zza(view, R.id.button_1, this.ty[1], uIMediaController);
        this.zza(view, R.id.button_play_pause_toggle, R.id.cast_button_type_play_pause_toggle, uIMediaController);
        this.zza(view, R.id.button_2, this.ty[2], uIMediaController);
        this.zza(view, R.id.button_3, this.ty[3], uIMediaController);
        this.tA = this.findViewById(R.id.ad_container);
        this.tx = this.zza((RelativeLayout)view.findViewById(R.id.seek_bar_controls));
    }

    private void zzaop() {
        Drawable drawable2;
        Drawable drawable3 = this.getResources().getDrawable(this.ts);
        ColorStateList colorStateList = null;
        if (drawable3 != null) {
            if (this.ts == R.drawable.cast_expanded_controller_seekbar_track) {
                colorStateList = this.zzaoq();
                drawable2 = (LayerDrawable)drawable3;
                Drawable drawable4 = DrawableCompat.wrap((Drawable)drawable2.findDrawableByLayerId(16908301));
                DrawableCompat.setTintList((Drawable)drawable4, (ColorStateList)colorStateList);
                drawable2.setDrawableByLayerId(16908301, drawable4);
                Drawable drawable5 = drawable2.findDrawableByLayerId(0x1020000);
                drawable5.setColorFilter(this.getResources().getColor(R.color.cast_expanded_controller_seek_bar_progress_background_tint_color), PorterDuff.Mode.SRC_IN);
            }
            this.sM.setProgressDrawable(drawable3);
        }
        if ((drawable2 = this.getResources().getDrawable(this.tt)) != null) {
            if (this.tt == R.drawable.cast_expanded_controller_seekbar_thumb) {
                if (colorStateList == null) {
                    colorStateList = this.zzaoq();
                }
                drawable2 = DrawableCompat.wrap((Drawable)drawable2);
                DrawableCompat.setTintList((Drawable)drawable2, (ColorStateList)colorStateList);
            }
            this.sM.setThumb(drawable2);
        }
    }

    private ColorStateList zzaoq() {
        int n = this.getResources().getColor(this.tr);
        TypedValue typedValue = new TypedValue();
        this.getResources().getValue(R.dimen.cast_expanded_controller_seekbar_disabled_alpha, typedValue, true);
        int n2 = Color.argb((int)((int)(typedValue.getFloat() * (float)Color.alpha((int)n))), (int)Color.red((int)n), (int)Color.green((int)n), (int)Color.blue((int)n));
        int[] nArray = new int[]{n, n2};
        int[][] nArrayArray = new int[][]{{16842910}, {-16842910}};
        return new ColorStateList((int[][])nArrayArray, nArray);
    }

    @TargetApi(value=21)
    private void zzaor() {
        if (zzs.zzayx()) {
            this.sM.setSplitTrack(false);
        }
    }

    private zzov zza(RelativeLayout relativeLayout) {
        zzov zzov2 = new zzov((Context)this);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -2);
        layoutParams.addRule(0, R.id.end_text);
        layoutParams.addRule(1, R.id.start_text);
        layoutParams.addRule(6, R.id.seek_bar);
        layoutParams.addRule(7, R.id.seek_bar);
        layoutParams.addRule(5, R.id.seek_bar);
        layoutParams.addRule(8, R.id.seek_bar);
        zzov2.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        zzov2.setPadding(this.sM.getPaddingLeft(), this.sM.getPaddingTop(), this.sM.getPaddingRight(), this.sM.getPaddingBottom());
        zzov2.setContentDescription(this.getResources().getString(R.string.cast_seek_bar));
        zzov2.setBackgroundColor(0);
        relativeLayout.addView((View)zzov2);
        return zzov2;
    }

    private void zza(Toolbar toolbar) {
        this.setSupportActionBar(toolbar);
        if (this.getSupportActionBar() != null) {
            this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
            this.getSupportActionBar().setHomeAsUpIndicator(R.drawable.quantum_ic_keyboard_arrow_down_white_36);
        }
    }

    @TargetApi(value=19)
    private void zzaos() {
        if (!zzs.zzayn()) {
            return;
        }
        int n = this.getWindow().getDecorView().getSystemUiVisibility();
        if (zzs.zzayq()) {
            n ^= 2;
        }
        if (zzs.zzayr()) {
            n ^= 4;
        }
        if (zzs.zzayu()) {
            n ^= 0x1000;
        }
        this.getWindow().getDecorView().setSystemUiVisibility(n);
        if (zzs.zzayt()) {
            this.setImmersive(true);
        }
    }

    private void zza(View view, int n, int n2, UIMediaController uIMediaController) {
        ImageView imageView = (ImageView)view.findViewById(n);
        if (n2 == R.id.cast_button_type_empty) {
            imageView.setVisibility(4);
        } else if (n2 != R.id.cast_button_type_custom) {
            if (n2 == R.id.cast_button_type_play_pause_toggle) {
                this.zza(imageView, uIMediaController);
            } else if (n2 == R.id.cast_button_type_skip_previous) {
                this.zzb(imageView, uIMediaController);
            } else if (n2 == R.id.cast_button_type_skip_next) {
                this.zzc(imageView, uIMediaController);
            } else if (n2 == R.id.cast_button_type_rewind_30_seconds) {
                this.zzd(imageView, uIMediaController);
            } else if (n2 == R.id.cast_button_type_forward_30_seconds) {
                this.zze(imageView, uIMediaController);
            } else if (n2 == R.id.cast_button_type_mute_toggle) {
                this.zzf(imageView, uIMediaController);
            } else if (n2 == R.id.cast_button_type_closed_caption) {
                this.zzg(imageView, uIMediaController);
            }
        }
    }

    private void zza(ImageView imageView, UIMediaController uIMediaController) {
        imageView.setBackgroundResource(this.tq);
        Drawable drawable2 = this.getResources().getDrawable(R.drawable.cast_ic_expanded_controller_pause);
        Drawable drawable3 = this.getResources().getDrawable(R.drawable.cast_ic_expanded_controller_play);
        Drawable drawable4 = this.getResources().getDrawable(R.drawable.cast_ic_expanded_controller_stop);
        imageView.setImageDrawable(drawable3);
        uIMediaController.bindImageViewToPlayPauseToggle(imageView, drawable3, drawable2, drawable4, null, false);
    }

    private void zzb(ImageView imageView, UIMediaController uIMediaController) {
        imageView.setBackgroundResource(this.tq);
        imageView.setImageDrawable(this.getResources().getDrawable(R.drawable.cast_ic_expanded_controller_skip_previous));
        imageView.setContentDescription((CharSequence)this.getResources().getString(R.string.cast_skip_prev));
        uIMediaController.bindViewToSkipPrev((View)imageView, 0);
    }

    private void zzc(ImageView imageView, UIMediaController uIMediaController) {
        imageView.setBackgroundResource(this.tq);
        imageView.setImageDrawable(this.getResources().getDrawable(R.drawable.cast_ic_expanded_controller_skip_next));
        imageView.setContentDescription((CharSequence)this.getResources().getString(R.string.cast_skip_next));
        uIMediaController.bindViewToSkipNext((View)imageView, 0);
    }

    private void zzd(ImageView imageView, UIMediaController uIMediaController) {
        imageView.setBackgroundResource(this.tq);
        imageView.setImageDrawable(this.getResources().getDrawable(R.drawable.cast_ic_expanded_controller_rewind30));
        imageView.setContentDescription((CharSequence)this.getResources().getString(R.string.cast_rewind_30));
        uIMediaController.bindViewToRewind((View)imageView, 30000L);
    }

    private void zze(ImageView imageView, UIMediaController uIMediaController) {
        imageView.setBackgroundResource(this.tq);
        imageView.setImageDrawable(this.getResources().getDrawable(R.drawable.cast_ic_expanded_controller_forward30));
        imageView.setContentDescription((CharSequence)this.getResources().getString(R.string.cast_forward_30));
        uIMediaController.bindViewToForward((View)imageView, 30000L);
    }

    private void zzf(ImageView imageView, UIMediaController uIMediaController) {
        imageView.setBackgroundResource(this.tq);
        imageView.setImageDrawable(this.getResources().getDrawable(R.drawable.cast_ic_expanded_controller_mute));
        uIMediaController.bindImageViewToMuteToggle(imageView);
    }

    private void zzg(ImageView imageView, UIMediaController uIMediaController) {
        imageView.setBackgroundResource(this.tq);
        imageView.setImageDrawable(this.getResources().getDrawable(R.drawable.cast_ic_expanded_controller_closed_caption));
        uIMediaController.bindViewToClosedCaption((View)imageView);
    }

    private RemoteMediaClient getRemoteMediaClient() {
        CastSession castSession = this.oX.getCurrentCastSession();
        return castSession != null && castSession.isConnected() ? castSession.getRemoteMediaClient() : null;
    }

    private void zzaot() {
        ActionBar actionBar;
        MediaMetadata mediaMetadata;
        MediaInfo mediaInfo;
        RemoteMediaClient remoteMediaClient = this.getRemoteMediaClient();
        if (remoteMediaClient != null && remoteMediaClient.hasMediaSession() && (mediaInfo = remoteMediaClient.getMediaInfo()) != null && (mediaMetadata = mediaInfo.getMetadata()) != null && (actionBar = this.getSupportActionBar()) != null) {
            actionBar.setTitle((CharSequence)mediaMetadata.getString("com.google.android.gms.cast.metadata.TITLE"));
        }
    }

    private void zzaou() {
        String string2;
        CastDevice castDevice;
        CastSession castSession = this.oX.getCurrentCastSession();
        if (castSession != null && (castDevice = castSession.getCastDevice()) != null && !TextUtils.isEmpty((CharSequence)(string2 = castDevice.getFriendlyName()))) {
            this.tu.setText((CharSequence)this.getResources().getString(R.string.cast_casting_to_device, new Object[]{string2}));
            return;
        }
        this.tu.setText((CharSequence)"");
    }

    private void zzaov() {
        Drawable drawable2;
        boolean bl;
        RemoteMediaClient remoteMediaClient = this.getRemoteMediaClient();
        MediaStatus mediaStatus = remoteMediaClient == null ? null : remoteMediaClient.getMediaStatus();
        boolean bl2 = bl = mediaStatus != null && mediaStatus.isPlayingAd();
        if (bl) {
            Bitmap bitmap;
            Bitmap bitmap2;
            if (zzs.zzays() && this.tw.getVisibility() == 8 && (drawable2 = this.tv.getDrawable()) != null && drawable2 instanceof BitmapDrawable && (bitmap2 = ((BitmapDrawable)drawable2).getBitmap()) != null && (bitmap = com.google.android.gms.cast.framework.media.widget.zza.zza((Context)this, bitmap2, 0.25f, 7.5f)) != null) {
                this.tw.setImageBitmap(bitmap);
                this.tw.setVisibility(0);
            }
            this.sM.setEnabled(false);
            this.tA.setVisibility(0);
        } else {
            this.sM.setEnabled(true);
            this.tA.setVisibility(8);
            if (zzs.zzays()) {
                this.tw.setVisibility(8);
                this.tw.setImageBitmap(null);
            }
        }
        MediaInfo mediaInfo = drawable2 = remoteMediaClient == null ? null : remoteMediaClient.getMediaInfo();
        if (drawable2 != null) {
            this.tx.zzez(this.sM.getMax());
            this.tx.zzb(drawable2.getAdBreaks(), -1);
        }
    }

    private class zza
    implements RemoteMediaClient.Listener {
        private zza() {
        }

        @Override
        public void onStatusUpdated() {
            RemoteMediaClient remoteMediaClient = ExpandedControllerActivity.this.getRemoteMediaClient();
            if (remoteMediaClient == null || !remoteMediaClient.hasMediaSession()) {
                ExpandedControllerActivity.this.finish();
                return;
            }
            ExpandedControllerActivity.this.zzaou();
            ExpandedControllerActivity.this.zzaov();
        }

        @Override
        public void onMetadataUpdated() {
            ExpandedControllerActivity.this.zzaot();
        }

        @Override
        public void onQueueStatusUpdated() {
        }

        @Override
        public void onPreloadStatusUpdated() {
        }

        @Override
        public void onSendingRemoteMediaRequest() {
            ExpandedControllerActivity.this.tu.setText((CharSequence)ExpandedControllerActivity.this.getResources().getString(R.string.cast_expanded_controller_loading));
        }
    }

    private class zzb
    implements SessionManagerListener<CastSession> {
        private zzb() {
        }

        @Override
        public void onSessionEnded(CastSession castSession, int n) {
            ExpandedControllerActivity.this.finish();
        }

        @Override
        public void onSessionStarting(CastSession castSession) {
        }

        @Override
        public void onSessionStarted(CastSession castSession, String string2) {
        }

        @Override
        public void onSessionStartFailed(CastSession castSession, int n) {
        }

        @Override
        public void onSessionEnding(CastSession castSession) {
        }

        @Override
        public void onSessionResuming(CastSession castSession, String string2) {
        }

        @Override
        public void onSessionResumed(CastSession castSession, boolean bl) {
        }

        @Override
        public void onSessionResumeFailed(CastSession castSession, int n) {
        }

        @Override
        public void onSessionSuspended(CastSession castSession, int n) {
        }
    }
}

