/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.widget.ImageView;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaQueueItem;
import com.google.android.gms.cast.framework.CastContext;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.media.CastMediaOptions;
import com.google.android.gms.cast.framework.media.ImageHints;
import com.google.android.gms.cast.framework.media.ImagePicker;
import com.google.android.gms.cast.framework.media.MediaUtils;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.media.uicontroller.UIController;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.internal.zzoq;

public class zzox
extends UIController {
    private final ImageView sC;
    private final ImageHints rZ;
    private final Bitmap sD;
    private final ImagePicker qO;
    private final zzoq sE;

    public zzox(ImageView imageView, Context context, @NonNull ImageHints imageHints, int n) {
        this.sC = imageView;
        this.rZ = imageHints;
        this.sD = BitmapFactory.decodeResource((Resources)context.getResources(), (int)n);
        CastMediaOptions castMediaOptions = CastContext.getSharedInstance(context).getCastOptions().getCastMediaOptions();
        this.qO = castMediaOptions != null ? castMediaOptions.getImagePicker() : null;
        this.sE = new zzoq(context.getApplicationContext());
    }

    @Override
    public void onSessionConnected(CastSession castSession) {
        super.onSessionConnected(castSession);
        this.sE.zza(new zzoq.zza(){

            @Override
            public void zzc(Bitmap bitmap) {
                if (bitmap != null) {
                    zzox.this.sC.setImageBitmap(bitmap);
                }
            }
        });
        this.sC.setImageBitmap(this.sD);
        this.zzaoh();
    }

    @Override
    public void onSessionEnded() {
        this.sE.clear();
        this.sC.setImageBitmap(this.sD);
        super.onSessionEnded();
    }

    @Override
    public void onMediaStatusUpdated() {
        this.zzaoh();
    }

    private void zzaoh() {
        RemoteMediaClient remoteMediaClient = this.getRemoteMediaClient();
        if (remoteMediaClient == null || !remoteMediaClient.hasMediaSession()) {
            this.sC.setImageBitmap(this.sD);
            return;
        }
        Uri uri = this.zza(remoteMediaClient.getPreloadedItem());
        if (uri == null) {
            this.sC.setImageBitmap(this.sD);
        } else {
            this.sE.zzo(uri);
        }
    }

    private Uri zza(MediaQueueItem mediaQueueItem) {
        WebImage webImage;
        if (mediaQueueItem == null) {
            return null;
        }
        MediaInfo mediaInfo = mediaQueueItem.getMedia();
        if (mediaInfo == null) {
            return null;
        }
        if (this.qO != null && (webImage = this.qO.onPickImage(mediaInfo.getMetadata(), this.rZ)) != null && webImage.getUrl() != null) {
            return webImage.getUrl();
        }
        return MediaUtils.getImageUri(mediaInfo, 0);
    }
}

