/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.view.View;
import android.widget.ImageView;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.framework.CastContext;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.media.CastMediaOptions;
import com.google.android.gms.cast.framework.media.ImageHints;
import com.google.android.gms.cast.framework.media.ImagePicker;
import com.google.android.gms.cast.framework.media.MediaUtils;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.media.uicontroller.UIController;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.internal.zzoq;

public class zzoy
extends UIController {
    private final ImageView sC;
    private final ImageHints rZ;
    private final Bitmap sG;
    private final View sH;
    private final ImagePicker qO;
    private final zzoq sE;

    public zzoy(ImageView imageView, Context context, @NonNull ImageHints imageHints, int n, View view) {
        this.sC = imageView;
        this.rZ = imageHints;
        this.sG = n != 0 ? BitmapFactory.decodeResource((Resources)context.getResources(), (int)n) : null;
        this.sH = view;
        CastMediaOptions castMediaOptions = CastContext.getSharedInstance(context).getCastOptions().getCastMediaOptions();
        this.qO = castMediaOptions != null ? castMediaOptions.getImagePicker() : null;
        this.sE = new zzoq(context.getApplicationContext());
    }

    @Override
    public void onSessionConnected(CastSession castSession) {
        super.onSessionConnected(castSession);
        this.sE.zza(new zzoq.zza(){

            @Override
            public void zzc(Bitmap bitmap) {
                if (bitmap != null) {
                    if (zzoy.this.sH != null) {
                        zzoy.this.sH.setVisibility(4);
                    }
                    zzoy.this.sC.setVisibility(0);
                    zzoy.this.sC.setImageBitmap(bitmap);
                }
            }
        });
        this.zzaoi();
        this.zzaoh();
    }

    @Override
    public void onSessionEnded() {
        this.sE.clear();
        this.zzaoi();
        super.onSessionEnded();
    }

    @Override
    public void onMediaStatusUpdated() {
        this.zzaoh();
    }

    private void zzaoh() {
        RemoteMediaClient remoteMediaClient = this.getRemoteMediaClient();
        if (remoteMediaClient == null || !remoteMediaClient.hasMediaSession()) {
            this.zzaoi();
            return;
        }
        Uri uri = this.zzc(remoteMediaClient.getMediaInfo());
        if (uri == null) {
            this.zzaoi();
        } else {
            this.sE.zzo(uri);
        }
    }

    private Uri zzc(MediaInfo mediaInfo) {
        WebImage webImage;
        if (mediaInfo == null) {
            return null;
        }
        if (this.qO != null && (webImage = this.qO.onPickImage(mediaInfo.getMetadata(), this.rZ)) != null && webImage.getUrl() != null) {
            return webImage.getUrl();
        }
        return MediaUtils.getImageUri(mediaInfo, 0);
    }

    private void zzaoi() {
        if (this.sH != null) {
            this.sH.setVisibility(0);
            this.sC.setVisibility(4);
        }
        if (this.sG != null) {
            this.sC.setImageBitmap(this.sG);
        }
    }
}

