/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Color;
import android.graphics.Typeface;
import android.os.Parcel;
import android.os.Parcelable;
import android.view.accessibility.CaptioningManager;
import com.google.android.gms.cast.zzn;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.util.zzp;
import com.google.android.gms.common.util.zzs;
import com.google.android.gms.internal.zzym;
import org.json.JSONException;
import org.json.JSONObject;

public final class TextTrackStyle
extends zza {
    public static final float DEFAULT_FONT_SCALE = 1.0f;
    public static final int COLOR_UNSPECIFIED = 0;
    public static final int EDGE_TYPE_UNSPECIFIED = -1;
    public static final int EDGE_TYPE_NONE = 0;
    public static final int EDGE_TYPE_OUTLINE = 1;
    public static final int EDGE_TYPE_DROP_SHADOW = 2;
    public static final int EDGE_TYPE_RAISED = 3;
    public static final int EDGE_TYPE_DEPRESSED = 4;
    public static final int WINDOW_TYPE_UNSPECIFIED = -1;
    public static final int WINDOW_TYPE_NONE = 0;
    public static final int WINDOW_TYPE_NORMAL = 1;
    public static final int WINDOW_TYPE_ROUNDED = 2;
    public static final int FONT_FAMILY_UNSPECIFIED = -1;
    public static final int FONT_FAMILY_SANS_SERIF = 0;
    public static final int FONT_FAMILY_MONOSPACED_SANS_SERIF = 1;
    public static final int FONT_FAMILY_SERIF = 2;
    public static final int FONT_FAMILY_MONOSPACED_SERIF = 3;
    public static final int FONT_FAMILY_CASUAL = 4;
    public static final int FONT_FAMILY_CURSIVE = 5;
    public static final int FONT_FAMILY_SMALL_CAPITALS = 6;
    public static final int FONT_STYLE_UNSPECIFIED = -1;
    public static final int FONT_STYLE_NORMAL = 0;
    public static final int FONT_STYLE_BOLD = 1;
    public static final int FONT_STYLE_ITALIC = 2;
    public static final int FONT_STYLE_BOLD_ITALIC = 3;
    public static final Parcelable.Creator<TextTrackStyle> CREATOR = new zzn();
    private final int mVersionCode;
    private float zzaoE;
    private int zzaoF;
    private int mBackgroundColor;
    private int zzaoG;
    private int zzaoH;
    private int zzaoI;
    private int zzaoJ;
    private int zzaoK;
    private String zzaoL;
    private int zzaoM;
    private int zzaoN;
    String zzalH;
    private JSONObject zzalI;

    TextTrackStyle(int n, float f, int n2, int n3, int n4, int n5, int n6, int n7, int n8, String string2, int n9, int n10, String string3) {
        this.mVersionCode = n;
        this.zzaoE = f;
        this.zzaoF = n2;
        this.mBackgroundColor = n3;
        this.zzaoG = n4;
        this.zzaoH = n5;
        this.zzaoI = n6;
        this.zzaoJ = n7;
        this.zzaoK = n8;
        this.zzaoL = string2;
        this.zzaoM = n9;
        this.zzaoN = n10;
        this.zzalH = string3;
        if (this.zzalH != null) {
            try {
                this.zzalI = new JSONObject(this.zzalH);
            }
            catch (JSONException jSONException) {
                this.zzalI = null;
                this.zzalH = null;
            }
        } else {
            this.zzalI = null;
        }
    }

    public TextTrackStyle() {
        this(1, 1.0f, 0, 0, -1, 0, -1, 0, 0, null, -1, -1, null);
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public void setFontScale(float f) {
        this.zzaoE = f;
    }

    public float getFontScale() {
        return this.zzaoE;
    }

    public void setForegroundColor(int n) {
        this.zzaoF = n;
    }

    public int getForegroundColor() {
        return this.zzaoF;
    }

    public void setBackgroundColor(int n) {
        this.mBackgroundColor = n;
    }

    public int getBackgroundColor() {
        return this.mBackgroundColor;
    }

    public void setEdgeType(int n) {
        if (n < 0 || n > 4) {
            throw new IllegalArgumentException("invalid edgeType");
        }
        this.zzaoG = n;
    }

    public int getEdgeType() {
        return this.zzaoG;
    }

    public void setEdgeColor(int n) {
        this.zzaoH = n;
    }

    public int getEdgeColor() {
        return this.zzaoH;
    }

    public void setWindowType(int n) {
        if (n < 0 || n > 2) {
            throw new IllegalArgumentException("invalid windowType");
        }
        this.zzaoI = n;
    }

    public int getWindowType() {
        return this.zzaoI;
    }

    public void setWindowColor(int n) {
        this.zzaoJ = n;
    }

    public int getWindowColor() {
        return this.zzaoJ;
    }

    public void setWindowCornerRadius(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("invalid windowCornerRadius");
        }
        this.zzaoK = n;
    }

    public int getWindowCornerRadius() {
        return this.zzaoK;
    }

    public void setFontFamily(String string2) {
        this.zzaoL = string2;
    }

    public String getFontFamily() {
        return this.zzaoL;
    }

    public void setFontGenericFamily(int n) {
        if (n < 0 || n > 6) {
            throw new IllegalArgumentException("invalid fontGenericFamily");
        }
        this.zzaoM = n;
    }

    public int getFontGenericFamily() {
        return this.zzaoM;
    }

    public void setFontStyle(int n) {
        if (n < 0 || n > 3) {
            throw new IllegalArgumentException("invalid fontStyle");
        }
        this.zzaoN = n;
    }

    public int getFontStyle() {
        return this.zzaoN;
    }

    public void setCustomData(JSONObject jSONObject) {
        this.zzalI = jSONObject;
    }

    public JSONObject getCustomData() {
        return this.zzalI;
    }

    @TargetApi(value=19)
    public static TextTrackStyle fromSystemSettings(Context context) {
        TextTrackStyle textTrackStyle = new TextTrackStyle();
        if (!zzs.zzyF()) {
            return textTrackStyle;
        }
        CaptioningManager captioningManager = (CaptioningManager)context.getSystemService("captioning");
        textTrackStyle.setFontScale(captioningManager.getFontScale());
        CaptioningManager.CaptionStyle captionStyle = captioningManager.getUserStyle();
        textTrackStyle.setBackgroundColor(captionStyle.backgroundColor);
        textTrackStyle.setForegroundColor(captionStyle.foregroundColor);
        switch (captionStyle.edgeType) {
            case 1: {
                textTrackStyle.setEdgeType(1);
                break;
            }
            case 2: {
                textTrackStyle.setEdgeType(2);
                break;
            }
            default: {
                textTrackStyle.setEdgeType(0);
            }
        }
        textTrackStyle.setEdgeColor(captionStyle.edgeColor);
        Typeface typeface = captionStyle.getTypeface();
        if (typeface != null) {
            if (Typeface.MONOSPACE.equals((Object)typeface)) {
                textTrackStyle.setFontGenericFamily(1);
            } else if (Typeface.SANS_SERIF.equals((Object)typeface)) {
                textTrackStyle.setFontGenericFamily(0);
            } else if (Typeface.SERIF.equals((Object)typeface)) {
                textTrackStyle.setFontGenericFamily(2);
            } else {
                textTrackStyle.setFontGenericFamily(0);
            }
            boolean bl = typeface.isBold();
            boolean bl2 = typeface.isItalic();
            if (bl && bl2) {
                textTrackStyle.setFontStyle(3);
            } else if (bl) {
                textTrackStyle.setFontStyle(1);
            } else if (bl2) {
                textTrackStyle.setFontStyle(2);
            } else {
                textTrackStyle.setFontStyle(0);
            }
        }
        return textTrackStyle;
    }

    public void zzn(JSONObject jSONObject) throws JSONException {
        String string2;
        this.zzaoE = (float)jSONObject.optDouble("fontScale", 1.0);
        this.zzaoF = this.zzcI(jSONObject.optString("foregroundColor"));
        this.mBackgroundColor = this.zzcI(jSONObject.optString("backgroundColor"));
        if (jSONObject.has("edgeType")) {
            string2 = jSONObject.getString("edgeType");
            if ("NONE".equals(string2)) {
                this.zzaoG = 0;
            } else if ("OUTLINE".equals(string2)) {
                this.zzaoG = 1;
            } else if ("DROP_SHADOW".equals(string2)) {
                this.zzaoG = 2;
            } else if ("RAISED".equals(string2)) {
                this.zzaoG = 3;
            } else if ("DEPRESSED".equals(string2)) {
                this.zzaoG = 4;
            }
        }
        this.zzaoH = this.zzcI(jSONObject.optString("edgeColor"));
        if (jSONObject.has("windowType")) {
            string2 = jSONObject.getString("windowType");
            if ("NONE".equals(string2)) {
                this.zzaoI = 0;
            } else if ("NORMAL".equals(string2)) {
                this.zzaoI = 1;
            } else if ("ROUNDED_CORNERS".equals(string2)) {
                this.zzaoI = 2;
            }
        }
        this.zzaoJ = this.zzcI(jSONObject.optString("windowColor"));
        if (this.zzaoI == 2) {
            this.zzaoK = jSONObject.optInt("windowRoundedCornerRadius", 0);
        }
        this.zzaoL = jSONObject.optString("fontFamily", null);
        if (jSONObject.has("fontGenericFamily")) {
            string2 = jSONObject.getString("fontGenericFamily");
            if ("SANS_SERIF".equals(string2)) {
                this.zzaoM = 0;
            } else if ("MONOSPACED_SANS_SERIF".equals(string2)) {
                this.zzaoM = 1;
            } else if ("SERIF".equals(string2)) {
                this.zzaoM = 2;
            } else if ("MONOSPACED_SERIF".equals(string2)) {
                this.zzaoM = 3;
            } else if ("CASUAL".equals(string2)) {
                this.zzaoM = 4;
            } else if ("CURSIVE".equals(string2)) {
                this.zzaoM = 5;
            } else if ("SMALL_CAPITALS".equals(string2)) {
                this.zzaoM = 6;
            }
        }
        if (jSONObject.has("fontStyle")) {
            string2 = jSONObject.getString("fontStyle");
            if ("NORMAL".equals(string2)) {
                this.zzaoN = 0;
            } else if ("BOLD".equals(string2)) {
                this.zzaoN = 1;
            } else if ("ITALIC".equals(string2)) {
                this.zzaoN = 2;
            } else if ("BOLD_ITALIC".equals(string2)) {
                this.zzaoN = 3;
            }
        }
        this.zzalI = jSONObject.optJSONObject("customData");
    }

    public JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("fontScale", (double)this.zzaoE);
            if (this.zzaoF != 0) {
                jSONObject.put("foregroundColor", (Object)this.zzZ(this.zzaoF));
            }
            if (this.mBackgroundColor != 0) {
                jSONObject.put("backgroundColor", (Object)this.zzZ(this.mBackgroundColor));
            }
            switch (this.zzaoG) {
                case 0: {
                    jSONObject.put("edgeType", (Object)"NONE");
                    break;
                }
                case 1: {
                    jSONObject.put("edgeType", (Object)"OUTLINE");
                    break;
                }
                case 2: {
                    jSONObject.put("edgeType", (Object)"DROP_SHADOW");
                    break;
                }
                case 3: {
                    jSONObject.put("edgeType", (Object)"RAISED");
                    break;
                }
                case 4: {
                    jSONObject.put("edgeType", (Object)"DEPRESSED");
                }
            }
            if (this.zzaoH != 0) {
                jSONObject.put("edgeColor", (Object)this.zzZ(this.zzaoH));
            }
            switch (this.zzaoI) {
                case 0: {
                    jSONObject.put("windowType", (Object)"NONE");
                    break;
                }
                case 1: {
                    jSONObject.put("windowType", (Object)"NORMAL");
                    break;
                }
                case 2: {
                    jSONObject.put("windowType", (Object)"ROUNDED_CORNERS");
                }
            }
            if (this.zzaoJ != 0) {
                jSONObject.put("windowColor", (Object)this.zzZ(this.zzaoJ));
            }
            if (this.zzaoI == 2) {
                jSONObject.put("windowRoundedCornerRadius", this.zzaoK);
            }
            if (this.zzaoL != null) {
                jSONObject.put("fontFamily", (Object)this.zzaoL);
            }
            switch (this.zzaoM) {
                case 0: {
                    jSONObject.put("fontGenericFamily", (Object)"SANS_SERIF");
                    break;
                }
                case 1: {
                    jSONObject.put("fontGenericFamily", (Object)"MONOSPACED_SANS_SERIF");
                    break;
                }
                case 2: {
                    jSONObject.put("fontGenericFamily", (Object)"SERIF");
                    break;
                }
                case 3: {
                    jSONObject.put("fontGenericFamily", (Object)"MONOSPACED_SERIF");
                    break;
                }
                case 4: {
                    jSONObject.put("fontGenericFamily", (Object)"CASUAL");
                    break;
                }
                case 5: {
                    jSONObject.put("fontGenericFamily", (Object)"CURSIVE");
                    break;
                }
                case 6: {
                    jSONObject.put("fontGenericFamily", (Object)"SMALL_CAPITALS");
                }
            }
            switch (this.zzaoN) {
                case 0: {
                    jSONObject.put("fontStyle", (Object)"NORMAL");
                    break;
                }
                case 1: {
                    jSONObject.put("fontStyle", (Object)"BOLD");
                    break;
                }
                case 2: {
                    jSONObject.put("fontStyle", (Object)"ITALIC");
                    break;
                }
                case 3: {
                    jSONObject.put("fontStyle", (Object)"BOLD_ITALIC");
                }
            }
            if (this.zzalI != null) {
                jSONObject.put("customData", (Object)this.zzalI);
            }
        }
        catch (JSONException jSONException) {}
        return jSONObject;
    }

    private String zzZ(int n) {
        return String.format("#%02X%02X%02X%02X", Color.red((int)n), Color.green((int)n), Color.blue((int)n), Color.alpha((int)n));
    }

    private int zzcI(String string2) {
        if (string2 != null && string2.length() == 9 && string2.charAt(0) == '#') {
            try {
                int n = Integer.parseInt(string2.substring(1, 3), 16);
                int n2 = Integer.parseInt(string2.substring(3, 5), 16);
                int n3 = Integer.parseInt(string2.substring(5, 7), 16);
                int n4 = Integer.parseInt(string2.substring(7, 9), 16);
                return Color.argb((int)n4, (int)n, (int)n2, (int)n3);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof TextTrackStyle)) {
            return false;
        }
        TextTrackStyle textTrackStyle = (TextTrackStyle)((Object)object);
        if (this.zzalI == null != (textTrackStyle.zzalI == null)) {
            return false;
        }
        if (this.zzalI != null && textTrackStyle.zzalI != null && !zzp.zzf((Object)this.zzalI, (Object)textTrackStyle.zzalI)) {
            return false;
        }
        return this.zzaoE == textTrackStyle.zzaoE && this.zzaoF == textTrackStyle.zzaoF && this.mBackgroundColor == textTrackStyle.mBackgroundColor && this.zzaoG == textTrackStyle.zzaoG && this.zzaoH == textTrackStyle.zzaoH && this.zzaoI == textTrackStyle.zzaoI && this.zzaoK == textTrackStyle.zzaoK && zzym.zza(this.zzaoL, textTrackStyle.zzaoL) && this.zzaoM == textTrackStyle.zzaoM && this.zzaoN == textTrackStyle.zzaoN;
    }

    public int hashCode() {
        return zzaa.hashCode((Object[])new Object[]{Float.valueOf(this.zzaoE), this.zzaoF, this.mBackgroundColor, this.zzaoG, this.zzaoH, this.zzaoI, this.zzaoJ, this.zzaoK, this.zzaoL, this.zzaoM, this.zzaoN, String.valueOf(this.zzalI)});
    }

    public void writeToParcel(Parcel parcel, int n) {
        this.zzalH = this.zzalI == null ? null : this.zzalI.toString();
        zzn.zza(this, parcel, n);
    }
}

