/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.android.gms.cast.zzm;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.util.zzq;
import com.google.android.gms.internal.zzyr;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public final class MediaTrack
extends zza
implements ReflectedParcelable {
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_TEXT = 1;
    public static final int TYPE_AUDIO = 2;
    public static final int TYPE_VIDEO = 3;
    public static final int SUBTYPE_UNKNOWN = -1;
    public static final int SUBTYPE_NONE = 0;
    public static final int SUBTYPE_SUBTITLES = 1;
    public static final int SUBTYPE_CAPTIONS = 2;
    public static final int SUBTYPE_DESCRIPTIONS = 3;
    public static final int SUBTYPE_CHAPTERS = 4;
    public static final int SUBTYPE_METADATA = 5;
    public static final Parcelable.Creator<MediaTrack> CREATOR = new zzm();
    private long zzait;
    private int zzakD;
    private String zzaoh;
    private String zzaoj;
    private String mName;
    private String zzacX;
    private int zzaoX;
    String zzamN;
    private JSONObject zzamO;

    MediaTrack(long l, int n, String string2, String string3, String string4, String string5, int n2, String string6) {
        this.zzait = l;
        this.zzakD = n;
        this.zzaoh = string2;
        this.zzaoj = string3;
        this.mName = string4;
        this.zzacX = string5;
        this.zzaoX = n2;
        this.zzamN = string6;
        if (this.zzamN != null) {
            try {
                this.zzamO = new JSONObject(this.zzamN);
            }
            catch (JSONException jSONException) {
                this.zzamO = null;
                this.zzamN = null;
            }
        } else {
            this.zzamO = null;
        }
    }

    MediaTrack(JSONObject jSONObject) throws JSONException {
        this(0L, 0, null, null, null, null, -1, null);
        this.zzn(jSONObject);
    }

    MediaTrack(long l, int n) throws IllegalArgumentException {
        this(0L, 0, null, null, null, null, -1, null);
        this.zzait = l;
        if (n <= 0 || n > 3) {
            throw new IllegalArgumentException(new StringBuilder(24).append("invalid type ").append(n).toString());
        }
        this.zzakD = n;
    }

    public long getId() {
        return this.zzait;
    }

    public int getType() {
        return this.zzakD;
    }

    public String getContentId() {
        return this.zzaoh;
    }

    public void setContentId(String string2) {
        this.zzaoh = string2;
    }

    public String getContentType() {
        return this.zzaoj;
    }

    public void setContentType(String string2) {
        this.zzaoj = string2;
    }

    public String getName() {
        return this.mName;
    }

    void setName(String string2) {
        this.mName = string2;
    }

    public String getLanguage() {
        return this.zzacX;
    }

    void setLanguage(String string2) {
        this.zzacX = string2;
    }

    public int getSubtype() {
        return this.zzaoX;
    }

    void zzbS(int n) throws IllegalArgumentException {
        if (n <= -1 || n > 5) {
            throw new IllegalArgumentException(new StringBuilder(27).append("invalid subtype ").append(n).toString());
        }
        if (n != 0 && this.zzakD != 1) {
            throw new IllegalArgumentException("subtypes are only valid for text tracks");
        }
        this.zzaoX = n;
    }

    public JSONObject getCustomData() {
        return this.zzamO;
    }

    void setCustomData(JSONObject jSONObject) {
        this.zzamO = jSONObject;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void zzn(JSONObject jSONObject) throws JSONException {
        block12: {
            block13: {
                String string2;
                block16: {
                    block15: {
                        block14: {
                            this.zzait = jSONObject.getLong("trackId");
                            string2 = jSONObject.getString("type");
                            if ("TEXT".equals(string2)) {
                                this.zzakD = 1;
                            } else if ("AUDIO".equals(string2)) {
                                this.zzakD = 2;
                            } else if ("VIDEO".equals(string2)) {
                                this.zzakD = 3;
                            } else {
                                String string3;
                                String string4 = String.valueOf(string2);
                                if (string4.length() != 0) {
                                    string3 = "invalid type: ".concat(string4);
                                    throw new JSONException(string3);
                                }
                                string3 = new String("invalid type: ");
                                throw new JSONException(string3);
                            }
                            this.zzaoh = jSONObject.optString("trackContentId", null);
                            this.zzaoj = jSONObject.optString("trackContentType", null);
                            this.mName = jSONObject.optString("name", null);
                            this.zzacX = jSONObject.optString("language", null);
                            if (!jSONObject.has("subtype")) break block13;
                            string2 = jSONObject.getString("subtype");
                            if (!"SUBTITLES".equals(string2)) break block14;
                            this.zzaoX = 1;
                            break block12;
                        }
                        if (!"CAPTIONS".equals(string2)) break block15;
                        this.zzaoX = 2;
                        break block12;
                    }
                    if (!"DESCRIPTIONS".equals(string2)) break block16;
                    this.zzaoX = 3;
                    break block12;
                }
                if ("CHAPTERS".equals(string2)) {
                    this.zzaoX = 4;
                    break block12;
                } else if ("METADATA".equals(string2)) {
                    this.zzaoX = 5;
                    break block12;
                } else {
                    String string5;
                    String string6 = String.valueOf(string2);
                    if (string6.length() != 0) {
                        string5 = "invalid subtype: ".concat(string6);
                        throw new JSONException(string5);
                    }
                    string5 = new String("invalid subtype: ");
                    throw new JSONException(string5);
                }
            }
            this.zzaoX = 0;
        }
        this.zzamO = jSONObject.optJSONObject("customData");
    }

    public JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("trackId", this.zzait);
            switch (this.zzakD) {
                case 1: {
                    jSONObject.put("type", (Object)"TEXT");
                    break;
                }
                case 2: {
                    jSONObject.put("type", (Object)"AUDIO");
                    break;
                }
                case 3: {
                    jSONObject.put("type", (Object)"VIDEO");
                }
            }
            if (this.zzaoh != null) {
                jSONObject.put("trackContentId", (Object)this.zzaoh);
            }
            if (this.zzaoj != null) {
                jSONObject.put("trackContentType", (Object)this.zzaoj);
            }
            if (this.mName != null) {
                jSONObject.put("name", (Object)this.mName);
            }
            if (!TextUtils.isEmpty((CharSequence)this.zzacX)) {
                jSONObject.put("language", (Object)this.zzacX);
            }
            switch (this.zzaoX) {
                case 1: {
                    jSONObject.put("subtype", (Object)"SUBTITLES");
                    break;
                }
                case 2: {
                    jSONObject.put("subtype", (Object)"CAPTIONS");
                    break;
                }
                case 3: {
                    jSONObject.put("subtype", (Object)"DESCRIPTIONS");
                    break;
                }
                case 4: {
                    jSONObject.put("subtype", (Object)"CHAPTERS");
                    break;
                }
                case 5: {
                    jSONObject.put("subtype", (Object)"METADATA");
                }
            }
            if (this.zzamO != null) {
                jSONObject.put("customData", (Object)this.zzamO);
            }
        }
        catch (JSONException jSONException) {}
        return jSONObject;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MediaTrack)) {
            return false;
        }
        MediaTrack mediaTrack = (MediaTrack)((Object)object);
        if (this.zzamO == null != (mediaTrack.zzamO == null)) {
            return false;
        }
        if (this.zzamO != null && mediaTrack.zzamO != null && !zzq.zze((Object)this.zzamO, (Object)mediaTrack.zzamO)) {
            return false;
        }
        return this.zzait == mediaTrack.zzait && this.zzakD == mediaTrack.zzakD && zzyr.zza(this.zzaoh, mediaTrack.zzaoh) && zzyr.zza(this.zzaoj, mediaTrack.zzaoj) && zzyr.zza(this.mName, mediaTrack.mName) && zzyr.zza(this.zzacX, mediaTrack.zzacX) && this.zzaoX == mediaTrack.zzaoX;
    }

    public int hashCode() {
        return zzaa.hashCode((Object[])new Object[]{this.zzait, this.zzakD, this.zzaoh, this.zzaoj, this.mName, this.zzacX, this.zzaoX, String.valueOf(this.zzamO)});
    }

    public void writeToParcel(Parcel parcel, int n) {
        this.zzamN = this.zzamO == null ? null : this.zzamO.toString();
        zzm.zza(this, parcel, n);
    }

    public static class Builder {
        private final MediaTrack zzaoY;

        public Builder(long l, int n) throws IllegalArgumentException {
            this.zzaoY = new MediaTrack(l, n);
        }

        public Builder setContentId(String string2) {
            this.zzaoY.setContentId(string2);
            return this;
        }

        public Builder setContentType(String string2) {
            this.zzaoY.setContentType(string2);
            return this;
        }

        public Builder setName(String string2) {
            this.zzaoY.setName(string2);
            return this;
        }

        public Builder setLanguage(String string2) {
            this.zzaoY.setLanguage(string2);
            return this;
        }

        public Builder setLanguage(Locale locale) {
            this.zzaoY.setLanguage(zzyr.zzb(locale));
            return this;
        }

        public Builder setSubtype(int n) throws IllegalArgumentException {
            this.zzaoY.zzbS(n);
            return this;
        }

        public Builder setCustomData(JSONObject jSONObject) {
            this.zzaoY.setCustomData(jSONObject);
            return this;
        }

        public MediaTrack build() {
            return this.zzaoY;
        }
    }
}

