/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.cast.zzb;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.internal.zzazq;
import java.util.Arrays;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AdBreakInfo
extends zza {
    public static final Parcelable.Creator<AdBreakInfo> CREATOR = new zzb();
    private final long zzaoG;
    private final String zzIl;
    private final long zzaoB;
    private final boolean zzaoH;
    private String[] zzaoI;

    public AdBreakInfo(long l, String string, long l2, boolean bl, String[] stringArray) {
        this.zzaoG = l;
        this.zzIl = string;
        this.zzaoB = l2;
        this.zzaoH = bl;
        this.zzaoI = stringArray;
    }

    public long getPlaybackPositionInMs() {
        return this.zzaoG;
    }

    public String getId() {
        return this.zzIl;
    }

    public long getDurationInMs() {
        return this.zzaoB;
    }

    public boolean isWatched() {
        return this.zzaoH;
    }

    public String[] getBreakClipIds() {
        return this.zzaoI;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        AdBreakInfo adBreakInfo = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)2, (long)adBreakInfo.getPlaybackPositionInMs());
        zzd.zza((Parcel)parcel2, (int)3, (String)adBreakInfo.getId(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)4, (long)adBreakInfo.getDurationInMs());
        zzd.zza((Parcel)parcel2, (int)5, (boolean)adBreakInfo.isWatched());
        zzd.zza((Parcel)parcel2, (int)6, (String[])adBreakInfo.getBreakClipIds(), (boolean)false);
        zzd.zzI((Parcel)parcel2, (int)n2);
    }

    public int hashCode() {
        return this.zzIl.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AdBreakInfo)) {
            return false;
        }
        AdBreakInfo adBreakInfo = (AdBreakInfo)((Object)object);
        return zzazq.zza(this.zzIl, adBreakInfo.zzIl) && this.zzaoG == adBreakInfo.zzaoG && this.zzaoB == adBreakInfo.zzaoB && this.zzaoH == adBreakInfo.zzaoH && Arrays.equals(this.zzaoI, adBreakInfo.zzaoI);
    }

    static AdBreakInfo zzi(JSONObject jSONObject) {
        if (jSONObject == null) {
            return null;
        }
        if (!jSONObject.has("id") || !jSONObject.has("position")) {
            return null;
        }
        try {
            String string = jSONObject.getString("id");
            long l = (long)((double)jSONObject.getLong("position") * 1000.0);
            boolean bl = jSONObject.optBoolean("isWatched");
            long l2 = (long)((double)jSONObject.optLong("duration") * 1000.0);
            JSONArray jSONArray = jSONObject.optJSONArray("breakClipIds");
            String[] stringArray = null;
            if (jSONArray != null) {
                stringArray = new String[jSONArray.length()];
                for (int i = 0; i < jSONArray.length(); ++i) {
                    stringArray[i] = jSONArray.getString(i);
                }
            }
            return new AdBreakInfo(l, string, l2, bl, stringArray);
        }
        catch (JSONException jSONException) {
            Log.d((String)"AdBreakInfo", (String)String.format(Locale.ROOT, "Error while creating an AdBreakInfo from JSON: %s", jSONException.getMessage()));
            return null;
        }
    }

    public static class Builder {
        private long zzaoG = 0L;

        public Builder(long l) {
            this.zzaoG = l;
        }

        public AdBreakInfo build() {
            return new AdBreakInfo(this.zzaoG, null, 0L, false, null);
        }
    }
}

