/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.zzae;
import com.google.android.gms.cast.zzaf;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.util.zzq;
import com.google.android.gms.internal.zzazq;
import java.util.Arrays;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MediaQueueItem
extends zza {
    public static final int INVALID_ITEM_ID = 0;
    public static final double DEFAULT_PLAYBACK_DURATION = Double.POSITIVE_INFINITY;
    public static final Parcelable.Creator<MediaQueueItem> CREATOR = new zzaf();
    private MediaInfo zzaqq;
    private int zzaqr;
    private boolean zzaqs;
    private double zzaqt;
    private double zzaqu;
    private double zzaqv;
    private long[] zzaqw;
    private String zzaoE;
    private JSONObject zzaoF;

    MediaQueueItem(MediaInfo mediaInfo, int n, boolean bl, double d, double d2, double d3, long[] lArray, String string2) {
        this.zzaqq = mediaInfo;
        this.zzaqr = n;
        this.zzaqs = bl;
        this.zzaqt = d;
        this.zzaqu = d2;
        this.zzaqv = d3;
        this.zzaqw = lArray;
        this.zzaoE = string2;
        if (this.zzaoE != null) {
            try {
                this.zzaoF = new JSONObject(this.zzaoE);
                return;
            }
            catch (JSONException jSONException) {
                this.zzaoF = null;
                this.zzaoE = null;
                return;
            }
        }
        this.zzaoF = null;
    }

    private MediaQueueItem(MediaInfo mediaInfo) throws IllegalArgumentException {
        this(mediaInfo, 0, true, 0.0, Double.POSITIVE_INFINITY, 0.0, null, null);
        if (mediaInfo == null) {
            throw new IllegalArgumentException("media cannot be null.");
        }
    }

    MediaQueueItem(JSONObject jSONObject) throws JSONException {
        this(null, 0, true, 0.0, Double.POSITIVE_INFINITY, 0.0, null, null);
        this.zzm(jSONObject);
    }

    private MediaQueueItem(MediaQueueItem mediaQueueItem) throws IllegalArgumentException {
        this(mediaQueueItem.getMedia(), mediaQueueItem.getItemId(), mediaQueueItem.getAutoplay(), mediaQueueItem.getStartTime(), mediaQueueItem.getPlaybackDuration(), mediaQueueItem.getPreloadTime(), mediaQueueItem.getActiveTrackIds(), null);
        if (this.zzaqq == null) {
            throw new IllegalArgumentException("media cannot be null.");
        }
        this.zzaoF = mediaQueueItem.getCustomData();
    }

    public final boolean zzm(JSONObject jSONObject) throws JSONException {
        int n;
        boolean bl = false;
        if (jSONObject.has("media")) {
            this.zzaqq = new MediaInfo(jSONObject.getJSONObject("media"));
            bl = true;
        }
        if (jSONObject.has("itemId") && this.zzaqr != (n = jSONObject.getInt("itemId"))) {
            this.zzaqr = n;
            bl = true;
        }
        if (jSONObject.has("autoplay") && this.zzaqs != (n = (int)(jSONObject.getBoolean("autoplay") ? 1 : 0))) {
            this.zzaqs = n;
            bl = true;
        }
        if (jSONObject.has("startTime")) {
            double d;
            double d2 = jSONObject.getDouble("startTime");
            if (Math.abs(d - this.zzaqt) > 1.0E-7) {
                this.zzaqt = d2;
                bl = true;
            }
        }
        if (jSONObject.has("playbackDuration")) {
            double d;
            double d3 = jSONObject.getDouble("playbackDuration");
            if (Math.abs(d - this.zzaqu) > 1.0E-7) {
                this.zzaqu = d3;
                bl = true;
            }
        }
        if (jSONObject.has("preloadTime")) {
            double d;
            double d4 = jSONObject.getDouble("preloadTime");
            if (Math.abs(d - this.zzaqv) > 1.0E-7) {
                this.zzaqv = d4;
                bl = true;
            }
        }
        boolean bl2 = false;
        long[] lArray = null;
        if (jSONObject.has("activeTrackIds")) {
            int n2;
            JSONArray jSONArray = jSONObject.getJSONArray("activeTrackIds");
            int n3 = jSONArray.length();
            lArray = new long[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                lArray[n2] = jSONArray.getLong(n2);
            }
            if (this.zzaqw == null) {
                bl2 = true;
            } else if (this.zzaqw.length != n3) {
                bl2 = true;
            } else {
                for (n2 = 0; n2 < n3; ++n2) {
                    if (this.zzaqw[n2] == lArray[n2]) continue;
                    bl2 = true;
                    break;
                }
            }
        }
        if (bl2) {
            this.zzaqw = lArray;
            bl = true;
        }
        if (jSONObject.has("customData")) {
            this.zzaoF = jSONObject.getJSONObject("customData");
            bl = true;
        }
        return bl;
    }

    public MediaInfo getMedia() {
        return this.zzaqq;
    }

    public int getItemId() {
        return this.zzaqr;
    }

    final void zzV(int n) {
        this.zzaqr = 0;
    }

    public boolean getAutoplay() {
        return this.zzaqs;
    }

    final void zzU(boolean bl) {
        this.zzaqs = bl;
    }

    public double getStartTime() {
        return this.zzaqt;
    }

    final void zzc(double d) throws IllegalArgumentException {
        if (Double.isNaN(d) || d < 0.0) {
            throw new IllegalArgumentException("startTime cannot be negative or NaN.");
        }
        this.zzaqt = d;
    }

    public double getPlaybackDuration() {
        return this.zzaqu;
    }

    final void zzd(double d) throws IllegalArgumentException {
        if (Double.isNaN(d)) {
            throw new IllegalArgumentException("playbackDuration cannot be NaN.");
        }
        this.zzaqu = d;
    }

    public double getPreloadTime() {
        return this.zzaqv;
    }

    final void zze(double d) throws IllegalArgumentException {
        if (Double.isNaN(d) || d < 0.0) {
            throw new IllegalArgumentException("preloadTime cannot be negative or NaN.");
        }
        this.zzaqv = d;
    }

    public long[] getActiveTrackIds() {
        return this.zzaqw;
    }

    final void zza(long[] lArray) {
        this.zzaqw = lArray;
    }

    public JSONObject getCustomData() {
        return this.zzaoF;
    }

    final void setCustomData(JSONObject jSONObject) {
        this.zzaoF = jSONObject;
    }

    final void zznh() throws IllegalArgumentException {
        if (this.zzaqq == null) {
            throw new IllegalArgumentException("media cannot be null.");
        }
        if (Double.isNaN(this.zzaqt) || this.zzaqt < 0.0) {
            throw new IllegalArgumentException("startTime cannot be negative or NaN.");
        }
        if (Double.isNaN(this.zzaqu)) {
            throw new IllegalArgumentException("playbackDuration cannot be NaN.");
        }
        if (Double.isNaN(this.zzaqv) || this.zzaqv < 0.0) {
            throw new IllegalArgumentException("preloadTime cannot be negative or Nan.");
        }
    }

    public final JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("media", (Object)this.zzaqq.toJson());
            if (this.zzaqr != 0) {
                jSONObject.put("itemId", this.zzaqr);
            }
            jSONObject.put("autoplay", this.zzaqs);
            jSONObject.put("startTime", this.zzaqt);
            if (this.zzaqu != Double.POSITIVE_INFINITY) {
                jSONObject.put("playbackDuration", this.zzaqu);
            }
            jSONObject.put("preloadTime", this.zzaqv);
            if (this.zzaqw != null) {
                JSONArray jSONArray = new JSONArray();
                long[] lArray = this.zzaqw;
                int n = this.zzaqw.length;
                for (int i = 0; i < n; ++i) {
                    long l = lArray[i];
                    jSONArray.put(l);
                }
                jSONObject.put("activeTrackIds", (Object)jSONArray);
            }
            if (this.zzaoF != null) {
                jSONObject.put("customData", (Object)this.zzaoF);
            }
        }
        catch (JSONException jSONException) {}
        return jSONObject;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MediaQueueItem)) {
            return false;
        }
        MediaQueueItem mediaQueueItem = (MediaQueueItem)((Object)object);
        if (this.zzaoF == null != (mediaQueueItem.zzaoF == null)) {
            return false;
        }
        if (this.zzaoF != null && mediaQueueItem.zzaoF != null && !zzq.zzc((Object)this.zzaoF, (Object)mediaQueueItem.zzaoF)) {
            return false;
        }
        return zzazq.zza(this.zzaqq, mediaQueueItem.zzaqq) && this.zzaqr == mediaQueueItem.zzaqr && this.zzaqs == mediaQueueItem.zzaqs && this.zzaqt == mediaQueueItem.zzaqt && this.zzaqu == mediaQueueItem.zzaqu && this.zzaqv == mediaQueueItem.zzaqv && Arrays.equals(this.zzaqw, mediaQueueItem.zzaqw);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzaqq, this.zzaqr, this.zzaqs, this.zzaqt, this.zzaqu, this.zzaqv, Arrays.hashCode(this.zzaqw), String.valueOf(this.zzaoF)});
    }

    public void writeToParcel(Parcel parcel, int n) {
        this.zzaoE = this.zzaoF == null ? null : this.zzaoF.toString();
        Parcel parcel2 = parcel;
        MediaQueueItem mediaQueueItem = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)2, (Parcelable)mediaQueueItem.getMedia(), (int)n, (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)3, (int)mediaQueueItem.getItemId());
        zzd.zza((Parcel)parcel2, (int)4, (boolean)mediaQueueItem.getAutoplay());
        zzd.zza((Parcel)parcel2, (int)5, (double)mediaQueueItem.getStartTime());
        zzd.zza((Parcel)parcel2, (int)6, (double)mediaQueueItem.getPlaybackDuration());
        zzd.zza((Parcel)parcel2, (int)7, (double)mediaQueueItem.getPreloadTime());
        zzd.zza((Parcel)parcel2, (int)8, (long[])mediaQueueItem.getActiveTrackIds(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)9, (String)mediaQueueItem.zzaoE, (boolean)false);
        zzd.zzI((Parcel)parcel2, (int)n2);
    }

    /* synthetic */ MediaQueueItem(MediaInfo mediaInfo, zzae zzae2) throws IllegalArgumentException {
        this(mediaInfo);
    }

    /* synthetic */ MediaQueueItem(MediaQueueItem mediaQueueItem, zzae zzae2) throws IllegalArgumentException {
        this(mediaQueueItem);
    }

    public static class Builder {
        private final MediaQueueItem zzaqx;

        public Builder(MediaInfo mediaInfo) throws IllegalArgumentException {
            this.zzaqx = new MediaQueueItem(mediaInfo, null);
        }

        public Builder(JSONObject jSONObject) throws JSONException {
            this.zzaqx = new MediaQueueItem(jSONObject);
        }

        public Builder(MediaQueueItem mediaQueueItem) throws IllegalArgumentException {
            this.zzaqx = new MediaQueueItem(mediaQueueItem, null);
        }

        public Builder clearItemId() {
            this.zzaqx.zzV(0);
            return this;
        }

        public Builder setAutoplay(boolean bl) {
            this.zzaqx.zzU(bl);
            return this;
        }

        public Builder setStartTime(double d) throws IllegalArgumentException {
            this.zzaqx.zzc(d);
            return this;
        }

        public Builder setPlaybackDuration(double d) {
            this.zzaqx.zzd(d);
            return this;
        }

        public Builder setPreloadTime(double d) throws IllegalArgumentException {
            this.zzaqx.zze(d);
            return this;
        }

        public Builder setActiveTrackIds(long[] lArray) {
            this.zzaqx.zza(lArray);
            return this;
        }

        public Builder setCustomData(JSONObject jSONObject) {
            this.zzaqx.setCustomData(jSONObject);
            return this;
        }

        public MediaQueueItem build() {
            this.zzaqx.zznh();
            return this.zzaqx;
        }
    }
}

