/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.cast.zzb;
import com.google.android.gms.internal.zzbcm;
import com.google.android.gms.internal.zzbfm;
import com.google.android.gms.internal.zzbfp;
import java.util.Arrays;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AdBreakInfo
extends zzbfm {
    public static final Parcelable.Creator<AdBreakInfo> CREATOR = new zzb();
    private final long zzemz;
    private final String zzbuz;
    private final long zzemu;
    private final boolean zzena;
    private String[] zzenb;

    public AdBreakInfo(long l, String string, long l2, boolean bl, String[] stringArray) {
        this.zzemz = l;
        this.zzbuz = string;
        this.zzemu = l2;
        this.zzena = bl;
        this.zzenb = stringArray;
    }

    public long getPlaybackPositionInMs() {
        return this.zzemz;
    }

    public String getId() {
        return this.zzbuz;
    }

    public long getDurationInMs() {
        return this.zzemu;
    }

    public boolean isWatched() {
        return this.zzena;
    }

    public String[] getBreakClipIds() {
        return this.zzenb;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        AdBreakInfo adBreakInfo = this;
        int n2 = zzbfp.zze((Parcel)parcel2);
        zzbfp.zza((Parcel)parcel2, (int)2, (long)adBreakInfo.getPlaybackPositionInMs());
        zzbfp.zza((Parcel)parcel2, (int)3, (String)adBreakInfo.getId(), (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)4, (long)adBreakInfo.getDurationInMs());
        zzbfp.zza((Parcel)parcel2, (int)5, (boolean)adBreakInfo.isWatched());
        zzbfp.zza((Parcel)parcel2, (int)6, (String[])adBreakInfo.getBreakClipIds(), (boolean)false);
        zzbfp.zzai((Parcel)parcel2, (int)n2);
    }

    public int hashCode() {
        return this.zzbuz.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AdBreakInfo)) {
            return false;
        }
        AdBreakInfo adBreakInfo = (AdBreakInfo)((Object)object);
        return zzbcm.zza(this.zzbuz, adBreakInfo.zzbuz) && this.zzemz == adBreakInfo.zzemz && this.zzemu == adBreakInfo.zzemu && this.zzena == adBreakInfo.zzena && Arrays.equals(this.zzenb, adBreakInfo.zzenb);
    }

    static AdBreakInfo zzr(JSONObject jSONObject) {
        if (jSONObject == null) {
            return null;
        }
        if (!jSONObject.has("id") || !jSONObject.has("position")) {
            return null;
        }
        try {
            String string = jSONObject.getString("id");
            long l = (long)((double)jSONObject.getLong("position") * 1000.0);
            boolean bl = jSONObject.optBoolean("isWatched");
            long l2 = (long)((double)jSONObject.optLong("duration") * 1000.0);
            JSONArray jSONArray = jSONObject.optJSONArray("breakClipIds");
            String[] stringArray = null;
            if (jSONArray != null) {
                stringArray = new String[jSONArray.length()];
                for (int i = 0; i < jSONArray.length(); ++i) {
                    stringArray[i] = jSONArray.getString(i);
                }
            }
            return new AdBreakInfo(l, string, l2, bl, stringArray);
        }
        catch (JSONException jSONException) {
            Log.d((String)"AdBreakInfo", (String)String.format(Locale.ROOT, "Error while creating an AdBreakInfo from JSON: %s", jSONException.getMessage()));
            return null;
        }
    }

    public static class Builder {
        private long zzemz = 0L;

        public Builder(long l) {
            this.zzemz = l;
        }

        public AdBreakInfo build() {
            return new AdBreakInfo(this.zzemz, null, 0L, false, null);
        }
    }
}

