/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.annotation.TargetApi;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import android.support.v4.app.NotificationCompat;
import android.support.v7.media.MediaRouteSelector;
import android.support.v7.media.MediaRouter;
import android.text.TextUtils;
import android.view.Display;
import com.google.android.gms.R;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.CastMediaControlIntent;
import com.google.android.gms.cast.CastRemoteDisplay;
import com.google.android.gms.cast.CastRemoteDisplayClient;
import com.google.android.gms.cast.zzaa;
import com.google.android.gms.cast.zzu;
import com.google.android.gms.cast.zzv;
import com.google.android.gms.cast.zzw;
import com.google.android.gms.cast.zzx;
import com.google.android.gms.cast.zzy;
import com.google.android.gms.cast.zzz;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.util.zzq;
import com.google.android.gms.internal.zzbcy;
import com.google.android.gms.tasks.OnCompleteListener;
import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicBoolean;

@TargetApi(value=19)
public abstract class CastRemoteDisplayLocalService
extends Service {
    private static final zzbcy zzeow = new zzbcy("CastRemoteDisplayLocalService");
    private static final int zzeox = R.id.cast_notification_id;
    private static final Object zzeoy = new Object();
    private static AtomicBoolean zzeoz = new AtomicBoolean(false);
    private String zzenh;
    private WeakReference<Callbacks> zzepa;
    private zzb zzepb;
    private NotificationSettings zzepc;
    private Notification mNotification;
    private boolean zzepd;
    private PendingIntent zzepe;
    private CastDevice zzepf;
    private Display zzdhs;
    private Context zzepg;
    private ServiceConnection zzeph;
    private Handler mHandler;
    private MediaRouter zzepi;
    private boolean zzepj = false;
    private CastRemoteDisplayClient zzepk;
    private final MediaRouter.Callback zzepl = new zzu(this);
    private static CastRemoteDisplayLocalService zzepm;
    private final IBinder zzepn = new zza();

    public CastRemoteDisplayLocalService() {
    }

    public IBinder onBind(Intent intent) {
        this.zzdv("onBind");
        return this.zzepn;
    }

    public void onCreate() {
        this.zzdv("onCreate");
        super.onCreate();
        this.mHandler = new Handler(this.getMainLooper());
        this.mHandler.postDelayed((Runnable)new zzv(this), 100L);
        if (this.zzepk == null) {
            this.zzepk = CastRemoteDisplay.getClient((Context)this);
        }
        CastRemoteDisplayLocalService castRemoteDisplayLocalService = this;
        if (zzq.isAtLeastO()) {
            NotificationManager notificationManager = (NotificationManager)castRemoteDisplayLocalService.getSystemService(NotificationManager.class);
            NotificationChannel notificationChannel = new NotificationChannel("cast_remote_display_local_service", (CharSequence)castRemoteDisplayLocalService.getString(R.string.cast_notification_default_channel_name), 2);
            notificationChannel.setShowBadge(false);
            notificationManager.createNotificationChannel(notificationChannel);
        }
    }

    public int onStartCommand(Intent intent, int n, int n2) {
        this.zzdv("onStartCommand");
        this.zzepj = true;
        return 2;
    }

    protected static void setDebugEnabled() {
        zzeow.zzbd(true);
    }

    protected Display getDisplay() {
        return this.zzdhs;
    }

    public abstract void onCreatePresentation(Display var1);

    public abstract void onDismissPresentation();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CastRemoteDisplayLocalService getInstance() {
        Object object = zzeoy;
        synchronized (object) {
            return zzepm;
        }
    }

    public static void startService(Context context, Class<? extends CastRemoteDisplayLocalService> clazz, String string2, CastDevice castDevice, NotificationSettings notificationSettings, Callbacks callbacks) {
        CastRemoteDisplayLocalService.startServiceWithOptions(context, clazz, string2, castDevice, new Options(), notificationSettings, callbacks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startServiceWithOptions(@NonNull Context context, @NonNull Class<? extends CastRemoteDisplayLocalService> clazz, @NonNull String string2, @NonNull CastDevice castDevice, @NonNull Options options, @NonNull NotificationSettings notificationSettings, @NonNull Callbacks callbacks) {
        zzeow.zzb("Starting Service", new Object[0]);
        Object object = zzeoy;
        synchronized (object) {
            if (zzepm != null) {
                zzeow.zzf("An existing service had not been stopped before starting one", new Object[0]);
                CastRemoteDisplayLocalService.zzat(true);
            }
        }
        Class<? extends CastRemoteDisplayLocalService> clazz2 = clazz;
        Context context2 = context;
        try {
            ComponentName componentName = new ComponentName(context2, clazz2);
            ServiceInfo serviceInfo = context2.getPackageManager().getServiceInfo(componentName, 128);
            if (serviceInfo != null && serviceInfo.exported) {
                throw new IllegalStateException("The service must not be exported, verify the manifest configuration");
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            throw new IllegalStateException("Service not found, did you forget to configure it in the manifest?");
        }
        zzbq.checkNotNull((Object)context, (Object)"activityContext is required.");
        zzbq.checkNotNull(clazz, (Object)"serviceClass is required.");
        zzbq.checkNotNull((Object)string2, (Object)"applicationId is required.");
        zzbq.checkNotNull((Object)((Object)castDevice), (Object)"device is required.");
        zzbq.checkNotNull((Object)options, (Object)"options is required.");
        zzbq.checkNotNull((Object)notificationSettings, (Object)"notificationSettings is required.");
        zzbq.checkNotNull((Object)callbacks, (Object)"callbacks is required.");
        if (notificationSettings.mNotification == null && notificationSettings.zzepv == null) {
            throw new IllegalArgumentException("notificationSettings: Either the notification or the notificationPendingIntent must be provided");
        }
        if (zzeoz.getAndSet(true)) {
            zzeow.zzc("Service is already being started, startService has been called twice", new Object[0]);
            return;
        }
        object = new Intent(context, clazz);
        context.startService((Intent)object);
        context.bindService((Intent)object, (ServiceConnection)new zzw(string2, castDevice, options, notificationSettings, context, callbacks), 64);
    }

    private final void zzas(boolean bl) {
        this.zzdv("Stopping Service");
        zzbq.zzge((String)"stopServiceInstanceInternal must be called on the main thread");
        if (!bl && this.zzepi != null) {
            this.zzdv("Setting default route");
            this.zzepi.selectRoute(this.zzepi.getDefaultRoute());
        }
        if (this.zzepb != null) {
            this.zzdv("Unregistering notification receiver");
            this.unregisterReceiver(this.zzepb);
        }
        CastRemoteDisplayLocalService castRemoteDisplayLocalService = this;
        castRemoteDisplayLocalService.zzdv("stopRemoteDisplaySession");
        CastRemoteDisplayLocalService castRemoteDisplayLocalService2 = castRemoteDisplayLocalService;
        castRemoteDisplayLocalService2.zzdv("stopRemoteDisplay");
        castRemoteDisplayLocalService2.zzepk.stopRemoteDisplay().addOnCompleteListener((OnCompleteListener)new zzaa(castRemoteDisplayLocalService2));
        if (castRemoteDisplayLocalService.zzepa.get() != null) {
            ((Callbacks)castRemoteDisplayLocalService.zzepa.get()).onRemoteDisplaySessionEnded(castRemoteDisplayLocalService);
        }
        castRemoteDisplayLocalService.onDismissPresentation();
        castRemoteDisplayLocalService = this;
        castRemoteDisplayLocalService.zzdv("Stopping the remote display Service");
        castRemoteDisplayLocalService.stopForeground(true);
        castRemoteDisplayLocalService.stopSelf();
        castRemoteDisplayLocalService = this;
        if (castRemoteDisplayLocalService.zzepi != null) {
            zzbq.zzge((String)"CastRemoteDisplayLocalService calls must be done on the main thread");
            castRemoteDisplayLocalService.zzdv("removeMediaRouterCallback");
            castRemoteDisplayLocalService.zzepi.removeCallback(castRemoteDisplayLocalService.zzepl);
        }
        if (this.zzepg != null && this.zzeph != null) {
            try {
                this.zzepg.unbindService(this.zzeph);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.zzdv("No need to unbind service, already unbound");
            }
            this.zzeph = null;
            this.zzepg = null;
        }
        this.zzenh = null;
        this.mNotification = null;
        this.zzdhs = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zzat(boolean bl) {
        CastRemoteDisplayLocalService castRemoteDisplayLocalService;
        zzeow.zzb("Stopping Service", new Object[0]);
        zzeoz.set(false);
        Object object = zzeoy;
        synchronized (object) {
            if (zzepm == null) {
                zzeow.zzc("Service is already being stopped", new Object[0]);
                return;
            }
            castRemoteDisplayLocalService = zzepm;
            zzepm = null;
        }
        boolean bl2 = bl;
        CastRemoteDisplayLocalService castRemoteDisplayLocalService2 = castRemoteDisplayLocalService;
        if (castRemoteDisplayLocalService2.mHandler != null) {
            if (Looper.myLooper() != Looper.getMainLooper()) {
                castRemoteDisplayLocalService2.mHandler.post((Runnable)new zzx(castRemoteDisplayLocalService2, bl2));
                return;
            }
            castRemoteDisplayLocalService2.zzas(bl2);
        }
    }

    public static void stopService() {
        CastRemoteDisplayLocalService.zzat(false);
    }

    public void updateNotificationSettings(NotificationSettings notificationSettings) {
        zzbq.checkNotNull((Object)notificationSettings, (Object)"notificationSettings is required.");
        zzbq.checkNotNull((Object)this.mHandler, (Object)"Service is not ready yet.");
        this.mHandler.post((Runnable)new zzy(this, notificationSettings));
    }

    private final void zza(NotificationSettings notificationSettings) {
        zzbq.zzge((String)"updateNotificationSettingsInternal must be called on the main thread");
        if (this.zzepc == null) {
            throw new IllegalStateException("No current notification settings to update");
        }
        if (this.zzepd) {
            if (notificationSettings.mNotification != null) {
                throw new IllegalStateException("Current mode is default notification, notification attribute must not be provided");
            }
            if (notificationSettings.zzepv != null) {
                this.zzepc.zzepv = notificationSettings.zzepv;
            }
            if (!TextUtils.isEmpty((CharSequence)notificationSettings.zzepw)) {
                this.zzepc.zzepw = notificationSettings.zzepw;
            }
            if (!TextUtils.isEmpty((CharSequence)notificationSettings.zzepx)) {
                this.zzepc.zzepx = notificationSettings.zzepx;
            }
            this.mNotification = this.zzau(true);
        } else {
            zzbq.checkNotNull((Object)notificationSettings.mNotification, (Object)"notification is required.");
            this.mNotification = notificationSettings.mNotification;
            this.zzepc.mNotification = this.mNotification;
        }
        this.startForeground(zzeox, this.mNotification);
    }

    private final void zza(Display display) {
        this.zzdhs = display;
        if (this.zzepd) {
            this.mNotification = this.zzau(true);
            this.startForeground(zzeox, this.mNotification);
        }
        if (this.zzepa.get() != null) {
            ((Callbacks)this.zzepa.get()).onRemoteDisplaySessionStarted(this);
        }
        this.onCreatePresentation(this.zzdhs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean zza(String string2, CastDevice castDevice, Options options, NotificationSettings notificationSettings, Context context, ServiceConnection serviceConnection, Callbacks callbacks) {
        this.zzdv("startRemoteDisplaySession");
        zzbq.zzge((String)"Starting the Cast Remote Display must be done on the main thread");
        Object object = zzeoy;
        synchronized (object) {
            if (zzepm != null) {
                zzeow.zzf("An existing service had not been stopped before starting one", new Object[0]);
                return false;
            }
            zzepm = this;
        }
        this.zzepa = new WeakReference<Callbacks>(callbacks);
        this.zzenh = string2;
        this.zzepf = castDevice;
        this.zzepg = context;
        this.zzeph = serviceConnection;
        if (this.zzepi == null) {
            this.zzepi = MediaRouter.getInstance((Context)this.getApplicationContext());
        }
        object = new MediaRouteSelector.Builder().addControlCategory(CastMediaControlIntent.categoryForCast(this.zzenh)).build();
        this.zzdv("addMediaRouterCallback");
        this.zzepi.addCallback((MediaRouteSelector)object, this.zzepl, 4);
        this.mNotification = notificationSettings.mNotification;
        this.zzepb = new zzb(null);
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("com.google.android.gms.cast.remote_display.ACTION_NOTIFICATION_DISCONNECT");
        intentFilter.addAction("com.google.android.gms.cast.remote_display.ACTION_SESSION_ENDED");
        this.registerReceiver(this.zzepb, intentFilter);
        this.zzepc = new NotificationSettings(notificationSettings, null);
        if (this.zzepc.mNotification == null) {
            this.zzepd = true;
            this.mNotification = this.zzau(false);
        } else {
            this.zzepd = false;
            this.mNotification = this.zzepc.mNotification;
        }
        this.startForeground(zzeox, this.mNotification);
        Options options2 = options;
        CastDevice castDevice2 = castDevice;
        CastRemoteDisplayLocalService castRemoteDisplayLocalService = this;
        castRemoteDisplayLocalService.zzdv("startRemoteDisplay");
        Intent intent = new Intent("com.google.android.gms.cast.remote_display.ACTION_SESSION_ENDED");
        intent.setPackage(castRemoteDisplayLocalService.zzepg.getPackageName());
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)castRemoteDisplayLocalService, (int)0, (Intent)intent, (int)0);
        castRemoteDisplayLocalService.zzepk.startRemoteDisplay(castDevice2, castRemoteDisplayLocalService.zzenh, options2.getConfigPreset(), pendingIntent).addOnCompleteListener((OnCompleteListener)new zzz(castRemoteDisplayLocalService));
        if (this.zzepa.get() != null) {
            ((Callbacks)this.zzepa.get()).onServiceCreated(this);
        }
        return true;
    }

    private final void zzacl() {
        if (this.zzepa.get() != null) {
            ((Callbacks)this.zzepa.get()).onRemoteDisplaySessionError(new Status(2200));
        }
        CastRemoteDisplayLocalService.stopService();
    }

    private final Notification zzau(boolean bl) {
        int n;
        int n2;
        this.zzdv("createDefaultNotification");
        String string2 = this.zzepc.zzepw;
        String string3 = this.zzepc.zzepx;
        if (bl) {
            n2 = R.string.cast_notification_connected_message;
            n = R.drawable.cast_ic_notification_on;
        } else {
            n2 = R.string.cast_notification_connecting_message;
            n = R.drawable.cast_ic_notification_connecting;
        }
        String string4 = TextUtils.isEmpty((CharSequence)string2) ? (String)this.getPackageManager().getApplicationLabel(this.getApplicationInfo()) : string2;
        String string5 = TextUtils.isEmpty((CharSequence)string3) ? this.getString(n2, new Object[]{this.zzepf.getFriendlyName()}) : string3;
        NotificationCompat.Builder builder = new NotificationCompat.Builder((Context)this, "cast_remote_display_local_service").setContentTitle((CharSequence)string4).setContentText((CharSequence)string5).setContentIntent(this.zzepc.zzepv).setSmallIcon(n).setOngoing(true);
        String string6 = this.getString(R.string.cast_notification_disconnect);
        CastRemoteDisplayLocalService castRemoteDisplayLocalService = this;
        if (castRemoteDisplayLocalService.zzepe == null) {
            Intent intent = new Intent("com.google.android.gms.cast.remote_display.ACTION_NOTIFICATION_DISCONNECT");
            intent.setPackage(castRemoteDisplayLocalService.zzepg.getPackageName());
            castRemoteDisplayLocalService.zzepe = PendingIntent.getBroadcast((Context)castRemoteDisplayLocalService, (int)0, (Intent)intent, (int)0x8000000);
        }
        return builder.addAction(17301560, (CharSequence)string6, castRemoteDisplayLocalService.zzepe).build();
    }

    private final void zzdv(String string2) {
        zzeow.zzb("[Instance: %s] %s", new Object[]{this, string2});
    }

    private final void zzdy(String string2) {
        zzeow.zzc("[Instance: %s] %s", new Object[]{this, string2});
    }

    static /* synthetic */ void zza(CastRemoteDisplayLocalService castRemoteDisplayLocalService, String string2) {
        castRemoteDisplayLocalService.zzdv(string2);
    }

    static /* synthetic */ CastDevice zza(CastRemoteDisplayLocalService castRemoteDisplayLocalService) {
        return castRemoteDisplayLocalService.zzepf;
    }

    static /* synthetic */ boolean zzb(CastRemoteDisplayLocalService castRemoteDisplayLocalService) {
        return castRemoteDisplayLocalService.zzepj;
    }

    static /* synthetic */ void zzb(CastRemoteDisplayLocalService castRemoteDisplayLocalService, String string2) {
        castRemoteDisplayLocalService.zzdy(string2);
    }

    static /* synthetic */ boolean zza(CastRemoteDisplayLocalService castRemoteDisplayLocalService, String string2, CastDevice castDevice, Options options, NotificationSettings notificationSettings, Context context, ServiceConnection serviceConnection, Callbacks callbacks) {
        return castRemoteDisplayLocalService.zza(string2, castDevice, options, notificationSettings, context, serviceConnection, callbacks);
    }

    static /* synthetic */ zzbcy zzacm() {
        return zzeow;
    }

    static /* synthetic */ AtomicBoolean zzacn() {
        return zzeoz;
    }

    static /* synthetic */ void zza(CastRemoteDisplayLocalService castRemoteDisplayLocalService, boolean bl) {
        castRemoteDisplayLocalService.zzas(bl);
    }

    static /* synthetic */ void zza(CastRemoteDisplayLocalService castRemoteDisplayLocalService, NotificationSettings notificationSettings) {
        castRemoteDisplayLocalService.zza(notificationSettings);
    }

    static /* synthetic */ void zzc(CastRemoteDisplayLocalService castRemoteDisplayLocalService) {
        castRemoteDisplayLocalService.zzacl();
    }

    static /* synthetic */ Object zzaco() {
        return zzeoy;
    }

    static /* synthetic */ CastRemoteDisplayLocalService zzacp() {
        return zzepm;
    }

    static /* synthetic */ void zza(CastRemoteDisplayLocalService castRemoteDisplayLocalService, Display display) {
        castRemoteDisplayLocalService.zza(display);
    }

    static /* synthetic */ Context zzd(CastRemoteDisplayLocalService castRemoteDisplayLocalService) {
        return castRemoteDisplayLocalService.zzepg;
    }

    static /* synthetic */ ServiceConnection zze(CastRemoteDisplayLocalService castRemoteDisplayLocalService) {
        return castRemoteDisplayLocalService.zzeph;
    }

    static /* synthetic */ ServiceConnection zza(CastRemoteDisplayLocalService castRemoteDisplayLocalService, ServiceConnection serviceConnection) {
        castRemoteDisplayLocalService.zzeph = null;
        return null;
    }

    static /* synthetic */ Context zza(CastRemoteDisplayLocalService castRemoteDisplayLocalService, Context context) {
        castRemoteDisplayLocalService.zzepg = null;
        return null;
    }

    static /* synthetic */ WeakReference zzf(CastRemoteDisplayLocalService castRemoteDisplayLocalService) {
        return castRemoteDisplayLocalService.zzepa;
    }

    static /* synthetic */ Display zzb(CastRemoteDisplayLocalService castRemoteDisplayLocalService, Display display) {
        castRemoteDisplayLocalService.zzdhs = null;
        return null;
    }

    @VisibleForTesting
    final class zza
    extends Binder {
        zza() {
        }
    }

    static final class zzb
    extends BroadcastReceiver {
        private zzb() {
        }

        public final void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("com.google.android.gms.cast.remote_display.ACTION_NOTIFICATION_DISCONNECT")) {
                CastRemoteDisplayLocalService.stopService();
                return;
            }
            if (intent.getAction().equals("com.google.android.gms.cast.remote_display.ACTION_SESSION_ENDED")) {
                CastRemoteDisplayLocalService.zzat(false);
            }
        }

        /* synthetic */ zzb(zzu zzu2) {
            this();
        }
    }

    public static class Options {
        @CastRemoteDisplay.Configuration
        private int zzeoj = 2;

        public Options() {
        }

        public void setConfigPreset(@CastRemoteDisplay.Configuration int n) {
            this.zzeoj = n;
        }

        @CastRemoteDisplay.Configuration
        public int getConfigPreset() {
            return this.zzeoj;
        }
    }

    public static final class NotificationSettings {
        private Notification mNotification;
        private PendingIntent zzepv;
        private String zzepw;
        private String zzepx;

        private NotificationSettings() {
        }

        private NotificationSettings(NotificationSettings notificationSettings) {
            this.mNotification = notificationSettings.mNotification;
            this.zzepv = notificationSettings.zzepv;
            this.zzepw = notificationSettings.zzepw;
            this.zzepx = notificationSettings.zzepx;
        }

        /* synthetic */ NotificationSettings(zzu zzu2) {
            this();
        }

        /* synthetic */ NotificationSettings(NotificationSettings notificationSettings, zzu zzu2) {
            this(notificationSettings);
        }

        public static final class Builder {
            private NotificationSettings zzepy = new NotificationSettings(null);

            public Builder() {
            }

            public final Builder setNotification(Notification notification) {
                this.zzepy.mNotification = notification;
                return this;
            }

            public final Builder setNotificationPendingIntent(PendingIntent pendingIntent) {
                this.zzepy.zzepv = pendingIntent;
                return this;
            }

            public final Builder setNotificationTitle(String string2) {
                this.zzepy.zzepw = string2;
                return this;
            }

            public final Builder setNotificationText(String string2) {
                this.zzepy.zzepx = string2;
                return this;
            }

            public final NotificationSettings build() {
                if (this.zzepy.mNotification != null) {
                    if (!TextUtils.isEmpty((CharSequence)this.zzepy.zzepw)) {
                        throw new IllegalArgumentException("notificationTitle requires using the default notification");
                    }
                    if (!TextUtils.isEmpty((CharSequence)this.zzepy.zzepx)) {
                        throw new IllegalArgumentException("notificationText requires using the default notification");
                    }
                    if (this.zzepy.zzepv != null) {
                        throw new IllegalArgumentException("notificationPendingIntent requires using the default notification");
                    }
                } else if (TextUtils.isEmpty((CharSequence)this.zzepy.zzepw) && TextUtils.isEmpty((CharSequence)this.zzepy.zzepx) && this.zzepy.zzepv == null) {
                    throw new IllegalArgumentException("At least an argument must be provided");
                }
                return this.zzepy;
            }
        }
    }

    public static interface Callbacks {
        public void onServiceCreated(CastRemoteDisplayLocalService var1);

        public void onRemoteDisplaySessionStarted(CastRemoteDisplayLocalService var1);

        public void onRemoteDisplaySessionError(Status var1);

        public void onRemoteDisplaySessionEnded(CastRemoteDisplayLocalService var1);
    }
}

