/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.SparseArray;
import com.google.android.gms.cast.AdBreakClipInfo;
import com.google.android.gms.cast.AdBreakInfo;
import com.google.android.gms.cast.AdBreakStatus;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaQueueItem;
import com.google.android.gms.cast.VideoInfo;
import com.google.android.gms.cast.zzaj;
import com.google.android.gms.common.util.zzo;
import com.google.android.gms.internal.zzbcm;
import com.google.android.gms.internal.zzbfm;
import com.google.android.gms.internal.zzbfp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MediaStatus
extends zzbfm {
    public static final long COMMAND_PAUSE = 1L;
    public static final long COMMAND_SEEK = 2L;
    public static final long COMMAND_SET_VOLUME = 4L;
    public static final long COMMAND_TOGGLE_MUTE = 8L;
    public static final long COMMAND_SKIP_FORWARD = 16L;
    public static final long COMMAND_SKIP_BACKWARD = 32L;
    public static final int PLAYER_STATE_UNKNOWN = 0;
    public static final int PLAYER_STATE_IDLE = 1;
    public static final int PLAYER_STATE_PLAYING = 2;
    public static final int PLAYER_STATE_PAUSED = 3;
    public static final int PLAYER_STATE_BUFFERING = 4;
    public static final int IDLE_REASON_NONE = 0;
    public static final int IDLE_REASON_FINISHED = 1;
    public static final int IDLE_REASON_CANCELED = 2;
    public static final int IDLE_REASON_INTERRUPTED = 3;
    public static final int IDLE_REASON_ERROR = 4;
    public static final int REPEAT_MODE_REPEAT_OFF = 0;
    public static final int REPEAT_MODE_REPEAT_ALL = 1;
    public static final int REPEAT_MODE_REPEAT_SINGLE = 2;
    public static final int REPEAT_MODE_REPEAT_ALL_AND_SHUFFLE = 3;
    public static final Parcelable.Creator<MediaStatus> CREATOR = new zzaj();
    private MediaInfo zzeql;
    private long zzerd;
    private int zzere;
    private double zzeqo;
    private int zzerf;
    private int zzerg;
    private long zzerh;
    private long zzeri;
    private double zzerj;
    private boolean zzerk;
    private long[] zzeqp;
    private int zzerl;
    private int zzerm;
    private String zzemx;
    private JSONObject zzemy;
    private int zzern;
    private ArrayList<MediaQueueItem> zzero = new ArrayList();
    private boolean zzerp;
    private AdBreakStatus zzerq;
    private VideoInfo zzerr;
    private final SparseArray<Integer> zzers = new SparseArray();

    MediaStatus(MediaInfo mediaInfo, long l, int n, double d, int n2, int n3, long l2, long l3, double d2, boolean bl, long[] lArray, int n4, int n5, String string2, int n6, List<MediaQueueItem> list, boolean bl2, AdBreakStatus adBreakStatus, VideoInfo videoInfo) {
        this.zzeql = mediaInfo;
        this.zzerd = l;
        this.zzere = n;
        this.zzeqo = d;
        this.zzerf = n2;
        this.zzerg = n3;
        this.zzerh = l2;
        this.zzeri = l3;
        this.zzerj = d2;
        this.zzerk = bl;
        this.zzeqp = lArray;
        this.zzerl = n4;
        this.zzerm = n5;
        this.zzemx = string2;
        if (this.zzemx != null) {
            try {
                this.zzemy = new JSONObject(this.zzemx);
            }
            catch (JSONException jSONException) {
                this.zzemy = null;
                this.zzemx = null;
            }
        } else {
            this.zzemy = null;
        }
        this.zzern = n6;
        if (list != null && !list.isEmpty()) {
            this.zza(list.toArray(new MediaQueueItem[list.size()]));
        }
        this.zzerp = bl2;
        this.zzerq = adBreakStatus;
        this.zzerr = videoInfo;
    }

    public MediaStatus(JSONObject jSONObject) throws JSONException {
        this(null, 0L, 0, 0.0, 0, 0, 0L, 0L, 0.0, false, null, 0, 0, null, 0, null, false, null, null);
        this.zza(jSONObject, 0);
    }

    public final long zzacr() {
        return this.zzerd;
    }

    public int getPlayerState() {
        return this.zzerf;
    }

    public int getIdleReason() {
        return this.zzerg;
    }

    public double getPlaybackRate() {
        return this.zzeqo;
    }

    public MediaInfo getMediaInfo() {
        return this.zzeql;
    }

    public long getStreamPosition() {
        return this.zzerh;
    }

    public boolean isMediaCommandSupported(long l) {
        return (this.zzeri & l) != 0L;
    }

    public double getStreamVolume() {
        return this.zzerj;
    }

    public boolean isMute() {
        return this.zzerk;
    }

    public long[] getActiveTrackIds() {
        return this.zzeqp;
    }

    public JSONObject getCustomData() {
        return this.zzemy;
    }

    public int getCurrentItemId() {
        return this.zzere;
    }

    public int getLoadingItemId() {
        return this.zzerl;
    }

    public int getPreloadedItemId() {
        return this.zzerm;
    }

    public int getQueueRepeatMode() {
        return this.zzern;
    }

    public List<MediaQueueItem> getQueueItems() {
        return this.zzero;
    }

    public int getQueueItemCount() {
        return this.zzero.size();
    }

    public MediaQueueItem getQueueItemById(int n) {
        return this.getItemById(n);
    }

    public MediaQueueItem getQueueItem(int n) {
        return this.getItemByIndex(n);
    }

    public boolean isPlayingAd() {
        return this.zzerp;
    }

    public final void zzax(boolean bl) {
        this.zzerp = bl;
    }

    public AdBreakStatus getAdBreakStatus() {
        return this.zzerq;
    }

    public VideoInfo getVideoInfo() {
        return this.zzerr;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final int zza(JSONObject jSONObject, int n) throws JSONException {
        int n2;
        block75: {
            int n3;
            block73: {
                MediaQueueItem[] mediaQueueItemArray;
                int n4;
                JSONArray jSONArray;
                String string2;
                MediaStatus mediaStatus;
                block74: {
                    block72: {
                        int n5;
                        boolean bl;
                        int n6;
                        block71: {
                            int n7;
                            block70: {
                                int n8;
                                int n9;
                                int n10;
                                int n11;
                                long[] lArray;
                                boolean bl2;
                                block69: {
                                    block67: {
                                        int n12;
                                        block68: {
                                            block65: {
                                                block66: {
                                                    long l;
                                                    long l2;
                                                    double d;
                                                    n2 = 0;
                                                    long l3 = jSONObject.getLong("mediaSessionId");
                                                    if (l3 != this.zzerd) {
                                                        this.zzerd = l3;
                                                        n2 = 1;
                                                    }
                                                    if (jSONObject.has("playerState")) {
                                                        int n13 = 0;
                                                        String string3 = jSONObject.getString("playerState");
                                                        if (string3.equals("IDLE")) {
                                                            n13 = 1;
                                                        } else if (string3.equals("PLAYING")) {
                                                            n13 = 2;
                                                        } else if (string3.equals("PAUSED")) {
                                                            n13 = 3;
                                                        } else if (string3.equals("BUFFERING")) {
                                                            n13 = 4;
                                                        }
                                                        if (n13 != this.zzerf) {
                                                            this.zzerf = n13;
                                                            n2 |= 2;
                                                        }
                                                        if (n13 == 1 && jSONObject.has("idleReason")) {
                                                            int n14 = 0;
                                                            string3 = jSONObject.getString("idleReason");
                                                            if (string3.equals("CANCELLED")) {
                                                                n14 = 2;
                                                            } else if (string3.equals("INTERRUPTED")) {
                                                                n14 = 3;
                                                            } else if (string3.equals("FINISHED")) {
                                                                n14 = 1;
                                                            } else if (string3.equals("ERROR")) {
                                                                n14 = 4;
                                                            }
                                                            if (n14 != this.zzerg) {
                                                                this.zzerg = n14;
                                                                n2 |= 2;
                                                            }
                                                        }
                                                    }
                                                    if (jSONObject.has("playbackRate") && this.zzeqo != (d = jSONObject.getDouble("playbackRate"))) {
                                                        this.zzeqo = d;
                                                        n2 |= 2;
                                                    }
                                                    if (jSONObject.has("currentTime") && (n & 2) == 0 && (l2 = (long)(jSONObject.getDouble("currentTime") * 1000.0)) != this.zzerh) {
                                                        this.zzerh = l2;
                                                        n2 |= 2;
                                                    }
                                                    if (jSONObject.has("supportedMediaCommands") && (l = jSONObject.getLong("supportedMediaCommands")) != this.zzeri) {
                                                        this.zzeri = l;
                                                        n2 |= 2;
                                                    }
                                                    if (jSONObject.has("volume") && (n & 1) == 0) {
                                                        JSONObject jSONObject2 = jSONObject.getJSONObject("volume");
                                                        double d2 = jSONObject2.getDouble("level");
                                                        if (d2 != this.zzerj) {
                                                            this.zzerj = d2;
                                                            n2 |= 2;
                                                        }
                                                        boolean bl3 = jSONObject2.getBoolean("muted");
                                                        n12 = bl3 ? 1 : 0;
                                                        if (bl3 != this.zzerk) {
                                                            this.zzerk = n12;
                                                            n2 |= 2;
                                                        }
                                                    }
                                                    bl2 = false;
                                                    lArray = null;
                                                    if (!jSONObject.has("activeTrackIds")) break block65;
                                                    JSONArray jSONArray2 = jSONObject.getJSONArray("activeTrackIds");
                                                    n12 = jSONArray2.length();
                                                    lArray = new long[n12];
                                                    for (n11 = 0; n11 < n12; ++n11) {
                                                        lArray[n11] = jSONArray2.getLong(n11);
                                                    }
                                                    if (this.zzeqp != null) break block66;
                                                    bl2 = true;
                                                    break block67;
                                                }
                                                if (this.zzeqp.length == n12) break block68;
                                                bl2 = true;
                                                break block67;
                                            }
                                            if (this.zzeqp != null) {
                                                bl2 = true;
                                            }
                                            break block69;
                                        }
                                        for (n11 = 0; n11 < n12; ++n11) {
                                            if (this.zzeqp[n11] == lArray[n11]) continue;
                                            bl2 = true;
                                            break;
                                        }
                                    }
                                    if (bl2) {
                                        this.zzeqp = lArray;
                                    }
                                }
                                if (bl2) {
                                    this.zzeqp = lArray;
                                    n2 |= 2;
                                }
                                if (jSONObject.has("customData")) {
                                    this.zzemy = jSONObject.getJSONObject("customData");
                                    this.zzemx = null;
                                    n2 |= 2;
                                }
                                if (jSONObject.has("media")) {
                                    JSONObject jSONObject3 = jSONObject.getJSONObject("media");
                                    MediaInfo mediaInfo = new MediaInfo(jSONObject3);
                                    if (this.zzeql == null || this.zzeql != null && !this.zzeql.equals((Object)mediaInfo)) {
                                        this.zzeql = mediaInfo;
                                        n2 |= 2;
                                    }
                                    if (jSONObject3.has("metadata")) {
                                        n2 |= 4;
                                    }
                                }
                                if (jSONObject.has("currentItemId") && this.zzere != (n10 = jSONObject.getInt("currentItemId"))) {
                                    this.zzere = n10;
                                    n2 |= 2;
                                }
                                if (this.zzerm != (n9 = jSONObject.optInt("preloadedItemId", 0))) {
                                    this.zzerm = n9;
                                    n2 |= 0x10;
                                }
                                if (this.zzerl != (n8 = jSONObject.optInt("loadingItemId", 0))) {
                                    this.zzerl = n8;
                                    n2 |= 2;
                                }
                                n6 = n11 = this.zzeql == null ? -1 : this.zzeql.getStreamType();
                                n3 = this.zzerl;
                                n7 = this.zzerg;
                                if (this.zzerf == 1) break block70;
                                bl = false;
                                break block71;
                            }
                            switch (n7) {
                                case 1: 
                                case 3: {
                                    if (n3 == 0) break;
                                    bl = false;
                                    break block71;
                                }
                                case 2: {
                                    if (n6 != 2) break;
                                    bl = false;
                                    break block71;
                                }
                            }
                            bl = true;
                        }
                        if (bl) break block72;
                        JSONObject jSONObject4 = jSONObject;
                        mediaStatus = this;
                        n3 = 0;
                        if (jSONObject4.has("repeatMode")) {
                            n6 = mediaStatus.zzern;
                            string2 = jSONObject4.getString("repeatMode");
                            n5 = -1;
                            switch (string2.hashCode()) {
                                case 1645952171: {
                                    if (!string2.equals("REPEAT_OFF")) break;
                                    n5 = 0;
                                    break;
                                }
                                case 1645938909: {
                                    if (!string2.equals("REPEAT_ALL")) break;
                                    n5 = 1;
                                    break;
                                }
                                case -962896020: {
                                    if (!string2.equals("REPEAT_SINGLE")) break;
                                    n5 = 2;
                                    break;
                                }
                                case -1118317585: {
                                    if (!string2.equals("REPEAT_ALL_AND_SHUFFLE")) break;
                                    n5 = 3;
                                    break;
                                }
                            }
                            switch (n5) {
                                case 0: {
                                    n6 = 0;
                                    break;
                                }
                                case 1: {
                                    n6 = 1;
                                    break;
                                }
                                case 2: {
                                    n6 = 2;
                                    break;
                                }
                                case 3: {
                                    n6 = 3;
                                    break;
                                }
                            }
                            if (mediaStatus.zzern != n6) {
                                mediaStatus.zzern = n6;
                                n3 = 1;
                            }
                        }
                        if (!jSONObject4.has("items")) break block73;
                        jSONArray = jSONObject4.getJSONArray("items");
                        n4 = jSONArray.length();
                        string2 = new SparseArray();
                        for (n5 = 0; n5 < n4; ++n5) {
                            string2.put(n5, (Object)jSONArray.getJSONObject(n5).getInt("itemId"));
                        }
                        mediaQueueItemArray = new MediaQueueItem[n4];
                        break block74;
                    }
                    this.zzere = 0;
                    this.zzerl = 0;
                    this.zzerm = 0;
                    if (!this.zzero.isEmpty()) {
                        MediaStatus mediaStatus2 = this;
                        this.zzern = 0;
                        mediaStatus2.zzero.clear();
                        mediaStatus2.zzers.clear();
                        n2 |= 8;
                    }
                    break block75;
                }
                for (int i = 0; i < n4; ++i) {
                    Integer n15 = (Integer)string2.get(i);
                    JSONObject jSONObject5 = jSONArray.getJSONObject(i);
                    MediaQueueItem mediaQueueItem = mediaStatus.getItemById(n15);
                    if (mediaQueueItem != null) {
                        n3 |= mediaQueueItem.zzv(jSONObject5);
                        mediaQueueItemArray[i] = mediaQueueItem;
                        if (i == mediaStatus.getIndexById(n15)) continue;
                        n3 = 1;
                        continue;
                    }
                    n3 = 1;
                    if (n15 == mediaStatus.zzere && mediaStatus.zzeql != null) {
                        mediaQueueItemArray[i] = new MediaQueueItem.Builder(mediaStatus.zzeql).build();
                        mediaQueueItemArray[i].zzv(jSONObject5);
                        continue;
                    }
                    mediaQueueItemArray[i] = new MediaQueueItem(jSONObject5);
                }
                if (mediaStatus.zzero.size() != n4) {
                    n3 = 1;
                }
                mediaStatus.zza(mediaQueueItemArray);
            }
            if (n3 != 0) {
                n2 |= 8;
            }
        }
        AdBreakStatus adBreakStatus = AdBreakStatus.zzs(jSONObject.optJSONObject("breakStatus"));
        if (this.zzerq == null && adBreakStatus != null || this.zzerq != null && !this.zzerq.equals((Object)adBreakStatus)) {
            boolean bl = adBreakStatus != null;
            this.zzerp = bl;
            this.zzerq = adBreakStatus;
            n2 |= 0x20;
        }
        VideoInfo videoInfo = VideoInfo.zzw(jSONObject.optJSONObject("videoInfo"));
        if (this.zzerr == null && videoInfo != null || this.zzerr != null && !this.zzerr.equals((Object)videoInfo)) {
            this.zzerr = videoInfo;
            n2 |= 0x40;
        }
        if (jSONObject.has("breakInfo") && this.zzeql != null) {
            this.zzeql.zzt(jSONObject.getJSONObject("breakInfo"));
            n2 |= 2;
        }
        return n2;
    }

    public MediaQueueItem getItemById(int n) {
        Integer n2 = (Integer)this.zzers.get(n);
        if (n2 == null) {
            return null;
        }
        return this.zzero.get(n2);
    }

    public MediaQueueItem getItemByIndex(int n) {
        if (n < 0 || n >= this.zzero.size()) {
            return null;
        }
        return this.zzero.get(n);
    }

    public Integer getIndexById(int n) {
        return (Integer)this.zzers.get(n);
    }

    private final void zza(MediaQueueItem[] mediaQueueItemArray) {
        this.zzero.clear();
        this.zzers.clear();
        for (int i = 0; i < mediaQueueItemArray.length; ++i) {
            MediaQueueItem mediaQueueItem = mediaQueueItemArray[i];
            this.zzero.add(mediaQueueItem);
            this.zzers.put(mediaQueueItem.getItemId(), (Object)i);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MediaStatus)) {
            return false;
        }
        MediaStatus mediaStatus = (MediaStatus)((Object)object);
        if (this.zzemy == null != (mediaStatus.zzemy == null)) {
            return false;
        }
        if (this.zzerd == mediaStatus.zzerd && this.zzere == mediaStatus.zzere && this.zzeqo == mediaStatus.zzeqo && this.zzerf == mediaStatus.zzerf && this.zzerg == mediaStatus.zzerg && this.zzerh == mediaStatus.zzerh && this.zzerj == mediaStatus.zzerj && this.zzerk == mediaStatus.zzerk && this.zzerl == mediaStatus.zzerl && this.zzerm == mediaStatus.zzerm && this.zzern == mediaStatus.zzern && Arrays.equals(this.zzeqp, mediaStatus.zzeqp) && zzbcm.zza(this.zzeri, mediaStatus.zzeri) && zzbcm.zza(this.zzero, mediaStatus.zzero) && zzbcm.zza(this.zzeql, mediaStatus.zzeql)) {
            MediaStatus mediaStatus2 = mediaStatus;
            MediaStatus mediaStatus3 = this;
            if ((mediaStatus3.zzemy == null || mediaStatus2.zzemy == null || zzo.zzc((Object)mediaStatus3.zzemy, (Object)mediaStatus2.zzemy)) && this.zzerp == mediaStatus.isPlayingAd()) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzeql, this.zzerd, this.zzere, this.zzeqo, this.zzerf, this.zzerg, this.zzerh, this.zzeri, this.zzerj, this.zzerk, Arrays.hashCode(this.zzeqp), this.zzerl, this.zzerm, String.valueOf(this.zzemy), this.zzern, this.zzero, this.zzerp});
    }

    public void writeToParcel(Parcel parcel, int n) {
        this.zzemx = this.zzemy == null ? null : this.zzemy.toString();
        Parcel parcel2 = parcel;
        MediaStatus mediaStatus = this;
        int n2 = zzbfp.zze((Parcel)parcel2);
        zzbfp.zza((Parcel)parcel2, (int)2, (Parcelable)mediaStatus.getMediaInfo(), (int)n, (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)3, (long)mediaStatus.zzerd);
        zzbfp.zzc((Parcel)parcel2, (int)4, (int)mediaStatus.getCurrentItemId());
        zzbfp.zza((Parcel)parcel2, (int)5, (double)mediaStatus.getPlaybackRate());
        zzbfp.zzc((Parcel)parcel2, (int)6, (int)mediaStatus.getPlayerState());
        zzbfp.zzc((Parcel)parcel2, (int)7, (int)mediaStatus.getIdleReason());
        zzbfp.zza((Parcel)parcel2, (int)8, (long)mediaStatus.getStreamPosition());
        zzbfp.zza((Parcel)parcel2, (int)9, (long)mediaStatus.zzeri);
        zzbfp.zza((Parcel)parcel2, (int)10, (double)mediaStatus.getStreamVolume());
        zzbfp.zza((Parcel)parcel2, (int)11, (boolean)mediaStatus.isMute());
        zzbfp.zza((Parcel)parcel2, (int)12, (long[])mediaStatus.getActiveTrackIds(), (boolean)false);
        zzbfp.zzc((Parcel)parcel2, (int)13, (int)mediaStatus.getLoadingItemId());
        zzbfp.zzc((Parcel)parcel2, (int)14, (int)mediaStatus.getPreloadedItemId());
        zzbfp.zza((Parcel)parcel2, (int)15, (String)mediaStatus.zzemx, (boolean)false);
        zzbfp.zzc((Parcel)parcel2, (int)16, (int)mediaStatus.zzern);
        zzbfp.zzc((Parcel)parcel2, (int)17, mediaStatus.zzero, (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)18, (boolean)mediaStatus.isPlayingAd());
        zzbfp.zza((Parcel)parcel2, (int)19, (Parcelable)mediaStatus.getAdBreakStatus(), (int)n, (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)20, (Parcelable)mediaStatus.getVideoInfo(), (int)n, (boolean)false);
        zzbfp.zzai((Parcel)parcel2, (int)n2);
    }

    public AdBreakInfo getCurrentAdBreak() {
        if (this.zzerq == null || this.zzeql == null) {
            return null;
        }
        String string2 = this.zzerq.getBreakId();
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        List<AdBreakInfo> list = this.zzeql.getAdBreaks();
        if (list == null || list.isEmpty()) {
            return null;
        }
        for (AdBreakInfo adBreakInfo : list) {
            if (!string2.equals(adBreakInfo.getId())) continue;
            return adBreakInfo;
        }
        return null;
    }

    public AdBreakClipInfo getCurrentAdBreakClip() {
        if (this.zzerq == null || this.zzeql == null) {
            return null;
        }
        String string2 = this.zzerq.getBreakClipId();
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        List<AdBreakClipInfo> list = this.zzeql.getAdBreakClips();
        if (list == null || list.isEmpty()) {
            return null;
        }
        for (AdBreakClipInfo adBreakClipInfo : list) {
            if (!string2.equals(adBreakClipInfo.getId())) continue;
            return adBreakClipInfo;
        }
        return null;
    }
}

