/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Color;
import android.graphics.Typeface;
import android.os.Parcel;
import android.os.Parcelable;
import android.view.accessibility.CaptioningManager;
import com.google.android.gms.cast.zzbn;
import com.google.android.gms.common.util.zzo;
import com.google.android.gms.common.util.zzq;
import com.google.android.gms.internal.zzbcm;
import com.google.android.gms.internal.zzbfm;
import com.google.android.gms.internal.zzbfp;
import java.util.Arrays;
import org.json.JSONException;
import org.json.JSONObject;

public final class TextTrackStyle
extends zzbfm {
    public static final float DEFAULT_FONT_SCALE = 1.0f;
    public static final int COLOR_UNSPECIFIED = 0;
    public static final int EDGE_TYPE_UNSPECIFIED = -1;
    public static final int EDGE_TYPE_NONE = 0;
    public static final int EDGE_TYPE_OUTLINE = 1;
    public static final int EDGE_TYPE_DROP_SHADOW = 2;
    public static final int EDGE_TYPE_RAISED = 3;
    public static final int EDGE_TYPE_DEPRESSED = 4;
    public static final int WINDOW_TYPE_UNSPECIFIED = -1;
    public static final int WINDOW_TYPE_NONE = 0;
    public static final int WINDOW_TYPE_NORMAL = 1;
    public static final int WINDOW_TYPE_ROUNDED = 2;
    public static final int FONT_FAMILY_UNSPECIFIED = -1;
    public static final int FONT_FAMILY_SANS_SERIF = 0;
    public static final int FONT_FAMILY_MONOSPACED_SANS_SERIF = 1;
    public static final int FONT_FAMILY_SERIF = 2;
    public static final int FONT_FAMILY_MONOSPACED_SERIF = 3;
    public static final int FONT_FAMILY_CASUAL = 4;
    public static final int FONT_FAMILY_CURSIVE = 5;
    public static final int FONT_FAMILY_SMALL_CAPITALS = 6;
    public static final int FONT_STYLE_UNSPECIFIED = -1;
    public static final int FONT_STYLE_NORMAL = 0;
    public static final int FONT_STYLE_BOLD = 1;
    public static final int FONT_STYLE_ITALIC = 2;
    public static final int FONT_STYLE_BOLD_ITALIC = 3;
    public static final Parcelable.Creator<TextTrackStyle> CREATOR = new zzbn();
    private float zzeti;
    private int zzetj;
    private int zzbtj;
    private int zzetk;
    private int zzetl;
    private int zzetm;
    private int zzetn;
    private int zzeto;
    private String zzetp;
    private int zzetq;
    private int zzetr;
    private String zzemx;
    private JSONObject zzemy;

    TextTrackStyle(float f, int n, int n2, int n3, int n4, int n5, int n6, int n7, String string2, int n8, int n9, String string3) {
        this.zzeti = f;
        this.zzetj = n;
        this.zzbtj = n2;
        this.zzetk = n3;
        this.zzetl = n4;
        this.zzetm = n5;
        this.zzetn = n6;
        this.zzeto = n7;
        this.zzetp = string2;
        this.zzetq = n8;
        this.zzetr = n9;
        this.zzemx = string3;
        if (this.zzemx != null) {
            try {
                this.zzemy = new JSONObject(this.zzemx);
                return;
            }
            catch (JSONException jSONException) {
                this.zzemy = null;
                this.zzemx = null;
                return;
            }
        }
        this.zzemy = null;
    }

    public TextTrackStyle() {
        this(1.0f, 0, 0, -1, 0, -1, 0, 0, null, -1, -1, null);
    }

    public final void setFontScale(float f) {
        this.zzeti = f;
    }

    public final float getFontScale() {
        return this.zzeti;
    }

    public final void setForegroundColor(int n) {
        this.zzetj = n;
    }

    public final int getForegroundColor() {
        return this.zzetj;
    }

    public final void setBackgroundColor(int n) {
        this.zzbtj = n;
    }

    public final int getBackgroundColor() {
        return this.zzbtj;
    }

    public final void setEdgeType(int n) {
        if (n < 0 || n > 4) {
            throw new IllegalArgumentException("invalid edgeType");
        }
        this.zzetk = n;
    }

    public final int getEdgeType() {
        return this.zzetk;
    }

    public final void setEdgeColor(int n) {
        this.zzetl = n;
    }

    public final int getEdgeColor() {
        return this.zzetl;
    }

    public final void setWindowType(int n) {
        if (n < 0 || n > 2) {
            throw new IllegalArgumentException("invalid windowType");
        }
        this.zzetm = n;
    }

    public final int getWindowType() {
        return this.zzetm;
    }

    public final void setWindowColor(int n) {
        this.zzetn = n;
    }

    public final int getWindowColor() {
        return this.zzetn;
    }

    public final void setWindowCornerRadius(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("invalid windowCornerRadius");
        }
        this.zzeto = n;
    }

    public final int getWindowCornerRadius() {
        return this.zzeto;
    }

    public final void setFontFamily(String string2) {
        this.zzetp = string2;
    }

    public final String getFontFamily() {
        return this.zzetp;
    }

    public final void setFontGenericFamily(int n) {
        if (n < 0 || n > 6) {
            throw new IllegalArgumentException("invalid fontGenericFamily");
        }
        this.zzetq = n;
    }

    public final int getFontGenericFamily() {
        return this.zzetq;
    }

    public final void setFontStyle(int n) {
        if (n < 0 || n > 3) {
            throw new IllegalArgumentException("invalid fontStyle");
        }
        this.zzetr = n;
    }

    public final int getFontStyle() {
        return this.zzetr;
    }

    public final void setCustomData(JSONObject jSONObject) {
        this.zzemy = jSONObject;
    }

    public final JSONObject getCustomData() {
        return this.zzemy;
    }

    @TargetApi(value=19)
    public static TextTrackStyle fromSystemSettings(Context context) {
        TextTrackStyle textTrackStyle = new TextTrackStyle();
        if (!zzq.zzaml()) {
            return textTrackStyle;
        }
        CaptioningManager captioningManager = (CaptioningManager)context.getSystemService("captioning");
        textTrackStyle.setFontScale(captioningManager.getFontScale());
        CaptioningManager.CaptionStyle captionStyle = captioningManager.getUserStyle();
        textTrackStyle.setBackgroundColor(captionStyle.backgroundColor);
        textTrackStyle.setForegroundColor(captionStyle.foregroundColor);
        switch (captionStyle.edgeType) {
            case 1: {
                textTrackStyle.setEdgeType(1);
                break;
            }
            case 2: {
                textTrackStyle.setEdgeType(2);
                break;
            }
            default: {
                textTrackStyle.setEdgeType(0);
            }
        }
        textTrackStyle.setEdgeColor(captionStyle.edgeColor);
        Typeface typeface = captionStyle.getTypeface();
        if (typeface != null) {
            if (Typeface.MONOSPACE.equals((Object)typeface)) {
                textTrackStyle.setFontGenericFamily(1);
            } else if (!Typeface.SANS_SERIF.equals((Object)typeface) && Typeface.SERIF.equals((Object)typeface)) {
                textTrackStyle.setFontGenericFamily(2);
            } else {
                textTrackStyle.setFontGenericFamily(0);
            }
            boolean bl = typeface.isBold();
            boolean bl2 = typeface.isItalic();
            if (bl && bl2) {
                textTrackStyle.setFontStyle(3);
            } else if (bl) {
                textTrackStyle.setFontStyle(1);
            } else if (bl2) {
                textTrackStyle.setFontStyle(2);
            } else {
                textTrackStyle.setFontStyle(0);
            }
        }
        return textTrackStyle;
    }

    public final void zzu(JSONObject jSONObject) throws JSONException {
        String string2;
        this.zzeti = (float)jSONObject.optDouble("fontScale", 1.0);
        this.zzetj = TextTrackStyle.zzfg(jSONObject.optString("foregroundColor"));
        this.zzbtj = TextTrackStyle.zzfg(jSONObject.optString("backgroundColor"));
        if (jSONObject.has("edgeType")) {
            string2 = jSONObject.getString("edgeType");
            if ("NONE".equals(string2)) {
                this.zzetk = 0;
            } else if ("OUTLINE".equals(string2)) {
                this.zzetk = 1;
            } else if ("DROP_SHADOW".equals(string2)) {
                this.zzetk = 2;
            } else if ("RAISED".equals(string2)) {
                this.zzetk = 3;
            } else if ("DEPRESSED".equals(string2)) {
                this.zzetk = 4;
            }
        }
        this.zzetl = TextTrackStyle.zzfg(jSONObject.optString("edgeColor"));
        if (jSONObject.has("windowType")) {
            string2 = jSONObject.getString("windowType");
            if ("NONE".equals(string2)) {
                this.zzetm = 0;
            } else if ("NORMAL".equals(string2)) {
                this.zzetm = 1;
            } else if ("ROUNDED_CORNERS".equals(string2)) {
                this.zzetm = 2;
            }
        }
        this.zzetn = TextTrackStyle.zzfg(jSONObject.optString("windowColor"));
        if (this.zzetm == 2) {
            this.zzeto = jSONObject.optInt("windowRoundedCornerRadius", 0);
        }
        this.zzetp = jSONObject.optString("fontFamily", null);
        if (jSONObject.has("fontGenericFamily")) {
            string2 = jSONObject.getString("fontGenericFamily");
            if ("SANS_SERIF".equals(string2)) {
                this.zzetq = 0;
            } else if ("MONOSPACED_SANS_SERIF".equals(string2)) {
                this.zzetq = 1;
            } else if ("SERIF".equals(string2)) {
                this.zzetq = 2;
            } else if ("MONOSPACED_SERIF".equals(string2)) {
                this.zzetq = 3;
            } else if ("CASUAL".equals(string2)) {
                this.zzetq = 4;
            } else if ("CURSIVE".equals(string2)) {
                this.zzetq = 5;
            } else if ("SMALL_CAPITALS".equals(string2)) {
                this.zzetq = 6;
            }
        }
        if (jSONObject.has("fontStyle")) {
            string2 = jSONObject.getString("fontStyle");
            if ("NORMAL".equals(string2)) {
                this.zzetr = 0;
            } else if ("BOLD".equals(string2)) {
                this.zzetr = 1;
            } else if ("ITALIC".equals(string2)) {
                this.zzetr = 2;
            } else if ("BOLD_ITALIC".equals(string2)) {
                this.zzetr = 3;
            }
        }
        this.zzemy = jSONObject.optJSONObject("customData");
    }

    public final JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("fontScale", (double)this.zzeti);
            if (this.zzetj != 0) {
                jSONObject.put("foregroundColor", (Object)TextTrackStyle.zzbe(this.zzetj));
            }
            if (this.zzbtj != 0) {
                jSONObject.put("backgroundColor", (Object)TextTrackStyle.zzbe(this.zzbtj));
            }
            switch (this.zzetk) {
                case 0: {
                    jSONObject.put("edgeType", (Object)"NONE");
                    break;
                }
                case 1: {
                    jSONObject.put("edgeType", (Object)"OUTLINE");
                    break;
                }
                case 2: {
                    jSONObject.put("edgeType", (Object)"DROP_SHADOW");
                    break;
                }
                case 3: {
                    jSONObject.put("edgeType", (Object)"RAISED");
                    break;
                }
                case 4: {
                    jSONObject.put("edgeType", (Object)"DEPRESSED");
                }
            }
            if (this.zzetl != 0) {
                jSONObject.put("edgeColor", (Object)TextTrackStyle.zzbe(this.zzetl));
            }
            switch (this.zzetm) {
                case 0: {
                    jSONObject.put("windowType", (Object)"NONE");
                    break;
                }
                case 1: {
                    jSONObject.put("windowType", (Object)"NORMAL");
                    break;
                }
                case 2: {
                    jSONObject.put("windowType", (Object)"ROUNDED_CORNERS");
                }
            }
            if (this.zzetn != 0) {
                jSONObject.put("windowColor", (Object)TextTrackStyle.zzbe(this.zzetn));
            }
            if (this.zzetm == 2) {
                jSONObject.put("windowRoundedCornerRadius", this.zzeto);
            }
            if (this.zzetp != null) {
                jSONObject.put("fontFamily", (Object)this.zzetp);
            }
            switch (this.zzetq) {
                case 0: {
                    jSONObject.put("fontGenericFamily", (Object)"SANS_SERIF");
                    break;
                }
                case 1: {
                    jSONObject.put("fontGenericFamily", (Object)"MONOSPACED_SANS_SERIF");
                    break;
                }
                case 2: {
                    jSONObject.put("fontGenericFamily", (Object)"SERIF");
                    break;
                }
                case 3: {
                    jSONObject.put("fontGenericFamily", (Object)"MONOSPACED_SERIF");
                    break;
                }
                case 4: {
                    jSONObject.put("fontGenericFamily", (Object)"CASUAL");
                    break;
                }
                case 5: {
                    jSONObject.put("fontGenericFamily", (Object)"CURSIVE");
                    break;
                }
                case 6: {
                    jSONObject.put("fontGenericFamily", (Object)"SMALL_CAPITALS");
                }
            }
            switch (this.zzetr) {
                case 0: {
                    jSONObject.put("fontStyle", (Object)"NORMAL");
                    break;
                }
                case 1: {
                    jSONObject.put("fontStyle", (Object)"BOLD");
                    break;
                }
                case 2: {
                    jSONObject.put("fontStyle", (Object)"ITALIC");
                    break;
                }
                case 3: {
                    jSONObject.put("fontStyle", (Object)"BOLD_ITALIC");
                }
            }
            if (this.zzemy != null) {
                jSONObject.put("customData", (Object)this.zzemy);
            }
        }
        catch (JSONException jSONException) {}
        return jSONObject;
    }

    private static String zzbe(int n) {
        return String.format("#%02X%02X%02X%02X", Color.red((int)n), Color.green((int)n), Color.blue((int)n), Color.alpha((int)n));
    }

    private static int zzfg(String string2) {
        if (string2 != null && string2.length() == 9 && string2.charAt(0) == '#') {
            try {
                int n = Integer.parseInt(string2.substring(1, 3), 16);
                int n2 = Integer.parseInt(string2.substring(3, 5), 16);
                int n3 = Integer.parseInt(string2.substring(5, 7), 16);
                return Color.argb((int)Integer.parseInt(string2.substring(7, 9), 16), (int)n, (int)n2, (int)n3);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return 0;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof TextTrackStyle)) {
            return false;
        }
        TextTrackStyle textTrackStyle = (TextTrackStyle)((Object)object);
        if (this.zzemy == null != (textTrackStyle.zzemy == null)) {
            return false;
        }
        if (this.zzemy != null && textTrackStyle.zzemy != null && !zzo.zzc((Object)this.zzemy, (Object)textTrackStyle.zzemy)) {
            return false;
        }
        return this.zzeti == textTrackStyle.zzeti && this.zzetj == textTrackStyle.zzetj && this.zzbtj == textTrackStyle.zzbtj && this.zzetk == textTrackStyle.zzetk && this.zzetl == textTrackStyle.zzetl && this.zzetm == textTrackStyle.zzetm && this.zzeto == textTrackStyle.zzeto && zzbcm.zza(this.zzetp, textTrackStyle.zzetp) && this.zzetq == textTrackStyle.zzetq && this.zzetr == textTrackStyle.zzetr;
    }

    public final int hashCode() {
        return Arrays.hashCode(new Object[]{Float.valueOf(this.zzeti), this.zzetj, this.zzbtj, this.zzetk, this.zzetl, this.zzetm, this.zzetn, this.zzeto, this.zzetp, this.zzetq, this.zzetr, String.valueOf(this.zzemy)});
    }

    public final void writeToParcel(Parcel parcel, int n) {
        this.zzemx = this.zzemy == null ? null : this.zzemy.toString();
        Parcel parcel2 = parcel;
        TextTrackStyle textTrackStyle = this;
        int n2 = zzbfp.zze((Parcel)parcel2);
        zzbfp.zza((Parcel)parcel2, (int)2, (float)textTrackStyle.getFontScale());
        zzbfp.zzc((Parcel)parcel2, (int)3, (int)textTrackStyle.getForegroundColor());
        zzbfp.zzc((Parcel)parcel2, (int)4, (int)textTrackStyle.getBackgroundColor());
        zzbfp.zzc((Parcel)parcel2, (int)5, (int)textTrackStyle.getEdgeType());
        zzbfp.zzc((Parcel)parcel2, (int)6, (int)textTrackStyle.getEdgeColor());
        zzbfp.zzc((Parcel)parcel2, (int)7, (int)textTrackStyle.getWindowType());
        zzbfp.zzc((Parcel)parcel2, (int)8, (int)textTrackStyle.getWindowColor());
        zzbfp.zzc((Parcel)parcel2, (int)9, (int)textTrackStyle.getWindowCornerRadius());
        zzbfp.zza((Parcel)parcel2, (int)10, (String)textTrackStyle.getFontFamily(), (boolean)false);
        zzbfp.zzc((Parcel)parcel2, (int)11, (int)textTrackStyle.getFontGenericFamily());
        zzbfp.zzc((Parcel)parcel2, (int)12, (int)textTrackStyle.getFontStyle());
        zzbfp.zza((Parcel)parcel2, (int)13, (String)textTrackStyle.zzemx, (boolean)false);
        zzbfp.zzai((Parcel)parcel2, (int)n2);
    }
}

