/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Bundle;
import android.os.RemoteException;
import com.google.android.gms.cast.ApplicationMetadata;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.LaunchOptions;
import com.google.android.gms.cast.zzab;
import com.google.android.gms.cast.zze;
import com.google.android.gms.cast.zzf;
import com.google.android.gms.cast.zzg;
import com.google.android.gms.cast.zzh;
import com.google.android.gms.cast.zzi;
import com.google.android.gms.cast.zzj;
import com.google.android.gms.cast.zzk;
import com.google.android.gms.cast.zzl;
import com.google.android.gms.cast.zzm;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzbdf;
import com.google.android.gms.internal.zzbdp;
import com.google.android.gms.internal.zzbeh;
import java.io.IOException;

public final class Cast {
    public static final int MAX_MESSAGE_LENGTH = 65536;
    public static final int MAX_NAMESPACE_LENGTH = 128;
    public static final int ACTIVE_INPUT_STATE_UNKNOWN = -1;
    public static final int ACTIVE_INPUT_STATE_NO = 0;
    public static final int ACTIVE_INPUT_STATE_YES = 1;
    public static final int STANDBY_STATE_UNKNOWN = -1;
    public static final int STANDBY_STATE_NO = 0;
    public static final int STANDBY_STATE_YES = 1;
    public static final String EXTRA_APP_NO_LONGER_RUNNING = "com.google.android.gms.cast.EXTRA_APP_NO_LONGER_RUNNING";
    private static Api.zza<zzbdp, CastOptions> zza = new zze();
    public static final Api<CastOptions> API = new Api("Cast.API", zza, zzbeh.zza);
    public static final CastApi CastApi = new CastApi.zza();

    private Cast() {
    }

    @Deprecated
    public static interface CastApi {
        public void requestStatus(GoogleApiClient var1) throws IOException, IllegalStateException;

        public PendingResult<Status> sendMessage(GoogleApiClient var1, String var2, String var3);

        public PendingResult<ApplicationConnectionResult> launchApplication(GoogleApiClient var1, String var2);

        @Deprecated
        public PendingResult<ApplicationConnectionResult> launchApplication(GoogleApiClient var1, String var2, boolean var3);

        public PendingResult<ApplicationConnectionResult> launchApplication(GoogleApiClient var1, String var2, LaunchOptions var3);

        public PendingResult<ApplicationConnectionResult> joinApplication(GoogleApiClient var1, String var2, String var3);

        public PendingResult<ApplicationConnectionResult> joinApplication(GoogleApiClient var1, String var2);

        public PendingResult<ApplicationConnectionResult> joinApplication(GoogleApiClient var1);

        public PendingResult<Status> leaveApplication(GoogleApiClient var1);

        public PendingResult<Status> stopApplication(GoogleApiClient var1);

        public PendingResult<Status> stopApplication(GoogleApiClient var1, String var2);

        public void setVolume(GoogleApiClient var1, double var2) throws IOException, IllegalArgumentException, IllegalStateException;

        public double getVolume(GoogleApiClient var1) throws IllegalStateException;

        public void setMute(GoogleApiClient var1, boolean var2) throws IOException, IllegalStateException;

        public boolean isMute(GoogleApiClient var1) throws IllegalStateException;

        public int getActiveInputState(GoogleApiClient var1) throws IllegalStateException;

        public int getStandbyState(GoogleApiClient var1) throws IllegalStateException;

        public ApplicationMetadata getApplicationMetadata(GoogleApiClient var1) throws IllegalStateException;

        public String getApplicationStatus(GoogleApiClient var1) throws IllegalStateException;

        public void setMessageReceivedCallbacks(GoogleApiClient var1, String var2, MessageReceivedCallback var3) throws IOException, IllegalStateException;

        public void removeMessageReceivedCallbacks(GoogleApiClient var1, String var2) throws IOException, IllegalArgumentException;

        @Hide
        public static final class zza
        implements CastApi {
            @Override
            public final void requestStatus(GoogleApiClient googleApiClient) throws IOException, IllegalStateException {
                try {
                    ((zzbdp)googleApiClient.zza(zzbeh.zza)).zzi();
                    return;
                }
                catch (RemoteException remoteException) {
                    throw new IOException("service error");
                }
            }

            @Override
            public final PendingResult<Status> sendMessage(GoogleApiClient googleApiClient, String string, String string2) {
                return googleApiClient.zzb((com.google.android.gms.common.api.internal.zzm)new zzf(this, googleApiClient, string, string2));
            }

            @Override
            public final PendingResult<ApplicationConnectionResult> launchApplication(GoogleApiClient googleApiClient, String string) {
                return googleApiClient.zzb((com.google.android.gms.common.api.internal.zzm)new zzg(this, googleApiClient, string));
            }

            @Override
            public final PendingResult<ApplicationConnectionResult> launchApplication(GoogleApiClient googleApiClient, String string, LaunchOptions launchOptions) {
                return googleApiClient.zzb((com.google.android.gms.common.api.internal.zzm)new zzh(this, googleApiClient, string, launchOptions));
            }

            @Override
            @Deprecated
            public final PendingResult<ApplicationConnectionResult> launchApplication(GoogleApiClient googleApiClient, String string, boolean bl) {
                LaunchOptions launchOptions = new LaunchOptions.Builder().setRelaunchIfRunning(bl).build();
                return this.launchApplication(googleApiClient, string, launchOptions);
            }

            private final PendingResult<ApplicationConnectionResult> zza(GoogleApiClient googleApiClient, String string, String string2, zzab zzab2) {
                return googleApiClient.zzb((com.google.android.gms.common.api.internal.zzm)new zzi(this, googleApiClient, string, string2, null));
            }

            @Override
            public final PendingResult<ApplicationConnectionResult> joinApplication(GoogleApiClient googleApiClient, String string, String string2) {
                return this.zza(googleApiClient, string, string2, null);
            }

            @Override
            public final PendingResult<ApplicationConnectionResult> joinApplication(GoogleApiClient googleApiClient, String string) {
                return this.zza(googleApiClient, string, null, null);
            }

            @Override
            public final PendingResult<ApplicationConnectionResult> joinApplication(GoogleApiClient googleApiClient) {
                return this.zza(googleApiClient, null, null, null);
            }

            @Override
            public final PendingResult<Status> leaveApplication(GoogleApiClient googleApiClient) {
                return googleApiClient.zzb((com.google.android.gms.common.api.internal.zzm)new zzj(this, googleApiClient));
            }

            @Override
            public final PendingResult<Status> stopApplication(GoogleApiClient googleApiClient) {
                return googleApiClient.zzb((com.google.android.gms.common.api.internal.zzm)new zzk(this, googleApiClient));
            }

            @Override
            public final PendingResult<Status> stopApplication(GoogleApiClient googleApiClient, String string) {
                return googleApiClient.zzb((com.google.android.gms.common.api.internal.zzm)new zzl(this, googleApiClient, string));
            }

            @Override
            public final void setVolume(GoogleApiClient googleApiClient, double d) throws IOException, IllegalArgumentException, IllegalStateException {
                try {
                    ((zzbdp)googleApiClient.zza(zzbeh.zza)).zza(d);
                    return;
                }
                catch (RemoteException remoteException) {
                    throw new IOException("service error");
                }
            }

            @Override
            public final double getVolume(GoogleApiClient googleApiClient) throws IllegalStateException {
                return ((zzbdp)googleApiClient.zza(zzbeh.zza)).zzj();
            }

            @Override
            public final void setMute(GoogleApiClient googleApiClient, boolean bl) throws IOException, IllegalStateException {
                try {
                    ((zzbdp)googleApiClient.zza(zzbeh.zza)).zza(bl);
                    return;
                }
                catch (RemoteException remoteException) {
                    throw new IOException("service error");
                }
            }

            @Override
            public final boolean isMute(GoogleApiClient googleApiClient) throws IllegalStateException {
                return ((zzbdp)googleApiClient.zza(zzbeh.zza)).zzk();
            }

            @Override
            public final int getActiveInputState(GoogleApiClient googleApiClient) throws IllegalStateException {
                return ((zzbdp)googleApiClient.zza(zzbeh.zza)).zzl();
            }

            @Override
            public final int getStandbyState(GoogleApiClient googleApiClient) throws IllegalStateException {
                return ((zzbdp)googleApiClient.zza(zzbeh.zza)).zzm();
            }

            @Override
            public final ApplicationMetadata getApplicationMetadata(GoogleApiClient googleApiClient) throws IllegalStateException {
                return ((zzbdp)googleApiClient.zza(zzbeh.zza)).zzn();
            }

            @Override
            public final String getApplicationStatus(GoogleApiClient googleApiClient) throws IllegalStateException {
                return ((zzbdp)googleApiClient.zza(zzbeh.zza)).zzo();
            }

            @Override
            public final void setMessageReceivedCallbacks(GoogleApiClient googleApiClient, String string, MessageReceivedCallback messageReceivedCallback) throws IOException, IllegalStateException {
                try {
                    ((zzbdp)googleApiClient.zza(zzbeh.zza)).zza(string, messageReceivedCallback);
                    return;
                }
                catch (RemoteException remoteException) {
                    throw new IOException("service error");
                }
            }

            @Override
            public final void removeMessageReceivedCallbacks(GoogleApiClient googleApiClient, String string) throws IOException, IllegalArgumentException {
                try {
                    ((zzbdp)googleApiClient.zza(zzbeh.zza)).zza(string);
                    return;
                }
                catch (RemoteException remoteException) {
                    throw new IOException("service error");
                }
            }
        }
    }

    static abstract class zza
    extends zzbdf<ApplicationConnectionResult> {
        public zza(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public void zza(zzbdp zzbdp2) throws RemoteException {
        }

        public final /* synthetic */ Result zza(Status status) {
            Status status2 = status;
            zza zza2 = this;
            return new zzm(zza2, status2);
        }
    }

    public static interface ApplicationConnectionResult
    extends Result {
        public ApplicationMetadata getApplicationMetadata();

        public String getApplicationStatus();

        public String getSessionId();

        public boolean getWasLaunched();
    }

    public static final class CastOptions
    implements Api.ApiOptions.HasOptions {
        final CastDevice zza;
        final Listener zzb;
        @Hide
        final Bundle zzc;
        private final int zzd;

        private CastOptions(Builder builder) {
            this.zza = builder.zza;
            this.zzb = builder.zzb;
            this.zzd = builder.zzc;
            this.zzc = builder.zzd;
        }

        @Deprecated
        public static Builder builder(CastDevice castDevice, Listener listener) {
            return new Builder(castDevice, listener);
        }

        /* synthetic */ CastOptions(Builder builder, zze zze2) {
            this(builder);
        }

        static /* synthetic */ int zza(CastOptions castOptions) {
            return castOptions.zzd;
        }

        public static final class Builder {
            CastDevice zza;
            Listener zzb;
            private int zzc;
            private Bundle zzd;

            public Builder(CastDevice castDevice, Listener listener) {
                zzbq.zza((Object)((Object)castDevice), (Object)"CastDevice parameter cannot be null");
                zzbq.zza((Object)listener, (Object)"CastListener parameter cannot be null");
                this.zza = castDevice;
                this.zzb = listener;
                this.zzc = 0;
            }

            public final Builder setVerboseLoggingEnabled(boolean bl) {
                this.zzc = bl ? (this.zzc |= 1) : (this.zzc &= 0xFFFFFFFE);
                return this;
            }

            @Hide
            public final Builder zza(Bundle bundle) {
                this.zzd = bundle;
                return this;
            }

            public final CastOptions build() {
                return new CastOptions(this, null);
            }
        }
    }

    public static interface MessageReceivedCallback {
        public void onMessageReceived(CastDevice var1, String var2, String var3);
    }

    public static class Listener {
        public Listener() {
        }

        public void onApplicationStatusChanged() {
        }

        public void onApplicationMetadataChanged(ApplicationMetadata applicationMetadata) {
        }

        public void onApplicationDisconnected(int n) {
        }

        public void onActiveInputStateChanged(int n) {
        }

        public void onStandbyStateChanged(int n) {
        }

        public void onVolumeChanged() {
        }
    }
}

