/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import com.google.android.gms.cast.zzaf;
import org.json.JSONObject;

public class MediaLoadOptions {
    public static final double PLAYBACK_RATE_MIN = 0.5;
    public static final double PLAYBACK_RATE_MAX = 2.0;
    private boolean zza;
    private long zzb;
    private double zzc;
    private long[] zzd;
    private JSONObject zze;
    private String zzf;
    private String zzg;

    private MediaLoadOptions(boolean bl, long l, double d, long[] lArray, JSONObject jSONObject, String string2, String string3) {
        this.zza = bl;
        this.zzb = l;
        this.zzc = d;
        this.zzd = lArray;
        this.zze = jSONObject;
        this.zzf = string2;
        this.zzg = string3;
    }

    public boolean getAutoplay() {
        return this.zza;
    }

    public long getPlayPosition() {
        return this.zzb;
    }

    public double getPlaybackRate() {
        return this.zzc;
    }

    public long[] getActiveTrackIds() {
        return this.zzd;
    }

    public JSONObject getCustomData() {
        return this.zze;
    }

    public String getCredentials() {
        return this.zzf;
    }

    public String getCredentialsType() {
        return this.zzg;
    }

    /* synthetic */ MediaLoadOptions(boolean bl, long l, double d, long[] lArray, JSONObject jSONObject, String string2, String string3, zzaf zzaf2) {
        this(bl, l, d, lArray, jSONObject, string2, string3);
    }

    public static class Builder {
        private boolean zza = true;
        private long zzb = 0L;
        private double zzc = 1.0;
        private long[] zzd = null;
        private JSONObject zze = null;
        private String zzf = null;
        private String zzg = null;

        public Builder() {
        }

        public Builder setAutoplay(boolean bl) {
            this.zza = bl;
            return this;
        }

        public Builder setPlayPosition(long l) {
            this.zzb = l;
            return this;
        }

        public Builder setPlaybackRate(double d) {
            if (Double.compare(d, 2.0) > 0 || Double.compare(d, 0.5) < 0) {
                throw new IllegalArgumentException("playbackRate must be between PLAYBACK_RATE_MIN and PLAYBACK_RATE_MAX");
            }
            this.zzc = d;
            return this;
        }

        public Builder setActiveTrackIds(long[] lArray) {
            this.zzd = lArray;
            return this;
        }

        public Builder setCustomData(JSONObject jSONObject) {
            this.zze = jSONObject;
            return this;
        }

        public Builder setCredentials(String string2) {
            this.zzf = string2;
            return this;
        }

        public Builder setCredentialsType(String string2) {
            this.zzg = string2;
            return this;
        }

        public MediaLoadOptions build() {
            return new MediaLoadOptions(this.zza, this.zzb, this.zzc, this.zzd, this.zze, this.zzf, this.zzg, null);
        }
    }
}

