/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.zzah;
import com.google.android.gms.cast.zzai;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.util.zzq;
import com.google.android.gms.internal.zzbdw;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import java.util.Arrays;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MediaQueueItem
extends zzbgl {
    public static final int INVALID_ITEM_ID = 0;
    public static final double DEFAULT_PLAYBACK_DURATION = Double.POSITIVE_INFINITY;
    @Hide
    public static final Parcelable.Creator<MediaQueueItem> CREATOR = new zzai();
    private MediaInfo zza;
    private int zzb;
    private boolean zzc;
    private double zzd;
    private double zze;
    private double zzf;
    private long[] zzg;
    private String zzh;
    private JSONObject zzi;

    MediaQueueItem(MediaInfo mediaInfo, int n, boolean bl, double d, double d2, double d3, long[] lArray, String string2) {
        this.zza = mediaInfo;
        this.zzb = n;
        this.zzc = bl;
        this.zzd = d;
        this.zze = d2;
        this.zzf = d3;
        this.zzg = lArray;
        this.zzh = string2;
        if (this.zzh != null) {
            try {
                this.zzi = new JSONObject(this.zzh);
                return;
            }
            catch (JSONException jSONException) {
                this.zzi = null;
                this.zzh = null;
                return;
            }
        }
        this.zzi = null;
    }

    private MediaQueueItem(MediaInfo mediaInfo) throws IllegalArgumentException {
        this(mediaInfo, 0, true, 0.0, Double.POSITIVE_INFINITY, 0.0, null, null);
        if (mediaInfo == null) {
            throw new IllegalArgumentException("media cannot be null.");
        }
    }

    MediaQueueItem(JSONObject jSONObject) throws JSONException {
        this(null, 0, true, 0.0, Double.POSITIVE_INFINITY, 0.0, null, null);
        this.zza(jSONObject);
    }

    @Hide
    private MediaQueueItem(MediaQueueItem mediaQueueItem) throws IllegalArgumentException {
        this(mediaQueueItem.getMedia(), mediaQueueItem.getItemId(), mediaQueueItem.getAutoplay(), mediaQueueItem.getStartTime(), mediaQueueItem.getPlaybackDuration(), mediaQueueItem.getPreloadTime(), mediaQueueItem.getActiveTrackIds(), null);
        if (this.zza == null) {
            throw new IllegalArgumentException("media cannot be null.");
        }
        this.zzi = mediaQueueItem.getCustomData();
    }

    @Hide
    public final boolean zza(JSONObject jSONObject) throws JSONException {
        int n;
        boolean bl = false;
        if (jSONObject.has("media")) {
            this.zza = new MediaInfo(jSONObject.getJSONObject("media"));
            bl = true;
        }
        if (jSONObject.has("itemId") && this.zzb != (n = jSONObject.getInt("itemId"))) {
            this.zzb = n;
            bl = true;
        }
        if (jSONObject.has("autoplay") && this.zzc != (n = (int)(jSONObject.getBoolean("autoplay") ? 1 : 0))) {
            this.zzc = n;
            bl = true;
        }
        if (jSONObject.has("startTime")) {
            double d;
            double d2 = jSONObject.getDouble("startTime");
            if (Math.abs(d - this.zzd) > 1.0E-7) {
                this.zzd = d2;
                bl = true;
            }
        }
        if (jSONObject.has("playbackDuration")) {
            double d;
            double d3 = jSONObject.getDouble("playbackDuration");
            if (Math.abs(d - this.zze) > 1.0E-7) {
                this.zze = d3;
                bl = true;
            }
        }
        if (jSONObject.has("preloadTime")) {
            double d;
            double d4 = jSONObject.getDouble("preloadTime");
            if (Math.abs(d - this.zzf) > 1.0E-7) {
                this.zzf = d4;
                bl = true;
            }
        }
        boolean bl2 = false;
        long[] lArray = null;
        if (jSONObject.has("activeTrackIds")) {
            int n2;
            JSONArray jSONArray = jSONObject.getJSONArray("activeTrackIds");
            int n3 = jSONArray.length();
            lArray = new long[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                lArray[n2] = jSONArray.getLong(n2);
            }
            if (this.zzg == null) {
                bl2 = true;
            } else if (this.zzg.length != n3) {
                bl2 = true;
            } else {
                for (n2 = 0; n2 < n3; ++n2) {
                    if (this.zzg[n2] == lArray[n2]) continue;
                    bl2 = true;
                    break;
                }
            }
        }
        if (bl2) {
            this.zzg = lArray;
            bl = true;
        }
        if (jSONObject.has("customData")) {
            this.zzi = jSONObject.getJSONObject("customData");
            bl = true;
        }
        return bl;
    }

    public MediaInfo getMedia() {
        return this.zza;
    }

    public int getItemId() {
        return this.zzb;
    }

    final void zza(int n) {
        this.zzb = 0;
    }

    public boolean getAutoplay() {
        return this.zzc;
    }

    final void zza(boolean bl) {
        this.zzc = bl;
    }

    public double getStartTime() {
        return this.zzd;
    }

    final void zza(double d) throws IllegalArgumentException {
        if (Double.isNaN(d) || d < 0.0) {
            throw new IllegalArgumentException("startTime cannot be negative or NaN.");
        }
        this.zzd = d;
    }

    public double getPlaybackDuration() {
        return this.zze;
    }

    final void zzb(double d) throws IllegalArgumentException {
        if (Double.isNaN(d)) {
            throw new IllegalArgumentException("playbackDuration cannot be NaN.");
        }
        this.zze = d;
    }

    public double getPreloadTime() {
        return this.zzf;
    }

    final void zzc(double d) throws IllegalArgumentException {
        if (Double.isNaN(d) || d < 0.0) {
            throw new IllegalArgumentException("preloadTime cannot be negative or NaN.");
        }
        this.zzf = d;
    }

    public long[] getActiveTrackIds() {
        return this.zzg;
    }

    final void zza(long[] lArray) {
        this.zzg = lArray;
    }

    public JSONObject getCustomData() {
        return this.zzi;
    }

    final void zzb(JSONObject jSONObject) {
        this.zzi = jSONObject;
    }

    final void zza() throws IllegalArgumentException {
        if (this.zza == null) {
            throw new IllegalArgumentException("media cannot be null.");
        }
        if (Double.isNaN(this.zzd) || this.zzd < 0.0) {
            throw new IllegalArgumentException("startTime cannot be negative or NaN.");
        }
        if (Double.isNaN(this.zze)) {
            throw new IllegalArgumentException("playbackDuration cannot be NaN.");
        }
        if (Double.isNaN(this.zzf) || this.zzf < 0.0) {
            throw new IllegalArgumentException("preloadTime cannot be negative or Nan.");
        }
    }

    @Hide
    public final JSONObject zzb() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("media", (Object)this.zza.zza());
            if (this.zzb != 0) {
                jSONObject.put("itemId", this.zzb);
            }
            jSONObject.put("autoplay", this.zzc);
            jSONObject.put("startTime", this.zzd);
            if (this.zze != Double.POSITIVE_INFINITY) {
                jSONObject.put("playbackDuration", this.zze);
            }
            jSONObject.put("preloadTime", this.zzf);
            if (this.zzg != null) {
                JSONArray jSONArray = new JSONArray();
                long[] lArray = this.zzg;
                int n = this.zzg.length;
                for (int i = 0; i < n; ++i) {
                    long l = lArray[i];
                    jSONArray.put(l);
                }
                jSONObject.put("activeTrackIds", (Object)jSONArray);
            }
            if (this.zzi != null) {
                jSONObject.put("customData", (Object)this.zzi);
            }
        }
        catch (JSONException jSONException) {}
        return jSONObject;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MediaQueueItem)) {
            return false;
        }
        MediaQueueItem mediaQueueItem = (MediaQueueItem)((Object)object);
        if (this.zzi == null != (mediaQueueItem.zzi == null)) {
            return false;
        }
        if (this.zzi != null && mediaQueueItem.zzi != null && !zzq.zza((Object)this.zzi, (Object)mediaQueueItem.zzi)) {
            return false;
        }
        return zzbdw.zza(this.zza, mediaQueueItem.zza) && this.zzb == mediaQueueItem.zzb && this.zzc == mediaQueueItem.zzc && this.zzd == mediaQueueItem.zzd && this.zze == mediaQueueItem.zze && this.zzf == mediaQueueItem.zzf && Arrays.equals(this.zzg, mediaQueueItem.zzg);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zza, this.zzb, this.zzc, this.zzd, this.zze, this.zzf, Arrays.hashCode(this.zzg), String.valueOf(this.zzi)});
    }

    public void writeToParcel(Parcel parcel, int n) {
        this.zzh = this.zzi == null ? null : this.zzi.toString();
        Parcel parcel2 = parcel;
        MediaQueueItem mediaQueueItem = this;
        int n2 = zzbgo.zza((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)2, (Parcelable)mediaQueueItem.getMedia(), (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)3, (int)mediaQueueItem.getItemId());
        zzbgo.zza((Parcel)parcel2, (int)4, (boolean)mediaQueueItem.getAutoplay());
        zzbgo.zza((Parcel)parcel2, (int)5, (double)mediaQueueItem.getStartTime());
        zzbgo.zza((Parcel)parcel2, (int)6, (double)mediaQueueItem.getPlaybackDuration());
        zzbgo.zza((Parcel)parcel2, (int)7, (double)mediaQueueItem.getPreloadTime());
        zzbgo.zza((Parcel)parcel2, (int)8, (long[])mediaQueueItem.getActiveTrackIds(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)9, (String)mediaQueueItem.zzh, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)n2);
    }

    /* synthetic */ MediaQueueItem(MediaInfo mediaInfo, zzah zzah2) throws IllegalArgumentException {
        this(mediaInfo);
    }

    /* synthetic */ MediaQueueItem(MediaQueueItem mediaQueueItem, zzah zzah2) throws IllegalArgumentException {
        this(mediaQueueItem);
    }

    public static class Builder {
        private final MediaQueueItem zza;

        public Builder(MediaInfo mediaInfo) throws IllegalArgumentException {
            this.zza = new MediaQueueItem(mediaInfo, null);
        }

        public Builder(JSONObject jSONObject) throws JSONException {
            this.zza = new MediaQueueItem(jSONObject);
        }

        public Builder(MediaQueueItem mediaQueueItem) throws IllegalArgumentException {
            this.zza = new MediaQueueItem(mediaQueueItem, null);
        }

        public Builder clearItemId() {
            this.zza.zza(0);
            return this;
        }

        public Builder setAutoplay(boolean bl) {
            this.zza.zza(bl);
            return this;
        }

        public Builder setStartTime(double d) throws IllegalArgumentException {
            this.zza.zza(d);
            return this;
        }

        public Builder setPlaybackDuration(double d) {
            this.zza.zzb(d);
            return this;
        }

        public Builder setPreloadTime(double d) throws IllegalArgumentException {
            this.zza.zzc(d);
            return this;
        }

        public Builder setActiveTrackIds(long[] lArray) {
            this.zza.zza(lArray);
            return this;
        }

        public Builder setCustomData(JSONObject jSONObject) {
            this.zza.zzb(jSONObject);
            return this;
        }

        public MediaQueueItem build() {
            this.zza.zza();
            return this.zza;
        }
    }
}

