/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.SparseArray;
import com.google.android.gms.cast.AdBreakClipInfo;
import com.google.android.gms.cast.AdBreakInfo;
import com.google.android.gms.cast.AdBreakStatus;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaQueueItem;
import com.google.android.gms.cast.VideoInfo;
import com.google.android.gms.cast.zzaj;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.util.zzq;
import com.google.android.gms.internal.zzbdw;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MediaStatus
extends zzbgl {
    public static final long COMMAND_PAUSE = 1L;
    public static final long COMMAND_SEEK = 2L;
    public static final long COMMAND_SET_VOLUME = 4L;
    public static final long COMMAND_TOGGLE_MUTE = 8L;
    public static final long COMMAND_SKIP_FORWARD = 16L;
    public static final long COMMAND_SKIP_BACKWARD = 32L;
    public static final int PLAYER_STATE_UNKNOWN = 0;
    public static final int PLAYER_STATE_IDLE = 1;
    public static final int PLAYER_STATE_PLAYING = 2;
    public static final int PLAYER_STATE_PAUSED = 3;
    public static final int PLAYER_STATE_BUFFERING = 4;
    public static final int IDLE_REASON_NONE = 0;
    public static final int IDLE_REASON_FINISHED = 1;
    public static final int IDLE_REASON_CANCELED = 2;
    public static final int IDLE_REASON_INTERRUPTED = 3;
    public static final int IDLE_REASON_ERROR = 4;
    public static final int REPEAT_MODE_REPEAT_OFF = 0;
    public static final int REPEAT_MODE_REPEAT_ALL = 1;
    public static final int REPEAT_MODE_REPEAT_SINGLE = 2;
    public static final int REPEAT_MODE_REPEAT_ALL_AND_SHUFFLE = 3;
    @Hide
    public static final Parcelable.Creator<MediaStatus> CREATOR = new zzaj();
    private MediaInfo zza;
    private long zzb;
    private int zzc;
    private double zzd;
    private int zze;
    private int zzf;
    private long zzg;
    private long zzh;
    private double zzi;
    private boolean zzj;
    private long[] zzk;
    private int zzl;
    private int zzm;
    private String zzn;
    private JSONObject zzo;
    private int zzp;
    private ArrayList<MediaQueueItem> zzq = new ArrayList();
    private boolean zzr;
    private AdBreakStatus zzs;
    private VideoInfo zzt;
    private final SparseArray<Integer> zzu = new SparseArray();

    MediaStatus(MediaInfo mediaInfo, long l, int n, double d, int n2, int n3, long l2, long l3, double d2, boolean bl, long[] lArray, int n4, int n5, String string2, int n6, List<MediaQueueItem> list, boolean bl2, AdBreakStatus adBreakStatus, VideoInfo videoInfo) {
        this.zza = mediaInfo;
        this.zzb = l;
        this.zzc = n;
        this.zzd = d;
        this.zze = n2;
        this.zzf = n3;
        this.zzg = l2;
        this.zzh = l3;
        this.zzi = d2;
        this.zzj = bl;
        this.zzk = lArray;
        this.zzl = n4;
        this.zzm = n5;
        this.zzn = string2;
        if (this.zzn != null) {
            try {
                this.zzo = new JSONObject(this.zzn);
            }
            catch (JSONException jSONException) {
                this.zzo = null;
                this.zzn = null;
            }
        } else {
            this.zzo = null;
        }
        this.zzp = n6;
        if (list != null && !list.isEmpty()) {
            this.zza(list.toArray(new MediaQueueItem[list.size()]));
        }
        this.zzr = bl2;
        this.zzs = adBreakStatus;
        this.zzt = videoInfo;
    }

    @Hide
    public MediaStatus(JSONObject jSONObject) throws JSONException {
        this(null, 0L, 0, 0.0, 0, 0, 0L, 0L, 0.0, false, null, 0, 0, null, 0, null, false, null, null);
        this.zza(jSONObject, 0);
    }

    @Hide
    public final long zza() {
        return this.zzb;
    }

    public int getPlayerState() {
        return this.zze;
    }

    public int getIdleReason() {
        return this.zzf;
    }

    public double getPlaybackRate() {
        return this.zzd;
    }

    public MediaInfo getMediaInfo() {
        return this.zza;
    }

    public long getStreamPosition() {
        return this.zzg;
    }

    public boolean isMediaCommandSupported(long l) {
        return (this.zzh & l) != 0L;
    }

    public double getStreamVolume() {
        return this.zzi;
    }

    public boolean isMute() {
        return this.zzj;
    }

    public long[] getActiveTrackIds() {
        return this.zzk;
    }

    public JSONObject getCustomData() {
        return this.zzo;
    }

    public int getCurrentItemId() {
        return this.zzc;
    }

    public int getLoadingItemId() {
        return this.zzl;
    }

    public int getPreloadedItemId() {
        return this.zzm;
    }

    public int getQueueRepeatMode() {
        return this.zzp;
    }

    public List<MediaQueueItem> getQueueItems() {
        return this.zzq;
    }

    public int getQueueItemCount() {
        return this.zzq.size();
    }

    public MediaQueueItem getQueueItemById(int n) {
        return this.getItemById(n);
    }

    public MediaQueueItem getQueueItem(int n) {
        return this.getItemByIndex(n);
    }

    public boolean isPlayingAd() {
        return this.zzr;
    }

    @Hide
    public final void zza(boolean bl) {
        this.zzr = bl;
    }

    public AdBreakStatus getAdBreakStatus() {
        return this.zzs;
    }

    public VideoInfo getVideoInfo() {
        return this.zzt;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Hide
    public final int zza(JSONObject jSONObject, int n) throws JSONException {
        int n2;
        block75: {
            int n3;
            block73: {
                MediaQueueItem[] mediaQueueItemArray;
                int n4;
                JSONArray jSONArray;
                String string2;
                MediaStatus mediaStatus;
                block74: {
                    block72: {
                        int n5;
                        boolean bl;
                        int n6;
                        block71: {
                            int n7;
                            block70: {
                                int n8;
                                int n9;
                                int n10;
                                int n11;
                                long[] lArray;
                                boolean bl2;
                                block69: {
                                    block67: {
                                        int n12;
                                        block68: {
                                            block65: {
                                                block66: {
                                                    long l;
                                                    long l2;
                                                    double d;
                                                    n2 = 0;
                                                    long l3 = jSONObject.getLong("mediaSessionId");
                                                    if (l3 != this.zzb) {
                                                        this.zzb = l3;
                                                        n2 = 1;
                                                    }
                                                    if (jSONObject.has("playerState")) {
                                                        int n13 = 0;
                                                        String string3 = jSONObject.getString("playerState");
                                                        if (string3.equals("IDLE")) {
                                                            n13 = 1;
                                                        } else if (string3.equals("PLAYING")) {
                                                            n13 = 2;
                                                        } else if (string3.equals("PAUSED")) {
                                                            n13 = 3;
                                                        } else if (string3.equals("BUFFERING")) {
                                                            n13 = 4;
                                                        }
                                                        if (n13 != this.zze) {
                                                            this.zze = n13;
                                                            n2 |= 2;
                                                        }
                                                        if (n13 == 1 && jSONObject.has("idleReason")) {
                                                            int n14 = 0;
                                                            string3 = jSONObject.getString("idleReason");
                                                            if (string3.equals("CANCELLED")) {
                                                                n14 = 2;
                                                            } else if (string3.equals("INTERRUPTED")) {
                                                                n14 = 3;
                                                            } else if (string3.equals("FINISHED")) {
                                                                n14 = 1;
                                                            } else if (string3.equals("ERROR")) {
                                                                n14 = 4;
                                                            }
                                                            if (n14 != this.zzf) {
                                                                this.zzf = n14;
                                                                n2 |= 2;
                                                            }
                                                        }
                                                    }
                                                    if (jSONObject.has("playbackRate") && this.zzd != (d = jSONObject.getDouble("playbackRate"))) {
                                                        this.zzd = d;
                                                        n2 |= 2;
                                                    }
                                                    if (jSONObject.has("currentTime") && (n & 2) == 0 && (l2 = (long)(jSONObject.getDouble("currentTime") * 1000.0)) != this.zzg) {
                                                        this.zzg = l2;
                                                        n2 |= 2;
                                                    }
                                                    if (jSONObject.has("supportedMediaCommands") && (l = jSONObject.getLong("supportedMediaCommands")) != this.zzh) {
                                                        this.zzh = l;
                                                        n2 |= 2;
                                                    }
                                                    if (jSONObject.has("volume") && (n & 1) == 0) {
                                                        JSONObject jSONObject2 = jSONObject.getJSONObject("volume");
                                                        double d2 = jSONObject2.getDouble("level");
                                                        if (d2 != this.zzi) {
                                                            this.zzi = d2;
                                                            n2 |= 2;
                                                        }
                                                        boolean bl3 = jSONObject2.getBoolean("muted");
                                                        n12 = bl3 ? 1 : 0;
                                                        if (bl3 != this.zzj) {
                                                            this.zzj = n12;
                                                            n2 |= 2;
                                                        }
                                                    }
                                                    bl2 = false;
                                                    lArray = null;
                                                    if (!jSONObject.has("activeTrackIds")) break block65;
                                                    JSONArray jSONArray2 = jSONObject.getJSONArray("activeTrackIds");
                                                    n12 = jSONArray2.length();
                                                    lArray = new long[n12];
                                                    for (n11 = 0; n11 < n12; ++n11) {
                                                        lArray[n11] = jSONArray2.getLong(n11);
                                                    }
                                                    if (this.zzk != null) break block66;
                                                    bl2 = true;
                                                    break block67;
                                                }
                                                if (this.zzk.length == n12) break block68;
                                                bl2 = true;
                                                break block67;
                                            }
                                            if (this.zzk != null) {
                                                bl2 = true;
                                            }
                                            break block69;
                                        }
                                        for (n11 = 0; n11 < n12; ++n11) {
                                            if (this.zzk[n11] == lArray[n11]) continue;
                                            bl2 = true;
                                            break;
                                        }
                                    }
                                    if (bl2) {
                                        this.zzk = lArray;
                                    }
                                }
                                if (bl2) {
                                    this.zzk = lArray;
                                    n2 |= 2;
                                }
                                if (jSONObject.has("customData")) {
                                    this.zzo = jSONObject.getJSONObject("customData");
                                    this.zzn = null;
                                    n2 |= 2;
                                }
                                if (jSONObject.has("media")) {
                                    JSONObject jSONObject3 = jSONObject.getJSONObject("media");
                                    MediaInfo mediaInfo = new MediaInfo(jSONObject3);
                                    if (this.zza == null || this.zza != null && !this.zza.equals((Object)mediaInfo)) {
                                        this.zza = mediaInfo;
                                        n2 |= 2;
                                    }
                                    if (jSONObject3.has("metadata")) {
                                        n2 |= 4;
                                    }
                                }
                                if (jSONObject.has("currentItemId") && this.zzc != (n10 = jSONObject.getInt("currentItemId"))) {
                                    this.zzc = n10;
                                    n2 |= 2;
                                }
                                if (this.zzm != (n9 = jSONObject.optInt("preloadedItemId", 0))) {
                                    this.zzm = n9;
                                    n2 |= 0x10;
                                }
                                if (this.zzl != (n8 = jSONObject.optInt("loadingItemId", 0))) {
                                    this.zzl = n8;
                                    n2 |= 2;
                                }
                                n6 = n11 = this.zza == null ? -1 : this.zza.getStreamType();
                                n3 = this.zzl;
                                n7 = this.zzf;
                                if (this.zze == 1) break block70;
                                bl = false;
                                break block71;
                            }
                            switch (n7) {
                                case 1: 
                                case 3: {
                                    if (n3 == 0) break;
                                    bl = false;
                                    break block71;
                                }
                                case 2: {
                                    if (n6 != 2) break;
                                    bl = false;
                                    break block71;
                                }
                            }
                            bl = true;
                        }
                        if (bl) break block72;
                        JSONObject jSONObject4 = jSONObject;
                        mediaStatus = this;
                        n3 = 0;
                        if (jSONObject4.has("repeatMode")) {
                            n6 = mediaStatus.zzp;
                            string2 = jSONObject4.getString("repeatMode");
                            n5 = -1;
                            switch (string2.hashCode()) {
                                case 1645952171: {
                                    if (!string2.equals("REPEAT_OFF")) break;
                                    n5 = 0;
                                    break;
                                }
                                case 1645938909: {
                                    if (!string2.equals("REPEAT_ALL")) break;
                                    n5 = 1;
                                    break;
                                }
                                case -962896020: {
                                    if (!string2.equals("REPEAT_SINGLE")) break;
                                    n5 = 2;
                                    break;
                                }
                                case -1118317585: {
                                    if (!string2.equals("REPEAT_ALL_AND_SHUFFLE")) break;
                                    n5 = 3;
                                    break;
                                }
                            }
                            switch (n5) {
                                case 0: {
                                    n6 = 0;
                                    break;
                                }
                                case 1: {
                                    n6 = 1;
                                    break;
                                }
                                case 2: {
                                    n6 = 2;
                                    break;
                                }
                                case 3: {
                                    n6 = 3;
                                    break;
                                }
                            }
                            if (mediaStatus.zzp != n6) {
                                mediaStatus.zzp = n6;
                                n3 = 1;
                            }
                        }
                        if (!jSONObject4.has("items")) break block73;
                        jSONArray = jSONObject4.getJSONArray("items");
                        n4 = jSONArray.length();
                        string2 = new SparseArray();
                        for (n5 = 0; n5 < n4; ++n5) {
                            string2.put(n5, (Object)jSONArray.getJSONObject(n5).getInt("itemId"));
                        }
                        mediaQueueItemArray = new MediaQueueItem[n4];
                        break block74;
                    }
                    this.zzc = 0;
                    this.zzl = 0;
                    this.zzm = 0;
                    if (!this.zzq.isEmpty()) {
                        MediaStatus mediaStatus2 = this;
                        this.zzp = 0;
                        mediaStatus2.zzq.clear();
                        mediaStatus2.zzu.clear();
                        n2 |= 8;
                    }
                    break block75;
                }
                for (int i = 0; i < n4; ++i) {
                    Integer n15 = (Integer)string2.get(i);
                    JSONObject jSONObject5 = jSONArray.getJSONObject(i);
                    MediaQueueItem mediaQueueItem = mediaStatus.getItemById(n15);
                    if (mediaQueueItem != null) {
                        n3 |= mediaQueueItem.zza(jSONObject5);
                        mediaQueueItemArray[i] = mediaQueueItem;
                        if (i == mediaStatus.getIndexById(n15)) continue;
                        n3 = 1;
                        continue;
                    }
                    n3 = 1;
                    if (n15 == mediaStatus.zzc && mediaStatus.zza != null) {
                        mediaQueueItemArray[i] = new MediaQueueItem.Builder(mediaStatus.zza).build();
                        mediaQueueItemArray[i].zza(jSONObject5);
                        continue;
                    }
                    mediaQueueItemArray[i] = new MediaQueueItem(jSONObject5);
                }
                if (mediaStatus.zzq.size() != n4) {
                    n3 = 1;
                }
                mediaStatus.zza(mediaQueueItemArray);
            }
            if (n3 != 0) {
                n2 |= 8;
            }
        }
        AdBreakStatus adBreakStatus = AdBreakStatus.zza(jSONObject.optJSONObject("breakStatus"));
        if (this.zzs == null && adBreakStatus != null || this.zzs != null && !this.zzs.equals((Object)adBreakStatus)) {
            boolean bl = adBreakStatus != null;
            this.zzr = bl;
            this.zzs = adBreakStatus;
            n2 |= 0x20;
        }
        VideoInfo videoInfo = VideoInfo.zza(jSONObject.optJSONObject("videoInfo"));
        if (this.zzt == null && videoInfo != null || this.zzt != null && !this.zzt.equals((Object)videoInfo)) {
            this.zzt = videoInfo;
            n2 |= 0x40;
        }
        if (jSONObject.has("breakInfo") && this.zza != null) {
            this.zza.zzb(jSONObject.getJSONObject("breakInfo"));
            n2 |= 2;
        }
        return n2;
    }

    public MediaQueueItem getItemById(int n) {
        Integer n2 = (Integer)this.zzu.get(n);
        if (n2 == null) {
            return null;
        }
        return this.zzq.get(n2);
    }

    public MediaQueueItem getItemByIndex(int n) {
        if (n < 0 || n >= this.zzq.size()) {
            return null;
        }
        return this.zzq.get(n);
    }

    public Integer getIndexById(int n) {
        return (Integer)this.zzu.get(n);
    }

    private final void zza(MediaQueueItem[] mediaQueueItemArray) {
        this.zzq.clear();
        this.zzu.clear();
        for (int i = 0; i < mediaQueueItemArray.length; ++i) {
            MediaQueueItem mediaQueueItem = mediaQueueItemArray[i];
            this.zzq.add(mediaQueueItem);
            this.zzu.put(mediaQueueItem.getItemId(), (Object)i);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MediaStatus)) {
            return false;
        }
        MediaStatus mediaStatus = (MediaStatus)((Object)object);
        if (this.zzo == null != (mediaStatus.zzo == null)) {
            return false;
        }
        if (this.zzb == mediaStatus.zzb && this.zzc == mediaStatus.zzc && this.zzd == mediaStatus.zzd && this.zze == mediaStatus.zze && this.zzf == mediaStatus.zzf && this.zzg == mediaStatus.zzg && this.zzi == mediaStatus.zzi && this.zzj == mediaStatus.zzj && this.zzl == mediaStatus.zzl && this.zzm == mediaStatus.zzm && this.zzp == mediaStatus.zzp && Arrays.equals(this.zzk, mediaStatus.zzk) && zzbdw.zza(this.zzh, mediaStatus.zzh) && zzbdw.zza(this.zzq, mediaStatus.zzq) && zzbdw.zza(this.zza, mediaStatus.zza)) {
            MediaStatus mediaStatus2 = mediaStatus;
            MediaStatus mediaStatus3 = this;
            if ((mediaStatus3.zzo == null || mediaStatus2.zzo == null || com.google.android.gms.common.util.zzq.zza((Object)mediaStatus3.zzo, (Object)mediaStatus2.zzo)) && this.zzr == mediaStatus.isPlayingAd()) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zza, this.zzb, this.zzc, this.zzd, this.zze, this.zzf, this.zzg, this.zzh, this.zzi, this.zzj, Arrays.hashCode(this.zzk), this.zzl, this.zzm, String.valueOf(this.zzo), this.zzp, this.zzq, this.zzr});
    }

    public void writeToParcel(Parcel parcel, int n) {
        this.zzn = this.zzo == null ? null : this.zzo.toString();
        Parcel parcel2 = parcel;
        MediaStatus mediaStatus = this;
        int n2 = zzbgo.zza((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)2, (Parcelable)mediaStatus.getMediaInfo(), (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)3, (long)mediaStatus.zzb);
        zzbgo.zza((Parcel)parcel2, (int)4, (int)mediaStatus.getCurrentItemId());
        zzbgo.zza((Parcel)parcel2, (int)5, (double)mediaStatus.getPlaybackRate());
        zzbgo.zza((Parcel)parcel2, (int)6, (int)mediaStatus.getPlayerState());
        zzbgo.zza((Parcel)parcel2, (int)7, (int)mediaStatus.getIdleReason());
        zzbgo.zza((Parcel)parcel2, (int)8, (long)mediaStatus.getStreamPosition());
        zzbgo.zza((Parcel)parcel2, (int)9, (long)mediaStatus.zzh);
        zzbgo.zza((Parcel)parcel2, (int)10, (double)mediaStatus.getStreamVolume());
        zzbgo.zza((Parcel)parcel2, (int)11, (boolean)mediaStatus.isMute());
        zzbgo.zza((Parcel)parcel2, (int)12, (long[])mediaStatus.getActiveTrackIds(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)13, (int)mediaStatus.getLoadingItemId());
        zzbgo.zza((Parcel)parcel2, (int)14, (int)mediaStatus.getPreloadedItemId());
        zzbgo.zza((Parcel)parcel2, (int)15, (String)mediaStatus.zzn, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)16, (int)mediaStatus.zzp);
        zzbgo.zzc((Parcel)parcel2, (int)17, mediaStatus.zzq, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)18, (boolean)mediaStatus.isPlayingAd());
        zzbgo.zza((Parcel)parcel2, (int)19, (Parcelable)mediaStatus.getAdBreakStatus(), (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)20, (Parcelable)mediaStatus.getVideoInfo(), (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)n2);
    }

    public AdBreakInfo getCurrentAdBreak() {
        if (this.zzs == null || this.zza == null) {
            return null;
        }
        String string2 = this.zzs.getBreakId();
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        List<AdBreakInfo> list = this.zza.getAdBreaks();
        if (list == null || list.isEmpty()) {
            return null;
        }
        for (AdBreakInfo adBreakInfo : list) {
            if (!string2.equals(adBreakInfo.getId())) continue;
            return adBreakInfo;
        }
        return null;
    }

    public AdBreakClipInfo getCurrentAdBreakClip() {
        if (this.zzs == null || this.zza == null) {
            return null;
        }
        String string2 = this.zzs.getBreakClipId();
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        List<AdBreakClipInfo> list = this.zza.getAdBreakClips();
        if (list == null || list.isEmpty()) {
            return null;
        }
        for (AdBreakClipInfo adBreakClipInfo : list) {
            if (!string2.equals(adBreakClipInfo.getId())) continue;
            return adBreakClipInfo;
        }
        return null;
    }
}

