/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.cast.zzb;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.internal.zzbdw;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import java.util.Arrays;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AdBreakInfo
extends zzbgl {
    @Hide
    public static final Parcelable.Creator<AdBreakInfo> CREATOR = new zzb();
    private final long zzest;
    private final String zzbzd;
    private final long zzesk;
    private final boolean zzesu;
    private String[] zzesv;
    private final boolean zzesw;

    @Hide
    public AdBreakInfo(long l, String string, long l2, boolean bl, String[] stringArray, boolean bl2) {
        this.zzest = l;
        this.zzbzd = string;
        this.zzesk = l2;
        this.zzesu = bl;
        this.zzesv = stringArray;
        this.zzesw = bl2;
    }

    public long getPlaybackPositionInMs() {
        return this.zzest;
    }

    public String getId() {
        return this.zzbzd;
    }

    public long getDurationInMs() {
        return this.zzesk;
    }

    public boolean isWatched() {
        return this.zzesu;
    }

    public boolean isEmbedded() {
        return this.zzesw;
    }

    public String[] getBreakClipIds() {
        return this.zzesv;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        AdBreakInfo adBreakInfo = this;
        int n2 = zzbgo.zze((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)2, (long)adBreakInfo.getPlaybackPositionInMs());
        zzbgo.zza((Parcel)parcel2, (int)3, (String)adBreakInfo.getId(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)4, (long)adBreakInfo.getDurationInMs());
        zzbgo.zza((Parcel)parcel2, (int)5, (boolean)adBreakInfo.isWatched());
        zzbgo.zza((Parcel)parcel2, (int)6, (String[])adBreakInfo.getBreakClipIds(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)7, (boolean)adBreakInfo.isEmbedded());
        zzbgo.zzai((Parcel)parcel2, (int)n2);
    }

    public int hashCode() {
        return this.zzbzd.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AdBreakInfo)) {
            return false;
        }
        AdBreakInfo adBreakInfo = (AdBreakInfo)((Object)object);
        return zzbdw.zza(this.zzbzd, adBreakInfo.zzbzd) && this.zzest == adBreakInfo.zzest && this.zzesk == adBreakInfo.zzesk && this.zzesu == adBreakInfo.zzesu && Arrays.equals(this.zzesv, adBreakInfo.zzesv) && this.zzesw == adBreakInfo.zzesw;
    }

    static AdBreakInfo zzq(JSONObject jSONObject) {
        if (jSONObject == null) {
            return null;
        }
        if (!jSONObject.has("id") || !jSONObject.has("position")) {
            return null;
        }
        try {
            int n;
            String string = jSONObject.getString("id");
            long l = (long)((double)jSONObject.getLong("position") * 1000.0);
            boolean bl = jSONObject.optBoolean("isWatched");
            long l2 = (long)((double)jSONObject.optLong("duration") * 1000.0);
            JSONArray jSONArray = jSONObject.optJSONArray("breakClipIds");
            String[] stringArray = null;
            if (jSONArray != null) {
                stringArray = new String[jSONArray.length()];
                for (n = 0; n < jSONArray.length(); ++n) {
                    stringArray[n] = jSONArray.getString(n);
                }
            }
            n = jSONObject.optBoolean("isEmbedded");
            return new AdBreakInfo(l, string, l2, bl, stringArray, n != 0);
        }
        catch (JSONException jSONException) {
            Log.d((String)"AdBreakInfo", (String)String.format(Locale.ROOT, "Error while creating an AdBreakInfo from JSON: %s", jSONException.getMessage()));
            return null;
        }
    }

    @Hide
    public final JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("id", (Object)this.zzbzd);
            jSONObject.put("position", (double)this.zzest / 1000.0);
            jSONObject.put("isWatched", this.zzesu);
            jSONObject.put("isEmbedded", this.zzesw);
            jSONObject.put("duration", (double)this.zzesk / 1000.0);
            if (this.zzesv != null) {
                JSONArray jSONArray = new JSONArray();
                String[] stringArray = this.zzesv;
                int n = this.zzesv.length;
                for (int i = 0; i < n; ++i) {
                    String string = stringArray[i];
                    jSONArray.put((Object)string);
                }
                jSONObject.put("breakClipIds", (Object)jSONArray);
            }
        }
        catch (JSONException jSONException) {}
        return jSONObject;
    }

    public static class Builder {
        private long zzest = 0L;
        private String zzbzd = null;
        private long zzesk = 0L;
        private boolean zzesu = false;
        private boolean zzesw = false;
        private String[] zzesv = null;

        public Builder(long l) {
            this.zzest = l;
        }

        public Builder setId(String string) {
            this.zzbzd = string;
            return this;
        }

        public Builder setDurationInMs(long l) {
            this.zzesk = l;
            return this;
        }

        public Builder setIsWatched(boolean bl) {
            this.zzesu = bl;
            return this;
        }

        public Builder setIsEmbedded(boolean bl) {
            this.zzesw = bl;
            return this;
        }

        public Builder setBreakClipIds(String[] stringArray) {
            this.zzesv = stringArray;
            return this;
        }

        public AdBreakInfo build() {
            return new AdBreakInfo(this.zzest, this.zzbzd, this.zzesk, this.zzesu, this.zzesv, this.zzesw);
        }
    }
}

