/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.cast.zzn;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.internal.zzbdw;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class CastDevice
extends zzbgl
implements ReflectedParcelable {
    public static final int CAPABILITY_VIDEO_OUT = 1;
    public static final int CAPABILITY_VIDEO_IN = 2;
    public static final int CAPABILITY_AUDIO_OUT = 4;
    public static final int CAPABILITY_AUDIO_IN = 8;
    public static final int CAPABILITY_MULTIZONE_GROUP = 32;
    @Hide
    public static final Parcelable.Creator<CastDevice> CREATOR = new zzn();
    private String zzetq;
    private String zzetr;
    private Inet4Address zzets;
    private String zzett;
    private String zzetu;
    private String zzetv;
    private int zzetw;
    private List<WebImage> zzetx;
    private int zzety;
    private int zzcfl;
    private String zzetz;
    private String zzeua;
    private int zzeub;
    private String zzeuc;
    private byte[] zzeud;

    CastDevice(String string, String string2, String string3, String string4, String string5, int n, List<WebImage> arrayList, int n2, int n3, String string6, String string7, int n4, String string8, byte[] byArray) {
        this.zzetq = CastDevice.zzfj(string);
        this.zzetr = CastDevice.zzfj(string2);
        if (!TextUtils.isEmpty((CharSequence)this.zzetr)) {
            try {
                InetAddress inetAddress = InetAddress.getByName(this.zzetr);
                if (inetAddress instanceof Inet4Address) {
                    this.zzets = (Inet4Address)inetAddress;
                }
            }
            catch (UnknownHostException unknownHostException) {
                String string9 = this.zzetr;
                String string10 = unknownHostException.getMessage();
                Log.i((String)"CastDevice", (String)new StringBuilder(48 + String.valueOf(string9).length() + String.valueOf(string10).length()).append("Unable to convert host address (").append(string9).append(") to ipaddress: ").append(string10).toString());
            }
        }
        this.zzett = CastDevice.zzfj(string3);
        this.zzetu = CastDevice.zzfj(string4);
        this.zzetv = CastDevice.zzfj(string5);
        this.zzetw = n;
        this.zzetx = arrayList != null ? arrayList : new ArrayList();
        this.zzety = n2;
        this.zzcfl = n3;
        this.zzetz = CastDevice.zzfj(string6);
        this.zzeua = string7;
        this.zzeub = n4;
        this.zzeuc = string8;
        this.zzeud = byArray;
    }

    public String getDeviceId() {
        if (this.zzetq.startsWith("__cast_nearby__")) {
            return this.zzetq.substring(16);
        }
        return this.zzetq;
    }

    public Inet4Address getIpAddress() {
        return this.zzets;
    }

    public String getFriendlyName() {
        return this.zzett;
    }

    public String getModelName() {
        return this.zzetu;
    }

    public String getDeviceVersion() {
        return this.zzetv;
    }

    public int getServicePort() {
        return this.zzetw;
    }

    public List<WebImage> getIcons() {
        return Collections.unmodifiableList(this.zzetx);
    }

    public WebImage getIcon(int n, int n2) {
        if (this.zzetx.isEmpty()) {
            return null;
        }
        if (n <= 0 || n2 <= 0) {
            return this.zzetx.get(0);
        }
        WebImage webImage = null;
        WebImage webImage2 = null;
        for (WebImage webImage3 : this.zzetx) {
            int n3 = webImage3.getWidth();
            int n4 = webImage3.getHeight();
            if (n3 >= n && n4 >= n2) {
                if (webImage != null && (webImage.getWidth() <= n3 || webImage.getHeight() <= n4)) continue;
                webImage = webImage3;
                continue;
            }
            if (n3 >= n || n4 >= n2 || webImage2 != null && (webImage2.getWidth() >= n3 || webImage2.getHeight() >= n4)) continue;
            webImage2 = webImage3;
        }
        WebImage webImage4 = webImage != null ? webImage : (webImage2 != null ? webImage2 : this.zzetx.get(0));
        return webImage4;
    }

    public boolean hasIcons() {
        return !this.zzetx.isEmpty();
    }

    public boolean hasCapability(int n) {
        return (this.zzety & n) == n;
    }

    public boolean hasCapabilities(int[] nArray) {
        if (nArray == null) {
            return false;
        }
        int[] nArray2 = nArray;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray2[i];
            if (this.hasCapability(n2)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return String.format("\"%s\" (%s)", this.zzett, this.zzetq);
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        CastDevice castDevice = this;
        int n2 = zzbgo.zze((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)2, (String)castDevice.zzetq, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)3, (String)castDevice.zzetr, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)4, (String)castDevice.getFriendlyName(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)5, (String)castDevice.getModelName(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)6, (String)castDevice.getDeviceVersion(), (boolean)false);
        zzbgo.zzc((Parcel)parcel2, (int)7, (int)castDevice.getServicePort());
        zzbgo.zzc((Parcel)parcel2, (int)8, castDevice.getIcons(), (boolean)false);
        zzbgo.zzc((Parcel)parcel2, (int)9, (int)castDevice.zzety);
        zzbgo.zzc((Parcel)parcel2, (int)10, (int)castDevice.zzcfl);
        zzbgo.zza((Parcel)parcel2, (int)11, (String)castDevice.zzetz, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)12, (String)castDevice.zzeua, (boolean)false);
        zzbgo.zzc((Parcel)parcel2, (int)13, (int)castDevice.zzeub);
        zzbgo.zza((Parcel)parcel2, (int)14, (String)castDevice.zzeuc, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)15, (byte[])castDevice.zzeud, (boolean)false);
        zzbgo.zzai((Parcel)parcel2, (int)n2);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CastDevice)) {
            return false;
        }
        CastDevice castDevice = (CastDevice)((Object)object);
        if (this.zzetq == null) {
            return castDevice.zzetq == null;
        }
        return zzbdw.zza(this.zzetq, castDevice.zzetq) && zzbdw.zza(this.zzets, castDevice.zzets) && zzbdw.zza(this.zzetu, castDevice.zzetu) && zzbdw.zza(this.zzett, castDevice.zzett) && zzbdw.zza(this.zzetv, castDevice.zzetv) && this.zzetw == castDevice.zzetw && zzbdw.zza(this.zzetx, castDevice.zzetx) && this.zzety == castDevice.zzety && this.zzcfl == castDevice.zzcfl && zzbdw.zza(this.zzetz, castDevice.zzetz) && zzbdw.zza(this.zzeub, castDevice.zzeub) && zzbdw.zza(this.zzeuc, castDevice.zzeuc) && zzbdw.zza(this.zzeua, castDevice.zzeua) && zzbdw.zza(this.zzetv, castDevice.getDeviceVersion()) && this.zzetw == castDevice.getServicePort() && (this.zzeud == null && castDevice.zzeud == null || Arrays.equals(this.zzeud, castDevice.zzeud));
    }

    public boolean isSameDevice(CastDevice castDevice) {
        if (castDevice == null) {
            return false;
        }
        if (!(TextUtils.isEmpty((CharSequence)this.getDeviceId()) || this.getDeviceId().startsWith("__cast_ble__") || TextUtils.isEmpty((CharSequence)castDevice.getDeviceId()) || castDevice.getDeviceId().startsWith("__cast_ble__"))) {
            return zzbdw.zza(this.getDeviceId(), castDevice.getDeviceId());
        }
        if (!TextUtils.isEmpty((CharSequence)this.zzeuc) && !TextUtils.isEmpty((CharSequence)castDevice.zzeuc)) {
            return zzbdw.zza(this.zzeuc, castDevice.zzeuc);
        }
        return false;
    }

    public int hashCode() {
        if (this.zzetq == null) {
            return 0;
        }
        return this.zzetq.hashCode();
    }

    public void putInBundle(Bundle bundle) {
        if (bundle == null) {
            return;
        }
        bundle.putParcelable("com.google.android.gms.cast.EXTRA_CAST_DEVICE", (Parcelable)this);
    }

    public static CastDevice getFromBundle(Bundle bundle) {
        if (bundle == null) {
            return null;
        }
        bundle.setClassLoader(CastDevice.class.getClassLoader());
        return (CastDevice)bundle.getParcelable("com.google.android.gms.cast.EXTRA_CAST_DEVICE");
    }

    public boolean isOnLocalNetwork() {
        return !this.zzetq.startsWith("__cast_nearby__");
    }

    private static String zzfj(String string) {
        if (string == null) {
            return "";
        }
        return string;
    }
}

