/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.SparseArray;
import com.google.android.gms.cast.AdBreakClipInfo;
import com.google.android.gms.cast.AdBreakInfo;
import com.google.android.gms.cast.AdBreakStatus;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaQueueItem;
import com.google.android.gms.cast.VideoInfo;
import com.google.android.gms.cast.zzaj;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.util.zzq;
import com.google.android.gms.internal.zzbdw;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MediaStatus
extends zzbgl {
    public static final long COMMAND_PAUSE = 1L;
    public static final long COMMAND_SEEK = 2L;
    public static final long COMMAND_SET_VOLUME = 4L;
    public static final long COMMAND_TOGGLE_MUTE = 8L;
    public static final long COMMAND_SKIP_FORWARD = 16L;
    public static final long COMMAND_SKIP_BACKWARD = 32L;
    public static final int PLAYER_STATE_UNKNOWN = 0;
    public static final int PLAYER_STATE_IDLE = 1;
    public static final int PLAYER_STATE_PLAYING = 2;
    public static final int PLAYER_STATE_PAUSED = 3;
    public static final int PLAYER_STATE_BUFFERING = 4;
    public static final int IDLE_REASON_NONE = 0;
    public static final int IDLE_REASON_FINISHED = 1;
    public static final int IDLE_REASON_CANCELED = 2;
    public static final int IDLE_REASON_INTERRUPTED = 3;
    public static final int IDLE_REASON_ERROR = 4;
    public static final int REPEAT_MODE_REPEAT_OFF = 0;
    public static final int REPEAT_MODE_REPEAT_ALL = 1;
    public static final int REPEAT_MODE_REPEAT_SINGLE = 2;
    public static final int REPEAT_MODE_REPEAT_ALL_AND_SHUFFLE = 3;
    @Hide
    public static final Parcelable.Creator<MediaStatus> CREATOR = new zzaj();
    private MediaInfo zzewh;
    private long zzexb;
    private int zzexc;
    private double zzewk;
    private int zzexd;
    private int zzexe;
    private long zzexf;
    private long zzexg;
    private double zzexh;
    private boolean zzexi;
    private long[] zzewl;
    private int zzexj;
    private int zzexk;
    private String zzesn;
    private JSONObject zzess;
    private int zzexl;
    private ArrayList<MediaQueueItem> zzexm = new ArrayList();
    private boolean zzexn;
    private AdBreakStatus zzexo;
    private VideoInfo zzexp;
    private final SparseArray<Integer> zzexq = new SparseArray();

    MediaStatus(MediaInfo mediaInfo, long l, int n, double d, int n2, int n3, long l2, long l3, double d2, boolean bl, long[] lArray, int n4, int n5, String string2, int n6, List<MediaQueueItem> list, boolean bl2, AdBreakStatus adBreakStatus, VideoInfo videoInfo) {
        this.zzewh = mediaInfo;
        this.zzexb = l;
        this.zzexc = n;
        this.zzewk = d;
        this.zzexd = n2;
        this.zzexe = n3;
        this.zzexf = l2;
        this.zzexg = l3;
        this.zzexh = d2;
        this.zzexi = bl;
        this.zzewl = lArray;
        this.zzexj = n4;
        this.zzexk = n5;
        this.zzesn = string2;
        if (this.zzesn != null) {
            try {
                this.zzess = new JSONObject(this.zzesn);
            }
            catch (JSONException jSONException) {
                this.zzess = null;
                this.zzesn = null;
            }
        } else {
            this.zzess = null;
        }
        this.zzexl = n6;
        if (list != null && !list.isEmpty()) {
            this.zza(list.toArray(new MediaQueueItem[list.size()]));
        }
        this.zzexn = bl2;
        this.zzexo = adBreakStatus;
        this.zzexp = videoInfo;
    }

    @Hide
    public MediaStatus(JSONObject jSONObject) throws JSONException {
        this(null, 0L, 0, 0.0, 0, 0, 0L, 0L, 0.0, false, null, 0, 0, null, 0, null, false, null, null);
        this.zza(jSONObject, 0);
    }

    @Hide
    public final long zzadv() {
        return this.zzexb;
    }

    public int getPlayerState() {
        return this.zzexd;
    }

    public int getIdleReason() {
        return this.zzexe;
    }

    public double getPlaybackRate() {
        return this.zzewk;
    }

    public MediaInfo getMediaInfo() {
        return this.zzewh;
    }

    public long getStreamPosition() {
        return this.zzexf;
    }

    public boolean isMediaCommandSupported(long l) {
        return (this.zzexg & l) != 0L;
    }

    public double getStreamVolume() {
        return this.zzexh;
    }

    public boolean isMute() {
        return this.zzexi;
    }

    public long[] getActiveTrackIds() {
        return this.zzewl;
    }

    public JSONObject getCustomData() {
        return this.zzess;
    }

    public int getCurrentItemId() {
        return this.zzexc;
    }

    public int getLoadingItemId() {
        return this.zzexj;
    }

    public int getPreloadedItemId() {
        return this.zzexk;
    }

    public int getQueueRepeatMode() {
        return this.zzexl;
    }

    public List<MediaQueueItem> getQueueItems() {
        return this.zzexm;
    }

    public int getQueueItemCount() {
        return this.zzexm.size();
    }

    public MediaQueueItem getQueueItemById(int n) {
        return this.getItemById(n);
    }

    public MediaQueueItem getQueueItem(int n) {
        return this.getItemByIndex(n);
    }

    public boolean isPlayingAd() {
        return this.zzexn;
    }

    @Hide
    public final void zzbb(boolean bl) {
        this.zzexn = bl;
    }

    public AdBreakStatus getAdBreakStatus() {
        return this.zzexo;
    }

    public VideoInfo getVideoInfo() {
        return this.zzexp;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Hide
    public final int zza(JSONObject jSONObject, int n) throws JSONException {
        int n2;
        block75: {
            int n3;
            block73: {
                MediaQueueItem[] mediaQueueItemArray;
                int n4;
                JSONArray jSONArray;
                String string2;
                MediaStatus mediaStatus;
                block74: {
                    block72: {
                        int n5;
                        boolean bl;
                        int n6;
                        block71: {
                            int n7;
                            block70: {
                                int n8;
                                int n9;
                                int n10;
                                int n11;
                                long[] lArray;
                                boolean bl2;
                                block69: {
                                    block67: {
                                        int n12;
                                        block68: {
                                            block65: {
                                                block66: {
                                                    long l;
                                                    long l2;
                                                    double d;
                                                    n2 = 0;
                                                    long l3 = jSONObject.getLong("mediaSessionId");
                                                    if (l3 != this.zzexb) {
                                                        this.zzexb = l3;
                                                        n2 = 1;
                                                    }
                                                    if (jSONObject.has("playerState")) {
                                                        int n13 = 0;
                                                        String string3 = jSONObject.getString("playerState");
                                                        if (string3.equals("IDLE")) {
                                                            n13 = 1;
                                                        } else if (string3.equals("PLAYING")) {
                                                            n13 = 2;
                                                        } else if (string3.equals("PAUSED")) {
                                                            n13 = 3;
                                                        } else if (string3.equals("BUFFERING")) {
                                                            n13 = 4;
                                                        }
                                                        if (n13 != this.zzexd) {
                                                            this.zzexd = n13;
                                                            n2 |= 2;
                                                        }
                                                        if (n13 == 1 && jSONObject.has("idleReason")) {
                                                            int n14 = 0;
                                                            string3 = jSONObject.getString("idleReason");
                                                            if (string3.equals("CANCELLED")) {
                                                                n14 = 2;
                                                            } else if (string3.equals("INTERRUPTED")) {
                                                                n14 = 3;
                                                            } else if (string3.equals("FINISHED")) {
                                                                n14 = 1;
                                                            } else if (string3.equals("ERROR")) {
                                                                n14 = 4;
                                                            }
                                                            if (n14 != this.zzexe) {
                                                                this.zzexe = n14;
                                                                n2 |= 2;
                                                            }
                                                        }
                                                    }
                                                    if (jSONObject.has("playbackRate") && this.zzewk != (d = jSONObject.getDouble("playbackRate"))) {
                                                        this.zzewk = d;
                                                        n2 |= 2;
                                                    }
                                                    if (jSONObject.has("currentTime") && (n & 2) == 0 && (l2 = (long)(jSONObject.getDouble("currentTime") * 1000.0)) != this.zzexf) {
                                                        this.zzexf = l2;
                                                        n2 |= 2;
                                                    }
                                                    if (jSONObject.has("supportedMediaCommands") && (l = jSONObject.getLong("supportedMediaCommands")) != this.zzexg) {
                                                        this.zzexg = l;
                                                        n2 |= 2;
                                                    }
                                                    if (jSONObject.has("volume") && (n & 1) == 0) {
                                                        JSONObject jSONObject2 = jSONObject.getJSONObject("volume");
                                                        double d2 = jSONObject2.getDouble("level");
                                                        if (d2 != this.zzexh) {
                                                            this.zzexh = d2;
                                                            n2 |= 2;
                                                        }
                                                        boolean bl3 = jSONObject2.getBoolean("muted");
                                                        n12 = bl3 ? 1 : 0;
                                                        if (bl3 != this.zzexi) {
                                                            this.zzexi = n12;
                                                            n2 |= 2;
                                                        }
                                                    }
                                                    bl2 = false;
                                                    lArray = null;
                                                    if (!jSONObject.has("activeTrackIds")) break block65;
                                                    JSONArray jSONArray2 = jSONObject.getJSONArray("activeTrackIds");
                                                    n12 = jSONArray2.length();
                                                    lArray = new long[n12];
                                                    for (n11 = 0; n11 < n12; ++n11) {
                                                        lArray[n11] = jSONArray2.getLong(n11);
                                                    }
                                                    if (this.zzewl != null) break block66;
                                                    bl2 = true;
                                                    break block67;
                                                }
                                                if (this.zzewl.length == n12) break block68;
                                                bl2 = true;
                                                break block67;
                                            }
                                            if (this.zzewl != null) {
                                                bl2 = true;
                                            }
                                            break block69;
                                        }
                                        for (n11 = 0; n11 < n12; ++n11) {
                                            if (this.zzewl[n11] == lArray[n11]) continue;
                                            bl2 = true;
                                            break;
                                        }
                                    }
                                    if (bl2) {
                                        this.zzewl = lArray;
                                    }
                                }
                                if (bl2) {
                                    this.zzewl = lArray;
                                    n2 |= 2;
                                }
                                if (jSONObject.has("customData")) {
                                    this.zzess = jSONObject.getJSONObject("customData");
                                    this.zzesn = null;
                                    n2 |= 2;
                                }
                                if (jSONObject.has("media")) {
                                    JSONObject jSONObject3 = jSONObject.getJSONObject("media");
                                    MediaInfo mediaInfo = new MediaInfo(jSONObject3);
                                    if (this.zzewh == null || this.zzewh != null && !this.zzewh.equals((Object)mediaInfo)) {
                                        this.zzewh = mediaInfo;
                                        n2 |= 2;
                                    }
                                    if (jSONObject3.has("metadata")) {
                                        n2 |= 4;
                                    }
                                }
                                if (jSONObject.has("currentItemId") && this.zzexc != (n10 = jSONObject.getInt("currentItemId"))) {
                                    this.zzexc = n10;
                                    n2 |= 2;
                                }
                                if (this.zzexk != (n9 = jSONObject.optInt("preloadedItemId", 0))) {
                                    this.zzexk = n9;
                                    n2 |= 0x10;
                                }
                                if (this.zzexj != (n8 = jSONObject.optInt("loadingItemId", 0))) {
                                    this.zzexj = n8;
                                    n2 |= 2;
                                }
                                n6 = n11 = this.zzewh == null ? -1 : this.zzewh.getStreamType();
                                n3 = this.zzexj;
                                n7 = this.zzexe;
                                if (this.zzexd == 1) break block70;
                                bl = false;
                                break block71;
                            }
                            switch (n7) {
                                case 1: 
                                case 3: {
                                    if (n3 == 0) break;
                                    bl = false;
                                    break block71;
                                }
                                case 2: {
                                    if (n6 != 2) break;
                                    bl = false;
                                    break block71;
                                }
                            }
                            bl = true;
                        }
                        if (bl) break block72;
                        JSONObject jSONObject4 = jSONObject;
                        mediaStatus = this;
                        n3 = 0;
                        if (jSONObject4.has("repeatMode")) {
                            n6 = mediaStatus.zzexl;
                            string2 = jSONObject4.getString("repeatMode");
                            n5 = -1;
                            switch (string2.hashCode()) {
                                case 1645952171: {
                                    if (!string2.equals("REPEAT_OFF")) break;
                                    n5 = 0;
                                    break;
                                }
                                case 1645938909: {
                                    if (!string2.equals("REPEAT_ALL")) break;
                                    n5 = 1;
                                    break;
                                }
                                case -962896020: {
                                    if (!string2.equals("REPEAT_SINGLE")) break;
                                    n5 = 2;
                                    break;
                                }
                                case -1118317585: {
                                    if (!string2.equals("REPEAT_ALL_AND_SHUFFLE")) break;
                                    n5 = 3;
                                    break;
                                }
                            }
                            switch (n5) {
                                case 0: {
                                    n6 = 0;
                                    break;
                                }
                                case 1: {
                                    n6 = 1;
                                    break;
                                }
                                case 2: {
                                    n6 = 2;
                                    break;
                                }
                                case 3: {
                                    n6 = 3;
                                    break;
                                }
                            }
                            if (mediaStatus.zzexl != n6) {
                                mediaStatus.zzexl = n6;
                                n3 = 1;
                            }
                        }
                        if (!jSONObject4.has("items")) break block73;
                        jSONArray = jSONObject4.getJSONArray("items");
                        n4 = jSONArray.length();
                        string2 = new SparseArray();
                        for (n5 = 0; n5 < n4; ++n5) {
                            string2.put(n5, (Object)jSONArray.getJSONObject(n5).getInt("itemId"));
                        }
                        mediaQueueItemArray = new MediaQueueItem[n4];
                        break block74;
                    }
                    this.zzexc = 0;
                    this.zzexj = 0;
                    this.zzexk = 0;
                    if (!this.zzexm.isEmpty()) {
                        MediaStatus mediaStatus2 = this;
                        this.zzexl = 0;
                        mediaStatus2.zzexm.clear();
                        mediaStatus2.zzexq.clear();
                        n2 |= 8;
                    }
                    break block75;
                }
                for (int i = 0; i < n4; ++i) {
                    Integer n15 = (Integer)string2.get(i);
                    JSONObject jSONObject5 = jSONArray.getJSONObject(i);
                    MediaQueueItem mediaQueueItem = mediaStatus.getItemById(n15);
                    if (mediaQueueItem != null) {
                        n3 |= mediaQueueItem.zzu(jSONObject5);
                        mediaQueueItemArray[i] = mediaQueueItem;
                        if (i == mediaStatus.getIndexById(n15)) continue;
                        n3 = 1;
                        continue;
                    }
                    n3 = 1;
                    if (n15 == mediaStatus.zzexc && mediaStatus.zzewh != null) {
                        mediaQueueItemArray[i] = new MediaQueueItem.Builder(mediaStatus.zzewh).build();
                        mediaQueueItemArray[i].zzu(jSONObject5);
                        continue;
                    }
                    mediaQueueItemArray[i] = new MediaQueueItem(jSONObject5);
                }
                if (mediaStatus.zzexm.size() != n4) {
                    n3 = 1;
                }
                mediaStatus.zza(mediaQueueItemArray);
            }
            if (n3 != 0) {
                n2 |= 8;
            }
        }
        AdBreakStatus adBreakStatus = AdBreakStatus.zzr(jSONObject.optJSONObject("breakStatus"));
        if (this.zzexo == null && adBreakStatus != null || this.zzexo != null && !this.zzexo.equals((Object)adBreakStatus)) {
            boolean bl = adBreakStatus != null;
            this.zzexn = bl;
            this.zzexo = adBreakStatus;
            n2 |= 0x20;
        }
        VideoInfo videoInfo = VideoInfo.zzv(jSONObject.optJSONObject("videoInfo"));
        if (this.zzexp == null && videoInfo != null || this.zzexp != null && !this.zzexp.equals((Object)videoInfo)) {
            this.zzexp = videoInfo;
            n2 |= 0x40;
        }
        if (jSONObject.has("breakInfo") && this.zzewh != null) {
            this.zzewh.zzs(jSONObject.getJSONObject("breakInfo"));
            n2 |= 2;
        }
        return n2;
    }

    public MediaQueueItem getItemById(int n) {
        Integer n2 = (Integer)this.zzexq.get(n);
        if (n2 == null) {
            return null;
        }
        return this.zzexm.get(n2);
    }

    public MediaQueueItem getItemByIndex(int n) {
        if (n < 0 || n >= this.zzexm.size()) {
            return null;
        }
        return this.zzexm.get(n);
    }

    public Integer getIndexById(int n) {
        return (Integer)this.zzexq.get(n);
    }

    private final void zza(MediaQueueItem[] mediaQueueItemArray) {
        this.zzexm.clear();
        this.zzexq.clear();
        for (int i = 0; i < mediaQueueItemArray.length; ++i) {
            MediaQueueItem mediaQueueItem = mediaQueueItemArray[i];
            this.zzexm.add(mediaQueueItem);
            this.zzexq.put(mediaQueueItem.getItemId(), (Object)i);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MediaStatus)) {
            return false;
        }
        MediaStatus mediaStatus = (MediaStatus)((Object)object);
        if (this.zzess == null != (mediaStatus.zzess == null)) {
            return false;
        }
        if (this.zzexb == mediaStatus.zzexb && this.zzexc == mediaStatus.zzexc && this.zzewk == mediaStatus.zzewk && this.zzexd == mediaStatus.zzexd && this.zzexe == mediaStatus.zzexe && this.zzexf == mediaStatus.zzexf && this.zzexh == mediaStatus.zzexh && this.zzexi == mediaStatus.zzexi && this.zzexj == mediaStatus.zzexj && this.zzexk == mediaStatus.zzexk && this.zzexl == mediaStatus.zzexl && Arrays.equals(this.zzewl, mediaStatus.zzewl) && zzbdw.zza(this.zzexg, mediaStatus.zzexg) && zzbdw.zza(this.zzexm, mediaStatus.zzexm) && zzbdw.zza(this.zzewh, mediaStatus.zzewh)) {
            MediaStatus mediaStatus2 = mediaStatus;
            MediaStatus mediaStatus3 = this;
            if ((mediaStatus3.zzess == null || mediaStatus2.zzess == null || zzq.zzc((Object)mediaStatus3.zzess, (Object)mediaStatus2.zzess)) && this.zzexn == mediaStatus.isPlayingAd()) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzewh, this.zzexb, this.zzexc, this.zzewk, this.zzexd, this.zzexe, this.zzexf, this.zzexg, this.zzexh, this.zzexi, Arrays.hashCode(this.zzewl), this.zzexj, this.zzexk, String.valueOf(this.zzess), this.zzexl, this.zzexm, this.zzexn});
    }

    public void writeToParcel(Parcel parcel, int n) {
        this.zzesn = this.zzess == null ? null : this.zzess.toString();
        Parcel parcel2 = parcel;
        MediaStatus mediaStatus = this;
        int n2 = zzbgo.zze((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)2, (Parcelable)mediaStatus.getMediaInfo(), (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)3, (long)mediaStatus.zzexb);
        zzbgo.zzc((Parcel)parcel2, (int)4, (int)mediaStatus.getCurrentItemId());
        zzbgo.zza((Parcel)parcel2, (int)5, (double)mediaStatus.getPlaybackRate());
        zzbgo.zzc((Parcel)parcel2, (int)6, (int)mediaStatus.getPlayerState());
        zzbgo.zzc((Parcel)parcel2, (int)7, (int)mediaStatus.getIdleReason());
        zzbgo.zza((Parcel)parcel2, (int)8, (long)mediaStatus.getStreamPosition());
        zzbgo.zza((Parcel)parcel2, (int)9, (long)mediaStatus.zzexg);
        zzbgo.zza((Parcel)parcel2, (int)10, (double)mediaStatus.getStreamVolume());
        zzbgo.zza((Parcel)parcel2, (int)11, (boolean)mediaStatus.isMute());
        zzbgo.zza((Parcel)parcel2, (int)12, (long[])mediaStatus.getActiveTrackIds(), (boolean)false);
        zzbgo.zzc((Parcel)parcel2, (int)13, (int)mediaStatus.getLoadingItemId());
        zzbgo.zzc((Parcel)parcel2, (int)14, (int)mediaStatus.getPreloadedItemId());
        zzbgo.zza((Parcel)parcel2, (int)15, (String)mediaStatus.zzesn, (boolean)false);
        zzbgo.zzc((Parcel)parcel2, (int)16, (int)mediaStatus.zzexl);
        zzbgo.zzc((Parcel)parcel2, (int)17, mediaStatus.zzexm, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)18, (boolean)mediaStatus.isPlayingAd());
        zzbgo.zza((Parcel)parcel2, (int)19, (Parcelable)mediaStatus.getAdBreakStatus(), (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)20, (Parcelable)mediaStatus.getVideoInfo(), (int)n, (boolean)false);
        zzbgo.zzai((Parcel)parcel2, (int)n2);
    }

    public AdBreakInfo getCurrentAdBreak() {
        if (this.zzexo == null || this.zzewh == null) {
            return null;
        }
        String string2 = this.zzexo.getBreakId();
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        List<AdBreakInfo> list = this.zzewh.getAdBreaks();
        if (list == null || list.isEmpty()) {
            return null;
        }
        for (AdBreakInfo adBreakInfo : list) {
            if (!string2.equals(adBreakInfo.getId())) continue;
            return adBreakInfo;
        }
        return null;
    }

    public AdBreakClipInfo getCurrentAdBreakClip() {
        if (this.zzexo == null || this.zzewh == null) {
            return null;
        }
        String string2 = this.zzexo.getBreakClipId();
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        List<AdBreakClipInfo> list = this.zzewh.getAdBreakClips();
        if (list == null || list.isEmpty()) {
            return null;
        }
        for (AdBreakClipInfo adBreakClipInfo : list) {
            if (!string2.equals(adBreakClipInfo.getId())) continue;
            return adBreakClipInfo;
        }
        return null;
    }
}

