/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.cast.internal.zzf;
import com.google.android.gms.cast.zzb;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CastDevice
implements SafeParcelable {
    public static final int CAPABILITY_VIDEO_OUT = 1;
    public static final int CAPABILITY_VIDEO_IN = 2;
    public static final int CAPABILITY_AUDIO_OUT = 4;
    public static final int CAPABILITY_AUDIO_IN = 8;
    public static final Parcelable.Creator<CastDevice> CREATOR = new zzb();
    private final int zzzH;
    private String zzLV;
    String zzLW;
    private Inet4Address zzLX;
    private String zzLY;
    private String zzLZ;
    private String zzMa;
    private int zzMb;
    private List<WebImage> zzMc;
    private int zzMd;
    private int zzue;

    CastDevice(int versionCode, String deviceId, String hostAddress, String friendlyName, String modelName, String deviceVersion, int servicePort, List<WebImage> icons, int capabilities, int status) {
        this.zzzH = versionCode;
        this.zzLV = deviceId;
        this.zzLW = hostAddress;
        if (this.zzLW != null) {
            try {
                InetAddress inetAddress = InetAddress.getByName(this.zzLW);
                if (inetAddress instanceof Inet4Address) {
                    this.zzLX = (Inet4Address)inetAddress;
                }
            }
            catch (UnknownHostException unknownHostException) {
                this.zzLX = null;
            }
        }
        this.zzLY = friendlyName;
        this.zzLZ = modelName;
        this.zzMa = deviceVersion;
        this.zzMb = servicePort;
        this.zzMc = icons;
        this.zzMd = capabilities;
        this.zzue = status;
    }

    private CastDevice() {
        this(3, null, null, null, null, null, -1, new ArrayList<WebImage>(), 0, -1);
    }

    int getVersionCode() {
        return this.zzzH;
    }

    public String getDeviceId() {
        return this.zzLV;
    }

    public Inet4Address getIpAddress() {
        return this.zzLX;
    }

    public String getFriendlyName() {
        return this.zzLY;
    }

    public String getModelName() {
        return this.zzLZ;
    }

    public String getDeviceVersion() {
        return this.zzMa;
    }

    public int getServicePort() {
        return this.zzMb;
    }

    public List<WebImage> getIcons() {
        return Collections.unmodifiableList(this.zzMc);
    }

    public WebImage getIcon(int preferredWidth, int preferredHeight) {
        if (this.zzMc.isEmpty()) {
            return null;
        }
        if (preferredWidth <= 0 || preferredHeight <= 0) {
            return this.zzMc.get(0);
        }
        WebImage webImage = null;
        WebImage webImage2 = null;
        for (WebImage webImage3 : this.zzMc) {
            int n = webImage3.getWidth();
            int n2 = webImage3.getHeight();
            if (n >= preferredWidth && n2 >= preferredHeight) {
                if (webImage != null && (webImage.getWidth() <= n || webImage.getHeight() <= n2)) continue;
                webImage = webImage3;
                continue;
            }
            if (n >= preferredWidth || n2 >= preferredHeight || webImage2 != null && (webImage2.getWidth() >= n || webImage2.getHeight() >= n2)) continue;
            webImage2 = webImage3;
        }
        WebImage webImage4 = webImage != null ? webImage : (webImage2 != null ? webImage2 : this.zzMc.get(0));
        return webImage4;
    }

    public boolean hasIcons() {
        return !this.zzMc.isEmpty();
    }

    public int getCapabilities() {
        return this.zzMd;
    }

    public boolean hasCapability(int capability) {
        return (this.zzMd & capability) == capability;
    }

    public boolean hasCapabilities(int[] capabilities) {
        if (capabilities == null) {
            return false;
        }
        for (int n : capabilities) {
            if (this.hasCapability(n)) continue;
            return false;
        }
        return true;
    }

    public int getStatus() {
        return this.zzue;
    }

    public String toString() {
        return String.format("\"%s\" (%s)", this.zzLY, this.zzLV);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        zzb.zza(this, out, flags);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CastDevice)) {
            return false;
        }
        CastDevice castDevice = (CastDevice)obj;
        if (this.getDeviceId() == null) {
            return castDevice.getDeviceId() == null;
        }
        return zzf.zza(this.zzLV, castDevice.zzLV) && zzf.zza(this.zzLX, castDevice.zzLX) && zzf.zza(this.zzLZ, castDevice.zzLZ) && zzf.zza(this.zzLY, castDevice.zzLY) && zzf.zza(this.zzMa, castDevice.zzMa) && this.zzMb == castDevice.zzMb && zzf.zza(this.zzMc, castDevice.zzMc) && this.zzMd == castDevice.zzMd && this.zzue == castDevice.zzue;
    }

    public boolean isSameDevice(CastDevice castDevice) {
        if (castDevice == null) {
            return false;
        }
        if (this.getDeviceId() == null) {
            return castDevice.getDeviceId() == null;
        }
        return zzf.zza(this.getDeviceId(), castDevice.getDeviceId());
    }

    public int hashCode() {
        return this.zzLV == null ? 0 : this.zzLV.hashCode();
    }

    public void putInBundle(Bundle bundle) {
        if (bundle == null) {
            return;
        }
        bundle.putParcelable("com.google.android.gms.cast.EXTRA_CAST_DEVICE", (Parcelable)this);
    }

    public static CastDevice getFromBundle(Bundle extras) {
        if (extras == null) {
            return null;
        }
        extras.setClassLoader(CastDevice.class.getClassLoader());
        return (CastDevice)extras.getParcelable("com.google.android.gms.cast.EXTRA_CAST_DEVICE");
    }

    public boolean isOnLocalNetwork() {
        return !this.zzLV.startsWith("__cast_nearby__");
    }
}

