/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.text.TextUtils;
import com.google.android.gms.cast.internal.zzf;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.internal.zzhz;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public final class MediaTrack {
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_TEXT = 1;
    public static final int TYPE_AUDIO = 2;
    public static final int TYPE_VIDEO = 3;
    public static final int SUBTYPE_UNKNOWN = -1;
    public static final int SUBTYPE_NONE = 0;
    public static final int SUBTYPE_SUBTITLES = 1;
    public static final int SUBTYPE_CAPTIONS = 2;
    public static final int SUBTYPE_DESCRIPTIONS = 3;
    public static final int SUBTYPE_CHAPTERS = 4;
    public static final int SUBTYPE_METADATA = 5;
    private long zzKv;
    private int zzMG;
    private String zzMh;
    private String zzMj;
    private String mName;
    private String zzMf;
    private int zzMH;
    private JSONObject zzMo;

    MediaTrack(JSONObject json) throws JSONException {
        this.zzf(json);
    }

    MediaTrack(long id, int type) throws IllegalArgumentException {
        this.clear();
        this.zzKv = id;
        if (type <= 0 || type > 3) {
            throw new IllegalArgumentException("invalid type " + type);
        }
        this.zzMG = type;
    }

    public long getId() {
        return this.zzKv;
    }

    public int getType() {
        return this.zzMG;
    }

    public String getContentId() {
        return this.zzMh;
    }

    public void setContentId(String contentId) {
        this.zzMh = contentId;
    }

    public String getContentType() {
        return this.zzMj;
    }

    public void setContentType(String contentType) {
        this.zzMj = contentType;
    }

    public String getName() {
        return this.mName;
    }

    void setName(String name) {
        this.mName = name;
    }

    public String getLanguage() {
        return this.zzMf;
    }

    void setLanguage(String language) {
        this.zzMf = language;
    }

    public int getSubtype() {
        return this.zzMH;
    }

    void zzaj(int n) throws IllegalArgumentException {
        if (n <= -1 || n > 5) {
            throw new IllegalArgumentException("invalid subtype " + n);
        }
        if (n != 0 && this.zzMG != 1) {
            throw new IllegalArgumentException("subtypes are only valid for text tracks");
        }
        this.zzMH = n;
    }

    public JSONObject getCustomData() {
        return this.zzMo;
    }

    void setCustomData(JSONObject customData) {
        this.zzMo = customData;
    }

    private void clear() {
        this.zzKv = 0L;
        this.zzMG = 0;
        this.zzMh = null;
        this.mName = null;
        this.zzMf = null;
        this.zzMH = -1;
        this.zzMo = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void zzf(JSONObject jSONObject) throws JSONException {
        this.clear();
        this.zzKv = jSONObject.getLong("trackId");
        String string = jSONObject.getString("type");
        if ("TEXT".equals(string)) {
            this.zzMG = 1;
        } else if ("AUDIO".equals(string)) {
            this.zzMG = 2;
        } else {
            if (!"VIDEO".equals(string)) throw new JSONException("invalid type: " + string);
            this.zzMG = 3;
        }
        this.zzMh = jSONObject.optString("trackContentId", null);
        this.zzMj = jSONObject.optString("trackContentType", null);
        this.mName = jSONObject.optString("name", null);
        this.zzMf = jSONObject.optString("language", null);
        if (jSONObject.has("subtype")) {
            string = jSONObject.getString("subtype");
            if ("SUBTITLES".equals(string)) {
                this.zzMH = 1;
            } else if ("CAPTIONS".equals(string)) {
                this.zzMH = 2;
            } else if ("DESCRIPTIONS".equals(string)) {
                this.zzMH = 3;
            } else if ("CHAPTERS".equals(string)) {
                this.zzMH = 4;
            } else {
                if (!"METADATA".equals(string)) throw new JSONException("invalid subtype: " + string);
                this.zzMH = 5;
            }
        } else {
            this.zzMH = 0;
        }
        this.zzMo = jSONObject.optJSONObject("customData");
    }

    public JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("trackId", this.zzKv);
            switch (this.zzMG) {
                case 1: {
                    jSONObject.put("type", (Object)"TEXT");
                    break;
                }
                case 2: {
                    jSONObject.put("type", (Object)"AUDIO");
                    break;
                }
                case 3: {
                    jSONObject.put("type", (Object)"VIDEO");
                    break;
                }
            }
            if (this.zzMh != null) {
                jSONObject.put("trackContentId", (Object)this.zzMh);
            }
            if (this.zzMj != null) {
                jSONObject.put("trackContentType", (Object)this.zzMj);
            }
            if (this.mName != null) {
                jSONObject.put("name", (Object)this.mName);
            }
            if (!TextUtils.isEmpty((CharSequence)this.zzMf)) {
                jSONObject.put("language", (Object)this.zzMf);
            }
            switch (this.zzMH) {
                case 1: {
                    jSONObject.put("subtype", (Object)"SUBTITLES");
                    break;
                }
                case 2: {
                    jSONObject.put("subtype", (Object)"CAPTIONS");
                    break;
                }
                case 3: {
                    jSONObject.put("subtype", (Object)"DESCRIPTIONS");
                    break;
                }
                case 4: {
                    jSONObject.put("subtype", (Object)"CHAPTERS");
                    break;
                }
                case 5: {
                    jSONObject.put("subtype", (Object)"METADATA");
                    break;
                }
            }
            if (this.zzMo != null) {
                jSONObject.put("customData", (Object)this.zzMo);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jSONObject;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MediaTrack)) {
            return false;
        }
        MediaTrack mediaTrack = (MediaTrack)other;
        if (this.zzMo == null != (mediaTrack.zzMo == null)) {
            return false;
        }
        if (this.zzMo != null && mediaTrack.zzMo != null && !zzhz.zzd((Object)this.zzMo, (Object)mediaTrack.zzMo)) {
            return false;
        }
        return this.zzKv == mediaTrack.zzKv && this.zzMG == mediaTrack.zzMG && zzf.zza(this.zzMh, mediaTrack.zzMh) && zzf.zza(this.zzMj, mediaTrack.zzMj) && zzf.zza(this.mName, mediaTrack.mName) && zzf.zza(this.zzMf, mediaTrack.zzMf) && this.zzMH == mediaTrack.zzMH;
    }

    public int hashCode() {
        return zzu.hashCode((Object[])new Object[]{this.zzKv, this.zzMG, this.zzMh, this.zzMj, this.mName, this.zzMf, this.zzMH, this.zzMo});
    }

    public static class Builder {
        private final MediaTrack zzMI;

        public Builder(long trackId, int trackType) throws IllegalArgumentException {
            this.zzMI = new MediaTrack(trackId, trackType);
        }

        public Builder setContentId(String contentId) {
            this.zzMI.setContentId(contentId);
            return this;
        }

        public Builder setContentType(String contentType) {
            this.zzMI.setContentType(contentType);
            return this;
        }

        public Builder setName(String trackName) {
            this.zzMI.setName(trackName);
            return this;
        }

        public Builder setLanguage(String language) {
            this.zzMI.setLanguage(language);
            return this;
        }

        public Builder setLanguage(Locale locale) {
            this.zzMI.setLanguage(zzf.zzb(locale));
            return this;
        }

        public Builder setSubtype(int subtype) throws IllegalArgumentException {
            this.zzMI.zzaj(subtype);
            return this;
        }

        public Builder setCustomData(JSONObject customData) {
            this.zzMI.setCustomData(customData);
            return this;
        }

        public MediaTrack build() {
            return this.zzMI;
        }
    }
}

