/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.content.Context;
import android.graphics.Color;
import android.graphics.Typeface;
import android.view.accessibility.CaptioningManager;
import com.google.android.gms.cast.internal.zzf;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.internal.zzhz;
import com.google.android.gms.internal.zzic;
import org.json.JSONException;
import org.json.JSONObject;

public final class TextTrackStyle {
    public static final float DEFAULT_FONT_SCALE = 1.0f;
    public static final int COLOR_UNSPECIFIED = 0;
    public static final int EDGE_TYPE_UNSPECIFIED = -1;
    public static final int EDGE_TYPE_NONE = 0;
    public static final int EDGE_TYPE_OUTLINE = 1;
    public static final int EDGE_TYPE_DROP_SHADOW = 2;
    public static final int EDGE_TYPE_RAISED = 3;
    public static final int EDGE_TYPE_DEPRESSED = 4;
    public static final int WINDOW_TYPE_UNSPECIFIED = -1;
    public static final int WINDOW_TYPE_NONE = 0;
    public static final int WINDOW_TYPE_NORMAL = 1;
    public static final int WINDOW_TYPE_ROUNDED = 2;
    public static final int FONT_FAMILY_UNSPECIFIED = -1;
    public static final int FONT_FAMILY_SANS_SERIF = 0;
    public static final int FONT_FAMILY_MONOSPACED_SANS_SERIF = 1;
    public static final int FONT_FAMILY_SERIF = 2;
    public static final int FONT_FAMILY_MONOSPACED_SERIF = 3;
    public static final int FONT_FAMILY_CASUAL = 4;
    public static final int FONT_FAMILY_CURSIVE = 5;
    public static final int FONT_FAMILY_SMALL_CAPITALS = 6;
    public static final int FONT_STYLE_UNSPECIFIED = -1;
    public static final int FONT_STYLE_NORMAL = 0;
    public static final int FONT_STYLE_BOLD = 1;
    public static final int FONT_STYLE_ITALIC = 2;
    public static final int FONT_STYLE_BOLD_ITALIC = 3;
    private float zzNg;
    private int zzNh;
    private int zzsC;
    private int zzNi;
    private int zzNj;
    private int zzNk;
    private int zzNl;
    private int zzNm;
    private String zzNn;
    private int zzNo;
    private int zzNp;
    private JSONObject zzMo;

    public TextTrackStyle() {
        this.clear();
    }

    public void setFontScale(float fontScale) {
        this.zzNg = fontScale;
    }

    public float getFontScale() {
        return this.zzNg;
    }

    public void setForegroundColor(int foregroundColor) {
        this.zzNh = foregroundColor;
    }

    public int getForegroundColor() {
        return this.zzNh;
    }

    public void setBackgroundColor(int backgroundColor) {
        this.zzsC = backgroundColor;
    }

    public int getBackgroundColor() {
        return this.zzsC;
    }

    public void setEdgeType(int edgeType) {
        if (edgeType < 0 || edgeType > 4) {
            throw new IllegalArgumentException("invalid edgeType");
        }
        this.zzNi = edgeType;
    }

    public int getEdgeType() {
        return this.zzNi;
    }

    public void setEdgeColor(int edgeColor) {
        this.zzNj = edgeColor;
    }

    public int getEdgeColor() {
        return this.zzNj;
    }

    public void setWindowType(int windowType) {
        if (windowType < 0 || windowType > 2) {
            throw new IllegalArgumentException("invalid windowType");
        }
        this.zzNk = windowType;
    }

    public int getWindowType() {
        return this.zzNk;
    }

    public void setWindowColor(int windowColor) {
        this.zzNl = windowColor;
    }

    public int getWindowColor() {
        return this.zzNl;
    }

    public void setWindowCornerRadius(int windowCornerRadius) {
        if (windowCornerRadius < 0) {
            throw new IllegalArgumentException("invalid windowCornerRadius");
        }
        this.zzNm = windowCornerRadius;
    }

    public int getWindowCornerRadius() {
        return this.zzNm;
    }

    public void setFontFamily(String fontFamily) {
        this.zzNn = fontFamily;
    }

    public String getFontFamily() {
        return this.zzNn;
    }

    public void setFontGenericFamily(int fontGenericFamily) {
        if (fontGenericFamily < 0 || fontGenericFamily > 6) {
            throw new IllegalArgumentException("invalid fontGenericFamily");
        }
        this.zzNo = fontGenericFamily;
    }

    public int getFontGenericFamily() {
        return this.zzNo;
    }

    public void setFontStyle(int fontStyle) {
        if (fontStyle < 0 || fontStyle > 3) {
            throw new IllegalArgumentException("invalid fontStyle");
        }
        this.zzNp = fontStyle;
    }

    public int getFontStyle() {
        return this.zzNp;
    }

    public void setCustomData(JSONObject customData) {
        this.zzMo = customData;
    }

    public JSONObject getCustomData() {
        return this.zzMo;
    }

    private void clear() {
        this.zzNg = 1.0f;
        this.zzNh = 0;
        this.zzsC = 0;
        this.zzNi = -1;
        this.zzNj = 0;
        this.zzNk = -1;
        this.zzNl = 0;
        this.zzNm = 0;
        this.zzNn = null;
        this.zzNo = -1;
        this.zzNp = -1;
        this.zzMo = null;
    }

    public static TextTrackStyle fromSystemSettings(Context context) {
        TextTrackStyle textTrackStyle = new TextTrackStyle();
        if (!zzic.zznk()) {
            return textTrackStyle;
        }
        CaptioningManager captioningManager = (CaptioningManager)context.getSystemService("captioning");
        textTrackStyle.setFontScale(captioningManager.getFontScale());
        CaptioningManager.CaptionStyle captionStyle = captioningManager.getUserStyle();
        textTrackStyle.setBackgroundColor(captionStyle.backgroundColor);
        textTrackStyle.setForegroundColor(captionStyle.foregroundColor);
        switch (captionStyle.edgeType) {
            case 1: {
                textTrackStyle.setEdgeType(1);
                break;
            }
            case 2: {
                textTrackStyle.setEdgeType(2);
                break;
            }
            default: {
                textTrackStyle.setEdgeType(0);
            }
        }
        textTrackStyle.setEdgeColor(captionStyle.edgeColor);
        Typeface typeface = captionStyle.getTypeface();
        if (typeface != null) {
            if (Typeface.MONOSPACE.equals((Object)typeface)) {
                textTrackStyle.setFontGenericFamily(1);
            } else if (Typeface.SANS_SERIF.equals((Object)typeface)) {
                textTrackStyle.setFontGenericFamily(0);
            } else if (Typeface.SERIF.equals((Object)typeface)) {
                textTrackStyle.setFontGenericFamily(2);
            } else {
                textTrackStyle.setFontGenericFamily(0);
            }
            boolean bl = typeface.isBold();
            boolean bl2 = typeface.isItalic();
            if (bl && bl2) {
                textTrackStyle.setFontStyle(3);
            } else if (bl) {
                textTrackStyle.setFontStyle(1);
            } else if (bl2) {
                textTrackStyle.setFontStyle(2);
            } else {
                textTrackStyle.setFontStyle(0);
            }
        }
        return textTrackStyle;
    }

    public void zzf(JSONObject jSONObject) throws JSONException {
        String string;
        this.clear();
        this.zzNg = (float)jSONObject.optDouble("fontScale", 1.0);
        this.zzNh = this.zzbl(jSONObject.optString("foregroundColor"));
        this.zzsC = this.zzbl(jSONObject.optString("backgroundColor"));
        if (jSONObject.has("edgeType")) {
            string = jSONObject.getString("edgeType");
            if ("NONE".equals(string)) {
                this.zzNi = 0;
            } else if ("OUTLINE".equals(string)) {
                this.zzNi = 1;
            } else if ("DROP_SHADOW".equals(string)) {
                this.zzNi = 2;
            } else if ("RAISED".equals(string)) {
                this.zzNi = 3;
            } else if ("DEPRESSED".equals(string)) {
                this.zzNi = 4;
            }
        }
        this.zzNj = this.zzbl(jSONObject.optString("edgeColor"));
        if (jSONObject.has("windowType")) {
            string = jSONObject.getString("windowType");
            if ("NONE".equals(string)) {
                this.zzNk = 0;
            } else if ("NORMAL".equals(string)) {
                this.zzNk = 1;
            } else if ("ROUNDED_CORNERS".equals(string)) {
                this.zzNk = 2;
            }
        }
        this.zzNl = this.zzbl(jSONObject.optString("windowColor"));
        if (this.zzNk == 2) {
            this.zzNm = jSONObject.optInt("windowRoundedCornerRadius", 0);
        }
        this.zzNn = jSONObject.optString("fontFamily", null);
        if (jSONObject.has("fontGenericFamily")) {
            string = jSONObject.getString("fontGenericFamily");
            if ("SANS_SERIF".equals(string)) {
                this.zzNo = 0;
            } else if ("MONOSPACED_SANS_SERIF".equals(string)) {
                this.zzNo = 1;
            } else if ("SERIF".equals(string)) {
                this.zzNo = 2;
            } else if ("MONOSPACED_SERIF".equals(string)) {
                this.zzNo = 3;
            } else if ("CASUAL".equals(string)) {
                this.zzNo = 4;
            } else if ("CURSIVE".equals(string)) {
                this.zzNo = 5;
            } else if ("SMALL_CAPITALS".equals(string)) {
                this.zzNo = 6;
            }
        }
        if (jSONObject.has("fontStyle")) {
            string = jSONObject.getString("fontStyle");
            if ("NORMAL".equals(string)) {
                this.zzNp = 0;
            } else if ("BOLD".equals(string)) {
                this.zzNp = 1;
            } else if ("ITALIC".equals(string)) {
                this.zzNp = 2;
            } else if ("BOLD_ITALIC".equals(string)) {
                this.zzNp = 3;
            }
        }
        this.zzMo = jSONObject.optJSONObject("customData");
    }

    public JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("fontScale", (double)this.zzNg);
            if (this.zzNh != 0) {
                jSONObject.put("foregroundColor", (Object)this.zzA(this.zzNh));
            }
            if (this.zzsC != 0) {
                jSONObject.put("backgroundColor", (Object)this.zzA(this.zzsC));
            }
            switch (this.zzNi) {
                case 0: {
                    jSONObject.put("edgeType", (Object)"NONE");
                    break;
                }
                case 1: {
                    jSONObject.put("edgeType", (Object)"OUTLINE");
                    break;
                }
                case 2: {
                    jSONObject.put("edgeType", (Object)"DROP_SHADOW");
                    break;
                }
                case 3: {
                    jSONObject.put("edgeType", (Object)"RAISED");
                    break;
                }
                case 4: {
                    jSONObject.put("edgeType", (Object)"DEPRESSED");
                    break;
                }
            }
            if (this.zzNj != 0) {
                jSONObject.put("edgeColor", (Object)this.zzA(this.zzNj));
            }
            switch (this.zzNk) {
                case 0: {
                    jSONObject.put("windowType", (Object)"NONE");
                    break;
                }
                case 1: {
                    jSONObject.put("windowType", (Object)"NORMAL");
                    break;
                }
                case 2: {
                    jSONObject.put("windowType", (Object)"ROUNDED_CORNERS");
                    break;
                }
            }
            if (this.zzNl != 0) {
                jSONObject.put("windowColor", (Object)this.zzA(this.zzNl));
            }
            if (this.zzNk == 2) {
                jSONObject.put("windowRoundedCornerRadius", this.zzNm);
            }
            if (this.zzNn != null) {
                jSONObject.put("fontFamily", (Object)this.zzNn);
            }
            switch (this.zzNo) {
                case 0: {
                    jSONObject.put("fontGenericFamily", (Object)"SANS_SERIF");
                    break;
                }
                case 1: {
                    jSONObject.put("fontGenericFamily", (Object)"MONOSPACED_SANS_SERIF");
                    break;
                }
                case 2: {
                    jSONObject.put("fontGenericFamily", (Object)"SERIF");
                    break;
                }
                case 3: {
                    jSONObject.put("fontGenericFamily", (Object)"MONOSPACED_SERIF");
                    break;
                }
                case 4: {
                    jSONObject.put("fontGenericFamily", (Object)"CASUAL");
                    break;
                }
                case 5: {
                    jSONObject.put("fontGenericFamily", (Object)"CURSIVE");
                    break;
                }
                case 6: {
                    jSONObject.put("fontGenericFamily", (Object)"SMALL_CAPITALS");
                    break;
                }
            }
            switch (this.zzNp) {
                case 0: {
                    jSONObject.put("fontStyle", (Object)"NORMAL");
                    break;
                }
                case 1: {
                    jSONObject.put("fontStyle", (Object)"BOLD");
                    break;
                }
                case 2: {
                    jSONObject.put("fontStyle", (Object)"ITALIC");
                    break;
                }
                case 3: {
                    jSONObject.put("fontStyle", (Object)"BOLD_ITALIC");
                    break;
                }
            }
            if (this.zzMo != null) {
                jSONObject.put("customData", (Object)this.zzMo);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jSONObject;
    }

    private String zzA(int n) {
        return String.format("#%02X%02X%02X%02X", Color.red((int)n), Color.green((int)n), Color.blue((int)n), Color.alpha((int)n));
    }

    private int zzbl(String string) {
        if (string != null && string.length() == 9 && string.charAt(0) == '#') {
            try {
                int n = Integer.parseInt(string.substring(1, 3), 16);
                int n2 = Integer.parseInt(string.substring(3, 5), 16);
                int n3 = Integer.parseInt(string.substring(5, 7), 16);
                int n4 = Integer.parseInt(string.substring(7, 9), 16);
                return Color.argb((int)n4, (int)n, (int)n2, (int)n3);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TextTrackStyle)) {
            return false;
        }
        TextTrackStyle textTrackStyle = (TextTrackStyle)other;
        if (this.zzMo == null != (textTrackStyle.zzMo == null)) {
            return false;
        }
        if (this.zzMo != null && textTrackStyle.zzMo != null && !zzhz.zzd((Object)this.zzMo, (Object)textTrackStyle.zzMo)) {
            return false;
        }
        return this.zzNg == textTrackStyle.zzNg && this.zzNh == textTrackStyle.zzNh && this.zzsC == textTrackStyle.zzsC && this.zzNi == textTrackStyle.zzNi && this.zzNj == textTrackStyle.zzNj && this.zzNk == textTrackStyle.zzNk && this.zzNm == textTrackStyle.zzNm && zzf.zza(this.zzNn, textTrackStyle.zzNn) && this.zzNo == textTrackStyle.zzNo && this.zzNp == textTrackStyle.zzNp;
    }

    public int hashCode() {
        return zzu.hashCode((Object[])new Object[]{Float.valueOf(this.zzNg), this.zzNh, this.zzsC, this.zzNi, this.zzNj, this.zzNk, this.zzNl, this.zzNm, this.zzNn, this.zzNo, this.zzNp, this.zzMo});
    }
}

