/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.cast.internal.zzf;
import com.google.android.gms.cast.zza;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import java.util.ArrayList;
import java.util.List;

public final class ApplicationMetadata
implements SafeParcelable {
    public static final Parcelable.Creator<ApplicationMetadata> CREATOR = new zza();
    private final int mVersionCode;
    String zzUM;
    String mName;
    List<WebImage> zzwp;
    List<String> zzUN;
    String zzUO;
    Uri zzUP;

    ApplicationMetadata(int versionCode, String applicationId, String name, List<WebImage> images, List<String> namespaces, String senderAppIdentifier, Uri senderAppLaunchUrl) {
        this.mVersionCode = versionCode;
        this.zzUM = applicationId;
        this.mName = name;
        this.zzwp = images;
        this.zzUN = namespaces;
        this.zzUO = senderAppIdentifier;
        this.zzUP = senderAppLaunchUrl;
    }

    private ApplicationMetadata() {
        this.mVersionCode = 1;
        this.zzwp = new ArrayList<WebImage>();
        this.zzUN = new ArrayList<String>();
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public String getApplicationId() {
        return this.zzUM;
    }

    public String getName() {
        return this.mName;
    }

    public boolean isNamespaceSupported(String namespace) {
        return this.zzUN != null && this.zzUN.contains(namespace);
    }

    public boolean areNamespacesSupported(List<String> namespaces) {
        return this.zzUN != null && this.zzUN.containsAll(namespaces);
    }

    public String getSenderAppIdentifier() {
        return this.zzUO;
    }

    public Uri zzmj() {
        return this.zzUP;
    }

    public List<WebImage> getImages() {
        return this.zzwp;
    }

    public String toString() {
        return "applicationId: " + this.zzUM + ", name: " + this.mName + ", images.count: " + (this.zzwp == null ? 0 : this.zzwp.size()) + ", namespaces.count: " + (this.zzUN == null ? 0 : this.zzUN.size()) + ", senderAppIdentifier: " + this.zzUO + ", senderAppLaunchUrl: " + this.zzUP;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        zza.zza(this, out, flags);
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.mVersionCode, this.zzUM, this.mName, this.zzwp, this.zzUN, this.zzUO, this.zzUP});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ApplicationMetadata)) {
            return false;
        }
        ApplicationMetadata applicationMetadata = (ApplicationMetadata)obj;
        return zzf.zza(this.zzUM, applicationMetadata.zzUM) && zzf.zza(this.zzwp, applicationMetadata.zzwp) && zzf.zza(this.mName, applicationMetadata.mName) && zzf.zza(this.zzUN, applicationMetadata.zzUN) && zzf.zza(this.zzUO, applicationMetadata.zzUO) && zzf.zza(this.zzUP, applicationMetadata.zzUP);
    }
}

