/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.games;

import com.google.android.gms.cast.Cast;
import com.google.android.gms.cast.games.GameManagerState;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.internal.zzko;
import org.json.JSONObject;

public final class GameManagerClient {
    public static final int STATUS_INCORRECT_VERSION = 2150;
    public static final int STATUS_TOO_MANY_PLAYERS = 2151;
    public static final int PLAYER_STATE_UNKNOWN = 0;
    public static final int PLAYER_STATE_DROPPED = 1;
    public static final int PLAYER_STATE_QUIT = 2;
    public static final int PLAYER_STATE_AVAILABLE = 3;
    public static final int PLAYER_STATE_READY = 4;
    public static final int PLAYER_STATE_IDLE = 5;
    public static final int PLAYER_STATE_PLAYING = 6;
    public static final int LOBBY_STATE_UNKNOWN = 0;
    public static final int LOBBY_STATE_OPEN = 1;
    public static final int LOBBY_STATE_CLOSED = 2;
    public static final int GAMEPLAY_STATE_UNKNOWN = 0;
    public static final int GAMEPLAY_STATE_LOADING = 1;
    public static final int GAMEPLAY_STATE_RUNNING = 2;
    public static final int GAMEPLAY_STATE_PAUSED = 3;
    public static final int GAMEPLAY_STATE_SHOWING_INFO_SCREEN = 4;
    private final zzko zzXG;

    public GameManagerClient(zzko channel) {
        this.zzXG = channel;
    }

    public static PendingResult<GameManagerInstanceResult> getInstanceFor(GoogleApiClient googleApiClient, String castSessionId) throws IllegalArgumentException {
        zzko zzko2 = new zzko(googleApiClient, castSessionId, Cast.CastApi);
        return GameManagerClient.zza(zzko2);
    }

    static PendingResult<GameManagerInstanceResult> zza(zzko zzko2) throws IllegalArgumentException {
        GameManagerClient gameManagerClient = new GameManagerClient(zzko2);
        return zzko2.zza(gameManagerClient);
    }

    public PendingResult<GameManagerResult> sendPlayerAvailableRequest(JSONObject extraMessageData) throws IllegalStateException {
        return this.zza(this.getLastUsedPlayerId(), 3, extraMessageData);
    }

    public PendingResult<GameManagerResult> sendPlayerAvailableRequest(String playerId, JSONObject extraMessageData) throws IllegalStateException {
        return this.zza(playerId, 3, extraMessageData);
    }

    public PendingResult<GameManagerResult> sendPlayerReadyRequest(JSONObject extraMessageData) throws IllegalStateException {
        return this.zza(this.getLastUsedPlayerId(), 4, extraMessageData);
    }

    public PendingResult<GameManagerResult> sendPlayerReadyRequest(String playerId, JSONObject extraMessageData) throws IllegalStateException {
        return this.zza(playerId, 4, extraMessageData);
    }

    public PendingResult<GameManagerResult> sendPlayerPlayingRequest(JSONObject extraMessageData) throws IllegalStateException {
        return this.zza(this.getLastUsedPlayerId(), 6, extraMessageData);
    }

    public PendingResult<GameManagerResult> sendPlayerPlayingRequest(String playerId, JSONObject extraMessageData) throws IllegalStateException {
        return this.zza(playerId, 6, extraMessageData);
    }

    public PendingResult<GameManagerResult> sendPlayerIdleRequest(JSONObject extraMessageData) throws IllegalStateException {
        return this.zza(this.getLastUsedPlayerId(), 5, extraMessageData);
    }

    public PendingResult<GameManagerResult> sendPlayerIdleRequest(String playerId, JSONObject extraMessageData) throws IllegalStateException {
        return this.zza(playerId, 5, extraMessageData);
    }

    public PendingResult<GameManagerResult> sendPlayerQuitRequest(JSONObject extraMessageData) throws IllegalStateException {
        return this.zza(this.getLastUsedPlayerId(), 2, extraMessageData);
    }

    public PendingResult<GameManagerResult> sendPlayerQuitRequest(String playerId, JSONObject extraMessageData) throws IllegalStateException {
        return this.zza(playerId, 2, extraMessageData);
    }

    private PendingResult<GameManagerResult> zza(String string2, int n, JSONObject jSONObject) throws IllegalStateException {
        return this.zzXG.zza(string2, n, jSONObject);
    }

    public PendingResult<GameManagerResult> sendGameRequest(JSONObject extraMessageData) throws IllegalStateException {
        return this.sendGameRequest(this.getLastUsedPlayerId(), extraMessageData);
    }

    public PendingResult<GameManagerResult> sendGameRequest(String playerId, JSONObject extraMessageData) throws IllegalStateException {
        return this.zzXG.sendGameRequest(playerId, extraMessageData);
    }

    public void sendGameMessage(JSONObject extraMessageData) throws IllegalStateException {
        this.sendGameMessage(this.getLastUsedPlayerId(), extraMessageData);
    }

    public void sendGameMessage(String playerId, JSONObject extraMessageData) throws IllegalStateException {
        this.zzXG.sendGameMessage(playerId, extraMessageData);
    }

    public synchronized GameManagerState getCurrentState() throws IllegalStateException {
        return this.zzXG.getCurrentState();
    }

    public String getLastUsedPlayerId() throws IllegalStateException {
        return this.zzXG.getLastUsedPlayerId();
    }

    public void setListener(Listener listener) {
        this.zzXG.setListener(listener);
    }

    public void dispose() {
        this.zzXG.dispose();
    }

    public boolean isDisposed() {
        return this.zzXG.isDisposed();
    }

    public void setSessionLabel(String sessionLabel) {
        this.zzXG.setSessionLabel(sessionLabel);
    }

    public static interface GameManagerResult
    extends Result {
        public String getPlayerId();

        public long getRequestId();

        public JSONObject getExtraMessageData();
    }

    public static interface GameManagerInstanceResult
    extends Result {
        public GameManagerClient getGameManagerClient();
    }

    public static interface Listener {
        public void onStateChanged(GameManagerState var1, GameManagerState var2);

        public void onGameMessageReceived(String var1, JSONObject var2);
    }
}

