/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.text.TextUtils;
import com.google.android.gms.cast.ApplicationMetadata;
import com.google.android.gms.cast.Cast;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.JoinOptions;
import com.google.android.gms.cast.LaunchOptions;
import com.google.android.gms.cast.internal.ApplicationStatus;
import com.google.android.gms.cast.internal.DeviceStatus;
import com.google.android.gms.cast.internal.zzf;
import com.google.android.gms.cast.internal.zzi;
import com.google.android.gms.cast.internal.zzj;
import com.google.android.gms.cast.internal.zzl;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.BinderWrapper;
import com.google.android.gms.common.internal.zzj;
import com.google.android.gms.internal.zzlb;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public final class zze
extends zzj<zzi> {
    private static final zzl zzVo = new zzl("CastClientImpl");
    private ApplicationMetadata zzYF;
    private final CastDevice zzYG;
    private final Cast.Listener zzUZ;
    private final Map<String, Cast.MessageReceivedCallback> zzYH;
    private final long zzYI;
    private zzb zzYJ;
    private String zzYK;
    private boolean zzWB;
    private boolean zzYL;
    private boolean zzYM;
    private boolean zzYN;
    private double zzWA;
    private int zzYO;
    private int zzYP;
    private final AtomicLong zzYQ;
    private String zzYR;
    private String zzYS;
    private Bundle zzYT;
    private final Map<Long, zzlb.zzb<Status>> zzYU;
    private zzlb.zzb<Cast.ApplicationConnectionResult> zzYV;
    private zzlb.zzb<Status> zzYW;
    private static final Object zzYX = new Object();
    private static final Object zzYY = new Object();

    public zze(Context context, Looper looper, com.google.android.gms.common.internal.zzf zzf2, CastDevice castDevice, long l, Cast.Listener listener, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        super(context, looper, 10, zzf2, connectionCallbacks, onConnectionFailedListener);
        this.zzYG = castDevice;
        this.zzUZ = listener;
        this.zzYI = l;
        this.zzYH = new HashMap<String, Cast.MessageReceivedCallback>();
        this.zzYQ = new AtomicLong(0L);
        this.zzYU = new HashMap<Long, zzlb.zzb<Status>>();
        this.zzmR();
    }

    private void zzmR() {
        this.zzYN = false;
        this.zzYO = -1;
        this.zzYP = -1;
        this.zzYF = null;
        this.zzYK = null;
        this.zzWA = 0.0;
        this.zzWB = false;
    }

    protected void zza(int n, IBinder iBinder, Bundle bundle, int n2) {
        zzVo.zzb("in onPostInitHandler; statusCode=%d", n);
        if (n == 0 || n == 1001) {
            this.zzYN = true;
            this.zzYL = true;
            this.zzYM = true;
        } else {
            this.zzYN = false;
        }
        int n3 = n;
        if (n == 1001) {
            this.zzYT = new Bundle();
            this.zzYT.putBoolean("com.google.android.gms.cast.EXTRA_APP_NO_LONGER_RUNNING", true);
            n3 = 0;
        }
        super.zza(n3, iBinder, bundle, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        zzVo.zzb("disconnect(); ServiceListener=%s, isConnected=%b", this.zzYJ, this.isConnected());
        zzb zzb2 = this.zzYJ;
        this.zzYJ = null;
        if (zzb2 == null || zzb2.zznc() == null) {
            zzVo.zzb("already disposed, so short-circuiting", new Object[0]);
            return;
        }
        this.zzmX();
        try {
            ((zzi)this.zzpc()).disconnect();
        }
        catch (RemoteException | IllegalStateException throwable) {
            zzVo.zzb(throwable, "Error while disconnecting the controller interface: %s", throwable.getMessage());
        }
        finally {
            super.disconnect();
        }
    }

    public Bundle zzmS() {
        if (this.zzYT != null) {
            Bundle bundle = this.zzYT;
            this.zzYT = null;
            return bundle;
        }
        return super.zzmS();
    }

    protected String zzfK() {
        return "com.google.android.gms.cast.service.BIND_CAST_DEVICE_CONTROLLER_SERVICE";
    }

    protected String zzfL() {
        return "com.google.android.gms.cast.internal.ICastDeviceController";
    }

    protected zzi zzaA(IBinder iBinder) {
        return zzi.zza.zzaB(iBinder);
    }

    protected Bundle zzly() {
        Bundle bundle = new Bundle();
        zzVo.zzb("getRemoteService(): mLastApplicationId=%s, mLastSessionId=%s", this.zzYR, this.zzYS);
        this.zzYG.putInBundle(bundle);
        bundle.putLong("com.google.android.gms.cast.EXTRA_CAST_FLAGS", this.zzYI);
        this.zzYJ = new zzb(this);
        bundle.putParcelable("listener", (Parcelable)new BinderWrapper(this.zzYJ.asBinder()));
        if (this.zzYR != null) {
            bundle.putString("last_application_id", this.zzYR);
            if (this.zzYS != null) {
                bundle.putString("last_session_id", this.zzYS);
            }
        }
        return bundle;
    }

    public void zza(String string2, String string3, zzlb.zzb<Status> zzb2) throws IllegalArgumentException, IllegalStateException, RemoteException {
        if (TextUtils.isEmpty((CharSequence)string3)) {
            throw new IllegalArgumentException("The message payload cannot be null or empty");
        }
        if (string3.length() > 65536) {
            throw new IllegalArgumentException("Message exceeds maximum size");
        }
        zzf.zzbM(string2);
        this.zzmY();
        long l = this.zzYQ.incrementAndGet();
        try {
            this.zzYU.put(l, zzb2);
            ((zzi)this.zzpc()).zzb(string2, string3, l);
        }
        catch (Throwable throwable) {
            this.zzYU.remove(l);
            throw throwable;
        }
    }

    public void zza(String string2, boolean bl, zzlb.zzb<Cast.ApplicationConnectionResult> zzb2) throws IllegalStateException, RemoteException {
        this.zza(zzb2);
        ((zzi)this.zzpc()).zzf(string2, bl);
    }

    public void zza(String string2, LaunchOptions launchOptions, zzlb.zzb<Cast.ApplicationConnectionResult> zzb2) throws IllegalStateException, RemoteException {
        this.zza(zzb2);
        ((zzi)this.zzpc()).zza(string2, launchOptions);
    }

    public void zza(String string2, String string3, JoinOptions joinOptions, zzlb.zzb<Cast.ApplicationConnectionResult> zzb2) throws IllegalStateException, RemoteException {
        this.zza(zzb2);
        if (joinOptions == null) {
            joinOptions = new JoinOptions();
        }
        ((zzi)this.zzpc()).zza(string2, string3, joinOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zza(zzlb.zzb<Cast.ApplicationConnectionResult> zzb2) {
        Object object = zzYX;
        synchronized (object) {
            if (this.zzYV != null) {
                this.zzYV.zzp((Object)new zza(new Status(2002)));
            }
            this.zzYV = zzb2;
        }
    }

    public void zzb(zzlb.zzb<Status> zzb2) throws IllegalStateException, RemoteException {
        this.zzc(zzb2);
        ((zzi)this.zzpc()).zzne();
    }

    public void zza(String string2, zzlb.zzb<Status> zzb2) throws IllegalStateException, RemoteException {
        this.zzc(zzb2);
        ((zzi)this.zzpc()).zzbP(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzc(zzlb.zzb<Status> zzb2) {
        Object object = zzYY;
        synchronized (object) {
            if (this.zzYW != null) {
                zzb2.zzp((Object)new Status(2001));
                return;
            }
            this.zzYW = zzb2;
        }
    }

    public void zzmT() throws IllegalStateException, RemoteException {
        ((zzi)this.zzpc()).zzmT();
    }

    public void zzf(double d) throws IllegalArgumentException, IllegalStateException, RemoteException {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            throw new IllegalArgumentException("Volume cannot be " + d);
        }
        ((zzi)this.zzpc()).zza(d, this.zzWA, this.zzWB);
    }

    public void zzW(boolean bl) throws IllegalStateException, RemoteException {
        ((zzi)this.zzpc()).zza(bl, this.zzWA, this.zzWB);
    }

    public double zzmU() throws IllegalStateException {
        this.zzmY();
        return this.zzWA;
    }

    public boolean isMute() throws IllegalStateException {
        this.zzmY();
        return this.zzWB;
    }

    public int zzmV() throws IllegalStateException {
        this.zzmY();
        return this.zzYO;
    }

    public int zzmW() throws IllegalStateException {
        this.zzmY();
        return this.zzYP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(String string2, Cast.MessageReceivedCallback messageReceivedCallback) throws IllegalArgumentException, IllegalStateException, RemoteException {
        zzf.zzbM(string2);
        this.zzbL(string2);
        if (messageReceivedCallback != null) {
            Map<String, Cast.MessageReceivedCallback> map = this.zzYH;
            synchronized (map) {
                this.zzYH.put(string2, messageReceivedCallback);
            }
            ((zzi)this.zzpc()).zzbQ(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzbL(String string2) throws IllegalArgumentException, RemoteException {
        Cast.MessageReceivedCallback messageReceivedCallback;
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("Channel namespace cannot be null or empty");
        }
        Map<String, Cast.MessageReceivedCallback> map = this.zzYH;
        synchronized (map) {
            messageReceivedCallback = this.zzYH.remove(string2);
        }
        if (messageReceivedCallback != null) {
            try {
                ((zzi)this.zzpc()).zzbR(string2);
            }
            catch (IllegalStateException illegalStateException) {
                zzVo.zzb(illegalStateException, "Error unregistering namespace (%s): %s", string2, illegalStateException.getMessage());
            }
        }
    }

    public ApplicationMetadata getApplicationMetadata() throws IllegalStateException {
        this.zzmY();
        return this.zzYF;
    }

    public String getApplicationStatus() throws IllegalStateException {
        this.zzmY();
        return this.zzYK;
    }

    public void onConnectionFailed(ConnectionResult result) {
        super.onConnectionFailed(result);
        this.zzmX();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzmX() {
        zzVo.zzb("removing all MessageReceivedCallbacks", new Object[0]);
        Map<String, Cast.MessageReceivedCallback> map = this.zzYH;
        synchronized (map) {
            this.zzYH.clear();
        }
    }

    private void zza(DeviceStatus deviceStatus) {
        boolean bl;
        ApplicationMetadata applicationMetadata = deviceStatus.getApplicationMetadata();
        if (!zzf.zza(applicationMetadata, this.zzYF)) {
            this.zzYF = applicationMetadata;
            this.zzUZ.onApplicationMetadataChanged(this.zzYF);
        }
        boolean bl2 = false;
        double d = deviceStatus.zzmU();
        if (d != Double.NaN && Math.abs(d - this.zzWA) > 1.0E-7) {
            this.zzWA = d;
            bl2 = true;
        }
        if ((bl = deviceStatus.zznd()) != this.zzWB) {
            this.zzWB = bl;
            bl2 = true;
        }
        zzVo.zzb("hasVolumeChanged=%b, mFirstDeviceStatusUpdate=%b", bl2, this.zzYM);
        if (this.zzUZ != null && (bl2 || this.zzYM)) {
            this.zzUZ.onVolumeChanged();
        }
        boolean bl3 = false;
        int n = deviceStatus.zzmV();
        if (n != this.zzYO) {
            this.zzYO = n;
            bl3 = true;
        }
        zzVo.zzb("hasActiveInputChanged=%b, mFirstDeviceStatusUpdate=%b", bl3, this.zzYM);
        if (this.zzUZ != null && (bl3 || this.zzYM)) {
            this.zzUZ.onActiveInputStateChanged(this.zzYO);
        }
        boolean bl4 = false;
        int n2 = deviceStatus.zzmW();
        if (n2 != this.zzYP) {
            this.zzYP = n2;
            bl4 = true;
        }
        zzVo.zzb("hasStandbyStateChanged=%b, mFirstDeviceStatusUpdate=%b", bl4, this.zzYM);
        if (this.zzUZ != null && (bl4 || this.zzYM)) {
            this.zzUZ.onStandbyStateChanged(this.zzYP);
        }
        this.zzYM = false;
    }

    private void zza(ApplicationStatus applicationStatus) {
        boolean bl = false;
        String string2 = applicationStatus.zzmO();
        if (!zzf.zza(string2, this.zzYK)) {
            this.zzYK = string2;
            bl = true;
        }
        zzVo.zzb("hasChanged=%b, mFirstApplicationStatusUpdate=%b", bl, this.zzYL);
        if (this.zzUZ != null && (bl || this.zzYL)) {
            this.zzUZ.onApplicationStatusChanged();
        }
        this.zzYL = false;
    }

    private void zzmY() throws IllegalStateException {
        if (!this.zzYN || this.zzYJ == null || this.zzYJ.isDisposed()) {
            throw new IllegalStateException("Not connected to a device");
        }
    }

    protected /* synthetic */ IInterface zzW(IBinder iBinder) {
        return this.zzaA(iBinder);
    }

    private static class zzb
    extends zzj.zza {
        private final AtomicReference<zze> zzZc;
        private final Handler mHandler;

        public zzb(zze zze2) {
            this.zzZc = new AtomicReference<zze>(zze2);
            this.mHandler = new Handler(zze2.getLooper());
        }

        public zze zznc() {
            zze zze2 = this.zzZc.getAndSet(null);
            if (zze2 == null) {
                return null;
            }
            zze2.zzmR();
            return zze2;
        }

        public boolean isDisposed() {
            return this.zzZc.get() == null;
        }

        @Override
        public void zzbb(int n) {
            zze zze2 = this.zznc();
            if (zze2 == null) {
                return;
            }
            zzVo.zzb("ICastDeviceControllerListener.onDisconnected: %d", n);
            if (n != 0) {
                zze2.zzbE(2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zza(ApplicationMetadata applicationMetadata, String string2, String string3, boolean bl) {
            zze zze2 = this.zzZc.get();
            if (zze2 == null) {
                return;
            }
            zze2.zzYF = applicationMetadata;
            zze2.zzYR = applicationMetadata.getApplicationId();
            zze2.zzYS = string3;
            Object object = zzYX;
            synchronized (object) {
                if (zze2.zzYV != null) {
                    zze2.zzYV.zzp((Object)new zza(new Status(0), applicationMetadata, string2, string3, bl));
                    zze2.zzYV = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zzbc(int n) {
            zze zze2 = this.zzZc.get();
            if (zze2 == null) {
                return;
            }
            Object object = zzYX;
            synchronized (object) {
                if (zze2.zzYV != null) {
                    zze2.zzYV.zzp((Object)new zza(new Status(n)));
                    zze2.zzYV = null;
                }
            }
        }

        @Override
        public void zzbd(int n) {
            zze zze2 = this.zzZc.get();
            if (zze2 == null) {
                return;
            }
            this.zza(zze2, n);
        }

        @Override
        public void zzbe(int n) {
            zze zze2 = this.zzZc.get();
            if (zze2 == null) {
                return;
            }
            this.zza(zze2, n);
        }

        @Override
        public void onApplicationDisconnected(final int statusCode) {
            final zze zze2 = this.zzZc.get();
            if (zze2 == null) {
                return;
            }
            zze2.zzYR = null;
            zze2.zzYS = null;
            this.zza(zze2, statusCode);
            if (zze2.zzUZ != null) {
                this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (zze2.zzUZ != null) {
                            zze2.zzUZ.onApplicationDisconnected(statusCode);
                        }
                    }
                });
            }
        }

        @Override
        public void zza(String string2, double d, boolean bl) {
            zzVo.zzb("Deprecated callback: \"onStatusreceived\"", new Object[0]);
        }

        @Override
        public void zzb(final DeviceStatus deviceStatus) {
            final zze zze2 = this.zzZc.get();
            if (zze2 == null) {
                return;
            }
            zzVo.zzb("onDeviceStatusChanged", new Object[0]);
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    zze2.zza(deviceStatus);
                }
            });
        }

        @Override
        public void zzb(final ApplicationStatus applicationStatus) {
            final zze zze2 = this.zzZc.get();
            if (zze2 == null) {
                return;
            }
            zzVo.zzb("onApplicationStatusChanged", new Object[0]);
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    zze2.zza(applicationStatus);
                }
            });
        }

        @Override
        public void zzs(final String string2, final String string3) {
            final zze zze2 = this.zzZc.get();
            if (zze2 == null) {
                return;
            }
            zzVo.zzb("Receive (type=text, ns=%s) %s", string2, string3);
            this.mHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Cast.MessageReceivedCallback messageReceivedCallback;
                    Map map = zze2.zzYH;
                    synchronized (map) {
                        messageReceivedCallback = (Cast.MessageReceivedCallback)zze2.zzYH.get(string2);
                    }
                    if (messageReceivedCallback != null) {
                        messageReceivedCallback.onMessageReceived(zze2.zzYG, string2, string3);
                    } else {
                        zzVo.zzb("Discarded message for unknown namespace '%s'", string2);
                    }
                }
            });
        }

        @Override
        public void zzb(String string2, byte[] byArray) {
            zze zze2 = this.zzZc.get();
            if (zze2 == null) {
                return;
            }
            zzVo.zzb("IGNORING: Receive (type=binary, ns=%s) <%d bytes>", string2, byArray.length);
        }

        @Override
        public void zza(String string2, long l, int n) {
            zze zze2 = this.zzZc.get();
            if (zze2 == null) {
                return;
            }
            this.zza(zze2, l, n);
        }

        @Override
        public void zzd(String string2, long l) {
            zze zze2 = this.zzZc.get();
            if (zze2 == null) {
                return;
            }
            this.zza(zze2, l, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void zza(zze zze2, long l, int n) {
            zzlb.zzb zzb2;
            Map map = zze2.zzYU;
            synchronized (map) {
                zzb2 = (zzlb.zzb)zze2.zzYU.remove(l);
            }
            if (zzb2 != null) {
                zzb2.zzp((Object)new Status(n));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean zza(zze zze2, int n) {
            Object object = zzYY;
            synchronized (object) {
                if (zze2.zzYW != null) {
                    zze2.zzYW.zzp((Object)new Status(n));
                    zze2.zzYW = null;
                    return true;
                }
            }
            return false;
        }
    }

    private static final class zza
    implements Cast.ApplicationConnectionResult {
        private final Status zzSC;
        private final ApplicationMetadata zzYZ;
        private final String zzZa;
        private final String zzHP;
        private final boolean zzZb;

        public zza(Status status, ApplicationMetadata applicationMetadata, String string2, String string3, boolean bl) {
            this.zzSC = status;
            this.zzYZ = applicationMetadata;
            this.zzZa = string2;
            this.zzHP = string3;
            this.zzZb = bl;
        }

        public zza(Status status) {
            this(status, null, null, null, false);
        }

        public Status getStatus() {
            return this.zzSC;
        }

        @Override
        public ApplicationMetadata getApplicationMetadata() {
            return this.zzYZ;
        }

        @Override
        public String getApplicationStatus() {
            return this.zzZa;
        }

        @Override
        public String getSessionId() {
            return this.zzHP;
        }

        @Override
        public boolean getWasLaunched() {
            return this.zzZb;
        }
    }
}

