/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.text.TextUtils;
import com.google.android.gms.cast.MediaMetadata;
import com.google.android.gms.cast.MediaTrack;
import com.google.android.gms.cast.TextTrackStyle;
import com.google.android.gms.cast.internal.zzf;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.internal.zznu;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class MediaInfo {
    public static final int STREAM_TYPE_NONE = 0;
    public static final int STREAM_TYPE_BUFFERED = 1;
    public static final int STREAM_TYPE_LIVE = 2;
    public static final int STREAM_TYPE_INVALID = -1;
    public static final long UNKNOWN_DURATION = -1L;
    private final String zzZg;
    private int zzZh;
    private String zzZi;
    private MediaMetadata zzZj;
    private long zzZk;
    private List<MediaTrack> zzZl;
    private TextTrackStyle zzZm;
    private JSONObject zzZn;

    MediaInfo(String contentId) throws IllegalArgumentException {
        if (TextUtils.isEmpty((CharSequence)contentId)) {
            throw new IllegalArgumentException("content ID cannot be null or empty");
        }
        this.zzZg = contentId;
        this.zzZh = -1;
        this.zzZk = -1L;
    }

    MediaInfo(JSONObject json) throws JSONException {
        double d;
        int n;
        JSONObject jSONObject;
        this.zzZg = json.getString("contentId");
        String string2 = json.getString("streamType");
        this.zzZh = "NONE".equals(string2) ? 0 : ("BUFFERED".equals(string2) ? 1 : ("LIVE".equals(string2) ? 2 : -1));
        this.zzZi = json.getString("contentType");
        if (json.has("metadata")) {
            jSONObject = json.getJSONObject("metadata");
            n = jSONObject.getInt("metadataType");
            this.zzZj = new MediaMetadata(n);
            this.zzZj.zzf(jSONObject);
        }
        this.zzZk = -1L;
        if (json.has("duration") && !json.isNull("duration") && !Double.isNaN(d = json.optDouble("duration", 0.0)) && !Double.isInfinite(d)) {
            this.zzZk = zzf.zzg(d);
        }
        if (json.has("tracks")) {
            this.zzZl = new ArrayList<MediaTrack>();
            jSONObject = json.getJSONArray("tracks");
            for (n = 0; n < jSONObject.length(); ++n) {
                JSONObject jSONObject2 = jSONObject.getJSONObject(n);
                MediaTrack mediaTrack = new MediaTrack(jSONObject2);
                this.zzZl.add(mediaTrack);
            }
        } else {
            this.zzZl = null;
        }
        if (json.has("textTrackStyle")) {
            jSONObject = json.getJSONObject("textTrackStyle");
            TextTrackStyle textTrackStyle = new TextTrackStyle();
            textTrackStyle.zzf(jSONObject);
            this.zzZm = textTrackStyle;
        } else {
            this.zzZm = null;
        }
        this.zzZn = json.optJSONObject("customData");
    }

    public String getContentId() {
        return this.zzZg;
    }

    void setStreamType(int streamType) throws IllegalArgumentException {
        if (streamType < -1 || streamType > 2) {
            throw new IllegalArgumentException("invalid stream type");
        }
        this.zzZh = streamType;
    }

    public int getStreamType() {
        return this.zzZh;
    }

    void setContentType(String contentType) throws IllegalArgumentException {
        if (TextUtils.isEmpty((CharSequence)contentType)) {
            throw new IllegalArgumentException("content type cannot be null or empty");
        }
        this.zzZi = contentType;
    }

    public String getContentType() {
        return this.zzZi;
    }

    void zza(MediaMetadata mediaMetadata) {
        this.zzZj = mediaMetadata;
    }

    public MediaMetadata getMetadata() {
        return this.zzZj;
    }

    void zzx(long l) throws IllegalArgumentException {
        if (l < 0L && l != -1L) {
            throw new IllegalArgumentException("Invalid stream duration");
        }
        this.zzZk = l;
    }

    public long getStreamDuration() {
        return this.zzZk;
    }

    void zzs(List<MediaTrack> list) {
        this.zzZl = list;
    }

    public List<MediaTrack> getMediaTracks() {
        return this.zzZl;
    }

    public void setTextTrackStyle(TextTrackStyle textTrackStyle) {
        this.zzZm = textTrackStyle;
    }

    public TextTrackStyle getTextTrackStyle() {
        return this.zzZm;
    }

    void setCustomData(JSONObject customData) {
        this.zzZn = customData;
    }

    public JSONObject getCustomData() {
        return this.zzZn;
    }

    void zznv() throws IllegalArgumentException {
        if (TextUtils.isEmpty((CharSequence)this.zzZg)) {
            throw new IllegalArgumentException("content ID cannot be null or empty");
        }
        if (TextUtils.isEmpty((CharSequence)this.zzZi)) {
            throw new IllegalArgumentException("content type cannot be null or empty");
        }
        if (this.zzZh == -1) {
            throw new IllegalArgumentException("a valid stream type must be specified");
        }
    }

    public JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            String string2;
            jSONObject.put("contentId", (Object)this.zzZg);
            switch (this.zzZh) {
                case 1: {
                    string2 = "BUFFERED";
                    break;
                }
                case 2: {
                    string2 = "LIVE";
                    break;
                }
                default: {
                    string2 = "NONE";
                }
            }
            jSONObject.put("streamType", (Object)string2);
            if (this.zzZi != null) {
                jSONObject.put("contentType", (Object)this.zzZi);
            }
            if (this.zzZj != null) {
                jSONObject.put("metadata", (Object)this.zzZj.toJson());
            }
            if (this.zzZk <= -1L) {
                jSONObject.put("duration", JSONObject.NULL);
            } else {
                jSONObject.put("duration", zzf.zzA(this.zzZk));
            }
            if (this.zzZl != null) {
                JSONArray jSONArray = new JSONArray();
                for (MediaTrack mediaTrack : this.zzZl) {
                    jSONArray.put((Object)mediaTrack.toJson());
                }
                jSONObject.put("tracks", (Object)jSONArray);
            }
            if (this.zzZm != null) {
                jSONObject.put("textTrackStyle", (Object)this.zzZm.toJson());
            }
            if (this.zzZn != null) {
                jSONObject.put("customData", (Object)this.zzZn);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jSONObject;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MediaInfo)) {
            return false;
        }
        MediaInfo mediaInfo = (MediaInfo)other;
        if (this.zzZn == null != (mediaInfo.zzZn == null)) {
            return false;
        }
        if (this.zzZn != null && mediaInfo.zzZn != null && !zznu.zze((Object)this.zzZn, (Object)mediaInfo.zzZn)) {
            return false;
        }
        return zzf.zza(this.zzZg, mediaInfo.zzZg) && this.zzZh == mediaInfo.zzZh && zzf.zza(this.zzZi, mediaInfo.zzZi) && zzf.zza(this.zzZj, mediaInfo.zzZj) && this.zzZk == mediaInfo.zzZk;
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzZg, this.zzZh, this.zzZi, this.zzZj, this.zzZk, String.valueOf(this.zzZn)});
    }

    public static class Builder {
        private final MediaInfo zzZo;

        public Builder(String contentId) throws IllegalArgumentException {
            if (TextUtils.isEmpty((CharSequence)contentId)) {
                throw new IllegalArgumentException("Content ID cannot be empty");
            }
            this.zzZo = new MediaInfo(contentId);
        }

        public Builder setStreamType(int streamType) throws IllegalArgumentException {
            this.zzZo.setStreamType(streamType);
            return this;
        }

        public Builder setContentType(String contentType) throws IllegalArgumentException {
            this.zzZo.setContentType(contentType);
            return this;
        }

        public Builder setMetadata(MediaMetadata metadata) {
            this.zzZo.zza(metadata);
            return this;
        }

        public Builder setStreamDuration(long duration) throws IllegalArgumentException {
            this.zzZo.zzx(duration);
            return this;
        }

        public Builder setCustomData(JSONObject customData) {
            this.zzZo.setCustomData(customData);
            return this;
        }

        public Builder setMediaTracks(List<MediaTrack> mediaTracks) {
            this.zzZo.zzs(mediaTracks);
            return this;
        }

        public Builder setTextTrackStyle(TextTrackStyle textTrackStyle) {
            this.zzZo.setTextTrackStyle(textTrackStyle);
            return this;
        }

        public MediaInfo build() throws IllegalArgumentException {
            this.zzZo.zznv();
            return this.zzZo;
        }
    }
}

