/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.util.SparseArray;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaQueueItem;
import com.google.android.gms.cast.internal.zzf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class MediaStatus {
    public static final long COMMAND_PAUSE = 1L;
    public static final long COMMAND_SEEK = 2L;
    public static final long COMMAND_SET_VOLUME = 4L;
    public static final long COMMAND_TOGGLE_MUTE = 8L;
    public static final long COMMAND_SKIP_FORWARD = 16L;
    public static final long COMMAND_SKIP_BACKWARD = 32L;
    public static final int PLAYER_STATE_UNKNOWN = 0;
    public static final int PLAYER_STATE_IDLE = 1;
    public static final int PLAYER_STATE_PLAYING = 2;
    public static final int PLAYER_STATE_PAUSED = 3;
    public static final int PLAYER_STATE_BUFFERING = 4;
    public static final int IDLE_REASON_NONE = 0;
    public static final int IDLE_REASON_FINISHED = 1;
    public static final int IDLE_REASON_CANCELED = 2;
    public static final int IDLE_REASON_INTERRUPTED = 3;
    public static final int IDLE_REASON_ERROR = 4;
    public static final int REPEAT_MODE_REPEAT_OFF = 0;
    public static final int REPEAT_MODE_REPEAT_ALL = 1;
    public static final int REPEAT_MODE_REPEAT_SINGLE = 2;
    public static final int REPEAT_MODE_REPEAT_ALL_AND_SHUFFLE = 3;
    private int zzafN = 0;
    private long zzafO;
    private MediaInfo zzafx;
    private double zzafP;
    private int zzafQ;
    private int zzafR;
    private long zzafS;
    private long zzafT;
    private double zzafU;
    private boolean zzafV;
    private long[] zzafL;
    private JSONObject zzafw;
    private int zzafW = 0;
    private int zzafX = 0;
    private final zza zzafY = new zza();

    public MediaStatus(JSONObject jSONObject) throws JSONException {
        this.zza(jSONObject, 0);
    }

    public long zzpX() {
        return this.zzafO;
    }

    public int getPlayerState() {
        return this.zzafQ;
    }

    public int getIdleReason() {
        return this.zzafR;
    }

    public double getPlaybackRate() {
        return this.zzafP;
    }

    public MediaInfo getMediaInfo() {
        return this.zzafx;
    }

    public long getStreamPosition() {
        return this.zzafS;
    }

    public boolean isMediaCommandSupported(long l) {
        return (this.zzafT & l) != 0L;
    }

    public double getStreamVolume() {
        return this.zzafU;
    }

    public boolean isMute() {
        return this.zzafV;
    }

    public long[] getActiveTrackIds() {
        return this.zzafL;
    }

    public JSONObject getCustomData() {
        return this.zzafw;
    }

    public int getCurrentItemId() {
        return this.zzafN;
    }

    public int getLoadingItemId() {
        return this.zzafW;
    }

    public int getPreloadedItemId() {
        return this.zzafX;
    }

    public int getQueueRepeatMode() {
        return this.zzafY.getRepeatMode();
    }

    public List<MediaQueueItem> getQueueItems() {
        return this.zzafY.zzpY();
    }

    public int getQueueItemCount() {
        return this.zzafY.getItemCount();
    }

    public MediaQueueItem getQueueItemById(int n) {
        return this.zzafY.zzbi(n);
    }

    public MediaQueueItem getQueueItem(int n) {
        return this.zzafY.zzbj(n);
    }

    public int zza(JSONObject jSONObject, int n) throws JSONException {
        int n2;
        int n3;
        int n4;
        long l;
        long l2;
        double d;
        int n5 = 0;
        long l3 = jSONObject.getLong("mediaSessionId");
        if (l3 != this.zzafO) {
            this.zzafO = l3;
            n5 = 1;
        }
        if (jSONObject.has("playerState")) {
            int n6 = 0;
            String string2 = jSONObject.getString("playerState");
            if (string2.equals("IDLE")) {
                n6 = 1;
            } else if (string2.equals("PLAYING")) {
                n6 = 2;
            } else if (string2.equals("PAUSED")) {
                n6 = 3;
            } else if (string2.equals("BUFFERING")) {
                n6 = 4;
            }
            if (n6 != this.zzafQ) {
                this.zzafQ = n6;
                n5 |= 2;
            }
            if (n6 == 1 && jSONObject.has("idleReason")) {
                int n7 = 0;
                string2 = jSONObject.getString("idleReason");
                if (string2.equals("CANCELLED")) {
                    n7 = 2;
                } else if (string2.equals("INTERRUPTED")) {
                    n7 = 3;
                } else if (string2.equals("FINISHED")) {
                    n7 = 1;
                } else if (string2.equals("ERROR")) {
                    n7 = 4;
                }
                if (n7 != this.zzafR) {
                    this.zzafR = n7;
                    n5 |= 2;
                }
            }
        }
        if (jSONObject.has("playbackRate") && this.zzafP != (d = jSONObject.getDouble("playbackRate"))) {
            this.zzafP = d;
            n5 |= 2;
        }
        if (jSONObject.has("currentTime") && (n & 2) == 0 && (l2 = zzf.zzg(jSONObject.getDouble("currentTime"))) != this.zzafS) {
            this.zzafS = l2;
            n5 |= 2;
        }
        if (jSONObject.has("supportedMediaCommands") && (l = jSONObject.getLong("supportedMediaCommands")) != this.zzafT) {
            this.zzafT = l;
            n5 |= 2;
        }
        if (jSONObject.has("volume") && (n & 1) == 0) {
            JSONObject jSONObject2 = jSONObject.getJSONObject("volume");
            double d2 = jSONObject2.getDouble("level");
            if (d2 != this.zzafU) {
                this.zzafU = d2;
                n5 |= 2;
            }
            if ((n4 = (int)(jSONObject2.getBoolean("muted") ? 1 : 0)) != this.zzafV) {
                this.zzafV = n4;
                n5 |= 2;
            }
        }
        boolean bl = false;
        long[] lArray = null;
        if (jSONObject.has("activeTrackIds")) {
            int n8;
            JSONArray jSONArray = jSONObject.getJSONArray("activeTrackIds");
            n4 = jSONArray.length();
            lArray = new long[n4];
            for (n8 = 0; n8 < n4; ++n8) {
                lArray[n8] = jSONArray.getLong(n8);
            }
            if (this.zzafL == null) {
                bl = true;
            } else if (this.zzafL.length != n4) {
                bl = true;
            } else {
                for (n8 = 0; n8 < n4; ++n8) {
                    if (this.zzafL[n8] == lArray[n8]) continue;
                    bl = true;
                    break;
                }
            }
            if (bl) {
                this.zzafL = lArray;
            }
        } else if (this.zzafL != null) {
            bl = true;
        }
        if (bl) {
            this.zzafL = lArray;
            n5 |= 2;
        }
        if (jSONObject.has("customData")) {
            this.zzafw = jSONObject.getJSONObject("customData");
            n5 |= 2;
        }
        if (jSONObject.has("media")) {
            JSONObject jSONObject3 = jSONObject.getJSONObject("media");
            this.zzafx = new MediaInfo(jSONObject3);
            n5 |= 2;
            if (jSONObject3.has("metadata")) {
                n5 |= 4;
            }
        }
        if (jSONObject.has("currentItemId") && this.zzafN != (n3 = jSONObject.getInt("currentItemId"))) {
            this.zzafN = n3;
            n5 |= 2;
        }
        if (this.zzafX != (n2 = jSONObject.optInt("preloadedItemId", 0))) {
            this.zzafX = n2;
            n5 |= 0x10;
        }
        if (this.zzafW != (n4 = jSONObject.optInt("loadingItemId", 0))) {
            this.zzafW = n4;
            n5 |= 2;
        }
        if (!this.zzk(this.zzafQ, this.zzafW)) {
            if (this.zzafY.zzj(jSONObject)) {
                n5 |= 8;
            }
        } else {
            this.zzafN = 0;
            this.zzafW = 0;
            this.zzafX = 0;
            if (this.zzafY.getItemCount() > 0) {
                this.zzafY.clear();
                n5 |= 8;
            }
        }
        return n5;
    }

    private boolean zzk(int n, int n2) {
        return n == 1 && n2 == 0;
    }

    private class zza {
        private int zzafZ = 0;
        private List<MediaQueueItem> zzaga = new ArrayList<MediaQueueItem>();
        private SparseArray<Integer> zzagb = new SparseArray();

        zza() {
        }

        private boolean zzj(JSONObject jSONObject) throws JSONException {
            int n;
            String string2;
            boolean bl = false;
            if (jSONObject.has("repeatMode")) {
                String string3;
                int n2 = this.zzafZ;
                string2 = string3 = jSONObject.getString("repeatMode");
                n = -1;
                switch (string2.hashCode()) {
                    case 1645952171: {
                        if (!string2.equals("REPEAT_OFF")) break;
                        n = 0;
                        break;
                    }
                    case 1645938909: {
                        if (!string2.equals("REPEAT_ALL")) break;
                        n = 1;
                        break;
                    }
                    case -962896020: {
                        if (!string2.equals("REPEAT_SINGLE")) break;
                        n = 2;
                        break;
                    }
                    case -1118317585: {
                        if (!string2.equals("REPEAT_ALL_AND_SHUFFLE")) break;
                        n = 3;
                    }
                }
                switch (n) {
                    case 0: {
                        n2 = 0;
                        break;
                    }
                    case 1: {
                        n2 = 1;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                    case 3: {
                        n2 = 3;
                    }
                }
                if (this.zzafZ != n2) {
                    this.zzafZ = n2;
                    bl = true;
                }
            }
            if (jSONObject.has("items")) {
                JSONArray jSONArray = jSONObject.getJSONArray("items");
                int n3 = jSONArray.length();
                string2 = new SparseArray();
                for (n = 0; n < n3; ++n) {
                    string2.put(n, (Object)jSONArray.getJSONObject(n).getInt("itemId"));
                }
                MediaQueueItem[] mediaQueueItemArray = new MediaQueueItem[n3];
                for (int i = 0; i < n3; ++i) {
                    Integer n4 = (Integer)string2.get(i);
                    JSONObject jSONObject2 = jSONArray.getJSONObject(i);
                    MediaQueueItem mediaQueueItem = this.zzbi(n4);
                    if (mediaQueueItem != null) {
                        bl |= mediaQueueItem.zzj(jSONObject2);
                        mediaQueueItemArray[i] = mediaQueueItem;
                        if (i == this.zzbk(n4)) continue;
                        bl = true;
                        continue;
                    }
                    bl = true;
                    if (n4 == MediaStatus.this.zzafN) {
                        mediaQueueItemArray[i] = new MediaQueueItem.Builder(MediaStatus.this.zzafx).build();
                        mediaQueueItemArray[i].zzj(jSONObject2);
                        continue;
                    }
                    mediaQueueItemArray[i] = new MediaQueueItem(jSONObject2);
                }
                if (this.zzaga.size() != n3) {
                    bl = true;
                }
                this.zza(mediaQueueItemArray);
            }
            return bl;
        }

        public int getRepeatMode() {
            return this.zzafZ;
        }

        public List<MediaQueueItem> zzpY() {
            return Collections.unmodifiableList(this.zzaga);
        }

        public int getItemCount() {
            return this.zzaga.size();
        }

        public MediaQueueItem zzbi(int n) {
            Integer n2 = (Integer)this.zzagb.get(n);
            return n2 == null ? null : this.zzaga.get(n2);
        }

        public MediaQueueItem zzbj(int n) {
            if (n < 0 || n >= this.zzaga.size()) {
                return null;
            }
            return this.zzaga.get(n);
        }

        private Integer zzbk(int n) {
            return (Integer)this.zzagb.get(n);
        }

        private void zza(MediaQueueItem[] mediaQueueItemArray) {
            this.zzaga.clear();
            this.zzagb.clear();
            for (int i = 0; i < mediaQueueItemArray.length; ++i) {
                MediaQueueItem mediaQueueItem = mediaQueueItemArray[i];
                this.zzaga.add(mediaQueueItem);
                this.zzagb.put(mediaQueueItem.getItemId(), (Object)i);
            }
        }

        private void clear() {
            this.zzafZ = 0;
            this.zzaga.clear();
            this.zzagb.clear();
        }
    }
}

