/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.clearcut;

import com.google.android.gms.internal.clearcut.zzas;
import com.google.android.gms.internal.clearcut.zzba;
import com.google.android.gms.internal.clearcut.zzbb;
import com.google.android.gms.internal.clearcut.zzbo;
import com.google.android.gms.internal.clearcut.zzbp;
import com.google.android.gms.internal.clearcut.zzci;
import com.google.android.gms.internal.clearcut.zzcv;
import com.google.android.gms.internal.clearcut.zzdo;
import com.google.android.gms.internal.clearcut.zzef;
import com.google.android.gms.internal.clearcut.zzfd;
import com.google.android.gms.internal.clearcut.zzff;
import com.google.android.gms.internal.clearcut.zzfi;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class zzbn
extends zzba {
    private static final Logger logger = Logger.getLogger(zzbn.class.getName());
    private static final boolean zzfy = zzfd.zzed();
    zzbp zzfz;

    public static zzbn zzc(byte[] byArray) {
        int n = byArray.length;
        byte[] byArray2 = byArray;
        return new zza(byArray2, 0, n);
    }

    public static zzbn zza(ByteBuffer byteBuffer) {
        if (byteBuffer.hasArray()) {
            return new zzb(byteBuffer);
        }
        if (byteBuffer.isDirect() && !byteBuffer.isReadOnly()) {
            if (zzfd.zzee()) {
                ByteBuffer byteBuffer2 = byteBuffer;
                return new zze(byteBuffer2);
            }
            ByteBuffer byteBuffer3 = byteBuffer;
            return new zzd(byteBuffer3);
        }
        throw new IllegalArgumentException("ByteBuffer is read-only");
    }

    private zzbn() {
    }

    public abstract void zzb(int var1, int var2) throws IOException;

    public abstract void zzc(int var1, int var2) throws IOException;

    public abstract void zzd(int var1, int var2) throws IOException;

    public final void zze(int n, int n2) throws IOException {
        this.zzd(n, zzbn.zzy(n2));
    }

    public abstract void zzf(int var1, int var2) throws IOException;

    public abstract void zza(int var1, long var2) throws IOException;

    public final void zzb(int n, long l) throws IOException {
        this.zza(n, zzbn.zzj(l));
    }

    public abstract void zzc(int var1, long var2) throws IOException;

    public final void zza(int n, float f) throws IOException {
        this.zzf(n, Float.floatToRawIntBits(f));
    }

    public final void zza(int n, double d) throws IOException {
        this.zzc(n, Double.doubleToRawLongBits(d));
    }

    public abstract void zzb(int var1, boolean var2) throws IOException;

    public abstract void zza(int var1, String var2) throws IOException;

    public abstract void zza(int var1, zzbb var2) throws IOException;

    public abstract void zza(int var1, zzdo var2) throws IOException;

    abstract void zza(int var1, zzdo var2, zzef var3) throws IOException;

    public abstract void zzb(int var1, zzdo var2) throws IOException;

    public abstract void zzb(int var1, zzbb var2) throws IOException;

    public abstract void zzn(int var1) throws IOException;

    public abstract void zzo(int var1) throws IOException;

    public final void zzp(int n) throws IOException {
        this.zzo(zzbn.zzy(n));
    }

    public abstract void zzq(int var1) throws IOException;

    public abstract void zzb(long var1) throws IOException;

    public final void zzc(long l) throws IOException {
        this.zzb(zzbn.zzj(l));
    }

    public abstract void zzd(long var1) throws IOException;

    public final void zza(float f) throws IOException {
        this.zzq(Float.floatToRawIntBits(f));
    }

    public final void zza(double d) throws IOException {
        this.zzd(Double.doubleToRawLongBits(d));
    }

    public final void zza(boolean bl) throws IOException {
        this.zza((byte)(bl ? 1 : 0));
    }

    public abstract void zzg(String var1) throws IOException;

    public abstract void zza(zzbb var1) throws IOException;

    public abstract void zzb(zzdo var1) throws IOException;

    abstract void zza(zzdo var1, zzef var2) throws IOException;

    public abstract void zza(byte var1) throws IOException;

    public abstract void write(byte[] var1, int var2, int var3) throws IOException;

    public static int zzg(int n, int n2) {
        return zzbn.zzr(n) + zzbn.zzs(n2);
    }

    public static int zzh(int n, int n2) {
        return zzbn.zzr(n) + zzbn.zzt(n2);
    }

    public static int zzi(int n, int n2) {
        return zzbn.zzr(n) + zzbn.zzt(zzbn.zzy(n2));
    }

    public static int zzj(int n, int n2) {
        return zzbn.zzr(n) + 4;
    }

    public static int zzk(int n, int n2) {
        return zzbn.zzr(n) + 4;
    }

    public static int zzd(int n, long l) {
        return zzbn.zzr(n) + zzbn.zzf(l);
    }

    public static int zze(int n, long l) {
        return zzbn.zzr(n) + zzbn.zzf(l);
    }

    public static int zzf(int n, long l) {
        return zzbn.zzr(n) + zzbn.zzf(zzbn.zzj(l));
    }

    public static int zzg(int n, long l) {
        return zzbn.zzr(n) + 8;
    }

    public static int zzh(int n, long l) {
        return zzbn.zzr(n) + 8;
    }

    public static int zzb(int n, float f) {
        return zzbn.zzr(n) + 4;
    }

    public static int zzb(int n, double d) {
        return zzbn.zzr(n) + 8;
    }

    public static int zzc(int n, boolean bl) {
        return zzbn.zzr(n) + 1;
    }

    public static int zzl(int n, int n2) {
        return zzbn.zzr(n) + zzbn.zzs(n2);
    }

    public static int zzb(int n, String string) {
        return zzbn.zzr(n) + zzbn.zzh(string);
    }

    public static int zzc(int n, zzbb zzbb2) {
        int n2 = zzbb2.size();
        return zzbn.zzr(n) + (zzbn.zzt(n2) + n2);
    }

    public static int zza(int n, zzcv zzcv2) {
        int n2 = zzcv2.zzas();
        return zzbn.zzr(n) + (zzbn.zzt(n2) + n2);
    }

    public static int zzc(int n, zzdo zzdo2) {
        return zzbn.zzr(n) + zzbn.zzc(zzdo2);
    }

    static int zzb(int n, zzdo zzdo2, zzef zzef2) {
        return zzbn.zzr(n) + zzbn.zzb(zzdo2, zzef2);
    }

    public static int zzd(int n, zzdo zzdo2) {
        return (zzbn.zzr(1) << 1) + zzbn.zzh(2, n) + zzbn.zzc(3, zzdo2);
    }

    public static int zzd(int n, zzbb zzbb2) {
        return (zzbn.zzr(1) << 1) + zzbn.zzh(2, n) + zzbn.zzc(3, zzbb2);
    }

    public static int zzb(int n, zzcv zzcv2) {
        return (zzbn.zzr(1) << 1) + zzbn.zzh(2, n) + zzbn.zza(3, zzcv2);
    }

    public static int zzr(int n) {
        return zzbn.zzt(n << 3);
    }

    public static int zzs(int n) {
        if (n >= 0) {
            return zzbn.zzt(n);
        }
        return 10;
    }

    public static int zzt(int n) {
        if ((n & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((n & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((n & 0xFFE00000) == 0) {
            return 3;
        }
        if ((n & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    public static int zzu(int n) {
        return zzbn.zzt(zzbn.zzy(n));
    }

    public static int zzv(int n) {
        return 4;
    }

    public static int zzw(int n) {
        return 4;
    }

    public static int zze(long l) {
        return zzbn.zzf(l);
    }

    public static int zzf(long l) {
        if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if (l < 0L) {
            return 10;
        }
        int n = 2;
        if ((l & 0xFFFFFFF800000000L) != 0L) {
            n += 4;
            l >>>= 28;
        }
        if ((l & 0xFFFFFFFFFFE00000L) != 0L) {
            n += 2;
            l >>>= 14;
        }
        if ((l & 0xFFFFFFFFFFFFC000L) != 0L) {
            ++n;
        }
        return n;
    }

    public static int zzg(long l) {
        return zzbn.zzf(zzbn.zzj(l));
    }

    public static int zzh(long l) {
        return 8;
    }

    public static int zzi(long l) {
        return 8;
    }

    public static int zzb(float f) {
        return 4;
    }

    public static int zzb(double d) {
        return 8;
    }

    public static int zzb(boolean bl) {
        return 1;
    }

    public static int zzx(int n) {
        return zzbn.zzs(n);
    }

    public static int zzh(String string) {
        int n;
        try {
            n = zzff.zza(string);
        }
        catch (zzfi zzfi2) {
            n = string.getBytes(zzci.UTF_8).length;
        }
        int n2 = n;
        return zzbn.zzt(n2) + n2;
    }

    public static int zza(zzcv zzcv2) {
        int n = zzcv2.zzas();
        return zzbn.zzt(n) + n;
    }

    public static int zzb(zzbb zzbb2) {
        int n = zzbb2.size();
        return zzbn.zzt(n) + n;
    }

    public static int zzd(byte[] byArray) {
        int n = byArray.length;
        return zzbn.zzt(n) + n;
    }

    public static int zzc(zzdo zzdo2) {
        int n = zzdo2.zzas();
        return zzbn.zzt(n) + n;
    }

    static int zzb(zzdo zzdo2, zzef zzef2) {
        zzef zzef3 = zzef2;
        zzas zzas2 = (zzas)zzdo2;
        int n = zzas2.zzs();
        if (n == -1) {
            n = zzef3.zzm(zzas2);
            zzas2.zzf(n);
        }
        int n2 = n;
        return zzbn.zzt(n2) + n2;
    }

    private static int zzy(int n) {
        return n << 1 ^ n >> 31;
    }

    private static long zzj(long l) {
        return l << 1 ^ l >> 63;
    }

    public abstract void flush() throws IOException;

    public abstract int zzag();

    abstract void zzd(byte[] var1, int var2, int var3) throws IOException;

    final void zza(String string, zzfi zzfi2) throws IOException {
        logger.logp(Level.WARNING, "com.google.protobuf.CodedOutputStream", "inefficientWriteStringNoTag", "Converting ill-formed UTF-16. Your Protocol Buffer will not round trip correctly!", zzfi2);
        byte[] byArray = string.getBytes(zzci.UTF_8);
        try {
            this.zzo(byArray.length);
            this.zza(byArray, 0, byArray.length);
            return;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new zzc(indexOutOfBoundsException);
        }
        catch (zzc zzc2) {
            throw zzc2;
        }
    }

    @Deprecated
    static int zzc(int n, zzdo zzdo2, zzef zzef2) {
        zzef zzef3;
        int n2 = zzbn.zzr(n) << 1;
        zzef zzef4 = zzef3 = zzef2;
        zzas zzas2 = (zzas)zzdo2;
        int n3 = zzas2.zzs();
        if (n3 == -1) {
            n3 = zzef4.zzm(zzas2);
            zzas2.zzf(n3);
        }
        return n2 + n3;
    }

    @Deprecated
    public static int zzd(zzdo zzdo2) {
        return zzdo2.zzas();
    }

    @Deprecated
    public static int zzz(int n) {
        return zzbn.zzt(n);
    }

    /* synthetic */ zzbn(zzbo zzbo2) {
        this();
    }

    static final class zze
    extends zzbn {
        private final ByteBuffer zzgc;
        private final ByteBuffer zzgd;
        private final long zzge;
        private final long zzgf;
        private final long zzgg;
        private final long zzgh;
        private long zzgi;

        zze(ByteBuffer byteBuffer) {
            super(null);
            this.zzgc = byteBuffer;
            this.zzgd = byteBuffer.duplicate().order(ByteOrder.LITTLE_ENDIAN);
            this.zzge = zzfd.zzb(byteBuffer);
            this.zzgf = this.zzge + (long)byteBuffer.position();
            this.zzgg = this.zzge + (long)byteBuffer.limit();
            this.zzgh = this.zzgg - 10L;
            this.zzgi = this.zzgf;
        }

        @Override
        public final void zzb(int n, int n2) throws IOException {
            int n3 = n2;
            ((zzbn)this).zzo(n << 3 | n3);
        }

        @Override
        public final void zzc(int n, int n2) throws IOException {
            ((zzbn)this).zzb(n, 0);
            ((zzbn)this).zzn(n2);
        }

        @Override
        public final void zzd(int n, int n2) throws IOException {
            ((zzbn)this).zzb(n, 0);
            ((zzbn)this).zzo(n2);
        }

        @Override
        public final void zzf(int n, int n2) throws IOException {
            ((zzbn)this).zzb(n, 5);
            ((zzbn)this).zzq(n2);
        }

        @Override
        public final void zza(int n, long l) throws IOException {
            ((zzbn)this).zzb(n, 0);
            ((zzbn)this).zzb(l);
        }

        @Override
        public final void zzc(int n, long l) throws IOException {
            ((zzbn)this).zzb(n, 1);
            ((zzbn)this).zzd(l);
        }

        @Override
        public final void zzb(int n, boolean bl) throws IOException {
            ((zzbn)this).zzb(n, 0);
            ((zzbn)this).zza((byte)(bl ? 1 : 0));
        }

        @Override
        public final void zza(int n, String string) throws IOException {
            ((zzbn)this).zzb(n, 2);
            ((zzbn)this).zzg(string);
        }

        @Override
        public final void zza(int n, zzbb zzbb2) throws IOException {
            ((zzbn)this).zzb(n, 2);
            ((zzbn)this).zza(zzbb2);
        }

        @Override
        public final void zza(int n, zzdo zzdo2) throws IOException {
            ((zzbn)this).zzb(n, 2);
            ((zzbn)this).zzb(zzdo2);
        }

        @Override
        final void zza(int n, zzdo zzdo2, zzef zzef2) throws IOException {
            ((zzbn)this).zzb(n, 2);
            ((zzbn)this).zza(zzdo2, zzef2);
        }

        @Override
        public final void zzb(int n, zzdo zzdo2) throws IOException {
            ((zzbn)this).zzb(1, 3);
            ((zzbn)this).zzd(2, n);
            ((zzbn)this).zza(3, zzdo2);
            ((zzbn)this).zzb(1, 4);
        }

        @Override
        public final void zzb(int n, zzbb zzbb2) throws IOException {
            ((zzbn)this).zzb(1, 3);
            ((zzbn)this).zzd(2, n);
            ((zzbn)this).zza(3, zzbb2);
            ((zzbn)this).zzb(1, 4);
        }

        @Override
        public final void zzb(zzdo zzdo2) throws IOException {
            ((zzbn)this).zzo(zzdo2.zzas());
            zzdo2.zzb(this);
        }

        @Override
        final void zza(zzdo zzdo2, zzef zzef2) throws IOException {
            zzef zzef3 = zzef2;
            zzas zzas2 = (zzas)zzdo2;
            int n = zzas2.zzs();
            if (n == -1) {
                n = zzef3.zzm(zzas2);
                zzas2.zzf(n);
            }
            ((zzbn)this).zzo(n);
            zzef2.zza(zzdo2, this.zzfz);
        }

        @Override
        public final void zza(byte by) throws IOException {
            if (this.zzgi >= this.zzgg) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.zzgi, this.zzgg, 1));
            }
            zzfd.zza(this.zzgi++, by);
        }

        @Override
        public final void zza(zzbb zzbb2) throws IOException {
            ((zzbn)this).zzo(zzbb2.size());
            zzbb2.zza(this);
        }

        @Override
        public final void zzd(byte[] byArray, int n, int n2) throws IOException {
            ((zzbn)this).zzo(n2);
            ((zzbn)this).write(byArray, 0, n2);
        }

        @Override
        public final void zzn(int n) throws IOException {
            if (n >= 0) {
                ((zzbn)this).zzo(n);
                return;
            }
            ((zzbn)this).zzb(n);
        }

        @Override
        public final void zzo(int n) throws IOException {
            if (this.zzgi <= this.zzgh) {
                while (true) {
                    if ((n & 0xFFFFFF80) == 0) {
                        zzfd.zza(this.zzgi++, (byte)n);
                        return;
                    }
                    zzfd.zza(this.zzgi++, (byte)(n & 0x7F | 0x80));
                    n >>>= 7;
                }
            }
            while (this.zzgi < this.zzgg) {
                if ((n & 0xFFFFFF80) == 0) {
                    zzfd.zza(this.zzgi++, (byte)n);
                    return;
                }
                zzfd.zza(this.zzgi++, (byte)(n & 0x7F | 0x80));
                n >>>= 7;
            }
            throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.zzgi, this.zzgg, 1));
        }

        @Override
        public final void zzq(int n) throws IOException {
            long l = this.zzgi;
            zze zze2 = this;
            this.zzgd.putInt((int)(l - zze2.zzge), n);
            this.zzgi += 4L;
        }

        @Override
        public final void zzb(long l) throws IOException {
            if (this.zzgi <= this.zzgh) {
                while (true) {
                    if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        zzfd.zza(this.zzgi++, (byte)l);
                        return;
                    }
                    zzfd.zza(this.zzgi++, (byte)((int)l & 0x7F | 0x80));
                    l >>>= 7;
                }
            }
            while (this.zzgi < this.zzgg) {
                if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                    zzfd.zza(this.zzgi++, (byte)l);
                    return;
                }
                zzfd.zza(this.zzgi++, (byte)((int)l & 0x7F | 0x80));
                l >>>= 7;
            }
            throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.zzgi, this.zzgg, 1));
        }

        @Override
        public final void zzd(long l) throws IOException {
            long l2 = this.zzgi;
            zze zze2 = this;
            this.zzgd.putLong((int)(l2 - zze2.zzge), l);
            this.zzgi += 8L;
        }

        @Override
        public final void write(byte[] byArray, int n, int n2) throws IOException {
            if (byArray == null || n < 0 || n2 < 0 || byArray.length - n2 < n || this.zzgg - (long)n2 < this.zzgi) {
                if (byArray == null) {
                    throw new NullPointerException("value");
                }
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.zzgi, this.zzgg, n2));
            }
            zzfd.zza(byArray, n, this.zzgi, n2);
            this.zzgi += (long)n2;
        }

        @Override
        public final void zza(byte[] byArray, int n, int n2) throws IOException {
            ((zzbn)this).write(byArray, n, n2);
        }

        @Override
        public final void zzg(String string) throws IOException {
            long l = this.zzgi;
            try {
                int n = zze.zzt(string.length() * 3);
                int n2 = zze.zzt(string.length());
                if (n2 == n) {
                    long l2 = this.zzgi;
                    zze zze2 = this;
                    int n3 = (int)(l2 - zze2.zzge) + n2;
                    this.zzgd.position(n3);
                    zzff.zza(string, this.zzgd);
                    int n4 = this.zzgd.position() - n3;
                    ((zzbn)this).zzo(n4);
                    this.zzgi += (long)n4;
                    return;
                }
                int n5 = zzff.zza(string);
                ((zzbn)this).zzo(n5);
                this.zzk(this.zzgi);
                zzff.zza(string, this.zzgd);
                this.zzgi += (long)n5;
                return;
            }
            catch (zzfi zzfi2) {
                this.zzgi = l;
                this.zzk(this.zzgi);
                this.zza(string, zzfi2);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new zzc(illegalArgumentException);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(indexOutOfBoundsException);
            }
        }

        @Override
        public final void flush() {
            long l = this.zzgi;
            zze zze2 = this;
            this.zzgc.position((int)(l - zze2.zzge));
        }

        @Override
        public final int zzag() {
            return (int)(this.zzgg - this.zzgi);
        }

        private final void zzk(long l) {
            long l2 = l;
            zze zze2 = this;
            this.zzgd.position((int)(l2 - zze2.zzge));
        }
    }

    static final class zzd
    extends zzbn {
        private final ByteBuffer zzgc;
        private final ByteBuffer zzgd;
        private final int zzgb;

        zzd(ByteBuffer byteBuffer) {
            super(null);
            this.zzgc = byteBuffer;
            this.zzgd = byteBuffer.duplicate().order(ByteOrder.LITTLE_ENDIAN);
            this.zzgb = byteBuffer.position();
        }

        @Override
        public final void zzb(int n, int n2) throws IOException {
            int n3 = n2;
            ((zzbn)this).zzo(n << 3 | n3);
        }

        @Override
        public final void zzc(int n, int n2) throws IOException {
            ((zzbn)this).zzb(n, 0);
            ((zzbn)this).zzn(n2);
        }

        @Override
        public final void zzd(int n, int n2) throws IOException {
            ((zzbn)this).zzb(n, 0);
            ((zzbn)this).zzo(n2);
        }

        @Override
        public final void zzf(int n, int n2) throws IOException {
            ((zzbn)this).zzb(n, 5);
            ((zzbn)this).zzq(n2);
        }

        @Override
        public final void zza(int n, long l) throws IOException {
            ((zzbn)this).zzb(n, 0);
            ((zzbn)this).zzb(l);
        }

        @Override
        public final void zzc(int n, long l) throws IOException {
            ((zzbn)this).zzb(n, 1);
            ((zzbn)this).zzd(l);
        }

        @Override
        public final void zzb(int n, boolean bl) throws IOException {
            ((zzbn)this).zzb(n, 0);
            ((zzbn)this).zza((byte)(bl ? 1 : 0));
        }

        @Override
        public final void zza(int n, String string) throws IOException {
            ((zzbn)this).zzb(n, 2);
            ((zzbn)this).zzg(string);
        }

        @Override
        public final void zza(int n, zzbb zzbb2) throws IOException {
            ((zzbn)this).zzb(n, 2);
            ((zzbn)this).zza(zzbb2);
        }

        @Override
        public final void zza(int n, zzdo zzdo2) throws IOException {
            ((zzbn)this).zzb(n, 2);
            ((zzbn)this).zzb(zzdo2);
        }

        @Override
        final void zza(int n, zzdo zzdo2, zzef zzef2) throws IOException {
            ((zzbn)this).zzb(n, 2);
            ((zzbn)this).zza(zzdo2, zzef2);
        }

        @Override
        public final void zzb(int n, zzdo zzdo2) throws IOException {
            ((zzbn)this).zzb(1, 3);
            ((zzbn)this).zzd(2, n);
            ((zzbn)this).zza(3, zzdo2);
            ((zzbn)this).zzb(1, 4);
        }

        @Override
        public final void zzb(int n, zzbb zzbb2) throws IOException {
            ((zzbn)this).zzb(1, 3);
            ((zzbn)this).zzd(2, n);
            ((zzbn)this).zza(3, zzbb2);
            ((zzbn)this).zzb(1, 4);
        }

        @Override
        public final void zzb(zzdo zzdo2) throws IOException {
            ((zzbn)this).zzo(zzdo2.zzas());
            zzdo2.zzb(this);
        }

        @Override
        final void zza(zzdo zzdo2, zzef zzef2) throws IOException {
            zzef zzef3 = zzef2;
            zzas zzas2 = (zzas)zzdo2;
            int n = zzas2.zzs();
            if (n == -1) {
                n = zzef3.zzm(zzas2);
                zzas2.zzf(n);
            }
            ((zzbn)this).zzo(n);
            zzef2.zza(zzdo2, this.zzfz);
        }

        @Override
        public final void zza(byte by) throws IOException {
            try {
                this.zzgd.put(by);
                return;
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzc(bufferOverflowException);
            }
        }

        @Override
        public final void zza(zzbb zzbb2) throws IOException {
            ((zzbn)this).zzo(zzbb2.size());
            zzbb2.zza(this);
        }

        @Override
        public final void zzd(byte[] byArray, int n, int n2) throws IOException {
            ((zzbn)this).zzo(n2);
            ((zzbn)this).write(byArray, 0, n2);
        }

        @Override
        public final void zzn(int n) throws IOException {
            if (n >= 0) {
                ((zzbn)this).zzo(n);
                return;
            }
            ((zzbn)this).zzb(n);
        }

        @Override
        public final void zzo(int n) throws IOException {
            try {
                while (true) {
                    if ((n & 0xFFFFFF80) == 0) {
                        this.zzgd.put((byte)n);
                        return;
                    }
                    this.zzgd.put((byte)(n & 0x7F | 0x80));
                    n >>>= 7;
                }
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzc(bufferOverflowException);
            }
        }

        @Override
        public final void zzq(int n) throws IOException {
            try {
                this.zzgd.putInt(n);
                return;
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzc(bufferOverflowException);
            }
        }

        @Override
        public final void zzb(long l) throws IOException {
            try {
                while (true) {
                    if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        this.zzgd.put((byte)l);
                        return;
                    }
                    this.zzgd.put((byte)((int)l & 0x7F | 0x80));
                    l >>>= 7;
                }
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzc(bufferOverflowException);
            }
        }

        @Override
        public final void zzd(long l) throws IOException {
            try {
                this.zzgd.putLong(l);
                return;
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzc(bufferOverflowException);
            }
        }

        @Override
        public final void write(byte[] byArray, int n, int n2) throws IOException {
            try {
                this.zzgd.put(byArray, n, n2);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(indexOutOfBoundsException);
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzc(bufferOverflowException);
            }
        }

        @Override
        public final void zza(byte[] byArray, int n, int n2) throws IOException {
            ((zzbn)this).write(byArray, n, n2);
        }

        @Override
        public final void zzg(String string) throws IOException {
            int n = this.zzgd.position();
            try {
                int n2 = zzd.zzt(string.length() * 3);
                int n3 = zzd.zzt(string.length());
                if (n3 == n2) {
                    int n4 = this.zzgd.position() + n3;
                    this.zzgd.position(n4);
                    this.zzi(string);
                    int n5 = this.zzgd.position();
                    this.zzgd.position(n);
                    ((zzbn)this).zzo(n5 - n4);
                    this.zzgd.position(n5);
                    return;
                }
                int n6 = zzff.zza(string);
                ((zzbn)this).zzo(n6);
                this.zzi(string);
                return;
            }
            catch (zzfi zzfi2) {
                this.zzgd.position(n);
                this.zza(string, zzfi2);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new zzc(illegalArgumentException);
            }
        }

        @Override
        public final void flush() {
            this.zzgc.position(this.zzgd.position());
        }

        @Override
        public final int zzag() {
            return this.zzgd.remaining();
        }

        private final void zzi(String string) throws IOException {
            try {
                zzff.zza(string, this.zzgd);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(indexOutOfBoundsException);
            }
        }
    }

    static final class zzb
    extends zza {
        private final ByteBuffer zzga;
        private int zzgb;

        zzb(ByteBuffer byteBuffer) {
            super(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
            this.zzga = byteBuffer;
            this.zzgb = byteBuffer.position();
        }

        @Override
        public final void flush() {
            this.zzga.position(this.zzgb + this.zzai());
        }
    }

    static class zza
    extends zzbn {
        private final byte[] buffer;
        private final int offset;
        private final int limit;
        private int position;

        zza(byte[] byArray, int n, int n2) {
            super(null);
            if (byArray == null) {
                throw new NullPointerException("buffer");
            }
            if ((n | n2 | byArray.length - (n + n2)) < 0) {
                throw new IllegalArgumentException(String.format("Array range is invalid. Buffer.length=%d, offset=%d, length=%d", byArray.length, n, n2));
            }
            this.buffer = byArray;
            this.offset = n;
            this.position = n;
            this.limit = n + n2;
        }

        @Override
        public final void zzb(int n, int n2) throws IOException {
            int n3 = n2;
            ((zzbn)this).zzo(n << 3 | n3);
        }

        @Override
        public final void zzc(int n, int n2) throws IOException {
            ((zzbn)this).zzb(n, 0);
            ((zzbn)this).zzn(n2);
        }

        @Override
        public final void zzd(int n, int n2) throws IOException {
            ((zzbn)this).zzb(n, 0);
            ((zzbn)this).zzo(n2);
        }

        @Override
        public final void zzf(int n, int n2) throws IOException {
            ((zzbn)this).zzb(n, 5);
            ((zzbn)this).zzq(n2);
        }

        @Override
        public final void zza(int n, long l) throws IOException {
            ((zzbn)this).zzb(n, 0);
            ((zzbn)this).zzb(l);
        }

        @Override
        public final void zzc(int n, long l) throws IOException {
            ((zzbn)this).zzb(n, 1);
            ((zzbn)this).zzd(l);
        }

        @Override
        public final void zzb(int n, boolean bl) throws IOException {
            ((zzbn)this).zzb(n, 0);
            ((zzbn)this).zza((byte)(bl ? 1 : 0));
        }

        @Override
        public final void zza(int n, String string) throws IOException {
            ((zzbn)this).zzb(n, 2);
            ((zzbn)this).zzg(string);
        }

        @Override
        public final void zza(int n, zzbb zzbb2) throws IOException {
            ((zzbn)this).zzb(n, 2);
            ((zzbn)this).zza(zzbb2);
        }

        @Override
        public final void zza(zzbb zzbb2) throws IOException {
            ((zzbn)this).zzo(zzbb2.size());
            zzbb2.zza(this);
        }

        @Override
        public final void zzd(byte[] byArray, int n, int n2) throws IOException {
            ((zzbn)this).zzo(n2);
            ((zzbn)this).write(byArray, 0, n2);
        }

        @Override
        public final void zza(int n, zzdo zzdo2) throws IOException {
            ((zzbn)this).zzb(n, 2);
            ((zzbn)this).zzb(zzdo2);
        }

        @Override
        final void zza(int n, zzdo zzdo2, zzef zzef2) throws IOException {
            ((zzbn)this).zzb(n, 2);
            zzef zzef3 = zzef2;
            zzas zzas2 = (zzas)zzdo2;
            int n2 = zzas2.zzs();
            if (n2 == -1) {
                n2 = zzef3.zzm(zzas2);
                zzas2.zzf(n2);
            }
            ((zzbn)this).zzo(n2);
            zzef2.zza(zzdo2, this.zzfz);
        }

        @Override
        public final void zzb(int n, zzdo zzdo2) throws IOException {
            ((zzbn)this).zzb(1, 3);
            ((zzbn)this).zzd(2, n);
            ((zzbn)this).zza(3, zzdo2);
            ((zzbn)this).zzb(1, 4);
        }

        @Override
        public final void zzb(int n, zzbb zzbb2) throws IOException {
            ((zzbn)this).zzb(1, 3);
            ((zzbn)this).zzd(2, n);
            ((zzbn)this).zza(3, zzbb2);
            ((zzbn)this).zzb(1, 4);
        }

        @Override
        public final void zzb(zzdo zzdo2) throws IOException {
            ((zzbn)this).zzo(zzdo2.zzas());
            zzdo2.zzb(this);
        }

        @Override
        final void zza(zzdo zzdo2, zzef zzef2) throws IOException {
            zzef zzef3 = zzef2;
            zzas zzas2 = (zzas)zzdo2;
            int n = zzas2.zzs();
            if (n == -1) {
                n = zzef3.zzm(zzas2);
                zzas2.zzf(n);
            }
            ((zzbn)this).zzo(n);
            zzef2.zza(zzdo2, this.zzfz);
        }

        @Override
        public final void zza(byte by) throws IOException {
            try {
                this.buffer[this.position++] = by;
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zzn(int n) throws IOException {
            if (n >= 0) {
                ((zzbn)this).zzo(n);
                return;
            }
            ((zzbn)this).zzb(n);
        }

        @Override
        public final void zzo(int n) throws IOException {
            if (zzfy && ((zzbn)this).zzag() >= 10) {
                while (true) {
                    if ((n & 0xFFFFFF80) == 0) {
                        zzfd.zza(this.buffer, (long)this.position++, (byte)n);
                        return;
                    }
                    zzfd.zza(this.buffer, (long)this.position++, (byte)(n & 0x7F | 0x80));
                    n >>>= 7;
                }
            }
            try {
                while (true) {
                    if ((n & 0xFFFFFF80) == 0) {
                        this.buffer[this.position++] = (byte)n;
                        return;
                    }
                    this.buffer[this.position++] = (byte)(n & 0x7F | 0x80);
                    n >>>= 7;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zzq(int n) throws IOException {
            try {
                this.buffer[this.position++] = (byte)n;
                this.buffer[this.position++] = (byte)(n >> 8);
                this.buffer[this.position++] = (byte)(n >> 16);
                this.buffer[this.position++] = n >> 24;
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zzb(long l) throws IOException {
            if (zzfy && ((zzbn)this).zzag() >= 10) {
                while (true) {
                    if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        zzfd.zza(this.buffer, (long)this.position++, (byte)l);
                        return;
                    }
                    zzfd.zza(this.buffer, (long)this.position++, (byte)((int)l & 0x7F | 0x80));
                    l >>>= 7;
                }
            }
            try {
                while (true) {
                    if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        this.buffer[this.position++] = (byte)l;
                        return;
                    }
                    this.buffer[this.position++] = (byte)((int)l & 0x7F | 0x80);
                    l >>>= 7;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zzd(long l) throws IOException {
            try {
                this.buffer[this.position++] = (byte)l;
                this.buffer[this.position++] = (byte)(l >> 8);
                this.buffer[this.position++] = (byte)(l >> 16);
                this.buffer[this.position++] = (byte)(l >> 24);
                this.buffer[this.position++] = (byte)(l >> 32);
                this.buffer[this.position++] = (byte)(l >> 40);
                this.buffer[this.position++] = (byte)(l >> 48);
                this.buffer[this.position++] = (byte)(l >> 56);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void write(byte[] byArray, int n, int n2) throws IOException {
            try {
                System.arraycopy(byArray, n, this.buffer, this.position, n2);
                this.position += n2;
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, n2), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zza(byte[] byArray, int n, int n2) throws IOException {
            ((zzbn)this).write(byArray, n, n2);
        }

        @Override
        public final void zzg(String string) throws IOException {
            int n = this.position;
            try {
                int n2 = zza.zzt(string.length() * 3);
                int n3 = zza.zzt(string.length());
                if (n3 == n2) {
                    this.position = n + n3;
                    int n4 = zzff.zza(string, this.buffer, this.position, ((zzbn)this).zzag());
                    this.position = n;
                    int n5 = n4 - n - n3;
                    ((zzbn)this).zzo(n5);
                    this.position = n4;
                    return;
                }
                int n6 = zzff.zza(string);
                ((zzbn)this).zzo(n6);
                this.position = zzff.zza(string, this.buffer, this.position, ((zzbn)this).zzag());
                return;
            }
            catch (zzfi zzfi2) {
                this.position = n;
                this.zza(string, zzfi2);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(indexOutOfBoundsException);
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public final int zzag() {
            return this.limit - this.position;
        }

        public final int zzai() {
            return this.position - this.offset;
        }
    }

    public static final class zzc
    extends IOException {
        zzc() {
            super("CodedOutputStream was writing to a flat byte array and ran out of space.");
        }

        zzc(String string) {
            String string2 = String.valueOf("CodedOutputStream was writing to a flat byte array and ran out of space.: ");
            String string3 = String.valueOf(string);
            super(string3.length() != 0 ? string2.concat(string3) : new String(string2));
        }

        zzc(Throwable throwable) {
            super("CodedOutputStream was writing to a flat byte array and ran out of space.", throwable);
        }

        zzc(String string, Throwable throwable) {
            String string2 = String.valueOf("CodedOutputStream was writing to a flat byte array and ran out of space.: ");
            String string3 = String.valueOf(string);
            super(string3.length() != 0 ? string2.concat(string3) : new String(string2), throwable);
        }
    }
}

