/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cloudmessaging;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.google.android.gms.cloudmessaging.CloudMessage;
import com.google.android.gms.cloudmessaging.zzf;
import com.google.android.gms.cloudmessaging.zzu;
import com.google.android.gms.common.util.concurrent.NamedThreadFactory;
import com.google.android.gms.internal.cloudmessaging.zze;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import java.lang.ref.SoftReference;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public abstract class CloudMessagingReceiver
extends BroadcastReceiver {
    @Nullable
    private static SoftReference zza;

    @WorkerThread
    protected abstract int onMessageReceive(@NonNull Context var1, @NonNull CloudMessage var2);

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    protected Executor getBroadcastExecutor() {
        Class<CloudMessagingReceiver> clazz = CloudMessagingReceiver.class;
        synchronized (clazz) {
            Object object = zza;
            object = object != null ? (ExecutorService)((SoftReference)object).get() : null;
            if (object != null) return object;
            zze.zza();
            object = new NamedThreadFactory("firebase-iid-executor");
            object = Executors.unconfigurableExecutorService(Executors.newCachedThreadPool((ThreadFactory)object));
            zza = new SoftReference<Object>(object);
            return object;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    @WorkerThread
    protected void onNotificationDismissed(@NonNull Context context, @NonNull Bundle bundle) {
    }

    /*
     * WARNING - void declaration
     */
    public final void onReceive(@NonNull Context context, @NonNull Intent intent) {
        void var1_1;
        void var2_2;
        if (intent == null) {
            return;
        }
        boolean bl = this.isOrderedBroadcast();
        BroadcastReceiver.PendingResult pendingResult = this.goAsync();
        this.getBroadcastExecutor().execute(new zzf(this, (Intent)var2_2, (Context)var1_1, bl, pendingResult));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    private final int zzb(@NonNull Context context, @NonNull Intent intent) {
        if (intent.getExtras() == null) {
            return 500;
        }
        CloudMessage cloudMessage = new CloudMessage(intent);
        if (TextUtils.isEmpty((CharSequence)cloudMessage.getMessageId())) {
            intent = Tasks.forResult(null);
        } else {
            intent = new Bundle();
            Object object = cloudMessage.getMessageId();
            intent.putString("google.message_id", (String)object);
            object = cloudMessage.zza();
            if (object != null) {
                intent.putInt("google.product_id", ((Integer)object).intValue());
            }
            intent.putBoolean("supports_message_handled", true);
            intent = zzu.zzb(context).zzc(2, (Bundle)intent);
        }
        int n = this.onMessageReceive(context, cloudMessage);
        try {
            long l = TimeUnit.SECONDS.toMillis(1L);
            Tasks.await((Task)intent, (long)l, (TimeUnit)TimeUnit.MILLISECONDS);
            return n;
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            String string = "Message ack failed: ".concat(((Object)exception).toString());
            Log.w((String)"CloudMessagingReceiver", (String)string);
            return n;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    private final int zzc(@NonNull Context context, @NonNull Intent object) {
        String string;
        PendingIntent pendingIntent = (PendingIntent)object.getParcelableExtra("pending_intent");
        if (pendingIntent != null) {
            try {
                pendingIntent.send();
            }
            catch (PendingIntent.CanceledException canceledException) {
                Log.e((String)"CloudMessagingReceiver", (String)"Notification pending intent canceled");
            }
        }
        if ((pendingIntent = object.getExtras()) != null) {
            pendingIntent.remove("pending_intent");
        } else {
            pendingIntent = new Bundle();
        }
        if ((object = object.getAction()) == (string = "com.google.firebase.messaging.NOTIFICATION_DISMISS") || object != null && object.equals(string)) {
            this.onNotificationDismissed(context, (Bundle)pendingIntent);
            return -1;
        }
        Log.e((String)"CloudMessagingReceiver", (String)"Unknown notification action");
        return 500;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final /* synthetic */ void zza(Intent intent, Context context, boolean bl, BroadcastReceiver.PendingResult pendingResult) {
        block3: {
            try {
                Object object = intent.getParcelableExtra("wrapped_intent");
                boolean bl2 = object instanceof Intent;
                object = bl2 ? (Intent)object : null;
                int n = object != null ? this.zzc(context, (Intent)object) : this.zzb(context, intent);
                if (!bl) break block3;
                pendingResult.setResultCode(n);
            }
            catch (Throwable throwable) {
                pendingResult.finish();
                throw throwable;
            }
        }
        pendingResult.finish();
    }

    public static final class IntentKeys {
        @NonNull
        public static final String PENDING_INTENT = "pending_intent";
        @NonNull
        public static final String WRAPPED_INTENT = "wrapped_intent";

        private IntentKeys() {
        }
    }

    public static final class IntentActionKeys {
        @NonNull
        public static final String NOTIFICATION_OPEN = "com.google.firebase.messaging.NOTIFICATION_OPEN";
        @NonNull
        public static final String NOTIFICATION_DISMISS = "com.google.firebase.messaging.NOTIFICATION_DISMISS";

        private IntentActionKeys() {
        }
    }
}

