/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.events;

import android.os.IBinder;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.RemoteException;
import android.text.TextUtils;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.util.zzo;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.MetadataChangeSet;
import com.google.android.gms.drive.events.ResourceEvent;
import com.google.android.gms.drive.events.zzg;
import com.google.android.gms.drive.metadata.internal.MetadataBundle;
import com.google.android.gms.internal.zzahp;
import com.google.android.gms.internal.zzain;
import com.google.android.gms.internal.zzalh;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public final class CompletionEvent
extends zza
implements ResourceEvent {
    public static final int STATUS_SUCCESS = 0;
    public static final int STATUS_FAILURE = 1;
    public static final int STATUS_CONFLICT = 2;
    public static final int STATUS_CANCELED = 3;
    public static final Parcelable.Creator<CompletionEvent> CREATOR = new zzg();
    final int mVersionCode;
    final DriveId zzaJj;
    final String zzaht;
    final ParcelFileDescriptor zzaKm;
    final ParcelFileDescriptor zzaKn;
    final MetadataBundle zzaKo;
    final List<String> zzaKp;
    final int zzJh;
    final IBinder zzaKq;
    private boolean zzaKr = false;
    private boolean zzaKs = false;
    private boolean zzaKt = false;

    CompletionEvent(int n, DriveId driveId, String string, ParcelFileDescriptor parcelFileDescriptor, ParcelFileDescriptor parcelFileDescriptor2, MetadataBundle metadataBundle, List<String> list, int n2, IBinder iBinder) {
        this.mVersionCode = n;
        this.zzaJj = driveId;
        this.zzaht = string;
        this.zzaKm = parcelFileDescriptor;
        this.zzaKn = parcelFileDescriptor2;
        this.zzaKo = metadataBundle;
        this.zzaKp = list;
        this.zzJh = n2;
        this.zzaKq = iBinder;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzg.zza(this, parcel, n | 1);
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public DriveId getDriveId() {
        this.zzzY();
        return this.zzaJj;
    }

    public String getAccountName() {
        this.zzzY();
        return this.zzaht;
    }

    public InputStream getBaseContentsInputStream() {
        this.zzzY();
        if (this.zzaKm == null) {
            return null;
        }
        if (this.zzaKr) {
            throw new IllegalStateException("getBaseInputStream() can only be called once per CompletionEvent instance.");
        }
        this.zzaKr = true;
        return new FileInputStream(this.zzaKm.getFileDescriptor());
    }

    public InputStream getModifiedContentsInputStream() {
        this.zzzY();
        if (this.zzaKn == null) {
            return null;
        }
        if (this.zzaKs) {
            throw new IllegalStateException("getModifiedInputStream() can only be called once per CompletionEvent instance.");
        }
        this.zzaKs = true;
        return new FileInputStream(this.zzaKn.getFileDescriptor());
    }

    public MetadataChangeSet getModifiedMetadataChangeSet() {
        this.zzzY();
        return this.zzaKo != null ? new MetadataChangeSet(this.zzaKo) : null;
    }

    public List<String> getTrackingTags() {
        this.zzzY();
        return new ArrayList<String>(this.zzaKp);
    }

    public int getStatus() {
        this.zzzY();
        return this.zzJh;
    }

    public void dismiss() {
        this.zzy(false);
    }

    public void snooze() {
        this.zzy(true);
    }

    private void zzy(boolean bl) {
        this.zzzY();
        this.zzaKt = true;
        zzo.zza((ParcelFileDescriptor)this.zzaKm);
        zzo.zza((ParcelFileDescriptor)this.zzaKn);
        if (this.zzaKo != null && this.zzaKo.zzc(zzalh.zzaOf)) {
            this.zzaKo.zza(zzalh.zzaOf).release();
        }
        if (this.zzaKq == null) {
            String string = String.valueOf(bl ? "snooze" : "dismiss");
            zzahp.zzF("CompletionEvent", string.length() != 0 ? "No callback on ".concat(string) : new String("No callback on "));
            return;
        }
        try {
            zzain.zza.zzbO(this.zzaKq).zzy(bl);
        }
        catch (RemoteException remoteException) {
            String string = bl ? "snooze" : "dismiss";
            String string2 = String.valueOf((Object)remoteException);
            zzahp.zzF("CompletionEvent", new StringBuilder(21 + String.valueOf(string).length() + String.valueOf(string2).length()).append("RemoteException on ").append(string).append(": ").append(string2).toString());
        }
    }

    private void zzzY() {
        if (this.zzaKt) {
            throw new IllegalStateException("Event has already been dismissed or snoozed.");
        }
    }

    public String toString() {
        String string;
        if (this.zzaKp == null) {
            string = "<null>";
        } else {
            String string2 = String.valueOf(TextUtils.join((CharSequence)"','", this.zzaKp));
            string = new StringBuilder(2 + String.valueOf(string2).length()).append("'").append(string2).append("'").toString();
        }
        String string3 = string;
        return String.format(Locale.US, "CompletionEvent [id=%s, status=%s, trackingTag=%s]", new Object[]{this.zzaJj, this.zzJh, string3});
    }
}

