/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.widget;

import android.content.Context;
import android.database.CursorIndexOutOfBoundsException;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;
import com.google.android.gms.common.data.DataBuffer;
import com.google.android.gms.internal.zzahp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DataBufferAdapter<T>
extends BaseAdapter {
    private final Context mContext;
    private final int zzaPY;
    private int zzaPZ;
    private final int zzaQa;
    private final List<DataBuffer<T>> zzaQb;
    private final LayoutInflater mInflater;
    private boolean zzaQc = true;

    public DataBufferAdapter(Context context, int n, int n2, List<DataBuffer<T>> list) {
        this.mContext = context;
        this.zzaPY = this.zzaPZ = n;
        this.zzaQa = n2;
        this.zzaQb = list;
        this.mInflater = (LayoutInflater)context.getSystemService("layout_inflater");
    }

    public DataBufferAdapter(Context context, int n, int n2) {
        this(context, n, n2, new ArrayList<DataBuffer<T>>());
    }

    public DataBufferAdapter(Context context, int n, List<DataBuffer<T>> list) {
        this(context, n, 0, list);
    }

    public DataBufferAdapter(Context context, int n) {
        this(context, n, 0, new ArrayList<DataBuffer<T>>());
    }

    public DataBufferAdapter(Context context, int n, int n2, DataBuffer<T> ... dataBufferArray) {
        this(context, n, n2, Arrays.asList(dataBufferArray));
    }

    public DataBufferAdapter(Context context, int n, DataBuffer<T> ... dataBufferArray) {
        this(context, n, 0, Arrays.asList(dataBufferArray));
    }

    public void append(DataBuffer<T> dataBuffer) {
        this.zzaQb.add(dataBuffer);
        if (this.zzaQc) {
            this.notifyDataSetChanged();
        }
    }

    public void clear() {
        for (DataBuffer<T> dataBuffer : this.zzaQb) {
            dataBuffer.release();
        }
        this.zzaQb.clear();
        if (this.zzaQc) {
            this.notifyDataSetChanged();
        }
    }

    public void notifyDataSetChanged() {
        super.notifyDataSetChanged();
        this.zzaQc = true;
    }

    public void setNotifyOnChange(boolean bl) {
        this.zzaQc = bl;
    }

    public Context getContext() {
        return this.mContext;
    }

    public int getCount() {
        int n = 0;
        for (DataBuffer<T> dataBuffer : this.zzaQb) {
            n += dataBuffer.getCount();
        }
        return n;
    }

    public T getItem(int n) throws CursorIndexOutOfBoundsException {
        int n2 = n;
        for (DataBuffer<T> dataBuffer : this.zzaQb) {
            int n3 = dataBuffer.getCount();
            if (n3 <= n2) {
                n2 -= n3;
                continue;
            }
            try {
                return (T)dataBuffer.get(n2);
            }
            catch (CursorIndexOutOfBoundsException cursorIndexOutOfBoundsException) {
                throw new CursorIndexOutOfBoundsException(n, this.getCount());
            }
        }
        throw new CursorIndexOutOfBoundsException(n, this.getCount());
    }

    public long getItemId(int n) {
        return n;
    }

    private View zza(int n, View view, ViewGroup viewGroup, int n2) {
        TextView textView;
        View view2 = view == null ? this.mInflater.inflate(n2, viewGroup, false) : view;
        try {
            textView = this.zzaQa == 0 ? (TextView)view2 : (TextView)view2.findViewById(this.zzaQa);
        }
        catch (ClassCastException classCastException) {
            zzahp.zza("DataBufferAdapter", classCastException, "You must supply a resource ID for a TextView");
            throw new IllegalStateException("DataBufferAdapter requires the resource ID to be a TextView", classCastException);
        }
        T t = this.getItem(n);
        if (t instanceof CharSequence) {
            textView.setText((CharSequence)t);
        } else {
            textView.setText((CharSequence)t.toString());
        }
        return view2;
    }

    public View getView(int n, View view, ViewGroup viewGroup) {
        return this.zza(n, view, viewGroup, this.zzaPY);
    }

    public View getDropDownView(int n, View view, ViewGroup viewGroup) {
        return this.zza(n, view, viewGroup, this.zzaPZ);
    }

    public void setDropDownViewResource(int n) {
        this.zzaPZ = n;
    }
}

