/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.SuppressLint;
import android.os.RemoteException;
import com.google.android.gms.common.api.BooleanResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.drive.CreateFileActivityBuilder;
import com.google.android.gms.drive.Drive;
import com.google.android.gms.drive.DriveApi;
import com.google.android.gms.drive.DriveContents;
import com.google.android.gms.drive.DriveFile;
import com.google.android.gms.drive.DriveFolder;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.MetadataBuffer;
import com.google.android.gms.drive.OpenFileActivityBuilder;
import com.google.android.gms.drive.query.Query;
import com.google.android.gms.internal.zzagh;
import com.google.android.gms.internal.zzagu;
import com.google.android.gms.internal.zzahd;
import com.google.android.gms.internal.zzahj;
import com.google.android.gms.internal.zzahk;
import com.google.android.gms.internal.zzahl;
import com.google.android.gms.internal.zzahm;
import com.google.android.gms.internal.zzaho;
import com.google.android.gms.internal.zzaie;
import com.google.android.gms.internal.zzail;
import com.google.android.gms.internal.zzaiu;
import com.google.android.gms.internal.zzaja;
import com.google.android.gms.internal.zzajg;
import com.google.android.gms.internal.zzajl;
import com.google.android.gms.internal.zzakd;
import com.google.android.gms.internal.zzakp;
import com.google.android.gms.internal.zzzv;
import java.util.List;

public class zzahi
implements DriveApi {
    @Override
    public PendingResult<DriveApi.MetadataBufferResult> query(GoogleApiClient googleApiClient, final Query query) {
        if (query == null) {
            throw new IllegalArgumentException("Query must be provided.");
        }
        return googleApiClient.zza((zzzv.zza)new zzh(this, googleApiClient){

            protected void zza(zzahk zzahk2) throws RemoteException {
                zzahk2.zzAi().zza(new zzakd(query), (zzail)new zzi((zzzv.zzb<DriveApi.MetadataBufferResult>)this));
            }
        });
    }

    @Override
    public PendingResult<DriveApi.DriveContentsResult> newDriveContents(GoogleApiClient googleApiClient) {
        return this.zzb(googleApiClient, 0x20000000);
    }

    public PendingResult<DriveApi.DriveContentsResult> zzb(GoogleApiClient googleApiClient, final int n) {
        return googleApiClient.zza((zzzv.zza)new zzc(this, googleApiClient){

            protected void zza(zzahk zzahk2) throws RemoteException {
                zzahk2.zzAi().zza(new zzagu(n), (zzail)new zza((zzzv.zzb<DriveApi.DriveContentsResult>)this));
            }
        });
    }

    @Override
    public PendingResult<DriveApi.DriveIdResult> fetchDriveId(GoogleApiClient googleApiClient, final String string) {
        return googleApiClient.zza((zzzv.zza)new zzf(this, googleApiClient){

            protected void zza(zzahk zzahk2) throws RemoteException {
                zzahk2.zzAi().zza(new zzaie(DriveId.zzdH(string), false), (zzail)new zzd((zzzv.zzb<DriveApi.DriveIdResult>)this));
            }
        });
    }

    @Override
    public DriveFile getFile(GoogleApiClient googleApiClient, DriveId driveId) {
        if (driveId == null) {
            throw new IllegalArgumentException("Id must be provided.");
        }
        if (!googleApiClient.isConnected()) {
            throw new IllegalStateException("Client must be connected");
        }
        return new zzahm(driveId);
    }

    @Override
    public DriveFolder getFolder(GoogleApiClient googleApiClient, DriveId driveId) {
        if (driveId == null) {
            throw new IllegalArgumentException("Id must be provided.");
        }
        if (!googleApiClient.isConnected()) {
            throw new IllegalStateException("Client must be connected");
        }
        return new zzaho(driveId);
    }

    @Override
    public DriveFolder getRootFolder(GoogleApiClient googleApiClient) {
        zzahk zzahk2 = (zzahk)googleApiClient.zza(Drive.zzahc);
        if (!zzahk2.zzAl()) {
            throw new IllegalStateException("Client is not yet connected");
        }
        DriveId driveId = zzahk2.zzAj();
        return driveId != null ? new zzaho(driveId) : null;
    }

    @Override
    public DriveFolder getAppFolder(GoogleApiClient googleApiClient) {
        zzahk zzahk2 = (zzahk)googleApiClient.zza(Drive.zzahc);
        if (!zzahk2.zzAl()) {
            throw new IllegalStateException("Client is not yet connected");
        }
        DriveId driveId = zzahk2.zzAk();
        return driveId != null ? new zzaho(driveId) : null;
    }

    @Override
    public PendingResult<Status> requestSync(GoogleApiClient googleApiClient) {
        return googleApiClient.zzb((zzzv.zza)new zzahj.zza(this, googleApiClient){

            protected void zza(zzahk zzahk2) throws RemoteException {
                zzahk2.zzAi().zza(new zzakp((zzzv.zzb<Status>)this));
            }
        });
    }

    @Override
    public PendingResult<BooleanResult> isAutobackupEnabled(GoogleApiClient googleApiClient) {
        return googleApiClient.zza((zzzv.zza)new zzahj<BooleanResult>(this, googleApiClient){

            protected void zza(zzahk zzahk2) throws RemoteException {
                final 5 var2_2 = this;
                zzahk2.zzAi().zze(new zzagh(this){

                    @Override
                    public void zzav(boolean bl) {
                        var2_2.zzb((Result)new BooleanResult(Status.zzayh, bl));
                    }
                });
            }

            protected BooleanResult zzL(Status status) {
                return new BooleanResult(status, false);
            }

            protected /* synthetic */ Result zzc(Status status) {
                return this.zzL(status);
            }
        });
    }

    @Override
    public OpenFileActivityBuilder newOpenFileActivityBuilder() {
        return new OpenFileActivityBuilder();
    }

    @Override
    public CreateFileActivityBuilder newCreateFileActivityBuilder() {
        return new CreateFileActivityBuilder();
    }

    @Override
    public PendingResult<Status> cancelPendingActions(GoogleApiClient googleApiClient, List<String> list) {
        zzahk zzahk2 = (zzahk)googleApiClient.zza(Drive.zzahc);
        return zzahk2.cancelPendingActions(googleApiClient, list);
    }

    private static class zzi
    extends zzagh {
        private final zzzv.zzb<DriveApi.MetadataBufferResult> zzaFq;

        public zzi(zzzv.zzb<DriveApi.MetadataBufferResult> zzb2) {
            this.zzaFq = zzb2;
        }

        @Override
        public void zza(zzajg zzajg2) throws RemoteException {
            MetadataBuffer metadataBuffer = new MetadataBuffer(zzajg2.zzAu());
            this.zzaFq.setResult((Object)new zzg(Status.zzayh, metadataBuffer, zzajg2.zzAv()));
        }

        @Override
        public void onError(Status status) throws RemoteException {
            this.zzaFq.setResult((Object)new zzg(status, null, false));
        }
    }

    static class zzg
    implements DriveApi.MetadataBufferResult {
        private final Status zzahq;
        private final MetadataBuffer zzaLp;
        private final boolean zzaLq;

        public zzg(Status status, MetadataBuffer metadataBuffer, boolean bl) {
            this.zzahq = status;
            this.zzaLp = metadataBuffer;
            this.zzaLq = bl;
        }

        public Status getStatus() {
            return this.zzahq;
        }

        @Override
        public MetadataBuffer getMetadataBuffer() {
            return this.zzaLp;
        }

        public void release() {
            if (this.zzaLp != null) {
                this.zzaLp.release();
            }
        }
    }

    static abstract class zzh
    extends zzahj<DriveApi.MetadataBufferResult> {
        zzh(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public DriveApi.MetadataBufferResult zzO(Status status) {
            return new zzg(status, null, false);
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzO(status);
        }
    }

    static class zzd
    extends zzagh {
        private final zzzv.zzb<DriveApi.DriveIdResult> zzaFq;

        public zzd(zzzv.zzb<DriveApi.DriveIdResult> zzb2) {
            this.zzaFq = zzb2;
        }

        @Override
        public void zza(zzajl zzajl2) throws RemoteException {
            this.zzaFq.setResult((Object)new zze(Status.zzayh, new zzahd(zzajl2.zzAx()).getDriveId()));
        }

        @Override
        public void zza(zzaja zzaja2) throws RemoteException {
            this.zzaFq.setResult((Object)new zze(Status.zzayh, zzaja2.getDriveId()));
        }

        @Override
        public void onError(Status status) throws RemoteException {
            this.zzaFq.setResult((Object)new zze(status, null));
        }
    }

    private static class zze
    implements DriveApi.DriveIdResult {
        private final Status zzahq;
        private final DriveId zzaJj;

        public zze(Status status, DriveId driveId) {
            this.zzahq = status;
            this.zzaJj = driveId;
        }

        public Status getStatus() {
            return this.zzahq;
        }

        @Override
        public DriveId getDriveId() {
            return this.zzaJj;
        }
    }

    static abstract class zzf
    extends zzahj<DriveApi.DriveIdResult> {
        zzf(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public DriveApi.DriveIdResult zzN(Status status) {
            return new zze(status, null);
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzN(status);
        }
    }

    private static class zza
    extends zzagh {
        private final zzzv.zzb<DriveApi.DriveContentsResult> zzaFq;

        public zza(zzzv.zzb<DriveApi.DriveContentsResult> zzb2) {
            this.zzaFq = zzb2;
        }

        @Override
        public void zza(zzaiu zzaiu2) throws RemoteException {
            this.zzaFq.setResult((Object)new zzb(Status.zzayh, new zzahl(zzaiu2.zzAo())));
        }

        @Override
        public void onError(Status status) throws RemoteException {
            this.zzaFq.setResult((Object)new zzb(status, null));
        }
    }

    static class zzb
    implements Releasable,
    DriveApi.DriveContentsResult {
        private final Status zzahq;
        private final DriveContents zzaJm;

        public zzb(Status status, DriveContents driveContents) {
            this.zzahq = status;
            this.zzaJm = driveContents;
        }

        public Status getStatus() {
            return this.zzahq;
        }

        @Override
        public DriveContents getDriveContents() {
            return this.zzaJm;
        }

        public void release() {
            if (this.zzaJm != null) {
                this.zzaJm.zzzC();
            }
        }
    }

    static abstract class zzc
    extends zzahj<DriveApi.DriveContentsResult> {
        zzc(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public DriveApi.DriveContentsResult zzM(Status status) {
            return new zzb(status, null);
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzM(status);
        }
    }

    @SuppressLint(value={"MissingRemoteException"})
    static class zzj
    extends zzahj.zza {
        zzj(GoogleApiClient googleApiClient, Status status) {
            super(googleApiClient);
            this.zzb((Result)status);
        }
    }
}

