/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Process;
import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.common.internal.zzl;
import com.google.android.gms.common.util.zzx;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.events.ChangeListener;
import com.google.android.gms.drive.events.zzd;
import com.google.android.gms.drive.events.zzi;
import com.google.android.gms.internal.zzagb;
import com.google.android.gms.internal.zzagi;
import com.google.android.gms.internal.zzahg;
import com.google.android.gms.internal.zzahi;
import com.google.android.gms.internal.zzahj;
import com.google.android.gms.internal.zzahv;
import com.google.android.gms.internal.zzaik;
import com.google.android.gms.internal.zzail;
import com.google.android.gms.internal.zzaim;
import com.google.android.gms.internal.zzakf;
import com.google.android.gms.internal.zzakp;
import com.google.android.gms.internal.zzzv;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class zzahk
extends zzl<zzaik> {
    private final String zzahp;
    private final Bundle zzaLr;
    private final boolean zzaLs;
    private volatile DriveId zzaLt;
    private volatile DriveId zzaLu;
    private volatile boolean zzaLv = false;
    final GoogleApiClient.ConnectionCallbacks zzaLw;
    final Map<DriveId, Map<ChangeListener, zzahv>> zzaLx = new HashMap<DriveId, Map<ChangeListener, zzahv>>();
    final Map<zzd, zzahv> zzaLy = new HashMap<zzd, zzahv>();
    final Map<DriveId, Map<Object, zzahv>> zzaLz = new HashMap<DriveId, Map<Object, zzahv>>();
    final Map<DriveId, Map<Object, zzahv>> zzaLA = new HashMap<DriveId, Map<Object, zzahv>>();

    public zzahk(Context context, Looper looper, zzg zzg2, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, Bundle bundle) {
        super(context, looper, 11, zzg2, connectionCallbacks, onConnectionFailedListener);
        this.zzahp = zzg2.zzxh();
        this.zzaLw = connectionCallbacks;
        this.zzaLr = bundle;
        Intent intent = new Intent("com.google.android.gms.drive.events.HANDLE_EVENT");
        intent.setPackage(context.getPackageName());
        List list = context.getPackageManager().queryIntentServices(intent, 0);
        switch (list.size()) {
            case 0: {
                this.zzaLs = false;
                break;
            }
            case 1: {
                ServiceInfo serviceInfo = ((ResolveInfo)list.get((int)0)).serviceInfo;
                if (!serviceInfo.exported) {
                    String string = String.valueOf(serviceInfo.name);
                    throw new IllegalStateException(new StringBuilder(60 + String.valueOf(string).length()).append("Drive event service ").append(string).append(" must be exported in AndroidManifest.xml").toString());
                }
                this.zzaLs = true;
                break;
            }
            default: {
                String string = String.valueOf(intent.getAction());
                throw new IllegalStateException(new StringBuilder(72 + String.valueOf(string).length()).append("AndroidManifest.xml can only define one service that handles the ").append(string).append(" action").toString());
            }
        }
    }

    public boolean zzqD() {
        return !this.getContext().getPackageName().equals(this.zzahp) || !this.zzAh();
    }

    public boolean zzwX() {
        return true;
    }

    boolean zzAh() {
        return zzx.zzf((Context)this.getContext(), (int)Process.myUid());
    }

    protected zzaik zzbK(IBinder iBinder) {
        return zzaik.zza.zzbL(iBinder);
    }

    protected String zzev() {
        return "com.google.android.gms.drive.internal.IDriveService";
    }

    protected Bundle zzql() {
        String string = this.getContext().getPackageName();
        zzac.zzw((Object)string);
        zzac.zzar((!this.zzxp().zzxf().isEmpty() ? 1 : 0) != 0);
        Bundle bundle = new Bundle();
        if (!string.equals(this.zzahp)) {
            bundle.putString("proxy_package_name", this.zzahp);
        }
        bundle.putAll(this.zzaLr);
        return bundle;
    }

    protected String zzeu() {
        return "com.google.android.gms.drive.ApiService.START";
    }

    public zzaik zzAi() throws DeadObjectException {
        return (zzaik)this.zzwW();
    }

    public DriveId zzAj() {
        return this.zzaLt;
    }

    public DriveId zzAk() {
        return this.zzaLu;
    }

    public boolean zzAl() {
        return this.zzaLv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        Map<Object, Object> map;
        if (this.isConnected()) {
            try {
                map = (zzaik)this.zzwW();
                map.zza(new zzahg());
            }
            catch (RemoteException remoteException) {}
        }
        super.disconnect();
        map = this.zzaLx;
        synchronized (map) {
            this.zzaLx.clear();
        }
        map = this.zzaLy;
        synchronized (map) {
            this.zzaLy.clear();
        }
        map = this.zzaLz;
        synchronized (map) {
            this.zzaLz.clear();
        }
        map = this.zzaLA;
        synchronized (map) {
            this.zzaLA.clear();
        }
    }

    protected void zza(int n, IBinder iBinder, Bundle bundle, int n2) {
        if (bundle != null) {
            bundle.setClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            this.zzaLt = (DriveId)bundle.getParcelable("com.google.android.gms.drive.root_id");
            this.zzaLu = (DriveId)bundle.getParcelable("com.google.android.gms.drive.appdata_id");
            this.zzaLv = true;
        }
        super.zza(n, iBinder, bundle, n2);
    }

    public boolean zzAm() {
        return this.zzaLs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PendingResult<Status> zza(GoogleApiClient googleApiClient, DriveId driveId, ChangeListener changeListener) {
        zzac.zzas((boolean)zzi.zza(1, driveId));
        zzac.zzb((Object)changeListener, (Object)"listener");
        zzac.zza((boolean)this.isConnected(), (Object)"Client must be connected");
        Map<DriveId, Map<ChangeListener, zzahv>> map = this.zzaLx;
        synchronized (map) {
            zzahv zzahv2;
            Map<ChangeListener, zzahv> map2 = this.zzaLx.get((Object)driveId);
            if (map2 == null) {
                map2 = new HashMap<ChangeListener, zzahv>();
                this.zzaLx.put(driveId, map2);
            }
            if ((zzahv2 = map2.get(changeListener)) == null) {
                zzahv2 = new zzahv(this.getLooper(), this.getContext(), 1, changeListener);
                map2.put(changeListener, zzahv2);
            } else if (zzahv2.zzeI(1)) {
                return new zzahi.zzj(googleApiClient, Status.zzayh);
            }
            zzahv2.zzeH(1);
            return this.zza(googleApiClient, new zzagb(1, driveId), zzahv2);
        }
    }

    private PendingResult<Status> zza(GoogleApiClient googleApiClient, final zzagb zzagb2, final zzahv zzahv2) {
        return googleApiClient.zzb((zzzv.zza)new zzahj.zza(this, googleApiClient){

            protected void zza(zzahk zzahk2) throws RemoteException {
                zzahk2.zzAi().zza(zzagb2, (zzaim)zzahv2, null, (zzail)new zzakp((zzzv.zzb<Status>)this));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PendingResult<Status> zzb(GoogleApiClient googleApiClient, DriveId driveId, ChangeListener changeListener) {
        zzac.zzas((boolean)zzi.zza(1, driveId));
        zzac.zza((boolean)this.isConnected(), (Object)"Client must be connected");
        zzac.zzb((Object)changeListener, (Object)"listener");
        Map<DriveId, Map<ChangeListener, zzahv>> map = this.zzaLx;
        synchronized (map) {
            Map<ChangeListener, zzahv> map2 = this.zzaLx.get((Object)driveId);
            if (map2 == null) {
                return new zzahi.zzj(googleApiClient, Status.zzayh);
            }
            zzahv zzahv2 = map2.remove(changeListener);
            if (zzahv2 == null) {
                return new zzahi.zzj(googleApiClient, Status.zzayh);
            }
            if (map2.isEmpty()) {
                this.zzaLx.remove((Object)driveId);
            }
            return this.zza(googleApiClient, new zzakf(driveId, 1), zzahv2);
        }
    }

    private PendingResult<Status> zza(GoogleApiClient googleApiClient, final zzakf zzakf2, final zzahv zzahv2) {
        return googleApiClient.zzb((zzzv.zza)new zzahj.zza(this, googleApiClient){

            protected void zza(zzahk zzahk2) throws RemoteException {
                zzahk2.zzAi().zza(zzakf2, (zzaim)zzahv2, null, (zzail)new zzakp((zzzv.zzb<Status>)this));
            }
        });
    }

    PendingResult<Status> zza(GoogleApiClient googleApiClient, DriveId driveId) {
        return this.zza(googleApiClient, new zzagb(1, driveId));
    }

    private PendingResult<Status> zza(GoogleApiClient googleApiClient, final zzagb zzagb2) {
        zzac.zzas((boolean)zzi.zza(zzagb2.getEventType(), zzagb2.getDriveId()));
        zzac.zza((boolean)this.isConnected(), (Object)"Client must be connected");
        if (!this.zzaLs) {
            throw new IllegalStateException("Application must define an exported DriveEventService subclass in AndroidManifest.xml to add event subscriptions");
        }
        return googleApiClient.zzb((zzzv.zza)new zzahj.zza(this, googleApiClient){

            protected void zza(zzahk zzahk2) throws RemoteException {
                zzahk2.zzAi().zza(zzagb2, null, null, (zzail)new zzakp((zzzv.zzb<Status>)this));
            }
        });
    }

    PendingResult<Status> zzb(GoogleApiClient googleApiClient, DriveId driveId) {
        return this.zza(googleApiClient, 1, driveId);
    }

    private PendingResult<Status> zza(GoogleApiClient googleApiClient, final int n, final DriveId driveId) {
        zzac.zzas((boolean)zzi.zza(n, driveId));
        zzac.zza((boolean)this.isConnected(), (Object)"Client must be connected");
        return googleApiClient.zzb((zzzv.zza)new zzahj.zza(this, googleApiClient){

            protected void zza(zzahk zzahk2) throws RemoteException {
                zzahk2.zzAi().zza(new zzakf(driveId, n), null, null, (zzail)new zzakp((zzzv.zzb<Status>)this));
            }
        });
    }

    PendingResult<Status> cancelPendingActions(GoogleApiClient googleApiClient, final List<String> list) {
        zzac.zzas((list != null ? 1 : 0) != 0);
        zzac.zzas((!list.isEmpty() ? 1 : 0) != 0);
        zzac.zza((boolean)this.isConnected(), (Object)"Client must be connected");
        return googleApiClient.zzb((zzzv.zza)new zzahj.zza(this, googleApiClient){

            protected void zza(zzahk zzahk2) throws RemoteException {
                zzahk2.zzAi().zza(new zzagi(list), (zzail)new zzakp((zzzv.zzb<Status>)this));
            }
        });
    }

    protected /* synthetic */ IInterface zzh(IBinder iBinder) {
        return this.zzbK(iBinder);
    }
}

