/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.drive.Drive;
import com.google.android.gms.drive.DriveApi;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.DriveResource;
import com.google.android.gms.drive.Metadata;
import com.google.android.gms.drive.MetadataBuffer;
import com.google.android.gms.drive.MetadataChangeSet;
import com.google.android.gms.drive.events.ChangeListener;
import com.google.android.gms.internal.zzaad;
import com.google.android.gms.internal.zzagu;
import com.google.android.gms.internal.zzahq;
import com.google.android.gms.internal.zzahr;
import com.google.android.gms.internal.zzahv;
import com.google.android.gms.internal.zzahw;
import com.google.android.gms.internal.zzahx;
import com.google.android.gms.internal.zzair;
import com.google.android.gms.internal.zzaiy;
import com.google.android.gms.internal.zzajb;
import com.google.android.gms.internal.zzajv;
import com.google.android.gms.internal.zzajy;
import com.google.android.gms.internal.zzala;
import com.google.android.gms.internal.zzalc;
import com.google.android.gms.internal.zzalh;
import com.google.android.gms.internal.zzall;
import com.google.android.gms.internal.zzaln;
import java.util.ArrayList;
import java.util.Set;

public class zzaie
implements DriveResource {
    protected final DriveId zzaKG;

    public zzaie(DriveId driveId) {
        this.zzaKG = driveId;
    }

    @Override
    public DriveId getDriveId() {
        return this.zzaKG;
    }

    @Override
    public PendingResult<DriveResource.MetadataResult> getMetadata(GoogleApiClient googleApiClient) {
        return this.zza(googleApiClient, false);
    }

    private PendingResult<DriveResource.MetadataResult> zza(GoogleApiClient googleApiClient, final boolean bl) {
        return googleApiClient.zza((zzaad.zza)new zzd(googleApiClient){

            protected void zza(zzahx zzahx2) throws RemoteException {
                zzahx2.zzAW().zza(new zzair(zzaie.this.zzaKG, bl), (zzaiy)new zzb((zzaad.zzb<DriveResource.MetadataResult>)this));
            }
        });
    }

    @Override
    public PendingResult<DriveApi.MetadataBufferResult> listParents(GoogleApiClient googleApiClient) {
        return googleApiClient.zza((zzaad.zza)new zzahv.zzh(googleApiClient){

            protected void zza(zzahx zzahx2) throws RemoteException {
                zzahx2.zzAW().zza(new zzajb(zzaie.this.zzaKG), (zzaiy)new zza((zzaad.zzb<DriveApi.MetadataBufferResult>)this));
            }
        });
    }

    @Override
    public PendingResult<Status> setParents(GoogleApiClient googleApiClient, Set<DriveId> set) {
        if (set == null) {
            throw new IllegalArgumentException("ParentIds must be provided.");
        }
        final ArrayList<DriveId> arrayList = new ArrayList<DriveId>(set);
        return googleApiClient.zzb((zzaad.zza)new zzahw.zza(googleApiClient){

            protected void zza(zzahx zzahx2) throws RemoteException {
                zzahx2.zzAW().zza(new zzala(zzaie.this.zzaKG, arrayList), (zzaiy)new zzalc((zzaad.zzb<Status>)this));
            }
        });
    }

    @Override
    public PendingResult<DriveResource.MetadataResult> updateMetadata(GoogleApiClient googleApiClient, final MetadataChangeSet metadataChangeSet) {
        if (metadataChangeSet == null) {
            throw new IllegalArgumentException("ChangeSet must be provided.");
        }
        return googleApiClient.zzb((zzaad.zza)new zzd(googleApiClient){

            protected void zza(zzahx zzahx2) throws RemoteException {
                metadataChangeSet.zzAD().setContext(zzahx2.getContext());
                zzahx2.zzAW().zza(new zzaln(zzaie.this.zzaKG, metadataChangeSet.zzAD()), (zzaiy)new zzb((zzaad.zzb<DriveResource.MetadataResult>)this));
            }
        });
    }

    @Override
    public PendingResult<Status> delete(GoogleApiClient googleApiClient) {
        return googleApiClient.zzb((zzaad.zza)new zzahw.zza(googleApiClient){

            protected void zza(zzahx zzahx2) throws RemoteException {
                zzahx2.zzAW().zza(new zzahr(zzaie.this.zzaKG), (zzaiy)new zzalc((zzaad.zzb<Status>)this));
            }
        });
    }

    @Override
    public PendingResult<Status> addChangeListener(GoogleApiClient googleApiClient, ChangeListener changeListener) {
        zzahx zzahx2 = (zzahx)googleApiClient.zza(Drive.zzaid);
        return zzahx2.zza(googleApiClient, this.zzaKG, changeListener);
    }

    @Override
    public PendingResult<Status> removeChangeListener(GoogleApiClient googleApiClient, ChangeListener changeListener) {
        zzahx zzahx2 = (zzahx)googleApiClient.zza(Drive.zzaid);
        return zzahx2.zzb(googleApiClient, this.zzaKG, changeListener);
    }

    @Override
    public PendingResult<Status> addChangeSubscription(GoogleApiClient googleApiClient) {
        zzahx zzahx2 = (zzahx)googleApiClient.zza(Drive.zzaid);
        return zzahx2.zza(googleApiClient, this.zzaKG);
    }

    @Override
    public PendingResult<Status> removeChangeSubscription(GoogleApiClient googleApiClient) {
        zzahx zzahx2 = (zzahx)googleApiClient.zza(Drive.zzaid);
        return zzahx2.zzb(googleApiClient, this.zzaKG);
    }

    @Override
    public PendingResult<Status> trash(GoogleApiClient googleApiClient) {
        return googleApiClient.zzb((zzaad.zza)new zzahw.zza(googleApiClient){

            protected void zza(zzahx zzahx2) throws RemoteException {
                zzahx2.zzAW().zza(new zzalh(zzaie.this.zzaKG), (zzaiy)new zzalc((zzaad.zzb<Status>)this));
            }
        });
    }

    @Override
    public PendingResult<Status> untrash(GoogleApiClient googleApiClient) {
        return googleApiClient.zzb((zzaad.zza)new zzahw.zza(googleApiClient){

            protected void zza(zzahx zzahx2) throws RemoteException {
                zzahx2.zzAW().zza(new zzall(zzaie.this.zzaKG), (zzaiy)new zzalc((zzaad.zzb<Status>)this));
            }
        });
    }

    private static class zza
    extends zzagu {
        private final zzaad.zzb<DriveApi.MetadataBufferResult> zzaGN;

        public zza(zzaad.zzb<DriveApi.MetadataBufferResult> zzb2) {
            this.zzaGN = zzb2;
        }

        @Override
        public void zza(zzajv zzajv2) throws RemoteException {
            MetadataBuffer metadataBuffer = new MetadataBuffer(zzajv2.zzBk());
            this.zzaGN.setResult((Object)new zzahv.zzg(Status.zzazx, metadataBuffer, false));
        }

        @Override
        public void onError(Status status) throws RemoteException {
            this.zzaGN.setResult((Object)new zzahv.zzg(status, null, false));
        }
    }

    private static class zzb
    extends zzagu {
        private final zzaad.zzb<DriveResource.MetadataResult> zzaGN;

        public zzb(zzaad.zzb<DriveResource.MetadataResult> zzb2) {
            this.zzaGN = zzb2;
        }

        @Override
        public void zza(zzajy zzajy2) throws RemoteException {
            this.zzaGN.setResult((Object)new zzc(Status.zzazx, new zzahq(zzajy2.zzBl())));
        }

        @Override
        public void onError(Status status) throws RemoteException {
            this.zzaGN.setResult((Object)new zzc(status, null));
        }
    }

    private static class zzc
    implements DriveResource.MetadataResult {
        private final Status zzair;
        private final Metadata zzaND;

        public zzc(Status status, Metadata metadata) {
            this.zzair = status;
            this.zzaND = metadata;
        }

        public Status getStatus() {
            return this.zzair;
        }

        @Override
        public Metadata getMetadata() {
            return this.zzaND;
        }
    }

    private abstract class zzd
    extends zzahw<DriveResource.MetadataResult> {
        private zzd(zzaie zzaie2, GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public DriveResource.MetadataResult zzT(Status status) {
            return new zzc(status, null);
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzT(status);
        }
    }
}

