/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Process;
import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.common.internal.zzl;
import com.google.android.gms.common.util.zzy;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.events.ChangeListener;
import com.google.android.gms.drive.events.zzd;
import com.google.android.gms.drive.events.zzi;
import com.google.android.gms.internal.zzaad;
import com.google.android.gms.internal.zzago;
import com.google.android.gms.internal.zzagv;
import com.google.android.gms.internal.zzaht;
import com.google.android.gms.internal.zzahv;
import com.google.android.gms.internal.zzahw;
import com.google.android.gms.internal.zzaii;
import com.google.android.gms.internal.zzaix;
import com.google.android.gms.internal.zzaiy;
import com.google.android.gms.internal.zzaiz;
import com.google.android.gms.internal.zzaks;
import com.google.android.gms.internal.zzalc;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class zzahx
extends zzl<zzaix> {
    private final String zzaiq;
    private final Bundle zzaMO;
    private final boolean zzaMP;
    private volatile DriveId zzaMQ;
    private volatile DriveId zzaMR;
    private volatile boolean zzaMS = false;
    final GoogleApiClient.ConnectionCallbacks zzaMT;
    final Map<DriveId, Map<ChangeListener, zzaii>> zzaMU = new HashMap<DriveId, Map<ChangeListener, zzaii>>();
    final Map<zzd, zzaii> zzaMV = new HashMap<zzd, zzaii>();
    final Map<DriveId, Map<Object, zzaii>> zzaMW = new HashMap<DriveId, Map<Object, zzaii>>();
    final Map<DriveId, Map<Object, zzaii>> zzaMX = new HashMap<DriveId, Map<Object, zzaii>>();

    public zzahx(Context context, Looper looper, zzg zzg2, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, Bundle bundle) {
        super(context, looper, 11, zzg2, connectionCallbacks, onConnectionFailedListener);
        this.zzaiq = zzg2.zzxO();
        this.zzaMT = connectionCallbacks;
        this.zzaMO = bundle;
        Intent intent = new Intent("com.google.android.gms.drive.events.HANDLE_EVENT");
        intent.setPackage(context.getPackageName());
        List list = context.getPackageManager().queryIntentServices(intent, 0);
        switch (list.size()) {
            case 0: {
                this.zzaMP = false;
                break;
            }
            case 1: {
                ServiceInfo serviceInfo = ((ResolveInfo)list.get((int)0)).serviceInfo;
                if (!serviceInfo.exported) {
                    String string = String.valueOf(serviceInfo.name);
                    throw new IllegalStateException(new StringBuilder(60 + String.valueOf(string).length()).append("Drive event service ").append(string).append(" must be exported in AndroidManifest.xml").toString());
                }
                this.zzaMP = true;
                break;
            }
            default: {
                String string = String.valueOf(intent.getAction());
                throw new IllegalStateException(new StringBuilder(72 + String.valueOf(string).length()).append("AndroidManifest.xml can only define one service that handles the ").append(string).append(" action").toString());
            }
        }
    }

    public boolean zzrd() {
        return !this.getContext().getPackageName().equals(this.zzaiq) || !this.zzAW();
    }

    public boolean zzxE() {
        return true;
    }

    boolean zzAW() {
        return zzy.zzf((Context)this.getContext(), (int)Process.myUid());
    }

    protected zzaix zzbK(IBinder iBinder) {
        return zzaix.zza.zzbL(iBinder);
    }

    protected String zzeA() {
        return "com.google.android.gms.drive.internal.IDriveService";
    }

    protected Bundle zzqL() {
        String string = this.getContext().getPackageName();
        zzac.zzw((Object)string);
        zzac.zzaw((!this.zzxW().zzxM().isEmpty() ? 1 : 0) != 0);
        Bundle bundle = new Bundle();
        if (!string.equals(this.zzaiq)) {
            bundle.putString("proxy_package_name", this.zzaiq);
        }
        bundle.putAll(this.zzaMO);
        return bundle;
    }

    protected String zzez() {
        return "com.google.android.gms.drive.ApiService.START";
    }

    public zzaix zzAX() throws DeadObjectException {
        return (zzaix)this.zzxD();
    }

    public DriveId zzAY() {
        return this.zzaMQ;
    }

    public DriveId zzAZ() {
        return this.zzaMR;
    }

    public boolean zzBa() {
        return this.zzaMS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        Map<Object, Object> map;
        if (this.isConnected()) {
            try {
                map = (zzaix)this.zzxD();
                map.zza(new zzaht());
            }
            catch (RemoteException remoteException) {}
        }
        super.disconnect();
        map = this.zzaMU;
        synchronized (map) {
            this.zzaMU.clear();
        }
        map = this.zzaMV;
        synchronized (map) {
            this.zzaMV.clear();
        }
        map = this.zzaMW;
        synchronized (map) {
            this.zzaMW.clear();
        }
        map = this.zzaMX;
        synchronized (map) {
            this.zzaMX.clear();
        }
    }

    protected void zza(int n, IBinder iBinder, Bundle bundle, int n2) {
        if (bundle != null) {
            bundle.setClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            this.zzaMQ = (DriveId)bundle.getParcelable("com.google.android.gms.drive.root_id");
            this.zzaMR = (DriveId)bundle.getParcelable("com.google.android.gms.drive.appdata_id");
            this.zzaMS = true;
        }
        super.zza(n, iBinder, bundle, n2);
    }

    public boolean zzBb() {
        return this.zzaMP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PendingResult<Status> zza(GoogleApiClient googleApiClient, DriveId driveId, ChangeListener changeListener) {
        zzac.zzax((boolean)zzi.zza(1, driveId));
        zzac.zzb((Object)changeListener, (Object)"listener");
        zzac.zza((boolean)this.isConnected(), (Object)"Client must be connected");
        Map<DriveId, Map<ChangeListener, zzaii>> map = this.zzaMU;
        synchronized (map) {
            zzaii zzaii2;
            Map<ChangeListener, zzaii> map2 = this.zzaMU.get((Object)driveId);
            if (map2 == null) {
                map2 = new HashMap<ChangeListener, zzaii>();
                this.zzaMU.put(driveId, map2);
            }
            if ((zzaii2 = map2.get(changeListener)) == null) {
                zzaii2 = new zzaii(this.getLooper(), this.getContext(), 1, changeListener);
                map2.put(changeListener, zzaii2);
            } else if (zzaii2.zzeR(1)) {
                return new zzahv.zzj(googleApiClient, Status.zzazx);
            }
            zzaii2.zzeQ(1);
            return this.zza(googleApiClient, new zzago(1, driveId), zzaii2);
        }
    }

    private PendingResult<Status> zza(GoogleApiClient googleApiClient, final zzago zzago2, final zzaii zzaii2) {
        return googleApiClient.zzb((zzaad.zza)new zzahw.zza(this, googleApiClient){

            protected void zza(zzahx zzahx2) throws RemoteException {
                zzahx2.zzAX().zza(zzago2, (zzaiz)zzaii2, null, (zzaiy)new zzalc((zzaad.zzb<Status>)this));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PendingResult<Status> zzb(GoogleApiClient googleApiClient, DriveId driveId, ChangeListener changeListener) {
        zzac.zzax((boolean)zzi.zza(1, driveId));
        zzac.zza((boolean)this.isConnected(), (Object)"Client must be connected");
        zzac.zzb((Object)changeListener, (Object)"listener");
        Map<DriveId, Map<ChangeListener, zzaii>> map = this.zzaMU;
        synchronized (map) {
            Map<ChangeListener, zzaii> map2 = this.zzaMU.get((Object)driveId);
            if (map2 == null) {
                return new zzahv.zzj(googleApiClient, Status.zzazx);
            }
            zzaii zzaii2 = map2.remove(changeListener);
            if (zzaii2 == null) {
                return new zzahv.zzj(googleApiClient, Status.zzazx);
            }
            if (map2.isEmpty()) {
                this.zzaMU.remove((Object)driveId);
            }
            return this.zza(googleApiClient, new zzaks(driveId, 1), zzaii2);
        }
    }

    private PendingResult<Status> zza(GoogleApiClient googleApiClient, final zzaks zzaks2, final zzaii zzaii2) {
        return googleApiClient.zzb((zzaad.zza)new zzahw.zza(this, googleApiClient){

            protected void zza(zzahx zzahx2) throws RemoteException {
                zzahx2.zzAX().zza(zzaks2, (zzaiz)zzaii2, null, (zzaiy)new zzalc((zzaad.zzb<Status>)this));
            }
        });
    }

    PendingResult<Status> zza(GoogleApiClient googleApiClient, DriveId driveId) {
        return this.zza(googleApiClient, new zzago(1, driveId));
    }

    private PendingResult<Status> zza(GoogleApiClient googleApiClient, final zzago zzago2) {
        zzac.zzax((boolean)zzi.zza(zzago2.getEventType(), zzago2.getDriveId()));
        zzac.zza((boolean)this.isConnected(), (Object)"Client must be connected");
        if (!this.zzaMP) {
            throw new IllegalStateException("Application must define an exported DriveEventService subclass in AndroidManifest.xml to add event subscriptions");
        }
        return googleApiClient.zzb((zzaad.zza)new zzahw.zza(this, googleApiClient){

            protected void zza(zzahx zzahx2) throws RemoteException {
                zzahx2.zzAX().zza(zzago2, null, null, (zzaiy)new zzalc((zzaad.zzb<Status>)this));
            }
        });
    }

    PendingResult<Status> zzb(GoogleApiClient googleApiClient, DriveId driveId) {
        return this.zza(googleApiClient, 1, driveId);
    }

    private PendingResult<Status> zza(GoogleApiClient googleApiClient, final int n, final DriveId driveId) {
        zzac.zzax((boolean)zzi.zza(n, driveId));
        zzac.zza((boolean)this.isConnected(), (Object)"Client must be connected");
        return googleApiClient.zzb((zzaad.zza)new zzahw.zza(this, googleApiClient){

            protected void zza(zzahx zzahx2) throws RemoteException {
                zzahx2.zzAX().zza(new zzaks(driveId, n), null, null, (zzaiy)new zzalc((zzaad.zzb<Status>)this));
            }
        });
    }

    PendingResult<Status> cancelPendingActions(GoogleApiClient googleApiClient, final List<String> list) {
        zzac.zzax((list != null ? 1 : 0) != 0);
        zzac.zzax((!list.isEmpty() ? 1 : 0) != 0);
        zzac.zza((boolean)this.isConnected(), (Object)"Client must be connected");
        return googleApiClient.zzb((zzaad.zza)new zzahw.zza(this, googleApiClient){

            protected void zza(zzahx zzahx2) throws RemoteException {
                zzahx2.zzAX().zza(new zzagv(list), (zzaiy)new zzalc((zzaad.zzb<Status>)this));
            }
        });
    }

    protected /* synthetic */ IInterface zzh(IBinder iBinder) {
        return this.zzbK(iBinder);
    }
}

