/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Base64;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.zzbr;
import com.google.android.gms.drive.DriveFile;
import com.google.android.gms.drive.DriveFolder;
import com.google.android.gms.drive.DriveResource;
import com.google.android.gms.drive.zzj;
import com.google.android.gms.internal.aie;
import com.google.android.gms.internal.aif;
import com.google.android.gms.internal.zzboe;
import com.google.android.gms.internal.zzboj;
import com.google.android.gms.internal.zzbos;
import com.google.android.gms.internal.zzboz;
import com.google.android.gms.internal.zzbsm;
import com.google.android.gms.internal.zzbsn;

public class DriveId
extends zza
implements ReflectedParcelable {
    public static final int RESOURCE_TYPE_UNKNOWN = -1;
    public static final int RESOURCE_TYPE_FILE = 0;
    public static final int RESOURCE_TYPE_FOLDER = 1;
    public static final Parcelable.Creator<DriveId> CREATOR = new zzj();
    private String zzaMl;
    private long zzaMm;
    private long zzaLU;
    private int zzaMn;
    private volatile String zzaLW = null;
    private volatile String zzaMo = null;

    public static DriveId zzcP(String string) {
        zzbr.zzu((Object)string);
        return new DriveId(string, -1L, -1L, -1);
    }

    public String getResourceId() {
        return this.zzaMl;
    }

    public int getResourceType() {
        return this.zzaMn;
    }

    public DriveFile asDriveFile() {
        if (this.zzaMn == 1) {
            throw new IllegalStateException("This DriveId corresponds to a folder. Call asDriveFolder instead.");
        }
        return new zzboe(this);
    }

    public DriveFolder asDriveFolder() {
        if (this.zzaMn == 0) {
            throw new IllegalStateException("This DriveId corresponds to a file. Call asDriveFile instead.");
        }
        return new zzboj(this);
    }

    public DriveResource asDriveResource() {
        if (this.zzaMn == 1) {
            return this.asDriveFolder();
        }
        if (this.zzaMn == 0) {
            return this.asDriveFile();
        }
        return new zzboz(this);
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        DriveId driveId = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)2, (String)driveId.zzaMl, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)3, (long)driveId.zzaMm);
        zzd.zza((Parcel)parcel2, (int)4, (long)driveId.zzaLU);
        zzd.zzc((Parcel)parcel2, (int)5, (int)driveId.zzaMn);
        zzd.zzI((Parcel)parcel2, (int)n2);
    }

    public DriveId(String string, long l, long l2, int n) {
        this.zzaMl = string;
        zzbr.zzaf((!"".equals(string) ? 1 : 0) != 0);
        zzbr.zzaf((string != null || l != -1L ? 1 : 0) != 0);
        this.zzaMm = l;
        this.zzaLU = l2;
        this.zzaMn = n;
    }

    public int hashCode() {
        if (this.zzaMm == -1L) {
            return this.zzaMl.hashCode();
        }
        String string = String.valueOf(String.valueOf(this.zzaLU));
        String string2 = String.valueOf(String.valueOf(this.zzaMm));
        return (string2.length() != 0 ? string.concat(string2) : new String(string)).hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof DriveId)) {
            return false;
        }
        DriveId driveId = (DriveId)((Object)object);
        if (driveId.zzaLU != this.zzaLU) {
            return false;
        }
        if (driveId.zzaMm == -1L && this.zzaMm == -1L) {
            return driveId.zzaMl.equals(this.zzaMl);
        }
        if (this.zzaMl == null || driveId.zzaMl == null) {
            return driveId.zzaMm == this.zzaMm;
        }
        if (driveId.zzaMm == this.zzaMm) {
            if (driveId.zzaMl.equals(this.zzaMl)) {
                return true;
            }
            zzbos.zzy("DriveId", "Unexpected unequal resourceId for same DriveId object.");
        }
        return false;
    }

    public final String encodeToString() {
        if (this.zzaLW == null) {
            DriveId driveId = this;
            zzbsm zzbsm2 = new zzbsm();
            new zzbsm().versionCode = 1;
            zzbsm2.zzaPC = driveId.zzaMl == null ? "" : driveId.zzaMl;
            zzbsm2.zzaPD = driveId.zzaMm;
            zzbsm2.zzaPA = driveId.zzaLU;
            zzbsm2.zzaPE = driveId.zzaMn;
            String string = Base64.encodeToString((byte[])aif.zzd((aif)zzbsm2), (int)10);
            String string2 = String.valueOf("DriveId:");
            String string3 = String.valueOf(string);
            this.zzaLW = string3.length() != 0 ? string2.concat(string3) : new String(string2);
        }
        return this.zzaLW;
    }

    public final String toInvariantString() {
        if (this.zzaMo == null) {
            DriveId driveId = this;
            zzbsn zzbsn2 = new zzbsn();
            new zzbsn().zzaPD = driveId.zzaMm;
            zzbsn2.zzaPA = driveId.zzaLU;
            byte[] byArray = aif.zzd((aif)zzbsn2);
            this.zzaMo = Base64.encodeToString((byte[])byArray, (int)10);
        }
        return this.zzaMo;
    }

    public String toString() {
        return this.encodeToString();
    }

    public static DriveId decodeFromString(String string) {
        String string2 = String.valueOf(string);
        zzbr.zzb((boolean)string.startsWith("DriveId:"), (Object)(string2.length() != 0 ? "Invalid DriveId: ".concat(string2) : new String("Invalid DriveId: ")));
        return DriveId.zzj(Base64.decode((String)string.substring(8), (int)10));
    }

    private static DriveId zzj(byte[] byArray) {
        zzbsm zzbsm2;
        try {
            byte[] byArray2 = byArray;
            zzbsm2 = (zzbsm)aif.zza((aif)new zzbsm(), (byte[])byArray2);
        }
        catch (aie aie2) {
            throw new IllegalArgumentException();
        }
        String string = "".equals(zzbsm2.zzaPC) ? null : zzbsm2.zzaPC;
        return new DriveId(string, zzbsm2.zzaPD, zzbsm2.zzaPA, zzbsm2.zzaPE);
    }
}

