/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive;

import com.google.android.gms.common.internal.zzbr;
import com.google.android.gms.drive.metadata.CustomPropertyKey;
import com.google.android.gms.drive.metadata.MetadataField;
import com.google.android.gms.drive.metadata.internal.AppVisibleCustomProperties;
import com.google.android.gms.drive.metadata.internal.MetadataBundle;
import com.google.android.gms.internal.zzbso;
import com.google.android.gms.internal.zzbtb;
import java.util.Collections;
import java.util.Date;
import java.util.Map;

public final class MetadataChangeSet {
    public static final int INDEXABLE_TEXT_SIZE_LIMIT_BYTES = 131072;
    public static final int CUSTOM_PROPERTY_SIZE_LIMIT_BYTES = 124;
    public static final int MAX_PUBLIC_PROPERTIES_PER_RESOURCE = 30;
    public static final int MAX_PRIVATE_PROPERTIES_PER_RESOURCE_PER_APP = 30;
    public static final int MAX_TOTAL_PROPERTIES_PER_RESOURCE = 100;
    public static final MetadataChangeSet zzaMD = new MetadataChangeSet(MetadataBundle.zzto());
    private final MetadataBundle zzaME;

    public MetadataChangeSet(MetadataBundle metadataBundle) {
        this.zzaME = metadataBundle.zztp();
    }

    public final Map<CustomPropertyKey, String> getCustomPropertyChangeMap() {
        AppVisibleCustomProperties appVisibleCustomProperties = this.zzaME.zza(zzbso.zzaPW);
        if (appVisibleCustomProperties == null) {
            return Collections.emptyMap();
        }
        return appVisibleCustomProperties.zztk();
    }

    public final String getDescription() {
        return this.zzaME.zza(zzbso.zzaPX);
    }

    public final String getIndexableText() {
        return this.zzaME.zza(zzbso.zzaQd);
    }

    public final Date getLastViewedByMeDate() {
        return this.zzaME.zza(zzbtb.zzaQN);
    }

    public final String getMimeType() {
        return this.zzaME.zza(zzbso.zzaQr);
    }

    public final String getTitle() {
        return this.zzaME.zza(zzbso.zzaQA);
    }

    public final Boolean isPinned() {
        return this.zzaME.zza(zzbso.zzaQj);
    }

    public final Boolean isStarred() {
        return this.zzaME.zza(zzbso.zzaQy);
    }

    public final Boolean isViewed() {
        return this.zzaME.zza(zzbso.zzaQq);
    }

    public final MetadataBundle zzsV() {
        return this.zzaME;
    }

    public final <T> MetadataChangeSet zza(MetadataField<T> metadataField, T t) {
        MetadataChangeSet metadataChangeSet = this;
        MetadataChangeSet metadataChangeSet2 = new MetadataChangeSet(metadataChangeSet.zzaME);
        metadataChangeSet2.zzaME.zzc(metadataField, t);
        return metadataChangeSet2;
    }

    public static class Builder {
        private final MetadataBundle zzaME = MetadataBundle.zzto();
        private AppVisibleCustomProperties.zza zzaMF;

        private final AppVisibleCustomProperties.zza zzsW() {
            if (this.zzaMF == null) {
                this.zzaMF = new AppVisibleCustomProperties.zza();
            }
            return this.zzaMF;
        }

        private static int zzcQ(String string) {
            if (string == null) {
                return 0;
            }
            return string.getBytes().length;
        }

        private static void zzi(String string, int n, int n2) {
            int n3 = n2;
            int n4 = n;
            String string2 = string;
            zzbr.zzb((n2 <= n ? 1 : 0) != 0, (Object)String.format("%s must be no more than %d bytes, but is %d bytes.", string2, n4, n3));
        }

        public Builder setCustomProperty(CustomPropertyKey customPropertyKey, String string) {
            zzbr.zzb((Object)((Object)customPropertyKey), (Object)"key");
            zzbr.zzb((Object)string, (Object)"value");
            int n = Builder.zzcQ(customPropertyKey.getKey()) + Builder.zzcQ(string);
            Builder.zzi("The total size of key string and value string of a custom property", 124, n);
            this.zzsW().zza(customPropertyKey, string);
            return this;
        }

        public Builder deleteCustomProperty(CustomPropertyKey customPropertyKey) {
            zzbr.zzb((Object)((Object)customPropertyKey), (Object)"key");
            this.zzsW().zza(customPropertyKey, null);
            return this;
        }

        public Builder setDescription(String string) {
            this.zzaME.zzc(zzbso.zzaPX, string);
            return this;
        }

        public Builder setIndexableText(String string) {
            int n = Builder.zzcQ(string);
            Builder.zzi("Indexable text size", 131072, n);
            this.zzaME.zzc(zzbso.zzaQd, string);
            return this;
        }

        public Builder setLastViewedByMeDate(Date date) {
            this.zzaME.zzc(zzbtb.zzaQN, date);
            return this;
        }

        public Builder setMimeType(String string) {
            this.zzaME.zzc(zzbso.zzaQr, string);
            return this;
        }

        public Builder setPinned(boolean bl) {
            this.zzaME.zzc(zzbso.zzaQj, bl);
            return this;
        }

        public Builder setStarred(boolean bl) {
            this.zzaME.zzc(zzbso.zzaQy, bl);
            return this;
        }

        public Builder setTitle(String string) {
            this.zzaME.zzc(zzbso.zzaQA, string);
            return this;
        }

        public Builder setViewed(boolean bl) {
            this.zzaME.zzc(zzbso.zzaQq, bl);
            return this;
        }

        public MetadataChangeSet build() {
            if (this.zzaMF != null) {
                this.zzaME.zzc(zzbso.zzaPW, this.zzaMF.zztl());
            }
            return new MetadataChangeSet(this.zzaME);
        }
    }
}

