/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.events;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.RemoteException;
import com.google.android.gms.common.util.zzy;
import com.google.android.gms.drive.events.ChangeEvent;
import com.google.android.gms.drive.events.ChangeListener;
import com.google.android.gms.drive.events.CompletionEvent;
import com.google.android.gms.drive.events.CompletionListener;
import com.google.android.gms.drive.events.DriveEvent;
import com.google.android.gms.drive.events.zzd;
import com.google.android.gms.drive.events.zzh;
import com.google.android.gms.drive.events.zzi;
import com.google.android.gms.drive.events.zzr;
import com.google.android.gms.internal.zzbos;
import com.google.android.gms.internal.zzbqd;
import com.google.android.gms.internal.zzbqt;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class DriveEventService
extends Service
implements ChangeListener,
CompletionListener,
zzd,
zzi {
    public static final String ACTION_HANDLE_EVENT = "com.google.android.gms.drive.events.HANDLE_EVENT";
    private final String mName;
    private CountDownLatch zzaNi;
    zza zzaNj;
    boolean zzaNk = false;
    private int zzaGI = -1;

    protected DriveEventService(String string) {
        this.mName = string;
    }

    protected DriveEventService() {
        this("DriveEventService");
    }

    public final synchronized IBinder onBind(Intent intent) {
        if (ACTION_HANDLE_EVENT.equals(intent.getAction())) {
            if (this.zzaNj == null && !this.zzaNk) {
                this.zzaNk = true;
                CountDownLatch countDownLatch = new CountDownLatch(1);
                this.zzaNi = new CountDownLatch(1);
                new zzh(this, countDownLatch).start();
                try {
                    if (!countDownLatch.await(5000L, TimeUnit.MILLISECONDS)) {
                        zzbos.zzz("DriveEventService", "Failed to synchronously initialize event handler.");
                    }
                }
                catch (InterruptedException interruptedException) {
                    throw new RuntimeException("Unable to start event handler", interruptedException);
                }
            }
            return new zzb(this).asBinder();
        }
        return null;
    }

    public boolean onUnbind(Intent intent) {
        return true;
    }

    public synchronized void onDestroy() {
        zzbos.zzx("DriveEventService", "onDestroy");
        if (this.zzaNj != null) {
            Message message = this.zzaNj.zzsZ();
            this.zzaNj.sendMessage(message);
            this.zzaNj = null;
            try {
                if (!this.zzaNi.await(5000L, TimeUnit.MILLISECONDS)) {
                    zzbos.zzy("DriveEventService", "Failed to synchronously quit event handler. Will quit itself");
                }
            }
            catch (InterruptedException interruptedException) {}
            this.zzaNi = null;
        }
        super.onDestroy();
    }

    @Override
    public void onChange(ChangeEvent changeEvent) {
        String string = String.valueOf(changeEvent);
        zzbos.zzy(this.mName, new StringBuilder(24 + String.valueOf(string).length()).append("Unhandled change event: ").append(string).toString());
    }

    @Override
    public final void zza(com.google.android.gms.drive.events.zzb zzb2) {
        String string = String.valueOf(zzb2);
        zzbos.zzy(this.mName, new StringBuilder(35 + String.valueOf(string).length()).append("Unhandled changes available event: ").append(string).toString());
    }

    @Override
    public void onCompletion(CompletionEvent completionEvent) {
        String string = String.valueOf(completionEvent);
        zzbos.zzy(this.mName, new StringBuilder(28 + String.valueOf(string).length()).append("Unhandled completion event: ").append(string).toString());
    }

    protected int getCallingUid() {
        return Binder.getCallingUid();
    }

    private final void zza(zzbqt zzbqt2) {
        DriveEvent driveEvent = zzbqt2.zzti();
        String string = String.valueOf(driveEvent);
        zzbos.zzx("DriveEventService", new StringBuilder(20 + String.valueOf(string).length()).append("handleEventMessage: ").append(string).toString());
        try {
            switch (driveEvent.getType()) {
                case 1: {
                    this.onChange((ChangeEvent)driveEvent);
                    return;
                }
                case 2: {
                    this.onCompletion((CompletionEvent)driveEvent);
                    return;
                }
                case 4: {
                    this.zza((com.google.android.gms.drive.events.zzb)driveEvent);
                    return;
                }
                case 7: {
                    zzr zzr2 = (zzr)driveEvent;
                    String string2 = String.valueOf(zzr2);
                    zzbos.zzy(this.mName, new StringBuilder(32 + String.valueOf(string2).length()).append("Unhandled transfer state event: ").append(string2).toString());
                    return;
                }
            }
            string = String.valueOf(driveEvent);
            zzbos.zzy(this.mName, new StringBuilder(17 + String.valueOf(string).length()).append("Unhandled event: ").append(string).toString());
            return;
        }
        catch (Exception exception) {
            String string3 = String.valueOf(driveEvent);
            zzbos.zza(this.mName, exception, new StringBuilder(22 + String.valueOf(string3).length()).append("Error handling event: ").append(string3).toString());
            return;
        }
    }

    private final void zzsY() throws SecurityException {
        int n = this.getCallingUid();
        if (n == this.zzaGI) {
            return;
        }
        if (zzy.zzf((Context)this, (int)n)) {
            this.zzaGI = n;
            return;
        }
        throw new SecurityException("Caller is not GooglePlayServices");
    }

    static /* synthetic */ CountDownLatch zzb(DriveEventService driveEventService) {
        return driveEventService.zzaNi;
    }

    final class zzb
    extends zzbqd {
        private /* synthetic */ DriveEventService zzaNm;

        zzb(DriveEventService driveEventService) {
            this.zzaNm = driveEventService;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void zzc(zzbqt zzbqt2) throws RemoteException {
            DriveEventService driveEventService = this.zzaNm;
            synchronized (driveEventService) {
                String string = String.valueOf((Object)zzbqt2);
                zzbos.zzx("DriveEventService", new StringBuilder(9 + String.valueOf(string).length()).append("onEvent: ").append(string).toString());
                this.zzaNm.zzsY();
                if (this.zzaNm.zzaNj != null) {
                    string = this.zzaNm.zzaNj.zzb(zzbqt2);
                    this.zzaNm.zzaNj.sendMessage((Message)string);
                } else {
                    zzbos.zzz("DriveEventService", "Receiving event before initialize is completed.");
                }
                return;
            }
        }
    }

    final class zza
    extends Handler {
        private /* synthetic */ DriveEventService zzaNm;

        zza(DriveEventService driveEventService) {
            this.zzaNm = driveEventService;
        }

        private final Message zzb(zzbqt zzbqt2) {
            return this.obtainMessage(1, (Object)zzbqt2);
        }

        private final Message zzsZ() {
            return this.obtainMessage(2);
        }

        public final void handleMessage(Message message) {
            int n = message.what;
            zzbos.zzx("DriveEventService", new StringBuilder(38).append("handleMessage message type:").append(n).toString());
            switch (message.what) {
                case 1: {
                    this.zzaNm.zza((zzbqt)((Object)message.obj));
                    return;
                }
                case 2: {
                    this.getLooper().quit();
                    return;
                }
            }
            n = message.what;
            zzbos.zzy("DriveEventService", new StringBuilder(35).append("Unexpected message type:").append(n).toString());
        }
    }
}

