/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.events;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.RemoteException;
import com.google.android.gms.common.util.zzw;
import com.google.android.gms.drive.events.ChangeEvent;
import com.google.android.gms.drive.events.ChangeListener;
import com.google.android.gms.drive.events.CompletionEvent;
import com.google.android.gms.drive.events.CompletionListener;
import com.google.android.gms.drive.events.DriveEvent;
import com.google.android.gms.drive.events.zzd;
import com.google.android.gms.drive.events.zzh;
import com.google.android.gms.drive.events.zzi;
import com.google.android.gms.drive.events.zzr;
import com.google.android.gms.internal.zzbnf;
import com.google.android.gms.internal.zzboq;
import com.google.android.gms.internal.zzbpg;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class DriveEventService
extends Service
implements ChangeListener,
CompletionListener,
zzd,
zzi {
    public static final String ACTION_HANDLE_EVENT = "com.google.android.gms.drive.events.HANDLE_EVENT";
    private final String mName;
    private CountDownLatch zzaNe;
    zza zzaNf;
    boolean zzaNg = false;
    private int zzaGG = -1;

    protected DriveEventService(String string) {
        this.mName = string;
    }

    protected DriveEventService() {
        this("DriveEventService");
    }

    public final synchronized IBinder onBind(Intent intent) {
        if (ACTION_HANDLE_EVENT.equals(intent.getAction())) {
            if (this.zzaNf == null && !this.zzaNg) {
                this.zzaNg = true;
                CountDownLatch countDownLatch = new CountDownLatch(1);
                this.zzaNe = new CountDownLatch(1);
                new zzh(this, countDownLatch).start();
                try {
                    if (!countDownLatch.await(5000L, TimeUnit.MILLISECONDS)) {
                        zzbnf.zzz("DriveEventService", "Failed to synchronously initialize event handler.");
                    }
                }
                catch (InterruptedException interruptedException) {
                    throw new RuntimeException("Unable to start event handler", interruptedException);
                }
            }
            return new zzb(this).asBinder();
        }
        return null;
    }

    public boolean onUnbind(Intent intent) {
        return true;
    }

    public synchronized void onDestroy() {
        zzbnf.zzx("DriveEventService", "onDestroy");
        if (this.zzaNf != null) {
            Message message = this.zzaNf.zzta();
            this.zzaNf.sendMessage(message);
            this.zzaNf = null;
            try {
                if (!this.zzaNe.await(5000L, TimeUnit.MILLISECONDS)) {
                    zzbnf.zzy("DriveEventService", "Failed to synchronously quit event handler. Will quit itself");
                }
            }
            catch (InterruptedException interruptedException) {}
            this.zzaNe = null;
        }
        super.onDestroy();
    }

    @Override
    public void onChange(ChangeEvent changeEvent) {
        String string = String.valueOf(changeEvent);
        zzbnf.zzy(this.mName, new StringBuilder(24 + String.valueOf(string).length()).append("Unhandled change event: ").append(string).toString());
    }

    @Override
    public final void zza(com.google.android.gms.drive.events.zzb zzb2) {
        String string = String.valueOf(zzb2);
        zzbnf.zzy(this.mName, new StringBuilder(35 + String.valueOf(string).length()).append("Unhandled changes available event: ").append(string).toString());
    }

    @Override
    public void onCompletion(CompletionEvent completionEvent) {
        String string = String.valueOf(completionEvent);
        zzbnf.zzy(this.mName, new StringBuilder(28 + String.valueOf(string).length()).append("Unhandled completion event: ").append(string).toString());
    }

    protected int getCallingUid() {
        return Binder.getCallingUid();
    }

    private final void zza(zzbpg zzbpg2) {
        DriveEvent driveEvent = zzbpg2.zztj();
        String string = String.valueOf(driveEvent);
        zzbnf.zzx("DriveEventService", new StringBuilder(20 + String.valueOf(string).length()).append("handleEventMessage: ").append(string).toString());
        try {
            switch (driveEvent.getType()) {
                case 1: {
                    this.onChange((ChangeEvent)driveEvent);
                    return;
                }
                case 2: {
                    this.onCompletion((CompletionEvent)driveEvent);
                    return;
                }
                case 4: {
                    this.zza((com.google.android.gms.drive.events.zzb)driveEvent);
                    return;
                }
                case 7: {
                    zzr zzr2 = (zzr)driveEvent;
                    String string2 = String.valueOf(zzr2);
                    zzbnf.zzy(this.mName, new StringBuilder(32 + String.valueOf(string2).length()).append("Unhandled transfer state event: ").append(string2).toString());
                    return;
                }
            }
            string = String.valueOf(driveEvent);
            zzbnf.zzy(this.mName, new StringBuilder(17 + String.valueOf(string).length()).append("Unhandled event: ").append(string).toString());
            return;
        }
        catch (Exception exception) {
            String string3 = String.valueOf(driveEvent);
            zzbnf.zza(this.mName, exception, new StringBuilder(22 + String.valueOf(string3).length()).append("Error handling event: ").append(string3).toString());
            return;
        }
    }

    private final void zzsZ() throws SecurityException {
        int n = this.getCallingUid();
        if (n == this.zzaGG) {
            return;
        }
        if (zzw.zzf((Context)this, (int)n)) {
            this.zzaGG = n;
            return;
        }
        throw new SecurityException("Caller is not GooglePlayServices");
    }

    static /* synthetic */ CountDownLatch zzb(DriveEventService driveEventService) {
        return driveEventService.zzaNe;
    }

    final class zzb
    extends zzboq {
        private /* synthetic */ DriveEventService zzaNi;

        zzb(DriveEventService driveEventService) {
            this.zzaNi = driveEventService;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void zzc(zzbpg zzbpg2) throws RemoteException {
            DriveEventService driveEventService = this.zzaNi;
            synchronized (driveEventService) {
                String string = String.valueOf((Object)zzbpg2);
                zzbnf.zzx("DriveEventService", new StringBuilder(9 + String.valueOf(string).length()).append("onEvent: ").append(string).toString());
                this.zzaNi.zzsZ();
                if (this.zzaNi.zzaNf != null) {
                    string = this.zzaNi.zzaNf.zzb(zzbpg2);
                    this.zzaNi.zzaNf.sendMessage((Message)string);
                } else {
                    zzbnf.zzz("DriveEventService", "Receiving event before initialize is completed.");
                }
                return;
            }
        }
    }

    final class zza
    extends Handler {
        private /* synthetic */ DriveEventService zzaNi;

        zza(DriveEventService driveEventService) {
            this.zzaNi = driveEventService;
        }

        private final Message zzb(zzbpg zzbpg2) {
            return this.obtainMessage(1, (Object)zzbpg2);
        }

        private final Message zzta() {
            return this.obtainMessage(2);
        }

        public final void handleMessage(Message message) {
            int n = message.what;
            zzbnf.zzx("DriveEventService", new StringBuilder(38).append("handleMessage message type:").append(n).toString());
            switch (message.what) {
                case 1: {
                    this.zzaNi.zza((zzbpg)((Object)message.obj));
                    return;
                }
                case 2: {
                    this.getLooper().quit();
                    return;
                }
            }
            n = message.what;
            zzbnf.zzy("DriveEventService", new StringBuilder(35).append("Unexpected message type:").append(n).toString());
        }
    }
}

