/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.ParcelFileDescriptor;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.common.util.zzn;
import com.google.android.gms.drive.DriveApi;
import com.google.android.gms.drive.DriveContents;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.ExecutionOptions;
import com.google.android.gms.drive.MetadataChangeSet;
import com.google.android.gms.drive.zzc;
import com.google.android.gms.drive.zzp;
import com.google.android.gms.drive.zzr;
import com.google.android.gms.internal.zzbay;
import com.google.android.gms.internal.zzbmo;
import com.google.android.gms.internal.zzbmp;
import com.google.android.gms.internal.zzbmq;
import com.google.android.gms.internal.zzbmr;
import java.io.InputStream;
import java.io.OutputStream;

public final class zzbmn
implements DriveContents {
    private final zzc zzaOg;
    private boolean mClosed = false;
    private boolean zzaOh = false;
    private boolean zzaOi = false;

    public zzbmn(zzc zzc2) {
        this.zzaOg = (zzc)((Object)zzbo.zzu((Object)((Object)zzc2)));
    }

    @Override
    public final DriveId getDriveId() {
        return this.zzaOg.getDriveId();
    }

    @Override
    public final int getMode() {
        return this.zzaOg.getMode();
    }

    @Override
    public final ParcelFileDescriptor getParcelFileDescriptor() {
        if (this.mClosed) {
            throw new IllegalStateException("Contents have been closed, cannot access the output stream.");
        }
        return this.zzaOg.getParcelFileDescriptor();
    }

    @Override
    public final InputStream getInputStream() {
        if (this.mClosed) {
            throw new IllegalStateException("Contents have been closed, cannot access the input stream.");
        }
        if (this.zzaOg.getMode() != 0x10000000) {
            throw new IllegalStateException("getInputStream() can only be used with contents opened with MODE_READ_ONLY.");
        }
        if (this.zzaOh) {
            throw new IllegalStateException("getInputStream() can only be called once per Contents instance.");
        }
        this.zzaOh = true;
        return this.zzaOg.getInputStream();
    }

    @Override
    public final OutputStream getOutputStream() {
        if (this.mClosed) {
            throw new IllegalStateException("Contents have been closed, cannot access the output stream.");
        }
        if (this.zzaOg.getMode() != 0x20000000) {
            throw new IllegalStateException("getOutputStream() can only be used with contents opened with MODE_WRITE_ONLY.");
        }
        if (this.zzaOi) {
            throw new IllegalStateException("getOutputStream() can only be called once per Contents instance.");
        }
        this.zzaOi = true;
        return this.zzaOg.getOutputStream();
    }

    @Override
    public final PendingResult<DriveApi.DriveContentsResult> reopenForWrite(GoogleApiClient googleApiClient) {
        if (this.mClosed) {
            throw new IllegalStateException("DriveContents already closed.");
        }
        if (this.zzaOg.getMode() != 0x10000000) {
            throw new IllegalStateException("reopenForWrite can only be used with DriveContents opened with MODE_READ_ONLY.");
        }
        this.zzsN();
        return googleApiClient.zzd((zzbay)new zzbmo(this, googleApiClient));
    }

    @Override
    public final PendingResult<Status> commit(GoogleApiClient googleApiClient, MetadataChangeSet metadataChangeSet) {
        return this.zza(googleApiClient, metadataChangeSet, null);
    }

    @Override
    public final PendingResult<Status> commit(GoogleApiClient googleApiClient, MetadataChangeSet metadataChangeSet, ExecutionOptions executionOptions) {
        zzp zzp2;
        if (executionOptions == null) {
            zzp2 = null;
        } else {
            ExecutionOptions executionOptions2 = executionOptions;
            zzr zzr2 = new zzr();
            if (executionOptions2 != null) {
                zzr2.setConflictStrategy(executionOptions2.zzsR());
                zzr2.setNotifyOnCompletion(executionOptions2.zzsQ());
                String string = executionOptions2.zzsP();
                if (string != null) {
                    zzr2.setTrackingTag(string);
                }
            }
            zzp2 = (zzp)zzr2.build();
        }
        return this.zza(googleApiClient, metadataChangeSet, zzp2);
    }

    private final PendingResult<Status> zza(GoogleApiClient googleApiClient, MetadataChangeSet metadataChangeSet, zzp zzp2) {
        boolean bl;
        if (zzp2 == null) {
            zzp2 = (zzp)new zzr().build();
        }
        if (this.zzaOg.getMode() == 0x10000000) {
            throw new IllegalStateException("Cannot commit contents opened with MODE_READ_ONLY");
        }
        switch (zzp2.zzsR()) {
            case 1: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        if (bl && !this.zzaOg.zzsK()) {
            throw new IllegalStateException("DriveContents must be valid for conflict detection.");
        }
        zzp2.zze(googleApiClient);
        if (this.mClosed) {
            throw new IllegalStateException("DriveContents already closed.");
        }
        if (this.getDriveId() == null) {
            throw new IllegalStateException("Only DriveContents obtained through DriveFile.open can be committed.");
        }
        MetadataChangeSet metadataChangeSet2 = metadataChangeSet != null ? metadataChangeSet : MetadataChangeSet.zzaMz;
        zzp zzp3 = zzp2;
        this.zzsN();
        return googleApiClient.zze((zzbay)new zzbmp(this, googleApiClient, metadataChangeSet2, zzp3));
    }

    @Override
    public final void discard(GoogleApiClient googleApiClient) {
        if (this.mClosed) {
            throw new IllegalStateException("DriveContents already closed.");
        }
        this.zzsN();
        ((zzbmr)googleApiClient.zze((zzbay)new zzbmr(this, googleApiClient))).setResultCallback(new zzbmq(this));
    }

    @Override
    public final zzc zzsM() {
        return this.zzaOg;
    }

    @Override
    public final void zzsN() {
        zzn.zza((ParcelFileDescriptor)this.zzaOg.getParcelFileDescriptor());
        this.mClosed = true;
    }

    @Override
    public final boolean zzsO() {
        return this.mClosed;
    }

    static /* synthetic */ zzc zza(zzbmn zzbmn2) {
        return zzbmn2.zzaOg;
    }
}

