/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Base64;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.drive.DriveFile;
import com.google.android.gms.drive.DriveFolder;
import com.google.android.gms.drive.DriveResource;
import com.google.android.gms.drive.zzj;
import com.google.android.gms.internal.zzbjh;
import com.google.android.gms.internal.zzbjm;
import com.google.android.gms.internal.zzbjv;
import com.google.android.gms.internal.zzbkc;
import com.google.android.gms.internal.zzbnp;
import com.google.android.gms.internal.zzbnq;
import com.google.android.gms.internal.zzegn;
import com.google.android.gms.internal.zzego;

public class DriveId
extends zza
implements ReflectedParcelable {
    public static final int RESOURCE_TYPE_UNKNOWN = -1;
    public static final int RESOURCE_TYPE_FILE = 0;
    public static final int RESOURCE_TYPE_FOLDER = 1;
    public static final Parcelable.Creator<DriveId> CREATOR = new zzj();
    private String zzgdj;
    private long zzgdk;
    private long zzgcs;
    private int zzgdl;
    private volatile String zzgcu = null;
    private volatile String zzgdm = null;

    public static DriveId zzgo(String string) {
        zzbp.zzu((Object)string);
        return new DriveId(string, -1L, -1L, -1);
    }

    public String getResourceId() {
        return this.zzgdj;
    }

    public int getResourceType() {
        return this.zzgdl;
    }

    public DriveFile asDriveFile() {
        if (this.zzgdl == 1) {
            throw new IllegalStateException("This DriveId corresponds to a folder. Call asDriveFolder instead.");
        }
        return new zzbjh(this);
    }

    public DriveFolder asDriveFolder() {
        if (this.zzgdl == 0) {
            throw new IllegalStateException("This DriveId corresponds to a file. Call asDriveFile instead.");
        }
        return new zzbjm(this);
    }

    public DriveResource asDriveResource() {
        if (this.zzgdl == 1) {
            return this.asDriveFolder();
        }
        if (this.zzgdl == 0) {
            return this.asDriveFile();
        }
        return new zzbkc(this);
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        DriveId driveId = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)2, (String)driveId.zzgdj, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)3, (long)driveId.zzgdk);
        zzd.zza((Parcel)parcel2, (int)4, (long)driveId.zzgcs);
        zzd.zzc((Parcel)parcel2, (int)5, (int)driveId.zzgdl);
        zzd.zzai((Parcel)parcel2, (int)n2);
    }

    public DriveId(String string, long l, long l2, int n) {
        this.zzgdj = string;
        zzbp.zzbh((!"".equals(string) ? 1 : 0) != 0);
        zzbp.zzbh((string != null || l != -1L ? 1 : 0) != 0);
        this.zzgdk = l;
        this.zzgcs = l2;
        this.zzgdl = n;
    }

    public int hashCode() {
        if (this.zzgdk == -1L) {
            return this.zzgdj.hashCode();
        }
        String string = String.valueOf(String.valueOf(this.zzgcs));
        String string2 = String.valueOf(String.valueOf(this.zzgdk));
        return (string2.length() != 0 ? string.concat(string2) : new String(string)).hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof DriveId)) {
            return false;
        }
        DriveId driveId = (DriveId)((Object)object);
        if (driveId.zzgcs != this.zzgcs) {
            return false;
        }
        if (driveId.zzgdk == -1L && this.zzgdk == -1L) {
            return driveId.zzgdj.equals(this.zzgdj);
        }
        if (this.zzgdj == null || driveId.zzgdj == null) {
            return driveId.zzgdk == this.zzgdk;
        }
        if (driveId.zzgdk == this.zzgdk) {
            if (driveId.zzgdj.equals(this.zzgdj)) {
                return true;
            }
            zzbjv.zzy("DriveId", "Unexpected unequal resourceId for same DriveId object.");
        }
        return false;
    }

    public final String encodeToString() {
        if (this.zzgcu == null) {
            DriveId driveId = this;
            zzbnp zzbnp2 = new zzbnp();
            new zzbnp().versionCode = 1;
            zzbnp2.zzgkb = driveId.zzgdj == null ? "" : driveId.zzgdj;
            zzbnp2.zzgkc = driveId.zzgdk;
            zzbnp2.zzgjz = driveId.zzgcs;
            zzbnp2.zzgkd = driveId.zzgdl;
            String string = Base64.encodeToString((byte[])zzego.zzc((zzego)zzbnp2), (int)10);
            String string2 = String.valueOf("DriveId:");
            String string3 = String.valueOf(string);
            this.zzgcu = string3.length() != 0 ? string2.concat(string3) : new String(string2);
        }
        return this.zzgcu;
    }

    public final String toInvariantString() {
        if (this.zzgdm == null) {
            DriveId driveId = this;
            zzbnq zzbnq2 = new zzbnq();
            new zzbnq().zzgkc = driveId.zzgdk;
            zzbnq2.zzgjz = driveId.zzgcs;
            byte[] byArray = zzego.zzc((zzego)zzbnq2);
            this.zzgdm = Base64.encodeToString((byte[])byArray, (int)10);
        }
        return this.zzgdm;
    }

    public String toString() {
        return this.encodeToString();
    }

    public static DriveId decodeFromString(String string) {
        String string2 = String.valueOf(string);
        zzbp.zzb((boolean)string.startsWith("DriveId:"), (Object)(string2.length() != 0 ? "Invalid DriveId: ".concat(string2) : new String("Invalid DriveId: ")));
        return DriveId.zzl(Base64.decode((String)string.substring(8), (int)10));
    }

    private static DriveId zzl(byte[] byArray) {
        zzbnp zzbnp2;
        try {
            byte[] byArray2 = byArray;
            zzbnp2 = (zzbnp)zzego.zza((zzego)new zzbnp(), (byte[])byArray2);
        }
        catch (zzegn zzegn2) {
            throw new IllegalArgumentException();
        }
        String string = "".equals(zzbnp2.zzgkb) ? null : zzbnp2.zzgkb;
        return new DriveId(string, zzbnp2.zzgkc, zzbnp2.zzgjz, zzbnp2.zzgkd);
    }
}

