/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive;

import android.text.TextUtils;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.zzbf;
import com.google.android.gms.drive.Drive;
import com.google.android.gms.internal.zzbiw;
import java.util.Arrays;

public class ExecutionOptions {
    public static final int MAX_TRACKING_TAG_STRING_LENGTH = 65536;
    public static final int CONFLICT_STRATEGY_OVERWRITE_REMOTE = 0;
    public static final int CONFLICT_STRATEGY_KEEP_REMOTE = 1;
    private final String zzgdt;
    private final boolean zzgdu;
    private final int zzgdv;

    public ExecutionOptions(String string, boolean bl, int n) {
        this.zzgdt = string;
        this.zzgdu = bl;
        this.zzgdv = n;
    }

    public final String zzamt() {
        return this.zzgdt;
    }

    public final boolean zzamu() {
        return this.zzgdu;
    }

    public final int zzamv() {
        return this.zzgdv;
    }

    public final void zze(GoogleApiClient googleApiClient) {
        zzbiw zzbiw2 = (zzbiw)googleApiClient.zza(Drive.zzdwq);
        if (this.zzgdu && !zzbiw2.zzanm()) {
            throw new IllegalStateException("Application must define an exported DriveEventService subclass in AndroidManifest.xml to be notified on completion");
        }
    }

    public boolean equals(Object object) {
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        if (object == this) {
            return true;
        }
        ExecutionOptions executionOptions = (ExecutionOptions)object;
        return zzbf.equal((Object)this.zzgdt, (Object)executionOptions.zzgdt) && this.zzgdv == executionOptions.zzgdv && this.zzgdu == executionOptions.zzgdu;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzgdt, this.zzgdv, this.zzgdu});
    }

    public static class Builder {
        protected String zzgdt;
        protected boolean zzgdu;
        protected int zzgdv = 0;

        public Builder() {
        }

        public Builder setTrackingTag(String string) {
            String string2 = string;
            if (!(!TextUtils.isEmpty((CharSequence)string2) && string2.length() <= 65536)) {
                throw new IllegalArgumentException(String.format("trackingTag must not be null nor empty, and the length must be <= the maximum length (%s)", 65536));
            }
            this.zzgdt = string;
            return this;
        }

        public Builder setNotifyOnCompletion(boolean bl) {
            this.zzgdu = bl;
            return this;
        }

        public Builder setConflictStrategy(int n) {
            boolean bl;
            switch (n) {
                case 0: 
                case 1: {
                    bl = true;
                    break;
                }
                default: {
                    bl = false;
                }
            }
            if (!bl) {
                throw new IllegalArgumentException(new StringBuilder(53).append("Unrecognized value for conflict strategy: ").append(n).toString());
            }
            this.zzgdv = n;
            return this;
        }

        protected final void zzamw() {
            if (this.zzgdv == 1 && !this.zzgdu) {
                throw new IllegalStateException("Cannot use CONFLICT_STRATEGY_KEEP_REMOTE without requesting completion notifications");
            }
        }

        public ExecutionOptions build() {
            this.zzamw();
            return new ExecutionOptions(this.zzgdt, this.zzgdu, this.zzgdv);
        }
    }
}

