/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive;

import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.drive.metadata.CustomPropertyKey;
import com.google.android.gms.drive.metadata.MetadataField;
import com.google.android.gms.drive.metadata.internal.AppVisibleCustomProperties;
import com.google.android.gms.drive.metadata.internal.MetadataBundle;
import com.google.android.gms.internal.zzbnr;
import com.google.android.gms.internal.zzboe;
import java.util.Collections;
import java.util.Date;
import java.util.Map;

public final class MetadataChangeSet {
    public static final int INDEXABLE_TEXT_SIZE_LIMIT_BYTES = 131072;
    public static final int CUSTOM_PROPERTY_SIZE_LIMIT_BYTES = 124;
    public static final int MAX_PUBLIC_PROPERTIES_PER_RESOURCE = 30;
    public static final int MAX_PRIVATE_PROPERTIES_PER_RESOURCE_PER_APP = 30;
    public static final int MAX_TOTAL_PROPERTIES_PER_RESOURCE = 100;
    public static final MetadataChangeSet zzgeb = new MetadataChangeSet(MetadataBundle.zzant());
    private final MetadataBundle zzgec;

    public MetadataChangeSet(MetadataBundle metadataBundle) {
        this.zzgec = metadataBundle.zzanu();
    }

    public final Map<CustomPropertyKey, String> getCustomPropertyChangeMap() {
        AppVisibleCustomProperties appVisibleCustomProperties = this.zzgec.zza(zzbnr.zzgkv);
        if (appVisibleCustomProperties == null) {
            return Collections.emptyMap();
        }
        return appVisibleCustomProperties.zzanp();
    }

    public final String getDescription() {
        return this.zzgec.zza(zzbnr.zzgkw);
    }

    public final String getIndexableText() {
        return this.zzgec.zza(zzbnr.zzglc);
    }

    public final Date getLastViewedByMeDate() {
        return this.zzgec.zza(zzboe.zzgmm);
    }

    public final String getMimeType() {
        return this.zzgec.zza(zzbnr.zzglq);
    }

    public final String getTitle() {
        return this.zzgec.zza(zzbnr.zzglz);
    }

    public final Boolean isPinned() {
        return this.zzgec.zza(zzbnr.zzgli);
    }

    public final Boolean isStarred() {
        return this.zzgec.zza(zzbnr.zzglx);
    }

    public final Boolean isViewed() {
        return this.zzgec.zza(zzbnr.zzglp);
    }

    public final MetadataBundle zzana() {
        return this.zzgec;
    }

    public final <T> MetadataChangeSet zza(MetadataField<T> metadataField, T t) {
        MetadataChangeSet metadataChangeSet = this;
        MetadataChangeSet metadataChangeSet2 = new MetadataChangeSet(metadataChangeSet.zzgec);
        metadataChangeSet2.zzgec.zzc(metadataField, t);
        return metadataChangeSet2;
    }

    public static class Builder {
        private final MetadataBundle zzgec = MetadataBundle.zzant();
        private AppVisibleCustomProperties.zza zzged;

        public Builder() {
        }

        private final AppVisibleCustomProperties.zza zzanb() {
            if (this.zzged == null) {
                this.zzged = new AppVisibleCustomProperties.zza();
            }
            return this.zzged;
        }

        private static int zzgp(String string) {
            if (string == null) {
                return 0;
            }
            return string.getBytes().length;
        }

        private static void zzi(String string, int n, int n2) {
            int n3 = n2;
            int n4 = n;
            String string2 = string;
            zzbp.zzb((n2 <= n ? 1 : 0) != 0, (Object)String.format("%s must be no more than %d bytes, but is %d bytes.", string2, n4, n3));
        }

        public Builder setCustomProperty(CustomPropertyKey customPropertyKey, String string) {
            zzbp.zzb((Object)((Object)customPropertyKey), (Object)"key");
            zzbp.zzb((Object)string, (Object)"value");
            int n = Builder.zzgp(customPropertyKey.getKey()) + Builder.zzgp(string);
            Builder.zzi("The total size of key string and value string of a custom property", 124, n);
            this.zzanb().zza(customPropertyKey, string);
            return this;
        }

        public Builder deleteCustomProperty(CustomPropertyKey customPropertyKey) {
            zzbp.zzb((Object)((Object)customPropertyKey), (Object)"key");
            this.zzanb().zza(customPropertyKey, null);
            return this;
        }

        public Builder setDescription(String string) {
            this.zzgec.zzc(zzbnr.zzgkw, string);
            return this;
        }

        public Builder setIndexableText(String string) {
            int n = Builder.zzgp(string);
            Builder.zzi("Indexable text size", 131072, n);
            this.zzgec.zzc(zzbnr.zzglc, string);
            return this;
        }

        public Builder setLastViewedByMeDate(Date date) {
            this.zzgec.zzc(zzboe.zzgmm, date);
            return this;
        }

        public Builder setMimeType(String string) {
            this.zzgec.zzc(zzbnr.zzglq, string);
            return this;
        }

        public Builder setPinned(boolean bl) {
            this.zzgec.zzc(zzbnr.zzgli, bl);
            return this;
        }

        public Builder setStarred(boolean bl) {
            this.zzgec.zzc(zzbnr.zzglx, bl);
            return this;
        }

        public Builder setTitle(String string) {
            this.zzgec.zzc(zzbnr.zzglz, string);
            return this;
        }

        public Builder setViewed(boolean bl) {
            this.zzgec.zzc(zzbnr.zzglp, bl);
            return this;
        }

        public MetadataChangeSet build() {
            if (this.zzged != null) {
                this.zzgec.zzc(zzbnr.zzgkv, this.zzged.zzanq());
            }
            return new MetadataChangeSet(this.zzgec);
        }
    }
}

