/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.events;

import android.os.IBinder;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.RemoteException;
import android.text.TextUtils;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.util.zzm;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.MetadataChangeSet;
import com.google.android.gms.drive.events.ResourceEvent;
import com.google.android.gms.drive.events.zzg;
import com.google.android.gms.drive.metadata.internal.MetadataBundle;
import com.google.android.gms.internal.zzbjv;
import com.google.android.gms.internal.zzbli;
import com.google.android.gms.internal.zzbnr;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public final class CompletionEvent
extends zza
implements ResourceEvent {
    public static final int STATUS_SUCCESS = 0;
    public static final int STATUS_FAILURE = 1;
    public static final int STATUS_CONFLICT = 2;
    public static final int STATUS_CANCELED = 3;
    public static final Parcelable.Creator<CompletionEvent> CREATOR = new zzg();
    private DriveId zzgcx;
    private String zzdxg;
    private ParcelFileDescriptor zzgey;
    private ParcelFileDescriptor zzgez;
    private MetadataBundle zzgfa;
    private List<String> zzgfb;
    private int zzbyx;
    private IBinder zzgfc;
    private boolean zzgfd = false;
    private boolean zzgfe = false;
    private boolean zzgff = false;

    CompletionEvent(DriveId driveId, String string, ParcelFileDescriptor parcelFileDescriptor, ParcelFileDescriptor parcelFileDescriptor2, MetadataBundle metadataBundle, List<String> list, int n, IBinder iBinder) {
        this.zzgcx = driveId;
        this.zzdxg = string;
        this.zzgey = parcelFileDescriptor;
        this.zzgez = parcelFileDescriptor2;
        this.zzgfa = metadataBundle;
        this.zzgfb = list;
        this.zzbyx = n;
        this.zzgfc = iBinder;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        int n2 = n | 1;
        Parcel parcel2 = parcel;
        CompletionEvent completionEvent = this;
        int n3 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)2, (Parcelable)completionEvent.zzgcx, (int)n2, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)3, (String)completionEvent.zzdxg, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)4, (Parcelable)completionEvent.zzgey, (int)n2, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)5, (Parcelable)completionEvent.zzgez, (int)n2, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)6, (Parcelable)completionEvent.zzgfa, (int)n2, (boolean)false);
        zzd.zzb((Parcel)parcel2, (int)7, completionEvent.zzgfb, (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)8, (int)completionEvent.zzbyx);
        zzd.zza((Parcel)parcel2, (int)9, (IBinder)completionEvent.zzgfc, (boolean)false);
        zzd.zzai((Parcel)parcel2, (int)n3);
    }

    @Override
    public final int getType() {
        return 2;
    }

    @Override
    public final DriveId getDriveId() {
        this.zzanc();
        return this.zzgcx;
    }

    public final String getAccountName() {
        this.zzanc();
        return this.zzdxg;
    }

    public final InputStream getBaseContentsInputStream() {
        this.zzanc();
        if (this.zzgey == null) {
            return null;
        }
        if (this.zzgfd) {
            throw new IllegalStateException("getBaseInputStream() can only be called once per CompletionEvent instance.");
        }
        this.zzgfd = true;
        return new FileInputStream(this.zzgey.getFileDescriptor());
    }

    public final InputStream getModifiedContentsInputStream() {
        this.zzanc();
        if (this.zzgez == null) {
            return null;
        }
        if (this.zzgfe) {
            throw new IllegalStateException("getModifiedInputStream() can only be called once per CompletionEvent instance.");
        }
        this.zzgfe = true;
        return new FileInputStream(this.zzgez.getFileDescriptor());
    }

    public final MetadataChangeSet getModifiedMetadataChangeSet() {
        this.zzanc();
        if (this.zzgfa != null) {
            return new MetadataChangeSet(this.zzgfa);
        }
        return null;
    }

    public final List<String> getTrackingTags() {
        this.zzanc();
        return new ArrayList<String>(this.zzgfb);
    }

    public final int getStatus() {
        this.zzanc();
        return this.zzbyx;
    }

    public final void dismiss() {
        this.zzr(false);
    }

    public final void snooze() {
        this.zzr(true);
    }

    private final void zzr(boolean bl) {
        this.zzanc();
        this.zzgff = true;
        zzm.zza((ParcelFileDescriptor)this.zzgey);
        zzm.zza((ParcelFileDescriptor)this.zzgez);
        if (this.zzgfa != null && this.zzgfa.zzc(zzbnr.zzgly)) {
            this.zzgfa.zza(zzbnr.zzgly).release();
        }
        if (this.zzgfc == null) {
            String string = String.valueOf(bl ? "snooze" : "dismiss");
            zzbjv.zzz("CompletionEvent", string.length() != 0 ? "No callback on ".concat(string) : new String("No callback on "));
            return;
        }
        try {
            zzbli.zzam(this.zzgfc).zzr(bl);
            return;
        }
        catch (RemoteException remoteException) {
            String string = bl ? "snooze" : "dismiss";
            String string2 = String.valueOf((Object)remoteException);
            zzbjv.zzz("CompletionEvent", new StringBuilder(21 + String.valueOf(string).length() + String.valueOf(string2).length()).append("RemoteException on ").append(string).append(": ").append(string2).toString());
            return;
        }
    }

    private final void zzanc() {
        if (this.zzgff) {
            throw new IllegalStateException("Event has already been dismissed or snoozed.");
        }
    }

    public final String toString() {
        String string;
        if (this.zzgfb == null) {
            string = "<null>";
        } else {
            String string2 = TextUtils.join((CharSequence)"','", this.zzgfb);
            string = new StringBuilder(2 + String.valueOf(string2).length()).append("'").append(string2).append("'").toString();
        }
        String string3 = string;
        return String.format(Locale.US, "CompletionEvent [id=%s, status=%s, trackingTag=%s]", new Object[]{this.zzgcx, this.zzbyx, string3});
    }
}

