/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.events;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.RemoteException;
import com.google.android.gms.common.util.zzv;
import com.google.android.gms.drive.events.ChangeEvent;
import com.google.android.gms.drive.events.ChangeListener;
import com.google.android.gms.drive.events.CompletionEvent;
import com.google.android.gms.drive.events.CompletionListener;
import com.google.android.gms.drive.events.DriveEvent;
import com.google.android.gms.drive.events.zzd;
import com.google.android.gms.drive.events.zzh;
import com.google.android.gms.drive.events.zzi;
import com.google.android.gms.drive.events.zzr;
import com.google.android.gms.internal.zzbjv;
import com.google.android.gms.internal.zzblg;
import com.google.android.gms.internal.zzblw;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class DriveEventService
extends Service
implements ChangeListener,
CompletionListener,
zzd,
zzi {
    public static final String ACTION_HANDLE_EVENT = "com.google.android.gms.drive.events.HANDLE_EVENT";
    private final String mName;
    private CountDownLatch zzgfg;
    zza zzgfh;
    boolean zzgfi = false;
    private int zzgfj = -1;

    protected DriveEventService(String string) {
        this.mName = string;
    }

    protected DriveEventService() {
        this("DriveEventService");
    }

    public final synchronized IBinder onBind(Intent intent) {
        if (ACTION_HANDLE_EVENT.equals(intent.getAction())) {
            if (this.zzgfh == null && !this.zzgfi) {
                this.zzgfi = true;
                CountDownLatch countDownLatch = new CountDownLatch(1);
                this.zzgfg = new CountDownLatch(1);
                new zzh(this, countDownLatch).start();
                try {
                    if (!countDownLatch.await(5000L, TimeUnit.MILLISECONDS)) {
                        zzbjv.zzz("DriveEventService", "Failed to synchronously initialize event handler.");
                    }
                }
                catch (InterruptedException interruptedException) {
                    throw new RuntimeException("Unable to start event handler", interruptedException);
                }
            }
            return new zzb(this).asBinder();
        }
        return null;
    }

    public boolean onUnbind(Intent intent) {
        return true;
    }

    public synchronized void onDestroy() {
        zzbjv.zzx("DriveEventService", "onDestroy");
        if (this.zzgfh != null) {
            Message message = this.zzgfh.zzane();
            this.zzgfh.sendMessage(message);
            this.zzgfh = null;
            try {
                if (!this.zzgfg.await(5000L, TimeUnit.MILLISECONDS)) {
                    zzbjv.zzy("DriveEventService", "Failed to synchronously quit event handler. Will quit itself");
                }
            }
            catch (InterruptedException interruptedException) {}
            this.zzgfg = null;
        }
        super.onDestroy();
    }

    @Override
    public void onChange(ChangeEvent changeEvent) {
        String string = String.valueOf(changeEvent);
        zzbjv.zzy(this.mName, new StringBuilder(24 + String.valueOf(string).length()).append("Unhandled change event: ").append(string).toString());
    }

    @Override
    public final void zza(com.google.android.gms.drive.events.zzb zzb2) {
        String string = String.valueOf(zzb2);
        zzbjv.zzy(this.mName, new StringBuilder(35 + String.valueOf(string).length()).append("Unhandled changes available event: ").append(string).toString());
    }

    @Override
    public void onCompletion(CompletionEvent completionEvent) {
        String string = String.valueOf(completionEvent);
        zzbjv.zzy(this.mName, new StringBuilder(28 + String.valueOf(string).length()).append("Unhandled completion event: ").append(string).toString());
    }

    protected int getCallingUid() {
        return Binder.getCallingUid();
    }

    private final void zza(zzblw zzblw2) {
        DriveEvent driveEvent = zzblw2.zzann();
        String string = String.valueOf(driveEvent);
        zzbjv.zzx("DriveEventService", new StringBuilder(20 + String.valueOf(string).length()).append("handleEventMessage: ").append(string).toString());
        try {
            switch (driveEvent.getType()) {
                case 1: {
                    this.onChange((ChangeEvent)driveEvent);
                    return;
                }
                case 2: {
                    this.onCompletion((CompletionEvent)driveEvent);
                    return;
                }
                case 4: {
                    this.zza((com.google.android.gms.drive.events.zzb)driveEvent);
                    return;
                }
                case 7: {
                    zzr zzr2 = (zzr)driveEvent;
                    String string2 = String.valueOf(zzr2);
                    zzbjv.zzy(this.mName, new StringBuilder(32 + String.valueOf(string2).length()).append("Unhandled transfer state event: ").append(string2).toString());
                    return;
                }
            }
            string = String.valueOf(driveEvent);
            zzbjv.zzy(this.mName, new StringBuilder(17 + String.valueOf(string).length()).append("Unhandled event: ").append(string).toString());
            return;
        }
        catch (Exception exception) {
            String string3 = String.valueOf(driveEvent);
            zzbjv.zza(this.mName, exception, new StringBuilder(22 + String.valueOf(string3).length()).append("Error handling event: ").append(string3).toString());
            return;
        }
    }

    private final void zzand() throws SecurityException {
        int n = this.getCallingUid();
        if (n == this.zzgfj) {
            return;
        }
        if (zzv.zzf((Context)this, (int)n)) {
            this.zzgfj = n;
            return;
        }
        throw new SecurityException("Caller is not GooglePlayServices");
    }

    static /* synthetic */ CountDownLatch zzb(DriveEventService driveEventService) {
        return driveEventService.zzgfg;
    }

    final class zzb
    extends zzblg {
        private /* synthetic */ DriveEventService zzgfl;

        zzb(DriveEventService driveEventService) {
            this.zzgfl = driveEventService;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void zzc(zzblw zzblw2) throws RemoteException {
            DriveEventService driveEventService = this.zzgfl;
            synchronized (driveEventService) {
                String string = String.valueOf((Object)zzblw2);
                zzbjv.zzx("DriveEventService", new StringBuilder(9 + String.valueOf(string).length()).append("onEvent: ").append(string).toString());
                this.zzgfl.zzand();
                if (this.zzgfl.zzgfh != null) {
                    string = this.zzgfl.zzgfh.zzb(zzblw2);
                    this.zzgfl.zzgfh.sendMessage((Message)string);
                } else {
                    zzbjv.zzz("DriveEventService", "Receiving event before initialize is completed.");
                }
                return;
            }
        }
    }

    final class zza
    extends Handler {
        private /* synthetic */ DriveEventService zzgfl;

        zza(DriveEventService driveEventService) {
            this.zzgfl = driveEventService;
        }

        private final Message zzb(zzblw zzblw2) {
            return this.obtainMessage(1, (Object)zzblw2);
        }

        private final Message zzane() {
            return this.obtainMessage(2);
        }

        public final void handleMessage(Message message) {
            int n = message.what;
            zzbjv.zzx("DriveEventService", new StringBuilder(38).append("handleMessage message type:").append(n).toString());
            switch (message.what) {
                case 1: {
                    this.zzgfl.zza((zzblw)((Object)message.obj));
                    return;
                }
                case 2: {
                    this.getLooper().quit();
                    return;
                }
            }
            n = message.what;
            zzbjv.zzy("DriveEventService", new StringBuilder(35).append("Unexpected message type:").append(n).toString());
        }
    }
}

