/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.drive.DriveApi;
import com.google.android.gms.drive.DriveClient;
import com.google.android.gms.drive.DrivePreferencesApi;
import com.google.android.gms.drive.DriveResourceClient;
import com.google.android.gms.drive.zzf;
import com.google.android.gms.drive.zzg;
import com.google.android.gms.drive.zzh;
import com.google.android.gms.drive.zzk;
import com.google.android.gms.drive.zzm;
import com.google.android.gms.internal.zzbls;
import com.google.android.gms.internal.zzbmo;
import com.google.android.gms.internal.zzbmt;
import com.google.android.gms.internal.zzbnh;
import com.google.android.gms.internal.zzbnr;
import com.google.android.gms.internal.zzbnx;
import com.google.android.gms.internal.zzbpv;
import java.util.Arrays;
import java.util.Set;

public final class Drive {
    public static final Api.zzf<zzbmo> zzebf = new Api.zzf();
    private static final Api.zza<zzbmo, Api.ApiOptions.NoOptions> zzebg = new zzf();
    private static final Api.zza<zzbmo, zzb> zzgix = new zzg();
    private static final Api.zza<zzbmo, zza> zzgiy = new zzh();
    public static final Scope SCOPE_FILE = new Scope("https://www.googleapis.com/auth/drive.file");
    public static final Scope SCOPE_APPFOLDER = new Scope("https://www.googleapis.com/auth/drive.appdata");
    private static Scope zzgiz = new Scope("https://www.googleapis.com/auth/drive");
    private static Scope zzgja = new Scope("https://www.googleapis.com/auth/drive.apps");
    @Deprecated
    public static final Api<Api.ApiOptions.NoOptions> API = new Api("Drive.API", zzebg, zzebf);
    private static Api<zzb> zzgjb = new Api("Drive.INTERNAL_API", zzgix, zzebf);
    public static final Api<zza> zzgjc = new Api("Drive.API_CONNECTIONLESS", zzgiy, zzebf);
    @Deprecated
    public static final DriveApi DriveApi = new zzbls();
    private static zzk zzgjd = new zzbnh();
    private static zzm zzgje = new zzbpv();
    @Deprecated
    public static final DrivePreferencesApi DrivePreferencesApi = new zzbnr();

    private static void zza(GoogleSignInAccount googleSignInAccount) {
        zzbq.checkNotNull((Object)googleSignInAccount);
        Set set = googleSignInAccount.zzabb();
        zzbq.checkArgument((set.contains(SCOPE_FILE) || set.contains(SCOPE_APPFOLDER) || set.contains(zzgiz) || set.contains(zzgja) ? 1 : 0) != 0, (Object)"You must request a Drive scope in order to interact with the Drive API.");
    }

    public static DriveClient getDriveClient(@NonNull Context context, @NonNull GoogleSignInAccount googleSignInAccount) {
        Drive.zza(googleSignInAccount);
        return new zzbmt(context, new zza(googleSignInAccount));
    }

    public static DriveClient getDriveClient(@NonNull Activity activity, @NonNull GoogleSignInAccount googleSignInAccount) {
        Drive.zza(googleSignInAccount);
        return new zzbmt(activity, new zza(googleSignInAccount));
    }

    public static DriveResourceClient getDriveResourceClient(@NonNull Context context, @NonNull GoogleSignInAccount googleSignInAccount) {
        Drive.zza(googleSignInAccount);
        return new zzbnx(context, new zza(googleSignInAccount));
    }

    public static DriveResourceClient getDriveResourceClient(@NonNull Activity activity, @NonNull GoogleSignInAccount googleSignInAccount) {
        Drive.zza(googleSignInAccount);
        return new zzbnx(activity, new zza(googleSignInAccount));
    }

    private Drive() {
    }

    public static final class zza
    implements Api.ApiOptions.HasGoogleSignInAccountOptions {
        private final Bundle zzgjf = new Bundle();
        private final GoogleSignInAccount zzgjg;

        public zza(@NonNull GoogleSignInAccount googleSignInAccount) {
            this.zzgjg = googleSignInAccount;
        }

        public final Bundle zzanz() {
            return this.zzgjf;
        }

        public final GoogleSignInAccount getGoogleSignInAccount() {
            return this.zzgjg;
        }

        public final boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null || object.getClass() != this.getClass()) {
                return false;
            }
            zza zza2 = (zza)object;
            if (!zzbg.equal((Object)this.zzgjg, (Object)zza2.getGoogleSignInAccount())) {
                return false;
            }
            String string = this.zzgjf.getString("method_trace_filename");
            String string2 = zza2.zzgjf.getString("method_trace_filename");
            return (string == null && string2 == null || string != null && string2 != null && string.equals(string2)) && this.zzgjf.getBoolean("bypass_initial_sync") == zza2.zzgjf.getBoolean("bypass_initial_sync") && this.zzgjf.getInt("proxy_type") == zza2.zzgjf.getInt("proxy_type");
        }

        public final int hashCode() {
            String string = this.zzgjf.getString("method_trace_filename", "");
            int n = this.zzgjf.getInt("proxy_type");
            boolean bl = this.zzgjf.getBoolean("bypass_initial_sync");
            return Arrays.hashCode(new Object[]{this.zzgjg, string, n, bl});
        }
    }

    public static final class zzb
    implements Api.ApiOptions.Optional {
    }
}

