/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.support.annotation.NonNull;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.internal.zzm;
import com.google.android.gms.drive.DriveApi;
import com.google.android.gms.drive.DriveContents;
import com.google.android.gms.drive.DriveFolder;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.ExecutionOptions;
import com.google.android.gms.drive.MetadataChangeSet;
import com.google.android.gms.drive.metadata.internal.zzk;
import com.google.android.gms.drive.query.Filters;
import com.google.android.gms.drive.query.Query;
import com.google.android.gms.drive.query.SearchableField;
import com.google.android.gms.drive.zzo;
import com.google.android.gms.drive.zzq;
import com.google.android.gms.internal.zzbls;
import com.google.android.gms.internal.zzbmy;
import com.google.android.gms.internal.zzbnj;
import com.google.android.gms.internal.zzbnk;
import com.google.android.gms.internal.zzbpj;
import com.google.android.gms.internal.zzbth;

public final class zzbni
extends zzbpj
implements DriveFolder {
    public zzbni(DriveId driveId) {
        super(driveId);
    }

    @Override
    public final PendingResult<DriveApi.MetadataBufferResult> listChildren(GoogleApiClient googleApiClient) {
        return this.queryChildren(googleApiClient, null);
    }

    @Override
    public final PendingResult<DriveApi.MetadataBufferResult> queryChildren(GoogleApiClient googleApiClient, Query query) {
        Query query2 = query;
        zzbni zzbni2 = this;
        return new zzbls().query(googleApiClient, zzbni.zza(query2, zzbni2.getDriveId()));
    }

    static Query zza(Query query, @NonNull DriveId driveId) {
        Query.Builder builder = new Query.Builder().addFilter(Filters.in(SearchableField.PARENTS, driveId));
        if (query != null) {
            if (query.getFilter() != null) {
                builder.addFilter(query.getFilter());
            }
            builder.setPageToken(query.getPageToken());
            builder.setSortOrder(query.getSortOrder());
        }
        return builder.build();
    }

    @Override
    public final PendingResult<DriveFolder.DriveFileResult> createFile(GoogleApiClient googleApiClient, MetadataChangeSet metadataChangeSet, DriveContents driveContents) {
        zzbni.zzb(metadataChangeSet);
        return this.zza(googleApiClient, metadataChangeSet, driveContents, null);
    }

    @Override
    public final PendingResult<DriveFolder.DriveFileResult> createFile(GoogleApiClient googleApiClient, MetadataChangeSet metadataChangeSet, DriveContents driveContents, ExecutionOptions executionOptions) {
        zzbni.zzb(metadataChangeSet);
        return this.zza(googleApiClient, metadataChangeSet, driveContents, zzo.zza(executionOptions));
    }

    static void zzb(MetadataChangeSet metadataChangeSet) {
        zzk zzk2;
        if (metadataChangeSet == null) {
            throw new IllegalArgumentException("MetadataChangeSet must be provided.");
        }
        zzk zzk3 = zzk.zzgy(metadataChangeSet.getMimeType());
        if (zzk3 != null && !(!(zzk2 = zzk3).zzaps() && !zzk2.isFolder())) {
            throw new IllegalArgumentException("May not create shortcut files using this method. Use DriveFolder.createShortcutFile() instead.");
        }
    }

    private final PendingResult<DriveFolder.DriveFileResult> zza(GoogleApiClient googleApiClient, MetadataChangeSet metadataChangeSet, DriveContents driveContents, zzo zzo2) {
        if (zzo2 == null) {
            zzo2 = (zzo)((ExecutionOptions.Builder)new zzq()).build();
        }
        zzo zzo3 = zzo2;
        Object object = driveContents;
        MetadataChangeSet metadataChangeSet2 = metadataChangeSet;
        Object object2 = googleApiClient;
        if (metadataChangeSet2 == null) {
            throw new IllegalArgumentException("MetadataChangeSet must be provided.");
        }
        zzk zzk2 = zzk.zzgy(metadataChangeSet2.getMimeType());
        if (zzk2 != null && zzk2.isFolder()) {
            throw new IllegalArgumentException("May not create folders using this method. Use DriveFolder.createFolder() instead of mime type application/vnd.google-apps.folder");
        }
        zzo3.zzf((GoogleApiClient)object2);
        if (object != null) {
            if (!(object instanceof zzbmy)) {
                throw new IllegalArgumentException("Only DriveContents obtained from the Drive API are accepted.");
            }
            if (object.getDriveId() != null) {
                throw new IllegalArgumentException("Only DriveContents obtained through DriveApi.newDriveContents are accepted for file creation.");
            }
            if (object.zzaod()) {
                throw new IllegalArgumentException("DriveContents are already closed.");
            }
        }
        zzk zzk3 = zzk.zzgy(metadataChangeSet.getMimeType());
        int n = zzbni.zza(driveContents, zzk3);
        String string = zzo2.zzaoj();
        if (string != null) {
            metadataChangeSet = zzbni.zza(metadataChangeSet, string);
        }
        zzo zzo4 = zzo2;
        int n2 = n;
        object = metadataChangeSet;
        metadataChangeSet2 = googleApiClient;
        object2 = this;
        zzk2 = zzk.zzgy(((MetadataChangeSet)object).getMimeType());
        int n3 = zzk2 != null && zzk2.zzaps() ? 1 : 0;
        return metadataChangeSet2.zze(new zzbnj((zzbni)object2, (GoogleApiClient)metadataChangeSet2, (MetadataChangeSet)object, n2, n3, zzo4));
    }

    static MetadataChangeSet zza(MetadataChangeSet metadataChangeSet, String string) {
        return metadataChangeSet.zza(zzbth.zzgtv, string);
    }

    static int zza(DriveContents driveContents, zzk zzk2) {
        int n;
        if (driveContents == null) {
            n = zzk2 != null && zzk2.zzaps() ? 0 : 1;
        } else {
            n = driveContents.zzaob().getRequestId();
            driveContents.zzaoc();
        }
        return n;
    }

    @Override
    public final PendingResult<DriveFolder.DriveFolderResult> createFolder(GoogleApiClient googleApiClient, MetadataChangeSet metadataChangeSet) {
        if (metadataChangeSet == null) {
            throw new IllegalArgumentException("MetadataChangeSet must be provided.");
        }
        if (metadataChangeSet.getMimeType() != null && !metadataChangeSet.getMimeType().equals("application/vnd.google-apps.folder")) {
            throw new IllegalArgumentException("The mimetype must be of type application/vnd.google-apps.folder");
        }
        return googleApiClient.zze((zzm)new zzbnk(this, googleApiClient, metadataChangeSet));
    }
}

