/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.gms.common.api.internal.zzci;
import com.google.android.gms.common.api.internal.zzck;
import com.google.android.gms.common.internal.zzbj;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.drive.Drive;
import com.google.android.gms.drive.DriveApi;
import com.google.android.gms.drive.DriveContents;
import com.google.android.gms.drive.DriveFile;
import com.google.android.gms.drive.DriveFolder;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.DriveResource;
import com.google.android.gms.drive.DriveResourceClient;
import com.google.android.gms.drive.ExecutionOptions;
import com.google.android.gms.drive.Metadata;
import com.google.android.gms.drive.MetadataBuffer;
import com.google.android.gms.drive.MetadataChangeSet;
import com.google.android.gms.drive.events.ListenerToken;
import com.google.android.gms.drive.events.OnChangeListener;
import com.google.android.gms.drive.events.OpenFileCallback;
import com.google.android.gms.drive.events.zzj;
import com.google.android.gms.drive.query.Query;
import com.google.android.gms.drive.zzr;
import com.google.android.gms.drive.zzt;
import com.google.android.gms.internal.zzbkt;
import com.google.android.gms.internal.zzbls;
import com.google.android.gms.internal.zzbni;
import com.google.android.gms.internal.zzbny;
import com.google.android.gms.internal.zzbnz;
import com.google.android.gms.internal.zzboa;
import com.google.android.gms.internal.zzbob;
import com.google.android.gms.internal.zzboc;
import com.google.android.gms.internal.zzbod;
import com.google.android.gms.internal.zzboe;
import com.google.android.gms.internal.zzbof;
import com.google.android.gms.internal.zzbog;
import com.google.android.gms.internal.zzboh;
import com.google.android.gms.internal.zzboi;
import com.google.android.gms.internal.zzboj;
import com.google.android.gms.internal.zzbok;
import com.google.android.gms.internal.zzbol;
import com.google.android.gms.internal.zzbom;
import com.google.android.gms.internal.zzbon;
import com.google.android.gms.internal.zzboo;
import com.google.android.gms.internal.zzbop;
import com.google.android.gms.internal.zzboq;
import com.google.android.gms.internal.zzbor;
import com.google.android.gms.internal.zzbos;
import com.google.android.gms.internal.zzbot;
import com.google.android.gms.internal.zzbou;
import com.google.android.gms.internal.zzbov;
import com.google.android.gms.internal.zzbow;
import com.google.android.gms.internal.zzbox;
import com.google.android.gms.internal.zzboy;
import com.google.android.gms.internal.zzboz;
import com.google.android.gms.internal.zzbpc;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.Task;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public final class zzbnx
extends DriveResourceClient {
    private final DriveApi zzgnv = new zzbls();
    private static final AtomicInteger zzgot = new AtomicInteger();

    public zzbnx(@NonNull Context context, @Nullable Drive.zza zza2) {
        super(context, zza2);
    }

    public zzbnx(@NonNull Activity activity, @Nullable Drive.zza zza2) {
        super(activity, zza2);
    }

    @Override
    public final Task<DriveFolder> getRootFolder() {
        return this.zza(new zzbod(this));
    }

    @Override
    public final Task<DriveFolder> getAppFolder() {
        return this.zza(new zzboo(this));
    }

    @Override
    public final Task<MetadataBuffer> query(@NonNull Query query) {
        return zzbj.zza(this.zzgnv.query(this.zzago(), query), (zzbo)zzbny.zzgnw);
    }

    @Override
    public final Task<Metadata> getMetadata(@NonNull DriveResource driveResource) {
        zzbq.checkNotNull((Object)((Object)driveResource.getDriveId()));
        return this.zza(new zzbov(this, driveResource));
    }

    @Override
    public final Task<Metadata> updateMetadata(@NonNull DriveResource driveResource, @NonNull MetadataChangeSet metadataChangeSet) {
        zzbq.checkNotNull((Object)((Object)driveResource.getDriveId()));
        zzbq.checkNotNull((Object)metadataChangeSet);
        return this.zzb(new zzbow(this, metadataChangeSet, driveResource));
    }

    @Override
    public final Task<MetadataBuffer> listParents(@NonNull DriveResource driveResource) {
        zzbq.checkNotNull((Object)((Object)driveResource.getDriveId()));
        return this.zza(new zzbox(this, driveResource));
    }

    @Override
    public final Task<Void> setParents(@NonNull DriveResource driveResource, @NonNull Set<DriveId> set) {
        zzbq.checkNotNull((Object)((Object)driveResource.getDriveId()));
        zzbq.checkNotNull(set);
        ArrayList<DriveId> arrayList = new ArrayList<DriveId>(set);
        return this.zzb(new zzboy(this, driveResource, arrayList));
    }

    @Override
    public final Task<Void> delete(@NonNull DriveResource driveResource) {
        zzbq.checkNotNull((Object)((Object)driveResource.getDriveId()));
        return this.zzb(new zzboz(this, driveResource));
    }

    @Override
    public final Task<Void> trash(@NonNull DriveResource driveResource) {
        zzbq.checkNotNull((Object)((Object)driveResource.getDriveId()));
        return this.zzb(new zzboe(this, driveResource));
    }

    @Override
    public final Task<Void> untrash(@NonNull DriveResource driveResource) {
        zzbq.checkNotNull((Object)((Object)driveResource.getDriveId()));
        return this.zzb(new zzbof(this, driveResource));
    }

    @Override
    public final Task<ListenerToken> addChangeListener(@NonNull DriveResource driveResource, @NonNull OnChangeListener onChangeListener) {
        zzbq.checkNotNull((Object)((Object)driveResource.getDriveId()));
        zzbq.checkNotNull((Object)onChangeListener, (Object)"listener");
        zzbpc zzbpc2 = new zzbpc(this, onChangeListener, driveResource.getDriveId());
        int n = zzgot.incrementAndGet();
        zzci zzci2 = this.zza(zzbpc2, new StringBuilder(27).append("OnChangeListener").append(n).toString());
        zzbog zzbog2 = new zzbog(this, zzci2, driveResource, zzbpc2);
        zzboh zzboh2 = new zzboh(this, zzci2.zzajo(), driveResource, zzbpc2);
        return this.zza(zzbog2, zzboh2).continueWith((Continuation)new zzbnz(zzci2));
    }

    @Override
    public final Task<Boolean> removeChangeListener(@NonNull ListenerToken listenerToken) {
        zzbq.checkNotNull((Object)listenerToken, (Object)"Token is required to unregister listener.");
        if (listenerToken instanceof zzbkt) {
            return this.zza(((zzbkt)listenerToken).zzaoy());
        }
        throw new IllegalStateException("Could not recover key from ListenerToken");
    }

    @Override
    public final Task<Void> addChangeSubscription(@NonNull DriveResource driveResource) {
        zzbq.checkNotNull((Object)((Object)driveResource.getDriveId()));
        zzbq.checkArgument((boolean)zzj.zza(1, driveResource.getDriveId()));
        return this.zzb(new zzboi(this, driveResource));
    }

    @Override
    public final Task<Void> removeChangeSubscription(@NonNull DriveResource driveResource) {
        zzbq.checkNotNull((Object)((Object)driveResource.getDriveId()));
        zzbq.checkArgument((boolean)zzj.zza(1, driveResource.getDriveId()));
        return this.zzb(new zzboj(this, driveResource));
    }

    @Override
    public final Task<DriveContents> openFile(@NonNull DriveFile driveFile, int n) {
        zzbnx.zzcu(n);
        return this.zza(new zzbok(this, driveFile, n));
    }

    @Override
    public final Task<ListenerToken> openFile(@NonNull DriveFile driveFile, int n, @NonNull OpenFileCallback openFileCallback) {
        zzbnx.zzcu(n);
        int n2 = zzgot.incrementAndGet();
        zzci zzci2 = this.zza(openFileCallback, new StringBuilder(27).append("OpenFileCallback").append(n2).toString());
        zzck zzck2 = zzci2.zzajo();
        zzbkt zzbkt2 = new zzbkt(zzck2);
        zzbol zzbol2 = new zzbol(this, zzci2, driveFile, n, zzbkt2, zzci2);
        zzbom zzbom2 = new zzbom(this, zzck2, zzbkt2);
        return this.zza(zzbol2, zzbom2).continueWith((Continuation)new zzboa(zzbkt2));
    }

    @Override
    public final Task<Boolean> cancelOpenFileCallback(@NonNull ListenerToken listenerToken) {
        if (!(listenerToken instanceof zzbkt)) {
            throw new IllegalArgumentException("Unrecognized ListenerToken");
        }
        return this.zza(((zzbkt)listenerToken).zzaoy());
    }

    @Override
    public final Task<DriveContents> createContents() {
        return this.zzb(new zzbon(this));
    }

    @Override
    public final Task<DriveContents> reopenContentsForWrite(@NonNull DriveContents driveContents) {
        zzbq.checkArgument((!driveContents.zzaod() ? 1 : 0) != 0, (Object)"DriveContents is already closed");
        zzbq.checkArgument((driveContents.getMode() == 0x10000000 ? 1 : 0) != 0, (Object)"This method can only be called on contents that are currently opened in MODE_READ_ONLY.");
        driveContents.zzaoc();
        return this.zza(new zzbop(this, driveContents));
    }

    @Override
    public final Task<Void> commitContents(@NonNull DriveContents driveContents, @Nullable MetadataChangeSet metadataChangeSet) {
        return ((DriveResourceClient)this).commitContents(driveContents, metadataChangeSet, (zzr)((ExecutionOptions.Builder)new zzt()).build());
    }

    @Override
    public final Task<Void> commitContents(@NonNull DriveContents driveContents, @Nullable MetadataChangeSet metadataChangeSet, @NonNull ExecutionOptions executionOptions) {
        zzbq.checkNotNull((Object)executionOptions, (Object)"Execution options cannot be null.");
        zzbq.checkArgument((!driveContents.zzaod() ? 1 : 0) != 0, (Object)"DriveContents is already closed");
        zzbq.checkArgument((driveContents.getMode() != 0x10000000 ? 1 : 0) != 0, (Object)"Cannot commit contents opened in MODE_READ_ONLY.");
        zzbq.checkNotNull((Object)((Object)driveContents.getDriveId()), (Object)"Only DriveContents obtained through DriveFile.open can be committed.");
        zzr zzr2 = zzr.zzb(executionOptions);
        if (ExecutionOptions.zzcr(zzr2.zzaog()) && !driveContents.zzaob().zzant()) {
            throw new IllegalStateException("DriveContents must be valid for conflict detection.");
        }
        MetadataChangeSet metadataChangeSet2 = metadataChangeSet == null ? MetadataChangeSet.zzgkc : metadataChangeSet;
        return this.zzb(new zzboq(this, zzr2, driveContents, metadataChangeSet2));
    }

    @Override
    public final Task<Void> discardContents(@NonNull DriveContents driveContents) {
        zzbq.checkArgument((!driveContents.zzaod() ? 1 : 0) != 0, (Object)"DriveContents is already closed");
        driveContents.zzaoc();
        return this.zzb(new zzbor(this, driveContents));
    }

    private static void zzcu(int n) {
        if (n != 0x10000000 && n != 0x20000000 && n != 0x30000000) {
            throw new IllegalArgumentException("Invalid openMode provided");
        }
    }

    @Override
    public final Task<MetadataBuffer> listChildren(@NonNull DriveFolder driveFolder) {
        return zzbj.zza(this.zzgnv.query(this.zzago(), zzbni.zza(null, driveFolder.getDriveId())), (zzbo)zzbob.zzgnw);
    }

    @Override
    public final Task<MetadataBuffer> queryChildren(@NonNull DriveFolder driveFolder, @NonNull Query query) {
        return zzbj.zza(this.zzgnv.query(this.zzago(), zzbni.zza(query, driveFolder.getDriveId())), (zzbo)zzboc.zzgnw);
    }

    @Override
    public final Task<DriveFile> createFile(@NonNull DriveFolder driveFolder, @NonNull MetadataChangeSet metadataChangeSet, @Nullable DriveContents driveContents) {
        return this.zzb(new zzbos(this, metadataChangeSet, driveContents, driveFolder));
    }

    @Override
    public final Task<DriveFile> createFile(@NonNull DriveFolder driveFolder, @NonNull MetadataChangeSet metadataChangeSet, @Nullable DriveContents driveContents, @NonNull ExecutionOptions executionOptions) {
        zzbq.checkNotNull((Object)executionOptions, (Object)"executionOptions cannot be null");
        return this.zzb(new zzbot(this, metadataChangeSet, driveContents, driveFolder, executionOptions));
    }

    @Override
    public final Task<DriveFolder> createFolder(@NonNull DriveFolder driveFolder, @NonNull MetadataChangeSet metadataChangeSet) {
        zzbq.checkNotNull((Object)metadataChangeSet, (Object)"MetadataChangeSet must be provided.");
        if (metadataChangeSet.getMimeType() != null && !metadataChangeSet.getMimeType().equals("application/vnd.google-apps.folder")) {
            throw new IllegalArgumentException("The mimetype must be of type application/vnd.google-apps.folder");
        }
        return this.zzb(new zzbou(this, metadataChangeSet, driveFolder));
    }

    static final /* synthetic */ ListenerToken zza(zzbkt zzbkt2, Task task) throws Exception {
        if (task.isSuccessful()) {
            return zzbkt2;
        }
        throw task.getException();
    }

    static final /* synthetic */ ListenerToken zza(zzci zzci2, Task task) throws Exception {
        if (task.isSuccessful()) {
            return new zzbkt(zzci2.zzajo());
        }
        throw task.getException();
    }
}

