/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.drive.DriveApi;
import com.google.android.gms.drive.DriveClient;
import com.google.android.gms.drive.DrivePreferencesApi;
import com.google.android.gms.drive.DriveResourceClient;
import com.google.android.gms.drive.zzf;
import com.google.android.gms.drive.zzg;
import com.google.android.gms.drive.zzh;
import com.google.android.gms.drive.zzk;
import com.google.android.gms.drive.zzm;
import com.google.android.gms.internal.zzbmu;
import com.google.android.gms.internal.zzbnq;
import com.google.android.gms.internal.zzbnv;
import com.google.android.gms.internal.zzboj;
import com.google.android.gms.internal.zzbot;
import com.google.android.gms.internal.zzboz;
import com.google.android.gms.internal.zzbqx;
import java.util.Arrays;
import java.util.Set;

public final class Drive {
    @Hide
    public static final Api.zzf<zzbnq> zza = new Api.zzf();
    @Hide
    private static final Api.zza<zzbnq, Api.ApiOptions.NoOptions> zzc = new zzf();
    @Hide
    private static final Api.zza<zzbnq, zzb> zzd = new zzg();
    @Hide
    private static final Api.zza<zzbnq, zza> zze = new zzh();
    public static final Scope SCOPE_FILE = new Scope("https://www.googleapis.com/auth/drive.file");
    public static final Scope SCOPE_APPFOLDER = new Scope("https://www.googleapis.com/auth/drive.appdata");
    @Hide
    private static Scope zzf = new Scope("https://www.googleapis.com/auth/drive");
    @Hide
    private static Scope zzg = new Scope("https://www.googleapis.com/auth/drive.apps");
    @Deprecated
    public static final Api<Api.ApiOptions.NoOptions> API = new Api("Drive.API", zzc, zza);
    @Hide
    private static Api<zzb> zzh = new Api("Drive.INTERNAL_API", zzd, zza);
    @Hide
    public static final Api<zza> zzb = new Api("Drive.API_CONNECTIONLESS", zze, zza);
    @Deprecated
    public static final DriveApi DriveApi = new zzbmu();
    @Hide
    private static zzk zzi = new zzboj();
    @Hide
    private static zzm zzj = new zzbqx();
    @Deprecated
    public static final DrivePreferencesApi DrivePreferencesApi = new zzbot();

    private static void zza(GoogleSignInAccount googleSignInAccount) {
        zzbq.zza((Object)googleSignInAccount);
        Set set = googleSignInAccount.zzd();
        zzbq.zzb((set.contains(SCOPE_FILE) || set.contains(SCOPE_APPFOLDER) || set.contains(zzf) || set.contains(zzg) ? 1 : 0) != 0, (Object)"You must request a Drive scope in order to interact with the Drive API.");
    }

    public static DriveClient getDriveClient(@NonNull Context context, @NonNull GoogleSignInAccount googleSignInAccount) {
        Drive.zza(googleSignInAccount);
        return new zzbnv(context, new zza(googleSignInAccount));
    }

    public static DriveClient getDriveClient(@NonNull Activity activity, @NonNull GoogleSignInAccount googleSignInAccount) {
        Drive.zza(googleSignInAccount);
        return new zzbnv(activity, new zza(googleSignInAccount));
    }

    public static DriveResourceClient getDriveResourceClient(@NonNull Context context, @NonNull GoogleSignInAccount googleSignInAccount) {
        Drive.zza(googleSignInAccount);
        return new zzboz(context, new zza(googleSignInAccount));
    }

    public static DriveResourceClient getDriveResourceClient(@NonNull Activity activity, @NonNull GoogleSignInAccount googleSignInAccount) {
        Drive.zza(googleSignInAccount);
        return new zzboz(activity, new zza(googleSignInAccount));
    }

    private Drive() {
    }

    @Hide
    public static final class zza
    implements Api.ApiOptions.HasGoogleSignInAccountOptions {
        private final Bundle zza = new Bundle();
        private final GoogleSignInAccount zzb;

        public zza(@NonNull GoogleSignInAccount googleSignInAccount) {
            this.zzb = googleSignInAccount;
        }

        public final Bundle zza() {
            return this.zza;
        }

        public final GoogleSignInAccount getGoogleSignInAccount() {
            return this.zzb;
        }

        public final boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null || object.getClass() != this.getClass()) {
                return false;
            }
            zza zza2 = (zza)object;
            if (!zzbg.zza((Object)this.zzb, (Object)zza2.getGoogleSignInAccount())) {
                return false;
            }
            String string = this.zza.getString("method_trace_filename");
            String string2 = zza2.zza.getString("method_trace_filename");
            return (string == null && string2 == null || string != null && string2 != null && string.equals(string2)) && this.zza.getBoolean("bypass_initial_sync") == zza2.zza.getBoolean("bypass_initial_sync") && this.zza.getInt("proxy_type") == zza2.zza.getInt("proxy_type");
        }

        public final int hashCode() {
            String string = this.zza.getString("method_trace_filename", "");
            int n = this.zza.getInt("proxy_type");
            boolean bl = this.zza.getBoolean("bypass_initial_sync");
            return Arrays.hashCode(new Object[]{this.zzb, string, n, bl});
        }
    }

    @Hide
    public static final class zzb
    implements Api.ApiOptions.Optional {
    }
}

